if("${CMAKE_${lang}_COMPILER_ID};${CMAKE_${lang}_SIMULATE_ID};${CMAKE_${lang}_COMPILER_FRONTEND_VARIANT}" STREQUAL "Clang;MSVC;GNU")
  # Clang does not actually support these, so Windows-Clang passes no flags.
  set(empty_PossibleDataLoss 1)
  set(empty_StackFrameErrorCheck 1)
  set(empty_UninitializedVariable 1)
  set(empty_RTCsu 1)
elseif("${CMAKE_${lang}_COMPILER_ID};${CMAKE_${lang}_SIMULATE_ID};${lang}" MATCHES "^Intel(LLVM)?;MSVC;Fortran$")
  # IntelLLVM Fortran does not actually support these, so Windows-IntelLLVM-Fortran passes no flags.
  set(empty_PossibleDataLoss 1)
  set(empty_StackFrameErrorCheck 1)
  set(empty_UninitializedVariable 0) # this one is supported
  set(empty_RTCsu 1)
elseif(CMAKE_${lang}_COMPILER_ID STREQUAL "MSVC" AND CMAKE_${lang}_COMPILER_VERSION VERSION_LESS 14)
  set(empty_PossibleDataLoss 1)
  set(empty_StackFrameErrorCheck 0)
  set(empty_UninitializedVariable 1)
  set(empty_RTCsu 0)
else()
  set(empty_PossibleDataLoss 0)
  set(empty_StackFrameErrorCheck 0)
  set(empty_UninitializedVariable 0)
  set(empty_RTCsu 0)
endif()

set(var "CMAKE_${lang}_COMPILE_OPTIONS_MSVC_RUNTIME_CHECKS_PossibleDataLoss")
if(empty_PossibleDataLoss AND ${var} STREQUAL "")
  set("${var}" "-DTEST_RTCc")
else()
  string(REPLACE "-RTCc" "-RTCc${delimiter}-DTEST_RTCc" "${var}" "${${var}}")
endif()
set(var "CMAKE_${lang}_COMPILE_OPTIONS_MSVC_RUNTIME_CHECKS_StackFrameErrorCheck")
if(empty_StackFrameErrorCheck AND ${var} STREQUAL "")
  set("${var}" "-DTEST_RTCs")
else()
  string(REPLACE "-RTCs" "-RTCs${delimiter}-DTEST_RTCs" "${var}" "${${var}}")
  string(REPLACE "-GZ" "-GZ${delimiter}-DTEST_RTCs" "${var}" "${${var}}")
endif()
set(var "CMAKE_${lang}_COMPILE_OPTIONS_MSVC_RUNTIME_CHECKS_UninitializedVariable")
if(empty_UninitializedVariable AND ${var} STREQUAL "")
  set("${var}" "-DTEST_RTCu")
else()
  string(REPLACE "-RTCu" "-RTCu${delimiter}-DTEST_RTCu" "${var}" "${${var}}")
endif()
set(var "CMAKE_${lang}_COMPILE_OPTIONS_MSVC_RUNTIME_CHECKS_RTCsu")
if(empty_RTCsu AND ${var} STREQUAL "")
  set("${var}" "-DTEST_RTCsu")
else()
  string(REPLACE "-RTC1" "-RTC1${delimiter}-DTEST_RTCsu" "${var}" "${${var}}")
  string(REPLACE "-GZ" "-GZ${delimiter}-DTEST_RTCsu" "${var}" "${${var}}")
endif()
