use Test::More tests => 5;

use ECMWF::ECaccess;

no warnings qw(uninitialized);

my $ecaccess = ECMWF::ECaccess->new(0, $ENV{'TEST_VERBOSE'} eq '1');
my $controlChannel   = $ecaccess->getControlChannel();
my $dataChannel      = $ecaccess->getDataChannel();
my $gatewayName      = $controlChannel->getGatewayName()->result;
my $gatewayConnected = $controlChannel->gatewayIsConnected()->result;

ok( defined($ecaccess) && ref $ecaccess eq 'ECMWF::ECaccess', 'new() works' );
ok( defined($controlChannel),   'getControlChannel() works' );
ok( defined($dataChannel),      'getDataChannel() works' );
ok( defined($gatewayName),      'getGatewayName() works (' . $gatewayName . ')' );
ok( defined($gatewayConnected), 'gatewayIsConnected() works (' . $gatewayConnected . ')' );
