//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armquantum

import "time"

// CheckNameAvailabilityParameters - Details of check name availability request body.
type CheckNameAvailabilityParameters struct {
	// Name for checking availability.
	Name *string `json:"name,omitempty"`

	// The resource type of Quantum Workspace.
	Type *string `json:"type,omitempty"`
}

// CheckNameAvailabilityResult - Result of check name availability.
type CheckNameAvailabilityResult struct {
	// Indicator of availability of the Quantum Workspace resource name.
	NameAvailable *bool `json:"nameAvailable,omitempty"`

	// The reason of unavailability.
	Reason *string `json:"reason,omitempty"`

	// READ-ONLY; The detailed info regarding the reason associated with the Namespace.
	Message *string `json:"message,omitempty" azure:"ro"`
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty" azure:"ro"`

	// READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error details.
	Details []*ErrorDetail `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The error target.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type ErrorResponse struct {
	// The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// OfferingsClientListOptions contains the optional parameters for the OfferingsClient.List method.
type OfferingsClientListOptions struct {
	// placeholder for future optional parameters
}

// OfferingsListResult - The response of a list Providers operation.
type OfferingsListResult struct {
	// Link to the next set of results. Not empty if Value contains incomplete list of Providers.
	NextLink *string `json:"nextLink,omitempty"`

	// Result of a list Providers operation.
	Value []*ProviderDescription `json:"value,omitempty"`
}

// Operation provided by provider
type Operation struct {
	// Properties of the operation
	Display *OperationDisplay `json:"display,omitempty"`

	// Indicates whether the operation is a data action
	IsDataAction *bool `json:"isDataAction,omitempty"`

	// Name of the operation
	Name *string `json:"name,omitempty"`
}

// OperationDisplay - Properties of the operation
type OperationDisplay struct {
	// Description of the operation
	Description *string `json:"description,omitempty"`

	// Operation name
	Operation *string `json:"operation,omitempty"`

	// Provider name
	Provider *string `json:"provider,omitempty"`

	// Resource name
	Resource *string `json:"resource,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// OperationsList - Lists the operations available.
type OperationsList struct {
	// REQUIRED; Array of operations
	Value []*Operation `json:"value,omitempty"`

	// Url to follow for getting next page of operations.
	NextLink *string `json:"nextLink,omitempty"`
}

// PricingDetail - Detailed pricing information for an sku.
type PricingDetail struct {
	// Unique id for this pricing information.
	ID *string `json:"id,omitempty"`

	// The unit cost of this sku.
	Value *string `json:"value,omitempty"`
}

// PricingDimension - Information about pricing dimension.
type PricingDimension struct {
	// Unique id of this pricing dimension.
	ID *string `json:"id,omitempty"`

	// The display name of this pricing dimension.
	Name *string `json:"name,omitempty"`
}

// Provider - Information about a Provider. A Provider is an entity that offers Targets to run Azure Quantum Jobs.
type Provider struct {
	// The provider's marketplace application display name.
	ApplicationName *string `json:"applicationName,omitempty"`

	// A Uri identifying the specific instance of this provider.
	InstanceURI *string `json:"instanceUri,omitempty"`

	// Unique id of this provider.
	ProviderID *string `json:"providerId,omitempty"`

	// The sku associated with pricing information for this provider.
	ProviderSKU *string `json:"providerSku,omitempty"`

	// Provisioning status field
	ProvisioningState *Status `json:"provisioningState,omitempty"`

	// Id to track resource usage for the provider.
	ResourceUsageID *string `json:"resourceUsageId,omitempty"`
}

// ProviderDescription - Information about an offering. A provider offering is an entity that offers Targets to run Azure
// Quantum Jobs.
type ProviderDescription struct {
	// Unique provider's id.
	ID *string `json:"id,omitempty"`

	// A list of provider-specific properties.
	Properties *ProviderProperties `json:"properties,omitempty"`

	// READ-ONLY; Provider's display name.
	Name *string `json:"name,omitempty" azure:"ro"`
}

// ProviderProperties - Provider properties.
type ProviderProperties struct {
	// Azure Active Directory info.
	AAD *ProviderPropertiesAAD `json:"aad,omitempty"`

	// Provider's Managed-Application info
	ManagedApplication *ProviderPropertiesManagedApplication `json:"managedApplication,omitempty"`

	// The list of pricing dimensions from the provider.
	PricingDimensions []*PricingDimension `json:"pricingDimensions,omitempty"`

	// The list of quota dimensions from the provider.
	QuotaDimensions []*QuotaDimension `json:"quotaDimensions,omitempty"`

	// The list of skus available from this provider.
	SKUs []*SKUDescription `json:"skus,omitempty"`

	// The list of targets available from this provider.
	Targets []*TargetDescription `json:"targets,omitempty"`

	// READ-ONLY; Company name.
	Company *string `json:"company,omitempty" azure:"ro"`

	// READ-ONLY; Provider's default endpoint.
	DefaultEndpoint *string `json:"defaultEndpoint,omitempty" azure:"ro"`

	// READ-ONLY; A description about this provider.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; Provider type.
	ProviderType *string `json:"providerType,omitempty" azure:"ro"`
}

// ProviderPropertiesAAD - Azure Active Directory info.
type ProviderPropertiesAAD struct {
	// READ-ONLY; Provider's application id.
	ApplicationID *string `json:"applicationId,omitempty" azure:"ro"`

	// READ-ONLY; Provider's tenant id.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// ProviderPropertiesManagedApplication - Provider's Managed-Application info
type ProviderPropertiesManagedApplication struct {
	// READ-ONLY; Provider's offer id.
	OfferID *string `json:"offerId,omitempty" azure:"ro"`

	// READ-ONLY; Provider's publisher id.
	PublisherID *string `json:"publisherId,omitempty" azure:"ro"`
}

// QuotaDimension - Information about a specific quota dimension.
type QuotaDimension struct {
	// A description about this quota dimension.
	Description *string `json:"description,omitempty"`

	// Unique id of this dimension.
	ID *string `json:"id,omitempty"`

	// The display name of this quota dimension.
	Name *string `json:"name,omitempty"`

	// The reset period of this quota dimension.
	Period *string `json:"period,omitempty"`

	// The max limit of this dimension.
	Quota *float32 `json:"quota,omitempty"`

	// The scope of this quota dimension.
	Scope *string `json:"scope,omitempty"`

	// The standard unit of measurement used for this quota dimension.
	Unit *string `json:"unit,omitempty"`

	// The standard unit of measurement used for this quota dimension in plural form.
	UnitPlural *string `json:"unitPlural,omitempty"`
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SKUDescription - Information about a specific sku.
type SKUDescription struct {
	// Flag to indicate whether the sku should be automatically added during workspace creation.
	AutoAdd *bool `json:"autoAdd,omitempty"`

	// Description about this sku.
	Description *string `json:"description,omitempty"`

	// Unique sku id.
	ID *string `json:"id,omitempty"`

	// Display name of this sku.
	Name *string `json:"name,omitempty"`

	// The list of pricing details for the sku.
	PricingDetails []*PricingDetail `json:"pricingDetails,omitempty"`

	// The list of quota dimensions for this sku.
	QuotaDimensions []*QuotaDimension `json:"quotaDimensions,omitempty"`

	// Uri to subscribe to the restricted access sku.
	RestrictedAccessURI *string `json:"restrictedAccessUri,omitempty"`

	// The list of targets available for this sku.
	Targets []*string `json:"targets,omitempty"`

	// Display name of this sku.
	Version *string `json:"version,omitempty"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// TagsObject - Tags object for patch operations.
type TagsObject struct {
	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// TargetDescription - Information about a Target. A target is the component that can process a specific type of Job.
type TargetDescription struct {
	// List of content encodings accepted by this target.
	AcceptedContentEncodings []*string `json:"acceptedContentEncodings,omitempty"`

	// List of data formats accepted by this target.
	AcceptedDataFormats []*string `json:"acceptedDataFormats,omitempty"`

	// A description about this target.
	Description *string `json:"description,omitempty"`

	// Unique target id.
	ID *string `json:"id,omitempty"`

	// Display name of this target.
	Name *string `json:"name,omitempty"`
}

// TrackedResource - The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags'
// and a 'location'
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// Workspace - The resource proxy definition object for quantum workspace.
type Workspace struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Managed Identity information.
	Identity *WorkspaceIdentity `json:"identity,omitempty"`

	// Gets or sets the properties. Define quantum workspace's specific properties.
	Properties *WorkspaceResourceProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; System metadata
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WorkspaceClientCheckNameAvailabilityOptions contains the optional parameters for the WorkspaceClient.CheckNameAvailability
// method.
type WorkspaceClientCheckNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// WorkspaceIdentity - Managed Identity information.
type WorkspaceIdentity struct {
	// The identity type.
	Type *ResourceIdentityType `json:"type,omitempty"`

	// READ-ONLY; The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// WorkspaceListResult - The response of a list Workspaces operation.
type WorkspaceListResult struct {
	// Link to the next set of results. Not empty if Value contains incomplete list of Workspaces.
	NextLink *string `json:"nextLink,omitempty"`

	// Result of a list Workspaces operation.
	Value []*Workspace `json:"value,omitempty"`
}

// WorkspaceResourceProperties - Properties of a Workspace
type WorkspaceResourceProperties struct {
	// List of Providers selected for this Workspace
	Providers []*Provider `json:"providers,omitempty"`

	// ARM Resource Id of the storage account associated with this workspace.
	StorageAccount *string `json:"storageAccount,omitempty"`

	// READ-ONLY; The URI of the workspace endpoint.
	EndpointURI *string `json:"endpointUri,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning status field
	ProvisioningState *ProvisioningStatus `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Whether the current workspace is ready to accept Jobs.
	Usable *UsableStatus `json:"usable,omitempty" azure:"ro"`
}

// WorkspacesClientBeginCreateOrUpdateOptions contains the optional parameters for the WorkspacesClient.BeginCreateOrUpdate
// method.
type WorkspacesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WorkspacesClientBeginDeleteOptions contains the optional parameters for the WorkspacesClient.BeginDelete method.
type WorkspacesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WorkspacesClientGetOptions contains the optional parameters for the WorkspacesClient.Get method.
type WorkspacesClientGetOptions struct {
	// placeholder for future optional parameters
}

// WorkspacesClientListByResourceGroupOptions contains the optional parameters for the WorkspacesClient.ListByResourceGroup
// method.
type WorkspacesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// WorkspacesClientListBySubscriptionOptions contains the optional parameters for the WorkspacesClient.ListBySubscription
// method.
type WorkspacesClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// WorkspacesClientUpdateTagsOptions contains the optional parameters for the WorkspacesClient.UpdateTags method.
type WorkspacesClientUpdateTagsOptions struct {
	// placeholder for future optional parameters
}
