//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armrecoveryservicesbackup

import "encoding/json"

func unmarshalBackupEngineBaseClassification(rawMsg json.RawMessage) (BackupEngineBaseClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b BackupEngineBaseClassification
	switch m["backupEngineType"] {
	case string(BackupEngineTypeAzureBackupServerEngine):
		b = &AzureBackupServerEngine{}
	case string(BackupEngineTypeDpmBackupEngine):
		b = &DpmBackupEngine{}
	default:
		b = &BackupEngineBase{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalBackupRequestClassification(rawMsg json.RawMessage) (BackupRequestClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b BackupRequestClassification
	switch m["objectType"] {
	case "AzureFileShareBackupRequest":
		b = &AzureFileShareBackupRequest{}
	case "AzureWorkloadBackupRequest":
		b = &AzureWorkloadBackupRequest{}
	case "IaasVMBackupRequest":
		b = &IaasVMBackupRequest{}
	default:
		b = &BackupRequest{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalILRRequestClassification(rawMsg json.RawMessage) (ILRRequestClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b ILRRequestClassification
	switch m["objectType"] {
	case "AzureFileShareProvisionILRRequest":
		b = &AzureFileShareProvisionILRRequest{}
	case "IaasVMILRRegistrationRequest":
		b = &IaasVMILRRegistrationRequest{}
	default:
		b = &ILRRequest{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalJobClassification(rawMsg json.RawMessage) (JobClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b JobClassification
	switch m["jobType"] {
	case "AzureIaaSVMJob":
		b = &AzureIaaSVMJob{}
	case "AzureIaaSVMJobV2":
		b = &AzureIaaSVMJobV2{}
	case "AzureStorageJob":
		b = &AzureStorageJob{}
	case "AzureWorkloadJob":
		b = &AzureWorkloadJob{}
	case "DpmJob":
		b = &DpmJob{}
	case "MabJob":
		b = &MabJob{}
	case "VaultJob":
		b = &VaultJob{}
	default:
		b = &Job{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalOperationResultInfoBaseClassification(rawMsg json.RawMessage) (OperationResultInfoBaseClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b OperationResultInfoBaseClassification
	switch m["objectType"] {
	case "ExportJobsOperationResultInfo":
		b = &ExportJobsOperationResultInfo{}
	case "OperationResultInfo":
		b = &OperationResultInfo{}
	default:
		b = &OperationResultInfoBase{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalOperationStatusExtendedInfoClassification(rawMsg json.RawMessage) (OperationStatusExtendedInfoClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b OperationStatusExtendedInfoClassification
	switch m["objectType"] {
	case "OperationStatusJobExtendedInfo":
		b = &OperationStatusJobExtendedInfo{}
	case "OperationStatusJobsExtendedInfo":
		b = &OperationStatusJobsExtendedInfo{}
	case "OperationStatusProvisionILRExtendedInfo":
		b = &OperationStatusProvisionILRExtendedInfo{}
	case "OperationStatusValidateOperationExtendedInfo":
		b = &OperationStatusValidateOperationExtendedInfo{}
	default:
		b = &OperationStatusExtendedInfo{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalProtectableContainerClassification(rawMsg json.RawMessage) (ProtectableContainerClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b ProtectableContainerClassification
	switch m["protectableContainerType"] {
	case string(ContainerTypeStorageContainer):
		b = &AzureStorageProtectableContainer{}
	case string(ContainerTypeVMAppContainer):
		b = &AzureVMAppContainerProtectableContainer{}
	default:
		b = &ProtectableContainer{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalProtectedItemClassification(rawMsg json.RawMessage) (ProtectedItemClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b ProtectedItemClassification
	switch m["protectedItemType"] {
	case "AzureFileShareProtectedItem":
		b = &AzureFileshareProtectedItem{}
	case "AzureIaaSVMProtectedItem":
		b = &AzureIaaSVMProtectedItem{}
	case "AzureVmWorkloadProtectedItem":
		b = &AzureVMWorkloadProtectedItem{}
	case "AzureVmWorkloadSAPAseDatabase":
		b = &AzureVMWorkloadSAPAseDatabaseProtectedItem{}
	case "AzureVmWorkloadSAPHanaDatabase":
		b = &AzureVMWorkloadSAPHanaDatabaseProtectedItem{}
	case "AzureVmWorkloadSQLDatabase":
		b = &AzureVMWorkloadSQLDatabaseProtectedItem{}
	case "DPMProtectedItem":
		b = &DPMProtectedItem{}
	case "GenericProtectedItem":
		b = &GenericProtectedItem{}
	case "MabFileFolderProtectedItem":
		b = &MabFileFolderProtectedItem{}
	case "Microsoft.ClassicCompute/virtualMachines":
		b = &AzureIaaSClassicComputeVMProtectedItem{}
	case "Microsoft.Compute/virtualMachines":
		b = &AzureIaaSComputeVMProtectedItem{}
	case "Microsoft.Sql/servers/databases":
		b = &AzureSQLProtectedItem{}
	default:
		b = &ProtectedItem{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalProtectionContainerClassification(rawMsg json.RawMessage) (ProtectionContainerClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b ProtectionContainerClassification
	switch m["containerType"] {
	case string(ContainerTypeAzureBackupServerContainer):
		b = &AzureBackupServerContainer{}
	case string(ContainerTypeAzureSQLContainer):
		b = &AzureSQLContainer{}
	case string(ContainerTypeAzureWorkloadContainer):
		b = &AzureWorkloadContainer{}
	case string(ContainerTypeDPMContainer):
		b = &DpmContainer{}
	case string(ContainerTypeGenericContainer):
		b = &GenericContainer{}
	case string(ContainerTypeIaasVMContainer):
		b = &IaaSVMContainer{}
	case string(ContainerTypeMicrosoftClassicComputeVirtualMachines):
		b = &AzureIaaSClassicComputeVMContainer{}
	case string(ContainerTypeMicrosoftComputeVirtualMachines):
		b = &AzureIaaSComputeVMContainer{}
	case string(ContainerTypeSQLAGWorkLoadContainer):
		b = &AzureSQLAGWorkloadContainerProtectionContainer{}
	case string(ContainerTypeStorageContainer):
		b = &AzureStorageContainer{}
	case string(ContainerTypeVMAppContainer):
		b = &AzureVMAppContainerProtectionContainer{}
	case string(ContainerTypeWindows):
		b = &MabContainer{}
	default:
		b = &ProtectionContainer{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalProtectionIntentClassification(rawMsg json.RawMessage) (ProtectionIntentClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b ProtectionIntentClassification
	switch m["protectionIntentItemType"] {
	case string(ProtectionIntentItemTypeAzureResourceItem):
		b = &AzureResourceProtectionIntent{}
	case "ProtectionIntentItemTypeAzureWorkloadAutoProtectionIntent":
		b = &AzureWorkloadAutoProtectionIntent{}
	case string(ProtectionIntentItemTypeAzureWorkloadContainerAutoProtectionIntent):
		b = &AzureWorkloadContainerAutoProtectionIntent{}
	case "ProtectionIntentItemTypeAzureWorkloadSQLAutoProtectionIntent":
		b = &AzureWorkloadSQLAutoProtectionIntent{}
	case string(ProtectionIntentItemTypeRecoveryServiceVaultItem):
		b = &AzureRecoveryServiceVaultProtectionIntent{}
	default:
		b = &ProtectionIntent{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalProtectionPolicyClassification(rawMsg json.RawMessage) (ProtectionPolicyClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b ProtectionPolicyClassification
	switch m["backupManagementType"] {
	case "AzureIaasVM":
		b = &AzureIaaSVMProtectionPolicy{}
	case "AzureSql":
		b = &AzureSQLProtectionPolicy{}
	case "AzureStorage":
		b = &AzureFileShareProtectionPolicy{}
	case "AzureWorkload":
		b = &AzureVMWorkloadProtectionPolicy{}
	case "GenericProtectionPolicy":
		b = &GenericProtectionPolicy{}
	case "MAB":
		b = &MabProtectionPolicy{}
	default:
		b = &ProtectionPolicy{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalRecoveryPointClassification(rawMsg json.RawMessage) (RecoveryPointClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b RecoveryPointClassification
	switch m["objectType"] {
	case "AzureFileShareRecoveryPoint":
		b = &AzureFileShareRecoveryPoint{}
	case "AzureWorkloadPointInTimeRecoveryPoint":
		b = &AzureWorkloadPointInTimeRecoveryPoint{}
	case "AzureWorkloadRecoveryPoint":
		b = &AzureWorkloadRecoveryPoint{}
	case "AzureWorkloadSAPHanaPointInTimeRecoveryPoint":
		b = &AzureWorkloadSAPHanaPointInTimeRecoveryPoint{}
	case "AzureWorkloadSAPHanaRecoveryPoint":
		b = &AzureWorkloadSAPHanaRecoveryPoint{}
	case "AzureWorkloadSQLPointInTimeRecoveryPoint":
		b = &AzureWorkloadSQLPointInTimeRecoveryPoint{}
	case "AzureWorkloadSQLRecoveryPoint":
		b = &AzureWorkloadSQLRecoveryPoint{}
	case "GenericRecoveryPoint":
		b = &GenericRecoveryPoint{}
	case "IaasVMRecoveryPoint":
		b = &IaasVMRecoveryPoint{}
	default:
		b = &RecoveryPoint{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalRestoreRequestClassification(rawMsg json.RawMessage) (RestoreRequestClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b RestoreRequestClassification
	switch m["objectType"] {
	case "AzureFileShareRestoreRequest":
		b = &AzureFileShareRestoreRequest{}
	case "AzureWorkloadPointInTimeRestoreRequest":
		b = &AzureWorkloadPointInTimeRestoreRequest{}
	case "AzureWorkloadRestoreRequest":
		b = &AzureWorkloadRestoreRequest{}
	case "AzureWorkloadSAPHanaPointInTimeRestoreRequest":
		b = &AzureWorkloadSAPHanaPointInTimeRestoreRequest{}
	case "AzureWorkloadSAPHanaPointInTimeRestoreWithRehydrateRequest":
		b = &AzureWorkloadSAPHanaPointInTimeRestoreWithRehydrateRequest{}
	case "AzureWorkloadSAPHanaRestoreRequest":
		b = &AzureWorkloadSAPHanaRestoreRequest{}
	case "AzureWorkloadSAPHanaRestoreWithRehydrateRequest":
		b = &AzureWorkloadSAPHanaRestoreWithRehydrateRequest{}
	case "AzureWorkloadSQLPointInTimeRestoreRequest":
		b = &AzureWorkloadSQLPointInTimeRestoreRequest{}
	case "AzureWorkloadSQLPointInTimeRestoreWithRehydrateRequest":
		b = &AzureWorkloadSQLPointInTimeRestoreWithRehydrateRequest{}
	case "AzureWorkloadSQLRestoreRequest":
		b = &AzureWorkloadSQLRestoreRequest{}
	case "AzureWorkloadSQLRestoreWithRehydrateRequest":
		b = &AzureWorkloadSQLRestoreWithRehydrateRequest{}
	case "IaasVMRestoreRequest":
		b = &IaasVMRestoreRequest{}
	case "IaasVMRestoreWithRehydrationRequest":
		b = &IaasVMRestoreWithRehydrationRequest{}
	default:
		b = &RestoreRequest{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalRetentionPolicyClassification(rawMsg json.RawMessage) (RetentionPolicyClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b RetentionPolicyClassification
	switch m["retentionPolicyType"] {
	case "LongTermRetentionPolicy":
		b = &LongTermRetentionPolicy{}
	case "SimpleRetentionPolicy":
		b = &SimpleRetentionPolicy{}
	default:
		b = &RetentionPolicy{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalSchedulePolicyClassification(rawMsg json.RawMessage) (SchedulePolicyClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b SchedulePolicyClassification
	switch m["schedulePolicyType"] {
	case "LogSchedulePolicy":
		b = &LogSchedulePolicy{}
	case "LongTermSchedulePolicy":
		b = &LongTermSchedulePolicy{}
	case "SimpleSchedulePolicy":
		b = &SimpleSchedulePolicy{}
	case "SimpleSchedulePolicyV2":
		b = &SimpleSchedulePolicyV2{}
	default:
		b = &SchedulePolicy{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalVaultStorageConfigOperationResultResponseClassification(rawMsg json.RawMessage) (VaultStorageConfigOperationResultResponseClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b VaultStorageConfigOperationResultResponseClassification
	switch m["objectType"] {
	case "PrepareDataMoveResponse":
		b = &PrepareDataMoveResponse{}
	default:
		b = &VaultStorageConfigOperationResultResponse{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalWorkloadItemClassification(rawMsg json.RawMessage) (WorkloadItemClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b WorkloadItemClassification
	switch m["workloadItemType"] {
	case "AzureVmWorkloadItem":
		b = &AzureVMWorkloadItem{}
	case "SAPAseDatabase":
		b = &AzureVMWorkloadSAPAseDatabaseWorkloadItem{}
	case "SAPAseSystem":
		b = &AzureVMWorkloadSAPAseSystemWorkloadItem{}
	case "SAPHanaDatabase":
		b = &AzureVMWorkloadSAPHanaDatabaseWorkloadItem{}
	case "SAPHanaSystem":
		b = &AzureVMWorkloadSAPHanaSystemWorkloadItem{}
	case "SQLDataBase":
		b = &AzureVMWorkloadSQLDatabaseWorkloadItem{}
	case "SQLInstance":
		b = &AzureVMWorkloadSQLInstanceWorkloadItem{}
	default:
		b = &WorkloadItem{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalWorkloadProtectableItemClassification(rawMsg json.RawMessage) (WorkloadProtectableItemClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b WorkloadProtectableItemClassification
	switch m["protectableItemType"] {
	case "AzureFileShare":
		b = &AzureFileShareProtectableItem{}
	case "AzureVmWorkloadProtectableItem":
		b = &AzureVMWorkloadProtectableItem{}
	case "IaaSVMProtectableItem":
		b = &IaaSVMProtectableItem{}
	case "Microsoft.ClassicCompute/virtualMachines":
		b = &AzureIaaSClassicComputeVMProtectableItem{}
	case "Microsoft.Compute/virtualMachines":
		b = &AzureIaaSComputeVMProtectableItem{}
	case "SAPAseSystem":
		b = &AzureVMWorkloadSAPAseSystemProtectableItem{}
	case "SAPHanaDatabase":
		b = &AzureVMWorkloadSAPHanaDatabaseProtectableItem{}
	case "SAPHanaSystem":
		b = &AzureVMWorkloadSAPHanaSystemProtectableItem{}
	case "SQLAvailabilityGroupContainer":
		b = &AzureVMWorkloadSQLAvailabilityGroupProtectableItem{}
	case "SQLDataBase":
		b = &AzureVMWorkloadSQLDatabaseProtectableItem{}
	case "SQLInstance":
		b = &AzureVMWorkloadSQLInstanceProtectableItem{}
	default:
		b = &WorkloadProtectableItem{}
	}
	return b, json.Unmarshal(rawMsg, b)
}
