# frozen_string_literal: true

class AddIndexForHasVulnerabilityResolutionOnVulnerabilityReads < Gitlab::Database::Migration[2.2]
  TABLE_NAME = :vulnerability_reads

  GROUP_LEVEL_INDEX = 'index_vulnerability_reads_common_attrs_for_groups'
  GROUP_LEVEL_COLUMNS = [:resolved_on_default_branch, :state, :report_type, :severity, :traversal_ids,
    :vulnerability_id, :has_vulnerability_resolution]

  PROJECT_LEVEL_INDEX = 'index_vulnerability_reads_common_finder_query'
  PROJECT_LEVEL_COLUMNS = [:project_id, :state, :report_type, :severity, :vulnerability_id, :dismissal_reason,
    :has_vulnerability_resolution]

  disable_ddl_transaction!
  milestone '17.5'

  # Index created asynchronously in previous MR: https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166312
  def up
    add_concurrent_index TABLE_NAME, GROUP_LEVEL_COLUMNS, name: GROUP_LEVEL_INDEX, where: 'archived = false'
    add_concurrent_index TABLE_NAME, PROJECT_LEVEL_COLUMNS, name: PROJECT_LEVEL_INDEX,
      order: { vulnerability_id: :desc }
  end

  def down
    remove_concurrent_index_by_name TABLE_NAME, name: GROUP_LEVEL_INDEX
    remove_concurrent_index_by_name TABLE_NAME, name: PROJECT_LEVEL_INDEX
  end
end
