---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# Exposure of Private Personal Information (PII) to an unauthorized actor (credit card)

## Description

The target application was found to return credit card information in the response. Organizations
found returning such information may be in violation of industry regulations and could face fines.

## Remediation

PII such as credit cards should never be directly returned to the user. The majority of the information should masked except
the last few digits or characters of the identifier. For example, credit card numbers should
only return the last four digits: `****-****-****-1234`. Ensure this masking is done on the server
and only then send the masked data back to the client. Do not rely on client side JavaScript or other methods
to mask these values as the data could still be intercepted or unmasked.

Additionally, credit card information should never be stored un-encrypted in files or databases.

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:--------|:--------|:--------|:--------|
| 359.1 | true | 359 | Passive | Medium |

## Links

- [OWASP Top 10 A3 2017 - Sensitive Data Exposure](https://owasp.org/www-project-top-ten/2017/A3_2017-Sensitive_Data_Exposure)
- [CWE](https://cwe.mitre.org/data/definitions/359.html)
- [PCI-DSS](https://www.pcisecuritystandards.org/pdfs/pci_fs_data_storage.pdf)
