+++
date = "2017-05-21T13:05:07+09:00"
title = "レイヤ"
weight = 10

+++

## このチュートリアルで扱う内容
1. Redactedにおける2D開発でのレイヤの基本的な概要
2. スクリーン上のスプライトの順序付け方法

### Redactedにおける2D開発でのレイヤの基本的な概要
2Dにおいてはz軸が存在しないため、シーン内要素の描画順を制御するためには代替となる仕組みが必要です。
Redactedでは**レイヤ**における**zIndex**属性を制御可能にすることで、この課題を解決しています。
**デフォルトでは、zIndexは0となりオブジェクトはレイヤに追加された順番に描画されます。**

レイヤにはいくつかの重要な特性があります。

* レイヤにはレイヤ化されたオブジェクトのみを含めることができます。(**3Dモデルは絶対に追加しないでください**）
* レイヤはレイヤ化されたオブジェクトです。（したがって、レイヤには他のレイヤを含めることができます)
* レイヤ化されたオブジェクトは、最大で1つのレイヤに属すことができます。

レイヤを直接初期化することはできませんが、その派生クラスは初期化することが可能です。**Scene2D**と**コンテナ**は、**レイヤ**から派生する2つの主なオブジェクトです。すべての初期化（createContainer、instantiate、...）はレイヤ上で行われます。つまり、2Dで初期化されるすべてのオブジェクトは、zIndexプロパティを持つレイヤ化されたオブジェクトです。

**zIndexはグローバルではありません!**

CSSとは異なり、zIndexはすべてのオブジェクトに対してグローバルではありません。zIndexプロパティは親レイヤに対してローカルです。詳細につきましては、コンテナチュートリアルで説明しています。 [TODO: Link]。

### スクリーン上のスプライトの順序付け方法
これまで学んだことを生かして、画面にスプライトを表示して、zIndexの設定をしてみましょう！

* まず、最初に (A,B,C)　スプライトを生成します。
* スプライトAをシーンに追加します（zIndex = 0、標準色）
* スプライトBをシーン2に追加すると、**スプライトAの上に**表示されます（zIndex = 0、赤色）
* 最後にスプライトCをシーンに追加します（青色）が、スプライトのzIndexを-1に設定すると、スプライトはAとBの後側に表示されます。

{{< code "static/tutorials/layers.html" >}}

### ソースコード全体
```js
{{< snippet "static/tutorials/layers.html" >}}
```
