#!/bin/csh -f 
#       $Id$
#  D. Sandwell 1/12/07
#  M. Wei 1/31/08
#
alias rm 'rm -f'
unset noclobber
if ( -f ~/.quiet ) then
    set V = ""
else
	set V = "-V"
endif

#
#
#  project an xy file from lon/lat coordinates into range/azimuth coordinates
#  this version only works with GMT V4.0 and higher
#
#  Input:
#  trans.dat    - file generated by llt_grid2rat  (r a topo lon lat)
#  phase_ll.xyz - an ascii file of phase or anything in longitude/latitude coordinates 
#
#  Output:
#  phase_ra.zyz - an ascii file of phase in radar coordinates
#
# check for number of arguments
#
 if ($#argv < 3) then
  echo " "
  echo "Usage: proj_ll2ra_ascii.csh trans.dat phase_ll.xyz phase_ra.xyz" 
  echo " "
  echo "        trans.dat    - file generated by llt_grid2rat  (r a topo lon lat)"
  echo "        phase_ll.xyz - an Ascii file of phase or anything in lon/lat-coordinates"
  echo "        phase_ra.xyz - output an Ascii file in radar coordinates" 
  echo " "
  exit 1
 endif 
#
#  extract the phase in the r a positions
#
#   make grids of longitude and latitude versus range and azimuth
#
gmt gmtconvert $1 -o3,4,0 -bi5d -bo3f > llr
gmt gmtconvert $1 -o3,4,1 -bi5d -bo3f > lla
#awk '{ printf("%f %f %e \n",$4,$5,$1) }' < $1 | gmtconvert -bos3 > llr 
#awk '{ printf("%f %f %e \n",$4,$5,$2) }' < $1 | gmtconvert -bos3 > lla 
#
gmt surface llr `gmt gmtinfo $2 -I0.01` -bi3f -I0.005 -T.50 -Gllr.grd $V
gmt surface lla `gmt gmtinfo $2 -I0.01` -bi3f -I0.005 -T.50 -Glla.grd $V
#
gmt grdtrack $2 -nl -Gllr.grd > llpr 
gmt grdtrack llpr -nl -Glla.grd > llpra 
#
# get the range, azimuth, phase columns and grid
#
awk '{print $4,$5,$3}' < llpra > $3
#
#
#
# clean
#
rm ll*
