// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"fmt"
	smithy "github.com/aws/smithy-go"
)

// Kinesis Video Streams has throttled the request because you have exceeded a
// limit. Try making the call later. For information about limits, see Kinesis
// Video Streams Limits
// (http://docs.aws.amazon.com/kinesisvideostreams/latest/dg/limits.html).
type ClientLimitExceededException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *ClientLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ClientLimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ClientLimitExceededException) ErrorCode() string             { return "ClientLimitExceededException" }
func (e *ClientLimitExceededException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A specified parameter exceeds its restrictions, is not supported, or can't be
// used.
type InvalidArgumentException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidArgumentException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidArgumentException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidArgumentException) ErrorCode() string             { return "InvalidArgumentException" }
func (e *InvalidArgumentException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The codec private data in at least one of the tracks of the video stream is not
// valid for this operation.
type InvalidCodecPrivateDataException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidCodecPrivateDataException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidCodecPrivateDataException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidCodecPrivateDataException) ErrorCode() string {
	return "InvalidCodecPrivateDataException"
}
func (e *InvalidCodecPrivateDataException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// One or more frames in the requested clip could not be parsed based on the
// specified codec.
type InvalidMediaFrameException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidMediaFrameException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidMediaFrameException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidMediaFrameException) ErrorCode() string             { return "InvalidMediaFrameException" }
func (e *InvalidMediaFrameException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// No codec private data was found in at least one of tracks of the video stream.
type MissingCodecPrivateDataException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *MissingCodecPrivateDataException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MissingCodecPrivateDataException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MissingCodecPrivateDataException) ErrorCode() string {
	return "MissingCodecPrivateDataException"
}
func (e *MissingCodecPrivateDataException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A streaming session was requested for a stream that does not retain data (that
// is, has a DataRetentionInHours of 0).
type NoDataRetentionException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *NoDataRetentionException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoDataRetentionException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoDataRetentionException) ErrorCode() string             { return "NoDataRetentionException" }
func (e *NoDataRetentionException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Status Code: 403, The caller is not authorized to perform an operation on the
// given stream, or the token has expired.
type NotAuthorizedException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *NotAuthorizedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NotAuthorizedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NotAuthorizedException) ErrorCode() string             { return "NotAuthorizedException" }
func (e *NotAuthorizedException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// GetMedia throws this error when Kinesis Video Streams can't find the stream that
// you specified. GetHLSStreamingSessionURL and GetDASHStreamingSessionURL throw
// this error if a session with a PlaybackMode of ON_DEMAND or LIVE_REPLAYis
// requested for a stream that has no fragments within the requested time range, or
// if a session with a PlaybackMode of LIVE is requested for a stream that has no
// fragments within the last 30 seconds.
type ResourceNotFoundException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceNotFoundException) ErrorCode() string             { return "ResourceNotFoundException" }
func (e *ResourceNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The type of the media (for example, h.264 or h.265 video or ACC or G.711 audio)
// could not be determined from the codec IDs of the tracks in the first fragment
// for a playback session. The codec ID for track 1 should be V_MPEG/ISO/AVC and,
// optionally, the codec ID for track 2 should be A_AAC.
type UnsupportedStreamMediaTypeException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *UnsupportedStreamMediaTypeException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *UnsupportedStreamMediaTypeException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *UnsupportedStreamMediaTypeException) ErrorCode() string {
	return "UnsupportedStreamMediaTypeException"
}
func (e *UnsupportedStreamMediaTypeException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}
