// Code generated by smithy-go-codegen DO NOT EDIT.

package ses

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/aws/protocol/query"
	"github.com/aws/aws-sdk-go-v2/service/ses/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"path"
)

type awsAwsquery_serializeOpCloneReceiptRuleSet struct {
}

func (*awsAwsquery_serializeOpCloneReceiptRuleSet) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpCloneReceiptRuleSet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CloneReceiptRuleSetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CloneReceiptRuleSet")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentCloneReceiptRuleSetInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpCreateConfigurationSet struct {
}

func (*awsAwsquery_serializeOpCreateConfigurationSet) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpCreateConfigurationSet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateConfigurationSetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateConfigurationSet")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentCreateConfigurationSetInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpCreateConfigurationSetEventDestination struct {
}

func (*awsAwsquery_serializeOpCreateConfigurationSetEventDestination) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpCreateConfigurationSetEventDestination) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateConfigurationSetEventDestinationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateConfigurationSetEventDestination")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentCreateConfigurationSetEventDestinationInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpCreateConfigurationSetTrackingOptions struct {
}

func (*awsAwsquery_serializeOpCreateConfigurationSetTrackingOptions) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpCreateConfigurationSetTrackingOptions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateConfigurationSetTrackingOptionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateConfigurationSetTrackingOptions")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentCreateConfigurationSetTrackingOptionsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpCreateCustomVerificationEmailTemplate struct {
}

func (*awsAwsquery_serializeOpCreateCustomVerificationEmailTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpCreateCustomVerificationEmailTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateCustomVerificationEmailTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateCustomVerificationEmailTemplate")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentCreateCustomVerificationEmailTemplateInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpCreateReceiptFilter struct {
}

func (*awsAwsquery_serializeOpCreateReceiptFilter) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpCreateReceiptFilter) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateReceiptFilterInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateReceiptFilter")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentCreateReceiptFilterInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpCreateReceiptRule struct {
}

func (*awsAwsquery_serializeOpCreateReceiptRule) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpCreateReceiptRule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateReceiptRuleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateReceiptRule")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentCreateReceiptRuleInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpCreateReceiptRuleSet struct {
}

func (*awsAwsquery_serializeOpCreateReceiptRuleSet) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpCreateReceiptRuleSet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateReceiptRuleSetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateReceiptRuleSet")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentCreateReceiptRuleSetInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpCreateTemplate struct {
}

func (*awsAwsquery_serializeOpCreateTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpCreateTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateTemplate")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentCreateTemplateInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeleteConfigurationSet struct {
}

func (*awsAwsquery_serializeOpDeleteConfigurationSet) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeleteConfigurationSet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteConfigurationSetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteConfigurationSet")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentDeleteConfigurationSetInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeleteConfigurationSetEventDestination struct {
}

func (*awsAwsquery_serializeOpDeleteConfigurationSetEventDestination) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeleteConfigurationSetEventDestination) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteConfigurationSetEventDestinationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteConfigurationSetEventDestination")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentDeleteConfigurationSetEventDestinationInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeleteConfigurationSetTrackingOptions struct {
}

func (*awsAwsquery_serializeOpDeleteConfigurationSetTrackingOptions) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeleteConfigurationSetTrackingOptions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteConfigurationSetTrackingOptionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteConfigurationSetTrackingOptions")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentDeleteConfigurationSetTrackingOptionsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeleteCustomVerificationEmailTemplate struct {
}

func (*awsAwsquery_serializeOpDeleteCustomVerificationEmailTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeleteCustomVerificationEmailTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteCustomVerificationEmailTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteCustomVerificationEmailTemplate")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentDeleteCustomVerificationEmailTemplateInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeleteIdentity struct {
}

func (*awsAwsquery_serializeOpDeleteIdentity) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeleteIdentity) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteIdentityInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteIdentity")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentDeleteIdentityInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeleteIdentityPolicy struct {
}

func (*awsAwsquery_serializeOpDeleteIdentityPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeleteIdentityPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteIdentityPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteIdentityPolicy")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentDeleteIdentityPolicyInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeleteReceiptFilter struct {
}

func (*awsAwsquery_serializeOpDeleteReceiptFilter) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeleteReceiptFilter) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteReceiptFilterInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteReceiptFilter")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentDeleteReceiptFilterInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeleteReceiptRule struct {
}

func (*awsAwsquery_serializeOpDeleteReceiptRule) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeleteReceiptRule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteReceiptRuleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteReceiptRule")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentDeleteReceiptRuleInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeleteReceiptRuleSet struct {
}

func (*awsAwsquery_serializeOpDeleteReceiptRuleSet) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeleteReceiptRuleSet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteReceiptRuleSetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteReceiptRuleSet")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentDeleteReceiptRuleSetInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeleteTemplate struct {
}

func (*awsAwsquery_serializeOpDeleteTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeleteTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteTemplate")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentDeleteTemplateInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeleteVerifiedEmailAddress struct {
}

func (*awsAwsquery_serializeOpDeleteVerifiedEmailAddress) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeleteVerifiedEmailAddress) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteVerifiedEmailAddressInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteVerifiedEmailAddress")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentDeleteVerifiedEmailAddressInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeActiveReceiptRuleSet struct {
}

func (*awsAwsquery_serializeOpDescribeActiveReceiptRuleSet) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeActiveReceiptRuleSet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeActiveReceiptRuleSetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeActiveReceiptRuleSet")
	body.Key("Version").String("2010-12-01")

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeConfigurationSet struct {
}

func (*awsAwsquery_serializeOpDescribeConfigurationSet) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeConfigurationSet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeConfigurationSetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeConfigurationSet")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentDescribeConfigurationSetInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeReceiptRule struct {
}

func (*awsAwsquery_serializeOpDescribeReceiptRule) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeReceiptRule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeReceiptRuleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeReceiptRule")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentDescribeReceiptRuleInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeReceiptRuleSet struct {
}

func (*awsAwsquery_serializeOpDescribeReceiptRuleSet) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeReceiptRuleSet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeReceiptRuleSetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeReceiptRuleSet")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentDescribeReceiptRuleSetInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpGetAccountSendingEnabled struct {
}

func (*awsAwsquery_serializeOpGetAccountSendingEnabled) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpGetAccountSendingEnabled) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetAccountSendingEnabledInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("GetAccountSendingEnabled")
	body.Key("Version").String("2010-12-01")

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpGetCustomVerificationEmailTemplate struct {
}

func (*awsAwsquery_serializeOpGetCustomVerificationEmailTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpGetCustomVerificationEmailTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetCustomVerificationEmailTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("GetCustomVerificationEmailTemplate")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentGetCustomVerificationEmailTemplateInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpGetIdentityDkimAttributes struct {
}

func (*awsAwsquery_serializeOpGetIdentityDkimAttributes) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpGetIdentityDkimAttributes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetIdentityDkimAttributesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("GetIdentityDkimAttributes")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentGetIdentityDkimAttributesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpGetIdentityMailFromDomainAttributes struct {
}

func (*awsAwsquery_serializeOpGetIdentityMailFromDomainAttributes) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpGetIdentityMailFromDomainAttributes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetIdentityMailFromDomainAttributesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("GetIdentityMailFromDomainAttributes")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentGetIdentityMailFromDomainAttributesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpGetIdentityNotificationAttributes struct {
}

func (*awsAwsquery_serializeOpGetIdentityNotificationAttributes) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpGetIdentityNotificationAttributes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetIdentityNotificationAttributesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("GetIdentityNotificationAttributes")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentGetIdentityNotificationAttributesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpGetIdentityPolicies struct {
}

func (*awsAwsquery_serializeOpGetIdentityPolicies) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpGetIdentityPolicies) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetIdentityPoliciesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("GetIdentityPolicies")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentGetIdentityPoliciesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpGetIdentityVerificationAttributes struct {
}

func (*awsAwsquery_serializeOpGetIdentityVerificationAttributes) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpGetIdentityVerificationAttributes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetIdentityVerificationAttributesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("GetIdentityVerificationAttributes")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentGetIdentityVerificationAttributesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpGetSendQuota struct {
}

func (*awsAwsquery_serializeOpGetSendQuota) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpGetSendQuota) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetSendQuotaInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("GetSendQuota")
	body.Key("Version").String("2010-12-01")

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpGetSendStatistics struct {
}

func (*awsAwsquery_serializeOpGetSendStatistics) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpGetSendStatistics) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetSendStatisticsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("GetSendStatistics")
	body.Key("Version").String("2010-12-01")

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpGetTemplate struct {
}

func (*awsAwsquery_serializeOpGetTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpGetTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("GetTemplate")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentGetTemplateInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpListConfigurationSets struct {
}

func (*awsAwsquery_serializeOpListConfigurationSets) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpListConfigurationSets) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListConfigurationSetsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ListConfigurationSets")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentListConfigurationSetsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpListCustomVerificationEmailTemplates struct {
}

func (*awsAwsquery_serializeOpListCustomVerificationEmailTemplates) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpListCustomVerificationEmailTemplates) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListCustomVerificationEmailTemplatesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ListCustomVerificationEmailTemplates")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentListCustomVerificationEmailTemplatesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpListIdentities struct {
}

func (*awsAwsquery_serializeOpListIdentities) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpListIdentities) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListIdentitiesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ListIdentities")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentListIdentitiesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpListIdentityPolicies struct {
}

func (*awsAwsquery_serializeOpListIdentityPolicies) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpListIdentityPolicies) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListIdentityPoliciesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ListIdentityPolicies")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentListIdentityPoliciesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpListReceiptFilters struct {
}

func (*awsAwsquery_serializeOpListReceiptFilters) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpListReceiptFilters) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListReceiptFiltersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ListReceiptFilters")
	body.Key("Version").String("2010-12-01")

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpListReceiptRuleSets struct {
}

func (*awsAwsquery_serializeOpListReceiptRuleSets) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpListReceiptRuleSets) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListReceiptRuleSetsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ListReceiptRuleSets")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentListReceiptRuleSetsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpListTemplates struct {
}

func (*awsAwsquery_serializeOpListTemplates) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpListTemplates) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTemplatesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ListTemplates")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentListTemplatesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpListVerifiedEmailAddresses struct {
}

func (*awsAwsquery_serializeOpListVerifiedEmailAddresses) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpListVerifiedEmailAddresses) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListVerifiedEmailAddressesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ListVerifiedEmailAddresses")
	body.Key("Version").String("2010-12-01")

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpPutConfigurationSetDeliveryOptions struct {
}

func (*awsAwsquery_serializeOpPutConfigurationSetDeliveryOptions) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpPutConfigurationSetDeliveryOptions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutConfigurationSetDeliveryOptionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("PutConfigurationSetDeliveryOptions")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentPutConfigurationSetDeliveryOptionsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpPutIdentityPolicy struct {
}

func (*awsAwsquery_serializeOpPutIdentityPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpPutIdentityPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutIdentityPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("PutIdentityPolicy")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentPutIdentityPolicyInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpReorderReceiptRuleSet struct {
}

func (*awsAwsquery_serializeOpReorderReceiptRuleSet) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpReorderReceiptRuleSet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ReorderReceiptRuleSetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ReorderReceiptRuleSet")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentReorderReceiptRuleSetInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpSendBounce struct {
}

func (*awsAwsquery_serializeOpSendBounce) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpSendBounce) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SendBounceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("SendBounce")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentSendBounceInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpSendBulkTemplatedEmail struct {
}

func (*awsAwsquery_serializeOpSendBulkTemplatedEmail) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpSendBulkTemplatedEmail) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SendBulkTemplatedEmailInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("SendBulkTemplatedEmail")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentSendBulkTemplatedEmailInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpSendCustomVerificationEmail struct {
}

func (*awsAwsquery_serializeOpSendCustomVerificationEmail) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpSendCustomVerificationEmail) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SendCustomVerificationEmailInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("SendCustomVerificationEmail")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentSendCustomVerificationEmailInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpSendEmail struct {
}

func (*awsAwsquery_serializeOpSendEmail) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpSendEmail) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SendEmailInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("SendEmail")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentSendEmailInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpSendRawEmail struct {
}

func (*awsAwsquery_serializeOpSendRawEmail) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpSendRawEmail) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SendRawEmailInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("SendRawEmail")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentSendRawEmailInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpSendTemplatedEmail struct {
}

func (*awsAwsquery_serializeOpSendTemplatedEmail) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpSendTemplatedEmail) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SendTemplatedEmailInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("SendTemplatedEmail")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentSendTemplatedEmailInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpSetActiveReceiptRuleSet struct {
}

func (*awsAwsquery_serializeOpSetActiveReceiptRuleSet) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpSetActiveReceiptRuleSet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SetActiveReceiptRuleSetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("SetActiveReceiptRuleSet")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentSetActiveReceiptRuleSetInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpSetIdentityDkimEnabled struct {
}

func (*awsAwsquery_serializeOpSetIdentityDkimEnabled) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpSetIdentityDkimEnabled) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SetIdentityDkimEnabledInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("SetIdentityDkimEnabled")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentSetIdentityDkimEnabledInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpSetIdentityFeedbackForwardingEnabled struct {
}

func (*awsAwsquery_serializeOpSetIdentityFeedbackForwardingEnabled) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpSetIdentityFeedbackForwardingEnabled) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SetIdentityFeedbackForwardingEnabledInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("SetIdentityFeedbackForwardingEnabled")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentSetIdentityFeedbackForwardingEnabledInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpSetIdentityHeadersInNotificationsEnabled struct {
}

func (*awsAwsquery_serializeOpSetIdentityHeadersInNotificationsEnabled) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpSetIdentityHeadersInNotificationsEnabled) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SetIdentityHeadersInNotificationsEnabledInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("SetIdentityHeadersInNotificationsEnabled")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentSetIdentityHeadersInNotificationsEnabledInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpSetIdentityMailFromDomain struct {
}

func (*awsAwsquery_serializeOpSetIdentityMailFromDomain) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpSetIdentityMailFromDomain) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SetIdentityMailFromDomainInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("SetIdentityMailFromDomain")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentSetIdentityMailFromDomainInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpSetIdentityNotificationTopic struct {
}

func (*awsAwsquery_serializeOpSetIdentityNotificationTopic) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpSetIdentityNotificationTopic) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SetIdentityNotificationTopicInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("SetIdentityNotificationTopic")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentSetIdentityNotificationTopicInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpSetReceiptRulePosition struct {
}

func (*awsAwsquery_serializeOpSetReceiptRulePosition) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpSetReceiptRulePosition) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SetReceiptRulePositionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("SetReceiptRulePosition")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentSetReceiptRulePositionInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpTestRenderTemplate struct {
}

func (*awsAwsquery_serializeOpTestRenderTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpTestRenderTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TestRenderTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("TestRenderTemplate")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentTestRenderTemplateInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpUpdateAccountSendingEnabled struct {
}

func (*awsAwsquery_serializeOpUpdateAccountSendingEnabled) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpUpdateAccountSendingEnabled) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateAccountSendingEnabledInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("UpdateAccountSendingEnabled")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentUpdateAccountSendingEnabledInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpUpdateConfigurationSetEventDestination struct {
}

func (*awsAwsquery_serializeOpUpdateConfigurationSetEventDestination) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpUpdateConfigurationSetEventDestination) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateConfigurationSetEventDestinationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("UpdateConfigurationSetEventDestination")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentUpdateConfigurationSetEventDestinationInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpUpdateConfigurationSetReputationMetricsEnabled struct {
}

func (*awsAwsquery_serializeOpUpdateConfigurationSetReputationMetricsEnabled) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpUpdateConfigurationSetReputationMetricsEnabled) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateConfigurationSetReputationMetricsEnabledInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("UpdateConfigurationSetReputationMetricsEnabled")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentUpdateConfigurationSetReputationMetricsEnabledInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpUpdateConfigurationSetSendingEnabled struct {
}

func (*awsAwsquery_serializeOpUpdateConfigurationSetSendingEnabled) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpUpdateConfigurationSetSendingEnabled) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateConfigurationSetSendingEnabledInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("UpdateConfigurationSetSendingEnabled")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentUpdateConfigurationSetSendingEnabledInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpUpdateConfigurationSetTrackingOptions struct {
}

func (*awsAwsquery_serializeOpUpdateConfigurationSetTrackingOptions) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpUpdateConfigurationSetTrackingOptions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateConfigurationSetTrackingOptionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("UpdateConfigurationSetTrackingOptions")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentUpdateConfigurationSetTrackingOptionsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpUpdateCustomVerificationEmailTemplate struct {
}

func (*awsAwsquery_serializeOpUpdateCustomVerificationEmailTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpUpdateCustomVerificationEmailTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateCustomVerificationEmailTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("UpdateCustomVerificationEmailTemplate")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentUpdateCustomVerificationEmailTemplateInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpUpdateReceiptRule struct {
}

func (*awsAwsquery_serializeOpUpdateReceiptRule) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpUpdateReceiptRule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateReceiptRuleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("UpdateReceiptRule")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentUpdateReceiptRuleInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpUpdateTemplate struct {
}

func (*awsAwsquery_serializeOpUpdateTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpUpdateTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("UpdateTemplate")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentUpdateTemplateInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpVerifyDomainDkim struct {
}

func (*awsAwsquery_serializeOpVerifyDomainDkim) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpVerifyDomainDkim) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*VerifyDomainDkimInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("VerifyDomainDkim")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentVerifyDomainDkimInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpVerifyDomainIdentity struct {
}

func (*awsAwsquery_serializeOpVerifyDomainIdentity) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpVerifyDomainIdentity) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*VerifyDomainIdentityInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("VerifyDomainIdentity")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentVerifyDomainIdentityInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpVerifyEmailAddress struct {
}

func (*awsAwsquery_serializeOpVerifyEmailAddress) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpVerifyEmailAddress) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*VerifyEmailAddressInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("VerifyEmailAddress")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentVerifyEmailAddressInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpVerifyEmailIdentity struct {
}

func (*awsAwsquery_serializeOpVerifyEmailIdentity) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpVerifyEmailIdentity) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*VerifyEmailIdentityInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("VerifyEmailIdentity")
	body.Key("Version").String("2010-12-01")

	if err := awsAwsquery_serializeOpDocumentVerifyEmailIdentityInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsAwsquery_serializeDocumentAddHeaderAction(v *types.AddHeaderAction, value query.Value) error {
	object := value.Object()
	_ = object

	if v.HeaderName != nil {
		objectKey := object.Key("HeaderName")
		objectKey.String(*v.HeaderName)
	}

	if v.HeaderValue != nil {
		objectKey := object.Key("HeaderValue")
		objectKey.String(*v.HeaderValue)
	}

	return nil
}

func awsAwsquery_serializeDocumentAddressList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentBody(v *types.Body, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Html != nil {
		objectKey := object.Key("Html")
		if err := awsAwsquery_serializeDocumentContent(v.Html, objectKey); err != nil {
			return err
		}
	}

	if v.Text != nil {
		objectKey := object.Key("Text")
		if err := awsAwsquery_serializeDocumentContent(v.Text, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeDocumentBounceAction(v *types.BounceAction, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Message != nil {
		objectKey := object.Key("Message")
		objectKey.String(*v.Message)
	}

	if v.Sender != nil {
		objectKey := object.Key("Sender")
		objectKey.String(*v.Sender)
	}

	if v.SmtpReplyCode != nil {
		objectKey := object.Key("SmtpReplyCode")
		objectKey.String(*v.SmtpReplyCode)
	}

	if v.StatusCode != nil {
		objectKey := object.Key("StatusCode")
		objectKey.String(*v.StatusCode)
	}

	if v.TopicArn != nil {
		objectKey := object.Key("TopicArn")
		objectKey.String(*v.TopicArn)
	}

	return nil
}

func awsAwsquery_serializeDocumentBouncedRecipientInfo(v *types.BouncedRecipientInfo, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.BounceType) > 0 {
		objectKey := object.Key("BounceType")
		objectKey.String(string(v.BounceType))
	}

	if v.Recipient != nil {
		objectKey := object.Key("Recipient")
		objectKey.String(*v.Recipient)
	}

	if v.RecipientArn != nil {
		objectKey := object.Key("RecipientArn")
		objectKey.String(*v.RecipientArn)
	}

	if v.RecipientDsnFields != nil {
		objectKey := object.Key("RecipientDsnFields")
		if err := awsAwsquery_serializeDocumentRecipientDsnFields(v.RecipientDsnFields, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeDocumentBouncedRecipientInfoList(v []types.BouncedRecipientInfo, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		if err := awsAwsquery_serializeDocumentBouncedRecipientInfo(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentBulkEmailDestination(v *types.BulkEmailDestination, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Destination != nil {
		objectKey := object.Key("Destination")
		if err := awsAwsquery_serializeDocumentDestination(v.Destination, objectKey); err != nil {
			return err
		}
	}

	if v.ReplacementTags != nil {
		objectKey := object.Key("ReplacementTags")
		if err := awsAwsquery_serializeDocumentMessageTagList(v.ReplacementTags, objectKey); err != nil {
			return err
		}
	}

	if v.ReplacementTemplateData != nil {
		objectKey := object.Key("ReplacementTemplateData")
		objectKey.String(*v.ReplacementTemplateData)
	}

	return nil
}

func awsAwsquery_serializeDocumentBulkEmailDestinationList(v []types.BulkEmailDestination, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		if err := awsAwsquery_serializeDocumentBulkEmailDestination(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentCloudWatchDestination(v *types.CloudWatchDestination, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DimensionConfigurations != nil {
		objectKey := object.Key("DimensionConfigurations")
		if err := awsAwsquery_serializeDocumentCloudWatchDimensionConfigurations(v.DimensionConfigurations, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeDocumentCloudWatchDimensionConfiguration(v *types.CloudWatchDimensionConfiguration, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DefaultDimensionValue != nil {
		objectKey := object.Key("DefaultDimensionValue")
		objectKey.String(*v.DefaultDimensionValue)
	}

	if v.DimensionName != nil {
		objectKey := object.Key("DimensionName")
		objectKey.String(*v.DimensionName)
	}

	if len(v.DimensionValueSource) > 0 {
		objectKey := object.Key("DimensionValueSource")
		objectKey.String(string(v.DimensionValueSource))
	}

	return nil
}

func awsAwsquery_serializeDocumentCloudWatchDimensionConfigurations(v []types.CloudWatchDimensionConfiguration, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		if err := awsAwsquery_serializeDocumentCloudWatchDimensionConfiguration(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentConfigurationSet(v *types.ConfigurationSet, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Name != nil {
		objectKey := object.Key("Name")
		objectKey.String(*v.Name)
	}

	return nil
}

func awsAwsquery_serializeDocumentConfigurationSetAttributeList(v []types.ConfigurationSetAttribute, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsquery_serializeDocumentContent(v *types.Content, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Charset != nil {
		objectKey := object.Key("Charset")
		objectKey.String(*v.Charset)
	}

	if v.Data != nil {
		objectKey := object.Key("Data")
		objectKey.String(*v.Data)
	}

	return nil
}

func awsAwsquery_serializeDocumentDeliveryOptions(v *types.DeliveryOptions, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.TlsPolicy) > 0 {
		objectKey := object.Key("TlsPolicy")
		objectKey.String(string(v.TlsPolicy))
	}

	return nil
}

func awsAwsquery_serializeDocumentDestination(v *types.Destination, value query.Value) error {
	object := value.Object()
	_ = object

	if v.BccAddresses != nil {
		objectKey := object.Key("BccAddresses")
		if err := awsAwsquery_serializeDocumentAddressList(v.BccAddresses, objectKey); err != nil {
			return err
		}
	}

	if v.CcAddresses != nil {
		objectKey := object.Key("CcAddresses")
		if err := awsAwsquery_serializeDocumentAddressList(v.CcAddresses, objectKey); err != nil {
			return err
		}
	}

	if v.ToAddresses != nil {
		objectKey := object.Key("ToAddresses")
		if err := awsAwsquery_serializeDocumentAddressList(v.ToAddresses, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeDocumentEventDestination(v *types.EventDestination, value query.Value) error {
	object := value.Object()
	_ = object

	if v.CloudWatchDestination != nil {
		objectKey := object.Key("CloudWatchDestination")
		if err := awsAwsquery_serializeDocumentCloudWatchDestination(v.CloudWatchDestination, objectKey); err != nil {
			return err
		}
	}

	if v.Enabled {
		objectKey := object.Key("Enabled")
		objectKey.Boolean(v.Enabled)
	}

	if v.KinesisFirehoseDestination != nil {
		objectKey := object.Key("KinesisFirehoseDestination")
		if err := awsAwsquery_serializeDocumentKinesisFirehoseDestination(v.KinesisFirehoseDestination, objectKey); err != nil {
			return err
		}
	}

	if v.MatchingEventTypes != nil {
		objectKey := object.Key("MatchingEventTypes")
		if err := awsAwsquery_serializeDocumentEventTypes(v.MatchingEventTypes, objectKey); err != nil {
			return err
		}
	}

	if v.Name != nil {
		objectKey := object.Key("Name")
		objectKey.String(*v.Name)
	}

	if v.SNSDestination != nil {
		objectKey := object.Key("SNSDestination")
		if err := awsAwsquery_serializeDocumentSNSDestination(v.SNSDestination, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeDocumentEventTypes(v []types.EventType, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsquery_serializeDocumentExtensionField(v *types.ExtensionField, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Name != nil {
		objectKey := object.Key("Name")
		objectKey.String(*v.Name)
	}

	if v.Value != nil {
		objectKey := object.Key("Value")
		objectKey.String(*v.Value)
	}

	return nil
}

func awsAwsquery_serializeDocumentExtensionFieldList(v []types.ExtensionField, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		if err := awsAwsquery_serializeDocumentExtensionField(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentIdentityList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentKinesisFirehoseDestination(v *types.KinesisFirehoseDestination, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DeliveryStreamARN != nil {
		objectKey := object.Key("DeliveryStreamARN")
		objectKey.String(*v.DeliveryStreamARN)
	}

	if v.IAMRoleARN != nil {
		objectKey := object.Key("IAMRoleARN")
		objectKey.String(*v.IAMRoleARN)
	}

	return nil
}

func awsAwsquery_serializeDocumentLambdaAction(v *types.LambdaAction, value query.Value) error {
	object := value.Object()
	_ = object

	if v.FunctionArn != nil {
		objectKey := object.Key("FunctionArn")
		objectKey.String(*v.FunctionArn)
	}

	if len(v.InvocationType) > 0 {
		objectKey := object.Key("InvocationType")
		objectKey.String(string(v.InvocationType))
	}

	if v.TopicArn != nil {
		objectKey := object.Key("TopicArn")
		objectKey.String(*v.TopicArn)
	}

	return nil
}

func awsAwsquery_serializeDocumentMessage(v *types.Message, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Body != nil {
		objectKey := object.Key("Body")
		if err := awsAwsquery_serializeDocumentBody(v.Body, objectKey); err != nil {
			return err
		}
	}

	if v.Subject != nil {
		objectKey := object.Key("Subject")
		if err := awsAwsquery_serializeDocumentContent(v.Subject, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeDocumentMessageDsn(v *types.MessageDsn, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ArrivalDate != nil {
		objectKey := object.Key("ArrivalDate")
		objectKey.String(smithytime.FormatDateTime(*v.ArrivalDate))
	}

	if v.ExtensionFields != nil {
		objectKey := object.Key("ExtensionFields")
		if err := awsAwsquery_serializeDocumentExtensionFieldList(v.ExtensionFields, objectKey); err != nil {
			return err
		}
	}

	if v.ReportingMta != nil {
		objectKey := object.Key("ReportingMta")
		objectKey.String(*v.ReportingMta)
	}

	return nil
}

func awsAwsquery_serializeDocumentMessageTag(v *types.MessageTag, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Name != nil {
		objectKey := object.Key("Name")
		objectKey.String(*v.Name)
	}

	if v.Value != nil {
		objectKey := object.Key("Value")
		objectKey.String(*v.Value)
	}

	return nil
}

func awsAwsquery_serializeDocumentMessageTagList(v []types.MessageTag, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		if err := awsAwsquery_serializeDocumentMessageTag(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentPolicyNameList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentRawMessage(v *types.RawMessage, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Data != nil {
		objectKey := object.Key("Data")
		objectKey.Base64EncodeBytes(v.Data)
	}

	return nil
}

func awsAwsquery_serializeDocumentReceiptAction(v *types.ReceiptAction, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AddHeaderAction != nil {
		objectKey := object.Key("AddHeaderAction")
		if err := awsAwsquery_serializeDocumentAddHeaderAction(v.AddHeaderAction, objectKey); err != nil {
			return err
		}
	}

	if v.BounceAction != nil {
		objectKey := object.Key("BounceAction")
		if err := awsAwsquery_serializeDocumentBounceAction(v.BounceAction, objectKey); err != nil {
			return err
		}
	}

	if v.LambdaAction != nil {
		objectKey := object.Key("LambdaAction")
		if err := awsAwsquery_serializeDocumentLambdaAction(v.LambdaAction, objectKey); err != nil {
			return err
		}
	}

	if v.S3Action != nil {
		objectKey := object.Key("S3Action")
		if err := awsAwsquery_serializeDocumentS3Action(v.S3Action, objectKey); err != nil {
			return err
		}
	}

	if v.SNSAction != nil {
		objectKey := object.Key("SNSAction")
		if err := awsAwsquery_serializeDocumentSNSAction(v.SNSAction, objectKey); err != nil {
			return err
		}
	}

	if v.StopAction != nil {
		objectKey := object.Key("StopAction")
		if err := awsAwsquery_serializeDocumentStopAction(v.StopAction, objectKey); err != nil {
			return err
		}
	}

	if v.WorkmailAction != nil {
		objectKey := object.Key("WorkmailAction")
		if err := awsAwsquery_serializeDocumentWorkmailAction(v.WorkmailAction, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeDocumentReceiptActionsList(v []types.ReceiptAction, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		if err := awsAwsquery_serializeDocumentReceiptAction(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentReceiptFilter(v *types.ReceiptFilter, value query.Value) error {
	object := value.Object()
	_ = object

	if v.IpFilter != nil {
		objectKey := object.Key("IpFilter")
		if err := awsAwsquery_serializeDocumentReceiptIpFilter(v.IpFilter, objectKey); err != nil {
			return err
		}
	}

	if v.Name != nil {
		objectKey := object.Key("Name")
		objectKey.String(*v.Name)
	}

	return nil
}

func awsAwsquery_serializeDocumentReceiptIpFilter(v *types.ReceiptIpFilter, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Cidr != nil {
		objectKey := object.Key("Cidr")
		objectKey.String(*v.Cidr)
	}

	if len(v.Policy) > 0 {
		objectKey := object.Key("Policy")
		objectKey.String(string(v.Policy))
	}

	return nil
}

func awsAwsquery_serializeDocumentReceiptRule(v *types.ReceiptRule, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Actions != nil {
		objectKey := object.Key("Actions")
		if err := awsAwsquery_serializeDocumentReceiptActionsList(v.Actions, objectKey); err != nil {
			return err
		}
	}

	if v.Enabled {
		objectKey := object.Key("Enabled")
		objectKey.Boolean(v.Enabled)
	}

	if v.Name != nil {
		objectKey := object.Key("Name")
		objectKey.String(*v.Name)
	}

	if v.Recipients != nil {
		objectKey := object.Key("Recipients")
		if err := awsAwsquery_serializeDocumentRecipientsList(v.Recipients, objectKey); err != nil {
			return err
		}
	}

	if v.ScanEnabled {
		objectKey := object.Key("ScanEnabled")
		objectKey.Boolean(v.ScanEnabled)
	}

	if len(v.TlsPolicy) > 0 {
		objectKey := object.Key("TlsPolicy")
		objectKey.String(string(v.TlsPolicy))
	}

	return nil
}

func awsAwsquery_serializeDocumentReceiptRuleNamesList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentRecipientDsnFields(v *types.RecipientDsnFields, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.Action) > 0 {
		objectKey := object.Key("Action")
		objectKey.String(string(v.Action))
	}

	if v.DiagnosticCode != nil {
		objectKey := object.Key("DiagnosticCode")
		objectKey.String(*v.DiagnosticCode)
	}

	if v.ExtensionFields != nil {
		objectKey := object.Key("ExtensionFields")
		if err := awsAwsquery_serializeDocumentExtensionFieldList(v.ExtensionFields, objectKey); err != nil {
			return err
		}
	}

	if v.FinalRecipient != nil {
		objectKey := object.Key("FinalRecipient")
		objectKey.String(*v.FinalRecipient)
	}

	if v.LastAttemptDate != nil {
		objectKey := object.Key("LastAttemptDate")
		objectKey.String(smithytime.FormatDateTime(*v.LastAttemptDate))
	}

	if v.RemoteMta != nil {
		objectKey := object.Key("RemoteMta")
		objectKey.String(*v.RemoteMta)
	}

	if v.Status != nil {
		objectKey := object.Key("Status")
		objectKey.String(*v.Status)
	}

	return nil
}

func awsAwsquery_serializeDocumentRecipientsList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentS3Action(v *types.S3Action, value query.Value) error {
	object := value.Object()
	_ = object

	if v.BucketName != nil {
		objectKey := object.Key("BucketName")
		objectKey.String(*v.BucketName)
	}

	if v.KmsKeyArn != nil {
		objectKey := object.Key("KmsKeyArn")
		objectKey.String(*v.KmsKeyArn)
	}

	if v.ObjectKeyPrefix != nil {
		objectKey := object.Key("ObjectKeyPrefix")
		objectKey.String(*v.ObjectKeyPrefix)
	}

	if v.TopicArn != nil {
		objectKey := object.Key("TopicArn")
		objectKey.String(*v.TopicArn)
	}

	return nil
}

func awsAwsquery_serializeDocumentSNSAction(v *types.SNSAction, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.Encoding) > 0 {
		objectKey := object.Key("Encoding")
		objectKey.String(string(v.Encoding))
	}

	if v.TopicArn != nil {
		objectKey := object.Key("TopicArn")
		objectKey.String(*v.TopicArn)
	}

	return nil
}

func awsAwsquery_serializeDocumentSNSDestination(v *types.SNSDestination, value query.Value) error {
	object := value.Object()
	_ = object

	if v.TopicARN != nil {
		objectKey := object.Key("TopicARN")
		objectKey.String(*v.TopicARN)
	}

	return nil
}

func awsAwsquery_serializeDocumentStopAction(v *types.StopAction, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.Scope) > 0 {
		objectKey := object.Key("Scope")
		objectKey.String(string(v.Scope))
	}

	if v.TopicArn != nil {
		objectKey := object.Key("TopicArn")
		objectKey.String(*v.TopicArn)
	}

	return nil
}

func awsAwsquery_serializeDocumentTemplate(v *types.Template, value query.Value) error {
	object := value.Object()
	_ = object

	if v.HtmlPart != nil {
		objectKey := object.Key("HtmlPart")
		objectKey.String(*v.HtmlPart)
	}

	if v.SubjectPart != nil {
		objectKey := object.Key("SubjectPart")
		objectKey.String(*v.SubjectPart)
	}

	if v.TemplateName != nil {
		objectKey := object.Key("TemplateName")
		objectKey.String(*v.TemplateName)
	}

	if v.TextPart != nil {
		objectKey := object.Key("TextPart")
		objectKey.String(*v.TextPart)
	}

	return nil
}

func awsAwsquery_serializeDocumentTrackingOptions(v *types.TrackingOptions, value query.Value) error {
	object := value.Object()
	_ = object

	if v.CustomRedirectDomain != nil {
		objectKey := object.Key("CustomRedirectDomain")
		objectKey.String(*v.CustomRedirectDomain)
	}

	return nil
}

func awsAwsquery_serializeDocumentWorkmailAction(v *types.WorkmailAction, value query.Value) error {
	object := value.Object()
	_ = object

	if v.OrganizationArn != nil {
		objectKey := object.Key("OrganizationArn")
		objectKey.String(*v.OrganizationArn)
	}

	if v.TopicArn != nil {
		objectKey := object.Key("TopicArn")
		objectKey.String(*v.TopicArn)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentCloneReceiptRuleSetInput(v *CloneReceiptRuleSetInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.OriginalRuleSetName != nil {
		objectKey := object.Key("OriginalRuleSetName")
		objectKey.String(*v.OriginalRuleSetName)
	}

	if v.RuleSetName != nil {
		objectKey := object.Key("RuleSetName")
		objectKey.String(*v.RuleSetName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentCreateConfigurationSetEventDestinationInput(v *CreateConfigurationSetEventDestinationInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ConfigurationSetName != nil {
		objectKey := object.Key("ConfigurationSetName")
		objectKey.String(*v.ConfigurationSetName)
	}

	if v.EventDestination != nil {
		objectKey := object.Key("EventDestination")
		if err := awsAwsquery_serializeDocumentEventDestination(v.EventDestination, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentCreateConfigurationSetInput(v *CreateConfigurationSetInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ConfigurationSet != nil {
		objectKey := object.Key("ConfigurationSet")
		if err := awsAwsquery_serializeDocumentConfigurationSet(v.ConfigurationSet, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentCreateConfigurationSetTrackingOptionsInput(v *CreateConfigurationSetTrackingOptionsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ConfigurationSetName != nil {
		objectKey := object.Key("ConfigurationSetName")
		objectKey.String(*v.ConfigurationSetName)
	}

	if v.TrackingOptions != nil {
		objectKey := object.Key("TrackingOptions")
		if err := awsAwsquery_serializeDocumentTrackingOptions(v.TrackingOptions, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentCreateCustomVerificationEmailTemplateInput(v *CreateCustomVerificationEmailTemplateInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.FailureRedirectionURL != nil {
		objectKey := object.Key("FailureRedirectionURL")
		objectKey.String(*v.FailureRedirectionURL)
	}

	if v.FromEmailAddress != nil {
		objectKey := object.Key("FromEmailAddress")
		objectKey.String(*v.FromEmailAddress)
	}

	if v.SuccessRedirectionURL != nil {
		objectKey := object.Key("SuccessRedirectionURL")
		objectKey.String(*v.SuccessRedirectionURL)
	}

	if v.TemplateContent != nil {
		objectKey := object.Key("TemplateContent")
		objectKey.String(*v.TemplateContent)
	}

	if v.TemplateName != nil {
		objectKey := object.Key("TemplateName")
		objectKey.String(*v.TemplateName)
	}

	if v.TemplateSubject != nil {
		objectKey := object.Key("TemplateSubject")
		objectKey.String(*v.TemplateSubject)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentCreateReceiptFilterInput(v *CreateReceiptFilterInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Filter != nil {
		objectKey := object.Key("Filter")
		if err := awsAwsquery_serializeDocumentReceiptFilter(v.Filter, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentCreateReceiptRuleInput(v *CreateReceiptRuleInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.After != nil {
		objectKey := object.Key("After")
		objectKey.String(*v.After)
	}

	if v.Rule != nil {
		objectKey := object.Key("Rule")
		if err := awsAwsquery_serializeDocumentReceiptRule(v.Rule, objectKey); err != nil {
			return err
		}
	}

	if v.RuleSetName != nil {
		objectKey := object.Key("RuleSetName")
		objectKey.String(*v.RuleSetName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentCreateReceiptRuleSetInput(v *CreateReceiptRuleSetInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.RuleSetName != nil {
		objectKey := object.Key("RuleSetName")
		objectKey.String(*v.RuleSetName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentCreateTemplateInput(v *CreateTemplateInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Template != nil {
		objectKey := object.Key("Template")
		if err := awsAwsquery_serializeDocumentTemplate(v.Template, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeleteConfigurationSetEventDestinationInput(v *DeleteConfigurationSetEventDestinationInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ConfigurationSetName != nil {
		objectKey := object.Key("ConfigurationSetName")
		objectKey.String(*v.ConfigurationSetName)
	}

	if v.EventDestinationName != nil {
		objectKey := object.Key("EventDestinationName")
		objectKey.String(*v.EventDestinationName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeleteConfigurationSetInput(v *DeleteConfigurationSetInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ConfigurationSetName != nil {
		objectKey := object.Key("ConfigurationSetName")
		objectKey.String(*v.ConfigurationSetName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeleteConfigurationSetTrackingOptionsInput(v *DeleteConfigurationSetTrackingOptionsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ConfigurationSetName != nil {
		objectKey := object.Key("ConfigurationSetName")
		objectKey.String(*v.ConfigurationSetName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeleteCustomVerificationEmailTemplateInput(v *DeleteCustomVerificationEmailTemplateInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.TemplateName != nil {
		objectKey := object.Key("TemplateName")
		objectKey.String(*v.TemplateName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeleteIdentityInput(v *DeleteIdentityInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Identity != nil {
		objectKey := object.Key("Identity")
		objectKey.String(*v.Identity)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeleteIdentityPolicyInput(v *DeleteIdentityPolicyInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Identity != nil {
		objectKey := object.Key("Identity")
		objectKey.String(*v.Identity)
	}

	if v.PolicyName != nil {
		objectKey := object.Key("PolicyName")
		objectKey.String(*v.PolicyName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeleteReceiptFilterInput(v *DeleteReceiptFilterInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.FilterName != nil {
		objectKey := object.Key("FilterName")
		objectKey.String(*v.FilterName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeleteReceiptRuleInput(v *DeleteReceiptRuleInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.RuleName != nil {
		objectKey := object.Key("RuleName")
		objectKey.String(*v.RuleName)
	}

	if v.RuleSetName != nil {
		objectKey := object.Key("RuleSetName")
		objectKey.String(*v.RuleSetName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeleteReceiptRuleSetInput(v *DeleteReceiptRuleSetInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.RuleSetName != nil {
		objectKey := object.Key("RuleSetName")
		objectKey.String(*v.RuleSetName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeleteTemplateInput(v *DeleteTemplateInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.TemplateName != nil {
		objectKey := object.Key("TemplateName")
		objectKey.String(*v.TemplateName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeleteVerifiedEmailAddressInput(v *DeleteVerifiedEmailAddressInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.EmailAddress != nil {
		objectKey := object.Key("EmailAddress")
		objectKey.String(*v.EmailAddress)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeActiveReceiptRuleSetInput(v *DescribeActiveReceiptRuleSetInput, value query.Value) error {
	object := value.Object()
	_ = object

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeConfigurationSetInput(v *DescribeConfigurationSetInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ConfigurationSetAttributeNames != nil {
		objectKey := object.Key("ConfigurationSetAttributeNames")
		if err := awsAwsquery_serializeDocumentConfigurationSetAttributeList(v.ConfigurationSetAttributeNames, objectKey); err != nil {
			return err
		}
	}

	if v.ConfigurationSetName != nil {
		objectKey := object.Key("ConfigurationSetName")
		objectKey.String(*v.ConfigurationSetName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeReceiptRuleInput(v *DescribeReceiptRuleInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.RuleName != nil {
		objectKey := object.Key("RuleName")
		objectKey.String(*v.RuleName)
	}

	if v.RuleSetName != nil {
		objectKey := object.Key("RuleSetName")
		objectKey.String(*v.RuleSetName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeReceiptRuleSetInput(v *DescribeReceiptRuleSetInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.RuleSetName != nil {
		objectKey := object.Key("RuleSetName")
		objectKey.String(*v.RuleSetName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentGetCustomVerificationEmailTemplateInput(v *GetCustomVerificationEmailTemplateInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.TemplateName != nil {
		objectKey := object.Key("TemplateName")
		objectKey.String(*v.TemplateName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentGetIdentityDkimAttributesInput(v *GetIdentityDkimAttributesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Identities != nil {
		objectKey := object.Key("Identities")
		if err := awsAwsquery_serializeDocumentIdentityList(v.Identities, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentGetIdentityMailFromDomainAttributesInput(v *GetIdentityMailFromDomainAttributesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Identities != nil {
		objectKey := object.Key("Identities")
		if err := awsAwsquery_serializeDocumentIdentityList(v.Identities, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentGetIdentityNotificationAttributesInput(v *GetIdentityNotificationAttributesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Identities != nil {
		objectKey := object.Key("Identities")
		if err := awsAwsquery_serializeDocumentIdentityList(v.Identities, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentGetIdentityPoliciesInput(v *GetIdentityPoliciesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Identity != nil {
		objectKey := object.Key("Identity")
		objectKey.String(*v.Identity)
	}

	if v.PolicyNames != nil {
		objectKey := object.Key("PolicyNames")
		if err := awsAwsquery_serializeDocumentPolicyNameList(v.PolicyNames, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentGetIdentityVerificationAttributesInput(v *GetIdentityVerificationAttributesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Identities != nil {
		objectKey := object.Key("Identities")
		if err := awsAwsquery_serializeDocumentIdentityList(v.Identities, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentGetTemplateInput(v *GetTemplateInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.TemplateName != nil {
		objectKey := object.Key("TemplateName")
		objectKey.String(*v.TemplateName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentListConfigurationSetsInput(v *ListConfigurationSetsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.MaxItems != nil {
		objectKey := object.Key("MaxItems")
		objectKey.Integer(*v.MaxItems)
	}

	if v.NextToken != nil {
		objectKey := object.Key("NextToken")
		objectKey.String(*v.NextToken)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentListCustomVerificationEmailTemplatesInput(v *ListCustomVerificationEmailTemplatesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.MaxResults != nil {
		objectKey := object.Key("MaxResults")
		objectKey.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		objectKey := object.Key("NextToken")
		objectKey.String(*v.NextToken)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentListIdentitiesInput(v *ListIdentitiesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.IdentityType) > 0 {
		objectKey := object.Key("IdentityType")
		objectKey.String(string(v.IdentityType))
	}

	if v.MaxItems != nil {
		objectKey := object.Key("MaxItems")
		objectKey.Integer(*v.MaxItems)
	}

	if v.NextToken != nil {
		objectKey := object.Key("NextToken")
		objectKey.String(*v.NextToken)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentListIdentityPoliciesInput(v *ListIdentityPoliciesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Identity != nil {
		objectKey := object.Key("Identity")
		objectKey.String(*v.Identity)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentListReceiptFiltersInput(v *ListReceiptFiltersInput, value query.Value) error {
	object := value.Object()
	_ = object

	return nil
}

func awsAwsquery_serializeOpDocumentListReceiptRuleSetsInput(v *ListReceiptRuleSetsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.NextToken != nil {
		objectKey := object.Key("NextToken")
		objectKey.String(*v.NextToken)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentListTemplatesInput(v *ListTemplatesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.MaxItems != nil {
		objectKey := object.Key("MaxItems")
		objectKey.Integer(*v.MaxItems)
	}

	if v.NextToken != nil {
		objectKey := object.Key("NextToken")
		objectKey.String(*v.NextToken)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentPutConfigurationSetDeliveryOptionsInput(v *PutConfigurationSetDeliveryOptionsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ConfigurationSetName != nil {
		objectKey := object.Key("ConfigurationSetName")
		objectKey.String(*v.ConfigurationSetName)
	}

	if v.DeliveryOptions != nil {
		objectKey := object.Key("DeliveryOptions")
		if err := awsAwsquery_serializeDocumentDeliveryOptions(v.DeliveryOptions, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentPutIdentityPolicyInput(v *PutIdentityPolicyInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Identity != nil {
		objectKey := object.Key("Identity")
		objectKey.String(*v.Identity)
	}

	if v.Policy != nil {
		objectKey := object.Key("Policy")
		objectKey.String(*v.Policy)
	}

	if v.PolicyName != nil {
		objectKey := object.Key("PolicyName")
		objectKey.String(*v.PolicyName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentReorderReceiptRuleSetInput(v *ReorderReceiptRuleSetInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.RuleNames != nil {
		objectKey := object.Key("RuleNames")
		if err := awsAwsquery_serializeDocumentReceiptRuleNamesList(v.RuleNames, objectKey); err != nil {
			return err
		}
	}

	if v.RuleSetName != nil {
		objectKey := object.Key("RuleSetName")
		objectKey.String(*v.RuleSetName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentSendBounceInput(v *SendBounceInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.BouncedRecipientInfoList != nil {
		objectKey := object.Key("BouncedRecipientInfoList")
		if err := awsAwsquery_serializeDocumentBouncedRecipientInfoList(v.BouncedRecipientInfoList, objectKey); err != nil {
			return err
		}
	}

	if v.BounceSender != nil {
		objectKey := object.Key("BounceSender")
		objectKey.String(*v.BounceSender)
	}

	if v.BounceSenderArn != nil {
		objectKey := object.Key("BounceSenderArn")
		objectKey.String(*v.BounceSenderArn)
	}

	if v.Explanation != nil {
		objectKey := object.Key("Explanation")
		objectKey.String(*v.Explanation)
	}

	if v.MessageDsn != nil {
		objectKey := object.Key("MessageDsn")
		if err := awsAwsquery_serializeDocumentMessageDsn(v.MessageDsn, objectKey); err != nil {
			return err
		}
	}

	if v.OriginalMessageId != nil {
		objectKey := object.Key("OriginalMessageId")
		objectKey.String(*v.OriginalMessageId)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentSendBulkTemplatedEmailInput(v *SendBulkTemplatedEmailInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ConfigurationSetName != nil {
		objectKey := object.Key("ConfigurationSetName")
		objectKey.String(*v.ConfigurationSetName)
	}

	if v.DefaultTags != nil {
		objectKey := object.Key("DefaultTags")
		if err := awsAwsquery_serializeDocumentMessageTagList(v.DefaultTags, objectKey); err != nil {
			return err
		}
	}

	if v.DefaultTemplateData != nil {
		objectKey := object.Key("DefaultTemplateData")
		objectKey.String(*v.DefaultTemplateData)
	}

	if v.Destinations != nil {
		objectKey := object.Key("Destinations")
		if err := awsAwsquery_serializeDocumentBulkEmailDestinationList(v.Destinations, objectKey); err != nil {
			return err
		}
	}

	if v.ReplyToAddresses != nil {
		objectKey := object.Key("ReplyToAddresses")
		if err := awsAwsquery_serializeDocumentAddressList(v.ReplyToAddresses, objectKey); err != nil {
			return err
		}
	}

	if v.ReturnPath != nil {
		objectKey := object.Key("ReturnPath")
		objectKey.String(*v.ReturnPath)
	}

	if v.ReturnPathArn != nil {
		objectKey := object.Key("ReturnPathArn")
		objectKey.String(*v.ReturnPathArn)
	}

	if v.Source != nil {
		objectKey := object.Key("Source")
		objectKey.String(*v.Source)
	}

	if v.SourceArn != nil {
		objectKey := object.Key("SourceArn")
		objectKey.String(*v.SourceArn)
	}

	if v.Template != nil {
		objectKey := object.Key("Template")
		objectKey.String(*v.Template)
	}

	if v.TemplateArn != nil {
		objectKey := object.Key("TemplateArn")
		objectKey.String(*v.TemplateArn)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentSendCustomVerificationEmailInput(v *SendCustomVerificationEmailInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ConfigurationSetName != nil {
		objectKey := object.Key("ConfigurationSetName")
		objectKey.String(*v.ConfigurationSetName)
	}

	if v.EmailAddress != nil {
		objectKey := object.Key("EmailAddress")
		objectKey.String(*v.EmailAddress)
	}

	if v.TemplateName != nil {
		objectKey := object.Key("TemplateName")
		objectKey.String(*v.TemplateName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentSendEmailInput(v *SendEmailInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ConfigurationSetName != nil {
		objectKey := object.Key("ConfigurationSetName")
		objectKey.String(*v.ConfigurationSetName)
	}

	if v.Destination != nil {
		objectKey := object.Key("Destination")
		if err := awsAwsquery_serializeDocumentDestination(v.Destination, objectKey); err != nil {
			return err
		}
	}

	if v.Message != nil {
		objectKey := object.Key("Message")
		if err := awsAwsquery_serializeDocumentMessage(v.Message, objectKey); err != nil {
			return err
		}
	}

	if v.ReplyToAddresses != nil {
		objectKey := object.Key("ReplyToAddresses")
		if err := awsAwsquery_serializeDocumentAddressList(v.ReplyToAddresses, objectKey); err != nil {
			return err
		}
	}

	if v.ReturnPath != nil {
		objectKey := object.Key("ReturnPath")
		objectKey.String(*v.ReturnPath)
	}

	if v.ReturnPathArn != nil {
		objectKey := object.Key("ReturnPathArn")
		objectKey.String(*v.ReturnPathArn)
	}

	if v.Source != nil {
		objectKey := object.Key("Source")
		objectKey.String(*v.Source)
	}

	if v.SourceArn != nil {
		objectKey := object.Key("SourceArn")
		objectKey.String(*v.SourceArn)
	}

	if v.Tags != nil {
		objectKey := object.Key("Tags")
		if err := awsAwsquery_serializeDocumentMessageTagList(v.Tags, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentSendRawEmailInput(v *SendRawEmailInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ConfigurationSetName != nil {
		objectKey := object.Key("ConfigurationSetName")
		objectKey.String(*v.ConfigurationSetName)
	}

	if v.Destinations != nil {
		objectKey := object.Key("Destinations")
		if err := awsAwsquery_serializeDocumentAddressList(v.Destinations, objectKey); err != nil {
			return err
		}
	}

	if v.FromArn != nil {
		objectKey := object.Key("FromArn")
		objectKey.String(*v.FromArn)
	}

	if v.RawMessage != nil {
		objectKey := object.Key("RawMessage")
		if err := awsAwsquery_serializeDocumentRawMessage(v.RawMessage, objectKey); err != nil {
			return err
		}
	}

	if v.ReturnPathArn != nil {
		objectKey := object.Key("ReturnPathArn")
		objectKey.String(*v.ReturnPathArn)
	}

	if v.Source != nil {
		objectKey := object.Key("Source")
		objectKey.String(*v.Source)
	}

	if v.SourceArn != nil {
		objectKey := object.Key("SourceArn")
		objectKey.String(*v.SourceArn)
	}

	if v.Tags != nil {
		objectKey := object.Key("Tags")
		if err := awsAwsquery_serializeDocumentMessageTagList(v.Tags, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentSendTemplatedEmailInput(v *SendTemplatedEmailInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ConfigurationSetName != nil {
		objectKey := object.Key("ConfigurationSetName")
		objectKey.String(*v.ConfigurationSetName)
	}

	if v.Destination != nil {
		objectKey := object.Key("Destination")
		if err := awsAwsquery_serializeDocumentDestination(v.Destination, objectKey); err != nil {
			return err
		}
	}

	if v.ReplyToAddresses != nil {
		objectKey := object.Key("ReplyToAddresses")
		if err := awsAwsquery_serializeDocumentAddressList(v.ReplyToAddresses, objectKey); err != nil {
			return err
		}
	}

	if v.ReturnPath != nil {
		objectKey := object.Key("ReturnPath")
		objectKey.String(*v.ReturnPath)
	}

	if v.ReturnPathArn != nil {
		objectKey := object.Key("ReturnPathArn")
		objectKey.String(*v.ReturnPathArn)
	}

	if v.Source != nil {
		objectKey := object.Key("Source")
		objectKey.String(*v.Source)
	}

	if v.SourceArn != nil {
		objectKey := object.Key("SourceArn")
		objectKey.String(*v.SourceArn)
	}

	if v.Tags != nil {
		objectKey := object.Key("Tags")
		if err := awsAwsquery_serializeDocumentMessageTagList(v.Tags, objectKey); err != nil {
			return err
		}
	}

	if v.Template != nil {
		objectKey := object.Key("Template")
		objectKey.String(*v.Template)
	}

	if v.TemplateArn != nil {
		objectKey := object.Key("TemplateArn")
		objectKey.String(*v.TemplateArn)
	}

	if v.TemplateData != nil {
		objectKey := object.Key("TemplateData")
		objectKey.String(*v.TemplateData)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentSetActiveReceiptRuleSetInput(v *SetActiveReceiptRuleSetInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.RuleSetName != nil {
		objectKey := object.Key("RuleSetName")
		objectKey.String(*v.RuleSetName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentSetIdentityDkimEnabledInput(v *SetIdentityDkimEnabledInput, value query.Value) error {
	object := value.Object()
	_ = object

	{
		objectKey := object.Key("DkimEnabled")
		objectKey.Boolean(v.DkimEnabled)
	}

	if v.Identity != nil {
		objectKey := object.Key("Identity")
		objectKey.String(*v.Identity)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentSetIdentityFeedbackForwardingEnabledInput(v *SetIdentityFeedbackForwardingEnabledInput, value query.Value) error {
	object := value.Object()
	_ = object

	{
		objectKey := object.Key("ForwardingEnabled")
		objectKey.Boolean(v.ForwardingEnabled)
	}

	if v.Identity != nil {
		objectKey := object.Key("Identity")
		objectKey.String(*v.Identity)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentSetIdentityHeadersInNotificationsEnabledInput(v *SetIdentityHeadersInNotificationsEnabledInput, value query.Value) error {
	object := value.Object()
	_ = object

	{
		objectKey := object.Key("Enabled")
		objectKey.Boolean(v.Enabled)
	}

	if v.Identity != nil {
		objectKey := object.Key("Identity")
		objectKey.String(*v.Identity)
	}

	if len(v.NotificationType) > 0 {
		objectKey := object.Key("NotificationType")
		objectKey.String(string(v.NotificationType))
	}

	return nil
}

func awsAwsquery_serializeOpDocumentSetIdentityMailFromDomainInput(v *SetIdentityMailFromDomainInput, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.BehaviorOnMXFailure) > 0 {
		objectKey := object.Key("BehaviorOnMXFailure")
		objectKey.String(string(v.BehaviorOnMXFailure))
	}

	if v.Identity != nil {
		objectKey := object.Key("Identity")
		objectKey.String(*v.Identity)
	}

	if v.MailFromDomain != nil {
		objectKey := object.Key("MailFromDomain")
		objectKey.String(*v.MailFromDomain)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentSetIdentityNotificationTopicInput(v *SetIdentityNotificationTopicInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Identity != nil {
		objectKey := object.Key("Identity")
		objectKey.String(*v.Identity)
	}

	if len(v.NotificationType) > 0 {
		objectKey := object.Key("NotificationType")
		objectKey.String(string(v.NotificationType))
	}

	if v.SnsTopic != nil {
		objectKey := object.Key("SnsTopic")
		objectKey.String(*v.SnsTopic)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentSetReceiptRulePositionInput(v *SetReceiptRulePositionInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.After != nil {
		objectKey := object.Key("After")
		objectKey.String(*v.After)
	}

	if v.RuleName != nil {
		objectKey := object.Key("RuleName")
		objectKey.String(*v.RuleName)
	}

	if v.RuleSetName != nil {
		objectKey := object.Key("RuleSetName")
		objectKey.String(*v.RuleSetName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentTestRenderTemplateInput(v *TestRenderTemplateInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.TemplateData != nil {
		objectKey := object.Key("TemplateData")
		objectKey.String(*v.TemplateData)
	}

	if v.TemplateName != nil {
		objectKey := object.Key("TemplateName")
		objectKey.String(*v.TemplateName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentUpdateAccountSendingEnabledInput(v *UpdateAccountSendingEnabledInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Enabled {
		objectKey := object.Key("Enabled")
		objectKey.Boolean(v.Enabled)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentUpdateConfigurationSetEventDestinationInput(v *UpdateConfigurationSetEventDestinationInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ConfigurationSetName != nil {
		objectKey := object.Key("ConfigurationSetName")
		objectKey.String(*v.ConfigurationSetName)
	}

	if v.EventDestination != nil {
		objectKey := object.Key("EventDestination")
		if err := awsAwsquery_serializeDocumentEventDestination(v.EventDestination, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentUpdateConfigurationSetReputationMetricsEnabledInput(v *UpdateConfigurationSetReputationMetricsEnabledInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ConfigurationSetName != nil {
		objectKey := object.Key("ConfigurationSetName")
		objectKey.String(*v.ConfigurationSetName)
	}

	{
		objectKey := object.Key("Enabled")
		objectKey.Boolean(v.Enabled)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentUpdateConfigurationSetSendingEnabledInput(v *UpdateConfigurationSetSendingEnabledInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ConfigurationSetName != nil {
		objectKey := object.Key("ConfigurationSetName")
		objectKey.String(*v.ConfigurationSetName)
	}

	{
		objectKey := object.Key("Enabled")
		objectKey.Boolean(v.Enabled)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentUpdateConfigurationSetTrackingOptionsInput(v *UpdateConfigurationSetTrackingOptionsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ConfigurationSetName != nil {
		objectKey := object.Key("ConfigurationSetName")
		objectKey.String(*v.ConfigurationSetName)
	}

	if v.TrackingOptions != nil {
		objectKey := object.Key("TrackingOptions")
		if err := awsAwsquery_serializeDocumentTrackingOptions(v.TrackingOptions, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentUpdateCustomVerificationEmailTemplateInput(v *UpdateCustomVerificationEmailTemplateInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.FailureRedirectionURL != nil {
		objectKey := object.Key("FailureRedirectionURL")
		objectKey.String(*v.FailureRedirectionURL)
	}

	if v.FromEmailAddress != nil {
		objectKey := object.Key("FromEmailAddress")
		objectKey.String(*v.FromEmailAddress)
	}

	if v.SuccessRedirectionURL != nil {
		objectKey := object.Key("SuccessRedirectionURL")
		objectKey.String(*v.SuccessRedirectionURL)
	}

	if v.TemplateContent != nil {
		objectKey := object.Key("TemplateContent")
		objectKey.String(*v.TemplateContent)
	}

	if v.TemplateName != nil {
		objectKey := object.Key("TemplateName")
		objectKey.String(*v.TemplateName)
	}

	if v.TemplateSubject != nil {
		objectKey := object.Key("TemplateSubject")
		objectKey.String(*v.TemplateSubject)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentUpdateReceiptRuleInput(v *UpdateReceiptRuleInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Rule != nil {
		objectKey := object.Key("Rule")
		if err := awsAwsquery_serializeDocumentReceiptRule(v.Rule, objectKey); err != nil {
			return err
		}
	}

	if v.RuleSetName != nil {
		objectKey := object.Key("RuleSetName")
		objectKey.String(*v.RuleSetName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentUpdateTemplateInput(v *UpdateTemplateInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Template != nil {
		objectKey := object.Key("Template")
		if err := awsAwsquery_serializeDocumentTemplate(v.Template, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentVerifyDomainDkimInput(v *VerifyDomainDkimInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Domain != nil {
		objectKey := object.Key("Domain")
		objectKey.String(*v.Domain)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentVerifyDomainIdentityInput(v *VerifyDomainIdentityInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Domain != nil {
		objectKey := object.Key("Domain")
		objectKey.String(*v.Domain)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentVerifyEmailAddressInput(v *VerifyEmailAddressInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.EmailAddress != nil {
		objectKey := object.Key("EmailAddress")
		objectKey.String(*v.EmailAddress)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentVerifyEmailIdentityInput(v *VerifyEmailIdentityInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.EmailAddress != nil {
		objectKey := object.Key("EmailAddress")
		objectKey.String(*v.EmailAddress)
	}

	return nil
}
