package network

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// Access enumerates the values for access.
type Access string

const (
	// AccessAllow ...
	AccessAllow Access = "Allow"
	// AccessDeny ...
	AccessDeny Access = "Deny"
)

// PossibleAccessValues returns an array of possible values for the Access const type.
func PossibleAccessValues() []Access {
	return []Access{AccessAllow, AccessDeny}
}

// ApplicationGatewayBackendHealthServerHealth enumerates the values for application gateway backend health
// server health.
type ApplicationGatewayBackendHealthServerHealth string

const (
	// ApplicationGatewayBackendHealthServerHealthDown ...
	ApplicationGatewayBackendHealthServerHealthDown ApplicationGatewayBackendHealthServerHealth = "Down"
	// ApplicationGatewayBackendHealthServerHealthDraining ...
	ApplicationGatewayBackendHealthServerHealthDraining ApplicationGatewayBackendHealthServerHealth = "Draining"
	// ApplicationGatewayBackendHealthServerHealthPartial ...
	ApplicationGatewayBackendHealthServerHealthPartial ApplicationGatewayBackendHealthServerHealth = "Partial"
	// ApplicationGatewayBackendHealthServerHealthUnknown ...
	ApplicationGatewayBackendHealthServerHealthUnknown ApplicationGatewayBackendHealthServerHealth = "Unknown"
	// ApplicationGatewayBackendHealthServerHealthUp ...
	ApplicationGatewayBackendHealthServerHealthUp ApplicationGatewayBackendHealthServerHealth = "Up"
)

// PossibleApplicationGatewayBackendHealthServerHealthValues returns an array of possible values for the ApplicationGatewayBackendHealthServerHealth const type.
func PossibleApplicationGatewayBackendHealthServerHealthValues() []ApplicationGatewayBackendHealthServerHealth {
	return []ApplicationGatewayBackendHealthServerHealth{ApplicationGatewayBackendHealthServerHealthDown, ApplicationGatewayBackendHealthServerHealthDraining, ApplicationGatewayBackendHealthServerHealthPartial, ApplicationGatewayBackendHealthServerHealthUnknown, ApplicationGatewayBackendHealthServerHealthUp}
}

// ApplicationGatewayCookieBasedAffinity enumerates the values for application gateway cookie based affinity.
type ApplicationGatewayCookieBasedAffinity string

const (
	// ApplicationGatewayCookieBasedAffinityDisabled ...
	ApplicationGatewayCookieBasedAffinityDisabled ApplicationGatewayCookieBasedAffinity = "Disabled"
	// ApplicationGatewayCookieBasedAffinityEnabled ...
	ApplicationGatewayCookieBasedAffinityEnabled ApplicationGatewayCookieBasedAffinity = "Enabled"
)

// PossibleApplicationGatewayCookieBasedAffinityValues returns an array of possible values for the ApplicationGatewayCookieBasedAffinity const type.
func PossibleApplicationGatewayCookieBasedAffinityValues() []ApplicationGatewayCookieBasedAffinity {
	return []ApplicationGatewayCookieBasedAffinity{ApplicationGatewayCookieBasedAffinityDisabled, ApplicationGatewayCookieBasedAffinityEnabled}
}

// ApplicationGatewayCustomErrorStatusCode enumerates the values for application gateway custom error status
// code.
type ApplicationGatewayCustomErrorStatusCode string

const (
	// ApplicationGatewayCustomErrorStatusCodeHTTPStatus403 ...
	ApplicationGatewayCustomErrorStatusCodeHTTPStatus403 ApplicationGatewayCustomErrorStatusCode = "HttpStatus403"
	// ApplicationGatewayCustomErrorStatusCodeHTTPStatus502 ...
	ApplicationGatewayCustomErrorStatusCodeHTTPStatus502 ApplicationGatewayCustomErrorStatusCode = "HttpStatus502"
)

// PossibleApplicationGatewayCustomErrorStatusCodeValues returns an array of possible values for the ApplicationGatewayCustomErrorStatusCode const type.
func PossibleApplicationGatewayCustomErrorStatusCodeValues() []ApplicationGatewayCustomErrorStatusCode {
	return []ApplicationGatewayCustomErrorStatusCode{ApplicationGatewayCustomErrorStatusCodeHTTPStatus403, ApplicationGatewayCustomErrorStatusCodeHTTPStatus502}
}

// ApplicationGatewayFirewallMode enumerates the values for application gateway firewall mode.
type ApplicationGatewayFirewallMode string

const (
	// ApplicationGatewayFirewallModeDetection ...
	ApplicationGatewayFirewallModeDetection ApplicationGatewayFirewallMode = "Detection"
	// ApplicationGatewayFirewallModePrevention ...
	ApplicationGatewayFirewallModePrevention ApplicationGatewayFirewallMode = "Prevention"
)

// PossibleApplicationGatewayFirewallModeValues returns an array of possible values for the ApplicationGatewayFirewallMode const type.
func PossibleApplicationGatewayFirewallModeValues() []ApplicationGatewayFirewallMode {
	return []ApplicationGatewayFirewallMode{ApplicationGatewayFirewallModeDetection, ApplicationGatewayFirewallModePrevention}
}

// ApplicationGatewayLoadDistributionAlgorithm enumerates the values for application gateway load distribution
// algorithm.
type ApplicationGatewayLoadDistributionAlgorithm string

const (
	// ApplicationGatewayLoadDistributionAlgorithmIPHash ...
	ApplicationGatewayLoadDistributionAlgorithmIPHash ApplicationGatewayLoadDistributionAlgorithm = "IpHash"
	// ApplicationGatewayLoadDistributionAlgorithmLeastConnections ...
	ApplicationGatewayLoadDistributionAlgorithmLeastConnections ApplicationGatewayLoadDistributionAlgorithm = "LeastConnections"
	// ApplicationGatewayLoadDistributionAlgorithmRoundRobin ...
	ApplicationGatewayLoadDistributionAlgorithmRoundRobin ApplicationGatewayLoadDistributionAlgorithm = "RoundRobin"
)

// PossibleApplicationGatewayLoadDistributionAlgorithmValues returns an array of possible values for the ApplicationGatewayLoadDistributionAlgorithm const type.
func PossibleApplicationGatewayLoadDistributionAlgorithmValues() []ApplicationGatewayLoadDistributionAlgorithm {
	return []ApplicationGatewayLoadDistributionAlgorithm{ApplicationGatewayLoadDistributionAlgorithmIPHash, ApplicationGatewayLoadDistributionAlgorithmLeastConnections, ApplicationGatewayLoadDistributionAlgorithmRoundRobin}
}

// ApplicationGatewayOperationalState enumerates the values for application gateway operational state.
type ApplicationGatewayOperationalState string

const (
	// ApplicationGatewayOperationalStateRunning ...
	ApplicationGatewayOperationalStateRunning ApplicationGatewayOperationalState = "Running"
	// ApplicationGatewayOperationalStateStarting ...
	ApplicationGatewayOperationalStateStarting ApplicationGatewayOperationalState = "Starting"
	// ApplicationGatewayOperationalStateStopped ...
	ApplicationGatewayOperationalStateStopped ApplicationGatewayOperationalState = "Stopped"
	// ApplicationGatewayOperationalStateStopping ...
	ApplicationGatewayOperationalStateStopping ApplicationGatewayOperationalState = "Stopping"
)

// PossibleApplicationGatewayOperationalStateValues returns an array of possible values for the ApplicationGatewayOperationalState const type.
func PossibleApplicationGatewayOperationalStateValues() []ApplicationGatewayOperationalState {
	return []ApplicationGatewayOperationalState{ApplicationGatewayOperationalStateRunning, ApplicationGatewayOperationalStateStarting, ApplicationGatewayOperationalStateStopped, ApplicationGatewayOperationalStateStopping}
}

// ApplicationGatewayProtocol enumerates the values for application gateway protocol.
type ApplicationGatewayProtocol string

const (
	// ApplicationGatewayProtocolHTTP ...
	ApplicationGatewayProtocolHTTP ApplicationGatewayProtocol = "Http"
	// ApplicationGatewayProtocolHTTPS ...
	ApplicationGatewayProtocolHTTPS ApplicationGatewayProtocol = "Https"
)

// PossibleApplicationGatewayProtocolValues returns an array of possible values for the ApplicationGatewayProtocol const type.
func PossibleApplicationGatewayProtocolValues() []ApplicationGatewayProtocol {
	return []ApplicationGatewayProtocol{ApplicationGatewayProtocolHTTP, ApplicationGatewayProtocolHTTPS}
}

// ApplicationGatewayRedirectType enumerates the values for application gateway redirect type.
type ApplicationGatewayRedirectType string

const (
	// ApplicationGatewayRedirectTypeFound ...
	ApplicationGatewayRedirectTypeFound ApplicationGatewayRedirectType = "Found"
	// ApplicationGatewayRedirectTypePermanent ...
	ApplicationGatewayRedirectTypePermanent ApplicationGatewayRedirectType = "Permanent"
	// ApplicationGatewayRedirectTypeSeeOther ...
	ApplicationGatewayRedirectTypeSeeOther ApplicationGatewayRedirectType = "SeeOther"
	// ApplicationGatewayRedirectTypeTemporary ...
	ApplicationGatewayRedirectTypeTemporary ApplicationGatewayRedirectType = "Temporary"
)

// PossibleApplicationGatewayRedirectTypeValues returns an array of possible values for the ApplicationGatewayRedirectType const type.
func PossibleApplicationGatewayRedirectTypeValues() []ApplicationGatewayRedirectType {
	return []ApplicationGatewayRedirectType{ApplicationGatewayRedirectTypeFound, ApplicationGatewayRedirectTypePermanent, ApplicationGatewayRedirectTypeSeeOther, ApplicationGatewayRedirectTypeTemporary}
}

// ApplicationGatewayRequestRoutingRuleType enumerates the values for application gateway request routing rule
// type.
type ApplicationGatewayRequestRoutingRuleType string

const (
	// ApplicationGatewayRequestRoutingRuleTypeBasic ...
	ApplicationGatewayRequestRoutingRuleTypeBasic ApplicationGatewayRequestRoutingRuleType = "Basic"
	// ApplicationGatewayRequestRoutingRuleTypePathBasedRouting ...
	ApplicationGatewayRequestRoutingRuleTypePathBasedRouting ApplicationGatewayRequestRoutingRuleType = "PathBasedRouting"
)

// PossibleApplicationGatewayRequestRoutingRuleTypeValues returns an array of possible values for the ApplicationGatewayRequestRoutingRuleType const type.
func PossibleApplicationGatewayRequestRoutingRuleTypeValues() []ApplicationGatewayRequestRoutingRuleType {
	return []ApplicationGatewayRequestRoutingRuleType{ApplicationGatewayRequestRoutingRuleTypeBasic, ApplicationGatewayRequestRoutingRuleTypePathBasedRouting}
}

// ApplicationGatewaySkuName enumerates the values for application gateway sku name.
type ApplicationGatewaySkuName string

const (
	// ApplicationGatewaySkuNameStandardLarge ...
	ApplicationGatewaySkuNameStandardLarge ApplicationGatewaySkuName = "Standard_Large"
	// ApplicationGatewaySkuNameStandardMedium ...
	ApplicationGatewaySkuNameStandardMedium ApplicationGatewaySkuName = "Standard_Medium"
	// ApplicationGatewaySkuNameStandardSmall ...
	ApplicationGatewaySkuNameStandardSmall ApplicationGatewaySkuName = "Standard_Small"
	// ApplicationGatewaySkuNameStandardV2 ...
	ApplicationGatewaySkuNameStandardV2 ApplicationGatewaySkuName = "Standard_v2"
	// ApplicationGatewaySkuNameWAFLarge ...
	ApplicationGatewaySkuNameWAFLarge ApplicationGatewaySkuName = "WAF_Large"
	// ApplicationGatewaySkuNameWAFMedium ...
	ApplicationGatewaySkuNameWAFMedium ApplicationGatewaySkuName = "WAF_Medium"
	// ApplicationGatewaySkuNameWAFV2 ...
	ApplicationGatewaySkuNameWAFV2 ApplicationGatewaySkuName = "WAF_v2"
)

// PossibleApplicationGatewaySkuNameValues returns an array of possible values for the ApplicationGatewaySkuName const type.
func PossibleApplicationGatewaySkuNameValues() []ApplicationGatewaySkuName {
	return []ApplicationGatewaySkuName{ApplicationGatewaySkuNameStandardLarge, ApplicationGatewaySkuNameStandardMedium, ApplicationGatewaySkuNameStandardSmall, ApplicationGatewaySkuNameStandardV2, ApplicationGatewaySkuNameWAFLarge, ApplicationGatewaySkuNameWAFMedium, ApplicationGatewaySkuNameWAFV2}
}

// ApplicationGatewaySslCipherSuite enumerates the values for application gateway ssl cipher suite.
type ApplicationGatewaySslCipherSuite string

const (
	// ApplicationGatewaySslCipherSuiteTLSDHEDSSWITH3DESEDECBCSHA ...
	ApplicationGatewaySslCipherSuiteTLSDHEDSSWITH3DESEDECBCSHA ApplicationGatewaySslCipherSuite = "TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA"
	// ApplicationGatewaySslCipherSuiteTLSDHEDSSWITHAES128CBCSHA ...
	ApplicationGatewaySslCipherSuiteTLSDHEDSSWITHAES128CBCSHA ApplicationGatewaySslCipherSuite = "TLS_DHE_DSS_WITH_AES_128_CBC_SHA"
	// ApplicationGatewaySslCipherSuiteTLSDHEDSSWITHAES128CBCSHA256 ...
	ApplicationGatewaySslCipherSuiteTLSDHEDSSWITHAES128CBCSHA256 ApplicationGatewaySslCipherSuite = "TLS_DHE_DSS_WITH_AES_128_CBC_SHA256"
	// ApplicationGatewaySslCipherSuiteTLSDHEDSSWITHAES256CBCSHA ...
	ApplicationGatewaySslCipherSuiteTLSDHEDSSWITHAES256CBCSHA ApplicationGatewaySslCipherSuite = "TLS_DHE_DSS_WITH_AES_256_CBC_SHA"
	// ApplicationGatewaySslCipherSuiteTLSDHEDSSWITHAES256CBCSHA256 ...
	ApplicationGatewaySslCipherSuiteTLSDHEDSSWITHAES256CBCSHA256 ApplicationGatewaySslCipherSuite = "TLS_DHE_DSS_WITH_AES_256_CBC_SHA256"
	// ApplicationGatewaySslCipherSuiteTLSDHERSAWITHAES128CBCSHA ...
	ApplicationGatewaySslCipherSuiteTLSDHERSAWITHAES128CBCSHA ApplicationGatewaySslCipherSuite = "TLS_DHE_RSA_WITH_AES_128_CBC_SHA"
	// ApplicationGatewaySslCipherSuiteTLSDHERSAWITHAES128GCMSHA256 ...
	ApplicationGatewaySslCipherSuiteTLSDHERSAWITHAES128GCMSHA256 ApplicationGatewaySslCipherSuite = "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256"
	// ApplicationGatewaySslCipherSuiteTLSDHERSAWITHAES256CBCSHA ...
	ApplicationGatewaySslCipherSuiteTLSDHERSAWITHAES256CBCSHA ApplicationGatewaySslCipherSuite = "TLS_DHE_RSA_WITH_AES_256_CBC_SHA"
	// ApplicationGatewaySslCipherSuiteTLSDHERSAWITHAES256GCMSHA384 ...
	ApplicationGatewaySslCipherSuiteTLSDHERSAWITHAES256GCMSHA384 ApplicationGatewaySslCipherSuite = "TLS_DHE_RSA_WITH_AES_256_GCM_SHA384"
	// ApplicationGatewaySslCipherSuiteTLSECDHEECDSAWITHAES128CBCSHA ...
	ApplicationGatewaySslCipherSuiteTLSECDHEECDSAWITHAES128CBCSHA ApplicationGatewaySslCipherSuite = "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA"
	// ApplicationGatewaySslCipherSuiteTLSECDHEECDSAWITHAES128CBCSHA256 ...
	ApplicationGatewaySslCipherSuiteTLSECDHEECDSAWITHAES128CBCSHA256 ApplicationGatewaySslCipherSuite = "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256"
	// ApplicationGatewaySslCipherSuiteTLSECDHEECDSAWITHAES128GCMSHA256 ...
	ApplicationGatewaySslCipherSuiteTLSECDHEECDSAWITHAES128GCMSHA256 ApplicationGatewaySslCipherSuite = "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256"
	// ApplicationGatewaySslCipherSuiteTLSECDHEECDSAWITHAES256CBCSHA ...
	ApplicationGatewaySslCipherSuiteTLSECDHEECDSAWITHAES256CBCSHA ApplicationGatewaySslCipherSuite = "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA"
	// ApplicationGatewaySslCipherSuiteTLSECDHEECDSAWITHAES256CBCSHA384 ...
	ApplicationGatewaySslCipherSuiteTLSECDHEECDSAWITHAES256CBCSHA384 ApplicationGatewaySslCipherSuite = "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384"
	// ApplicationGatewaySslCipherSuiteTLSECDHEECDSAWITHAES256GCMSHA384 ...
	ApplicationGatewaySslCipherSuiteTLSECDHEECDSAWITHAES256GCMSHA384 ApplicationGatewaySslCipherSuite = "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384"
	// ApplicationGatewaySslCipherSuiteTLSECDHERSAWITHAES128CBCSHA ...
	ApplicationGatewaySslCipherSuiteTLSECDHERSAWITHAES128CBCSHA ApplicationGatewaySslCipherSuite = "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA"
	// ApplicationGatewaySslCipherSuiteTLSECDHERSAWITHAES128CBCSHA256 ...
	ApplicationGatewaySslCipherSuiteTLSECDHERSAWITHAES128CBCSHA256 ApplicationGatewaySslCipherSuite = "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256"
	// ApplicationGatewaySslCipherSuiteTLSECDHERSAWITHAES128GCMSHA256 ...
	ApplicationGatewaySslCipherSuiteTLSECDHERSAWITHAES128GCMSHA256 ApplicationGatewaySslCipherSuite = "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256"
	// ApplicationGatewaySslCipherSuiteTLSECDHERSAWITHAES256CBCSHA ...
	ApplicationGatewaySslCipherSuiteTLSECDHERSAWITHAES256CBCSHA ApplicationGatewaySslCipherSuite = "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA"
	// ApplicationGatewaySslCipherSuiteTLSECDHERSAWITHAES256CBCSHA384 ...
	ApplicationGatewaySslCipherSuiteTLSECDHERSAWITHAES256CBCSHA384 ApplicationGatewaySslCipherSuite = "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384"
	// ApplicationGatewaySslCipherSuiteTLSECDHERSAWITHAES256GCMSHA384 ...
	ApplicationGatewaySslCipherSuiteTLSECDHERSAWITHAES256GCMSHA384 ApplicationGatewaySslCipherSuite = "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384"
	// ApplicationGatewaySslCipherSuiteTLSRSAWITH3DESEDECBCSHA ...
	ApplicationGatewaySslCipherSuiteTLSRSAWITH3DESEDECBCSHA ApplicationGatewaySslCipherSuite = "TLS_RSA_WITH_3DES_EDE_CBC_SHA"
	// ApplicationGatewaySslCipherSuiteTLSRSAWITHAES128CBCSHA ...
	ApplicationGatewaySslCipherSuiteTLSRSAWITHAES128CBCSHA ApplicationGatewaySslCipherSuite = "TLS_RSA_WITH_AES_128_CBC_SHA"
	// ApplicationGatewaySslCipherSuiteTLSRSAWITHAES128CBCSHA256 ...
	ApplicationGatewaySslCipherSuiteTLSRSAWITHAES128CBCSHA256 ApplicationGatewaySslCipherSuite = "TLS_RSA_WITH_AES_128_CBC_SHA256"
	// ApplicationGatewaySslCipherSuiteTLSRSAWITHAES128GCMSHA256 ...
	ApplicationGatewaySslCipherSuiteTLSRSAWITHAES128GCMSHA256 ApplicationGatewaySslCipherSuite = "TLS_RSA_WITH_AES_128_GCM_SHA256"
	// ApplicationGatewaySslCipherSuiteTLSRSAWITHAES256CBCSHA ...
	ApplicationGatewaySslCipherSuiteTLSRSAWITHAES256CBCSHA ApplicationGatewaySslCipherSuite = "TLS_RSA_WITH_AES_256_CBC_SHA"
	// ApplicationGatewaySslCipherSuiteTLSRSAWITHAES256CBCSHA256 ...
	ApplicationGatewaySslCipherSuiteTLSRSAWITHAES256CBCSHA256 ApplicationGatewaySslCipherSuite = "TLS_RSA_WITH_AES_256_CBC_SHA256"
	// ApplicationGatewaySslCipherSuiteTLSRSAWITHAES256GCMSHA384 ...
	ApplicationGatewaySslCipherSuiteTLSRSAWITHAES256GCMSHA384 ApplicationGatewaySslCipherSuite = "TLS_RSA_WITH_AES_256_GCM_SHA384"
)

// PossibleApplicationGatewaySslCipherSuiteValues returns an array of possible values for the ApplicationGatewaySslCipherSuite const type.
func PossibleApplicationGatewaySslCipherSuiteValues() []ApplicationGatewaySslCipherSuite {
	return []ApplicationGatewaySslCipherSuite{ApplicationGatewaySslCipherSuiteTLSDHEDSSWITH3DESEDECBCSHA, ApplicationGatewaySslCipherSuiteTLSDHEDSSWITHAES128CBCSHA, ApplicationGatewaySslCipherSuiteTLSDHEDSSWITHAES128CBCSHA256, ApplicationGatewaySslCipherSuiteTLSDHEDSSWITHAES256CBCSHA, ApplicationGatewaySslCipherSuiteTLSDHEDSSWITHAES256CBCSHA256, ApplicationGatewaySslCipherSuiteTLSDHERSAWITHAES128CBCSHA, ApplicationGatewaySslCipherSuiteTLSDHERSAWITHAES128GCMSHA256, ApplicationGatewaySslCipherSuiteTLSDHERSAWITHAES256CBCSHA, ApplicationGatewaySslCipherSuiteTLSDHERSAWITHAES256GCMSHA384, ApplicationGatewaySslCipherSuiteTLSECDHEECDSAWITHAES128CBCSHA, ApplicationGatewaySslCipherSuiteTLSECDHEECDSAWITHAES128CBCSHA256, ApplicationGatewaySslCipherSuiteTLSECDHEECDSAWITHAES128GCMSHA256, ApplicationGatewaySslCipherSuiteTLSECDHEECDSAWITHAES256CBCSHA, ApplicationGatewaySslCipherSuiteTLSECDHEECDSAWITHAES256CBCSHA384, ApplicationGatewaySslCipherSuiteTLSECDHEECDSAWITHAES256GCMSHA384, ApplicationGatewaySslCipherSuiteTLSECDHERSAWITHAES128CBCSHA, ApplicationGatewaySslCipherSuiteTLSECDHERSAWITHAES128CBCSHA256, ApplicationGatewaySslCipherSuiteTLSECDHERSAWITHAES128GCMSHA256, ApplicationGatewaySslCipherSuiteTLSECDHERSAWITHAES256CBCSHA, ApplicationGatewaySslCipherSuiteTLSECDHERSAWITHAES256CBCSHA384, ApplicationGatewaySslCipherSuiteTLSECDHERSAWITHAES256GCMSHA384, ApplicationGatewaySslCipherSuiteTLSRSAWITH3DESEDECBCSHA, ApplicationGatewaySslCipherSuiteTLSRSAWITHAES128CBCSHA, ApplicationGatewaySslCipherSuiteTLSRSAWITHAES128CBCSHA256, ApplicationGatewaySslCipherSuiteTLSRSAWITHAES128GCMSHA256, ApplicationGatewaySslCipherSuiteTLSRSAWITHAES256CBCSHA, ApplicationGatewaySslCipherSuiteTLSRSAWITHAES256CBCSHA256, ApplicationGatewaySslCipherSuiteTLSRSAWITHAES256GCMSHA384}
}

// ApplicationGatewaySslPolicyName enumerates the values for application gateway ssl policy name.
type ApplicationGatewaySslPolicyName string

const (
	// ApplicationGatewaySslPolicyNameAppGwSslPolicy20150501 ...
	ApplicationGatewaySslPolicyNameAppGwSslPolicy20150501 ApplicationGatewaySslPolicyName = "AppGwSslPolicy20150501"
	// ApplicationGatewaySslPolicyNameAppGwSslPolicy20170401 ...
	ApplicationGatewaySslPolicyNameAppGwSslPolicy20170401 ApplicationGatewaySslPolicyName = "AppGwSslPolicy20170401"
	// ApplicationGatewaySslPolicyNameAppGwSslPolicy20170401S ...
	ApplicationGatewaySslPolicyNameAppGwSslPolicy20170401S ApplicationGatewaySslPolicyName = "AppGwSslPolicy20170401S"
)

// PossibleApplicationGatewaySslPolicyNameValues returns an array of possible values for the ApplicationGatewaySslPolicyName const type.
func PossibleApplicationGatewaySslPolicyNameValues() []ApplicationGatewaySslPolicyName {
	return []ApplicationGatewaySslPolicyName{ApplicationGatewaySslPolicyNameAppGwSslPolicy20150501, ApplicationGatewaySslPolicyNameAppGwSslPolicy20170401, ApplicationGatewaySslPolicyNameAppGwSslPolicy20170401S}
}

// ApplicationGatewaySslPolicyType enumerates the values for application gateway ssl policy type.
type ApplicationGatewaySslPolicyType string

const (
	// ApplicationGatewaySslPolicyTypeCustom ...
	ApplicationGatewaySslPolicyTypeCustom ApplicationGatewaySslPolicyType = "Custom"
	// ApplicationGatewaySslPolicyTypePredefined ...
	ApplicationGatewaySslPolicyTypePredefined ApplicationGatewaySslPolicyType = "Predefined"
)

// PossibleApplicationGatewaySslPolicyTypeValues returns an array of possible values for the ApplicationGatewaySslPolicyType const type.
func PossibleApplicationGatewaySslPolicyTypeValues() []ApplicationGatewaySslPolicyType {
	return []ApplicationGatewaySslPolicyType{ApplicationGatewaySslPolicyTypeCustom, ApplicationGatewaySslPolicyTypePredefined}
}

// ApplicationGatewaySslProtocol enumerates the values for application gateway ssl protocol.
type ApplicationGatewaySslProtocol string

const (
	// ApplicationGatewaySslProtocolTLSv10 ...
	ApplicationGatewaySslProtocolTLSv10 ApplicationGatewaySslProtocol = "TLSv1_0"
	// ApplicationGatewaySslProtocolTLSv11 ...
	ApplicationGatewaySslProtocolTLSv11 ApplicationGatewaySslProtocol = "TLSv1_1"
	// ApplicationGatewaySslProtocolTLSv12 ...
	ApplicationGatewaySslProtocolTLSv12 ApplicationGatewaySslProtocol = "TLSv1_2"
)

// PossibleApplicationGatewaySslProtocolValues returns an array of possible values for the ApplicationGatewaySslProtocol const type.
func PossibleApplicationGatewaySslProtocolValues() []ApplicationGatewaySslProtocol {
	return []ApplicationGatewaySslProtocol{ApplicationGatewaySslProtocolTLSv10, ApplicationGatewaySslProtocolTLSv11, ApplicationGatewaySslProtocolTLSv12}
}

// ApplicationGatewayTier enumerates the values for application gateway tier.
type ApplicationGatewayTier string

const (
	// ApplicationGatewayTierStandard ...
	ApplicationGatewayTierStandard ApplicationGatewayTier = "Standard"
	// ApplicationGatewayTierStandardV2 ...
	ApplicationGatewayTierStandardV2 ApplicationGatewayTier = "Standard_v2"
	// ApplicationGatewayTierWAF ...
	ApplicationGatewayTierWAF ApplicationGatewayTier = "WAF"
	// ApplicationGatewayTierWAFV2 ...
	ApplicationGatewayTierWAFV2 ApplicationGatewayTier = "WAF_v2"
)

// PossibleApplicationGatewayTierValues returns an array of possible values for the ApplicationGatewayTier const type.
func PossibleApplicationGatewayTierValues() []ApplicationGatewayTier {
	return []ApplicationGatewayTier{ApplicationGatewayTierStandard, ApplicationGatewayTierStandardV2, ApplicationGatewayTierWAF, ApplicationGatewayTierWAFV2}
}

// AssociationType enumerates the values for association type.
type AssociationType string

const (
	// AssociationTypeAssociated ...
	AssociationTypeAssociated AssociationType = "Associated"
	// AssociationTypeContains ...
	AssociationTypeContains AssociationType = "Contains"
)

// PossibleAssociationTypeValues returns an array of possible values for the AssociationType const type.
func PossibleAssociationTypeValues() []AssociationType {
	return []AssociationType{AssociationTypeAssociated, AssociationTypeContains}
}

// AuthenticationMethod enumerates the values for authentication method.
type AuthenticationMethod string

const (
	// AuthenticationMethodEAPMSCHAPv2 ...
	AuthenticationMethodEAPMSCHAPv2 AuthenticationMethod = "EAPMSCHAPv2"
	// AuthenticationMethodEAPTLS ...
	AuthenticationMethodEAPTLS AuthenticationMethod = "EAPTLS"
)

// PossibleAuthenticationMethodValues returns an array of possible values for the AuthenticationMethod const type.
func PossibleAuthenticationMethodValues() []AuthenticationMethod {
	return []AuthenticationMethod{AuthenticationMethodEAPMSCHAPv2, AuthenticationMethodEAPTLS}
}

// AuthorizationUseStatus enumerates the values for authorization use status.
type AuthorizationUseStatus string

const (
	// AuthorizationUseStatusAvailable ...
	AuthorizationUseStatusAvailable AuthorizationUseStatus = "Available"
	// AuthorizationUseStatusInUse ...
	AuthorizationUseStatusInUse AuthorizationUseStatus = "InUse"
)

// PossibleAuthorizationUseStatusValues returns an array of possible values for the AuthorizationUseStatus const type.
func PossibleAuthorizationUseStatusValues() []AuthorizationUseStatus {
	return []AuthorizationUseStatus{AuthorizationUseStatusAvailable, AuthorizationUseStatusInUse}
}

// AzureFirewallApplicationRuleProtocolType enumerates the values for azure firewall application rule protocol
// type.
type AzureFirewallApplicationRuleProtocolType string

const (
	// AzureFirewallApplicationRuleProtocolTypeHTTP ...
	AzureFirewallApplicationRuleProtocolTypeHTTP AzureFirewallApplicationRuleProtocolType = "Http"
	// AzureFirewallApplicationRuleProtocolTypeHTTPS ...
	AzureFirewallApplicationRuleProtocolTypeHTTPS AzureFirewallApplicationRuleProtocolType = "Https"
	// AzureFirewallApplicationRuleProtocolTypeMssql ...
	AzureFirewallApplicationRuleProtocolTypeMssql AzureFirewallApplicationRuleProtocolType = "Mssql"
)

// PossibleAzureFirewallApplicationRuleProtocolTypeValues returns an array of possible values for the AzureFirewallApplicationRuleProtocolType const type.
func PossibleAzureFirewallApplicationRuleProtocolTypeValues() []AzureFirewallApplicationRuleProtocolType {
	return []AzureFirewallApplicationRuleProtocolType{AzureFirewallApplicationRuleProtocolTypeHTTP, AzureFirewallApplicationRuleProtocolTypeHTTPS, AzureFirewallApplicationRuleProtocolTypeMssql}
}

// AzureFirewallNatRCActionType enumerates the values for azure firewall nat rc action type.
type AzureFirewallNatRCActionType string

const (
	// AzureFirewallNatRCActionTypeDnat ...
	AzureFirewallNatRCActionTypeDnat AzureFirewallNatRCActionType = "Dnat"
	// AzureFirewallNatRCActionTypeSnat ...
	AzureFirewallNatRCActionTypeSnat AzureFirewallNatRCActionType = "Snat"
)

// PossibleAzureFirewallNatRCActionTypeValues returns an array of possible values for the AzureFirewallNatRCActionType const type.
func PossibleAzureFirewallNatRCActionTypeValues() []AzureFirewallNatRCActionType {
	return []AzureFirewallNatRCActionType{AzureFirewallNatRCActionTypeDnat, AzureFirewallNatRCActionTypeSnat}
}

// AzureFirewallNetworkRuleProtocol enumerates the values for azure firewall network rule protocol.
type AzureFirewallNetworkRuleProtocol string

const (
	// AzureFirewallNetworkRuleProtocolAny ...
	AzureFirewallNetworkRuleProtocolAny AzureFirewallNetworkRuleProtocol = "Any"
	// AzureFirewallNetworkRuleProtocolICMP ...
	AzureFirewallNetworkRuleProtocolICMP AzureFirewallNetworkRuleProtocol = "ICMP"
	// AzureFirewallNetworkRuleProtocolTCP ...
	AzureFirewallNetworkRuleProtocolTCP AzureFirewallNetworkRuleProtocol = "TCP"
	// AzureFirewallNetworkRuleProtocolUDP ...
	AzureFirewallNetworkRuleProtocolUDP AzureFirewallNetworkRuleProtocol = "UDP"
)

// PossibleAzureFirewallNetworkRuleProtocolValues returns an array of possible values for the AzureFirewallNetworkRuleProtocol const type.
func PossibleAzureFirewallNetworkRuleProtocolValues() []AzureFirewallNetworkRuleProtocol {
	return []AzureFirewallNetworkRuleProtocol{AzureFirewallNetworkRuleProtocolAny, AzureFirewallNetworkRuleProtocolICMP, AzureFirewallNetworkRuleProtocolTCP, AzureFirewallNetworkRuleProtocolUDP}
}

// AzureFirewallRCActionType enumerates the values for azure firewall rc action type.
type AzureFirewallRCActionType string

const (
	// AzureFirewallRCActionTypeAllow ...
	AzureFirewallRCActionTypeAllow AzureFirewallRCActionType = "Allow"
	// AzureFirewallRCActionTypeDeny ...
	AzureFirewallRCActionTypeDeny AzureFirewallRCActionType = "Deny"
)

// PossibleAzureFirewallRCActionTypeValues returns an array of possible values for the AzureFirewallRCActionType const type.
func PossibleAzureFirewallRCActionTypeValues() []AzureFirewallRCActionType {
	return []AzureFirewallRCActionType{AzureFirewallRCActionTypeAllow, AzureFirewallRCActionTypeDeny}
}

// AzureFirewallSkuName enumerates the values for azure firewall sku name.
type AzureFirewallSkuName string

const (
	// AzureFirewallSkuNameAZFWHub ...
	AzureFirewallSkuNameAZFWHub AzureFirewallSkuName = "AZFW_Hub"
	// AzureFirewallSkuNameAZFWVNet ...
	AzureFirewallSkuNameAZFWVNet AzureFirewallSkuName = "AZFW_VNet"
)

// PossibleAzureFirewallSkuNameValues returns an array of possible values for the AzureFirewallSkuName const type.
func PossibleAzureFirewallSkuNameValues() []AzureFirewallSkuName {
	return []AzureFirewallSkuName{AzureFirewallSkuNameAZFWHub, AzureFirewallSkuNameAZFWVNet}
}

// AzureFirewallSkuTier enumerates the values for azure firewall sku tier.
type AzureFirewallSkuTier string

const (
	// AzureFirewallSkuTierBasic ...
	AzureFirewallSkuTierBasic AzureFirewallSkuTier = "Basic"
	// AzureFirewallSkuTierPremium ...
	AzureFirewallSkuTierPremium AzureFirewallSkuTier = "Premium"
	// AzureFirewallSkuTierStandard ...
	AzureFirewallSkuTierStandard AzureFirewallSkuTier = "Standard"
)

// PossibleAzureFirewallSkuTierValues returns an array of possible values for the AzureFirewallSkuTier const type.
func PossibleAzureFirewallSkuTierValues() []AzureFirewallSkuTier {
	return []AzureFirewallSkuTier{AzureFirewallSkuTierBasic, AzureFirewallSkuTierPremium, AzureFirewallSkuTierStandard}
}

// AzureFirewallThreatIntelMode enumerates the values for azure firewall threat intel mode.
type AzureFirewallThreatIntelMode string

const (
	// AzureFirewallThreatIntelModeAlert ...
	AzureFirewallThreatIntelModeAlert AzureFirewallThreatIntelMode = "Alert"
	// AzureFirewallThreatIntelModeDeny ...
	AzureFirewallThreatIntelModeDeny AzureFirewallThreatIntelMode = "Deny"
	// AzureFirewallThreatIntelModeOff ...
	AzureFirewallThreatIntelModeOff AzureFirewallThreatIntelMode = "Off"
)

// PossibleAzureFirewallThreatIntelModeValues returns an array of possible values for the AzureFirewallThreatIntelMode const type.
func PossibleAzureFirewallThreatIntelModeValues() []AzureFirewallThreatIntelMode {
	return []AzureFirewallThreatIntelMode{AzureFirewallThreatIntelModeAlert, AzureFirewallThreatIntelModeDeny, AzureFirewallThreatIntelModeOff}
}

// BastionConnectProtocol enumerates the values for bastion connect protocol.
type BastionConnectProtocol string

const (
	// BastionConnectProtocolRDP ...
	BastionConnectProtocolRDP BastionConnectProtocol = "RDP"
	// BastionConnectProtocolSSH ...
	BastionConnectProtocolSSH BastionConnectProtocol = "SSH"
)

// PossibleBastionConnectProtocolValues returns an array of possible values for the BastionConnectProtocol const type.
func PossibleBastionConnectProtocolValues() []BastionConnectProtocol {
	return []BastionConnectProtocol{BastionConnectProtocolRDP, BastionConnectProtocolSSH}
}

// BastionHostSkuName enumerates the values for bastion host sku name.
type BastionHostSkuName string

const (
	// BastionHostSkuNameBasic ...
	BastionHostSkuNameBasic BastionHostSkuName = "Basic"
	// BastionHostSkuNameStandard ...
	BastionHostSkuNameStandard BastionHostSkuName = "Standard"
)

// PossibleBastionHostSkuNameValues returns an array of possible values for the BastionHostSkuName const type.
func PossibleBastionHostSkuNameValues() []BastionHostSkuName {
	return []BastionHostSkuName{BastionHostSkuNameBasic, BastionHostSkuNameStandard}
}

// BgpPeerState enumerates the values for bgp peer state.
type BgpPeerState string

const (
	// BgpPeerStateConnected ...
	BgpPeerStateConnected BgpPeerState = "Connected"
	// BgpPeerStateConnecting ...
	BgpPeerStateConnecting BgpPeerState = "Connecting"
	// BgpPeerStateIdle ...
	BgpPeerStateIdle BgpPeerState = "Idle"
	// BgpPeerStateStopped ...
	BgpPeerStateStopped BgpPeerState = "Stopped"
	// BgpPeerStateUnknown ...
	BgpPeerStateUnknown BgpPeerState = "Unknown"
)

// PossibleBgpPeerStateValues returns an array of possible values for the BgpPeerState const type.
func PossibleBgpPeerStateValues() []BgpPeerState {
	return []BgpPeerState{BgpPeerStateConnected, BgpPeerStateConnecting, BgpPeerStateIdle, BgpPeerStateStopped, BgpPeerStateUnknown}
}

// CircuitConnectionStatus enumerates the values for circuit connection status.
type CircuitConnectionStatus string

const (
	// CircuitConnectionStatusConnected ...
	CircuitConnectionStatusConnected CircuitConnectionStatus = "Connected"
	// CircuitConnectionStatusConnecting ...
	CircuitConnectionStatusConnecting CircuitConnectionStatus = "Connecting"
	// CircuitConnectionStatusDisconnected ...
	CircuitConnectionStatusDisconnected CircuitConnectionStatus = "Disconnected"
)

// PossibleCircuitConnectionStatusValues returns an array of possible values for the CircuitConnectionStatus const type.
func PossibleCircuitConnectionStatusValues() []CircuitConnectionStatus {
	return []CircuitConnectionStatus{CircuitConnectionStatusConnected, CircuitConnectionStatusConnecting, CircuitConnectionStatusDisconnected}
}

// CommissionedState enumerates the values for commissioned state.
type CommissionedState string

const (
	// CommissionedStateCommissioned ...
	CommissionedStateCommissioned CommissionedState = "Commissioned"
	// CommissionedStateCommissioning ...
	CommissionedStateCommissioning CommissionedState = "Commissioning"
	// CommissionedStateDecommissioning ...
	CommissionedStateDecommissioning CommissionedState = "Decommissioning"
	// CommissionedStateDeprovisioning ...
	CommissionedStateDeprovisioning CommissionedState = "Deprovisioning"
	// CommissionedStateProvisioned ...
	CommissionedStateProvisioned CommissionedState = "Provisioned"
	// CommissionedStateProvisioning ...
	CommissionedStateProvisioning CommissionedState = "Provisioning"
)

// PossibleCommissionedStateValues returns an array of possible values for the CommissionedState const type.
func PossibleCommissionedStateValues() []CommissionedState {
	return []CommissionedState{CommissionedStateCommissioned, CommissionedStateCommissioning, CommissionedStateDecommissioning, CommissionedStateDeprovisioning, CommissionedStateProvisioned, CommissionedStateProvisioning}
}

// ConnectionMonitorEndpointFilterItemType enumerates the values for connection monitor endpoint filter item
// type.
type ConnectionMonitorEndpointFilterItemType string

const (
	// ConnectionMonitorEndpointFilterItemTypeAgentAddress ...
	ConnectionMonitorEndpointFilterItemTypeAgentAddress ConnectionMonitorEndpointFilterItemType = "AgentAddress"
)

// PossibleConnectionMonitorEndpointFilterItemTypeValues returns an array of possible values for the ConnectionMonitorEndpointFilterItemType const type.
func PossibleConnectionMonitorEndpointFilterItemTypeValues() []ConnectionMonitorEndpointFilterItemType {
	return []ConnectionMonitorEndpointFilterItemType{ConnectionMonitorEndpointFilterItemTypeAgentAddress}
}

// ConnectionMonitorEndpointFilterType enumerates the values for connection monitor endpoint filter type.
type ConnectionMonitorEndpointFilterType string

const (
	// ConnectionMonitorEndpointFilterTypeInclude ...
	ConnectionMonitorEndpointFilterTypeInclude ConnectionMonitorEndpointFilterType = "Include"
)

// PossibleConnectionMonitorEndpointFilterTypeValues returns an array of possible values for the ConnectionMonitorEndpointFilterType const type.
func PossibleConnectionMonitorEndpointFilterTypeValues() []ConnectionMonitorEndpointFilterType {
	return []ConnectionMonitorEndpointFilterType{ConnectionMonitorEndpointFilterTypeInclude}
}

// ConnectionMonitorSourceStatus enumerates the values for connection monitor source status.
type ConnectionMonitorSourceStatus string

const (
	// ConnectionMonitorSourceStatusActive ...
	ConnectionMonitorSourceStatusActive ConnectionMonitorSourceStatus = "Active"
	// ConnectionMonitorSourceStatusInactive ...
	ConnectionMonitorSourceStatusInactive ConnectionMonitorSourceStatus = "Inactive"
	// ConnectionMonitorSourceStatusUnknown ...
	ConnectionMonitorSourceStatusUnknown ConnectionMonitorSourceStatus = "Unknown"
)

// PossibleConnectionMonitorSourceStatusValues returns an array of possible values for the ConnectionMonitorSourceStatus const type.
func PossibleConnectionMonitorSourceStatusValues() []ConnectionMonitorSourceStatus {
	return []ConnectionMonitorSourceStatus{ConnectionMonitorSourceStatusActive, ConnectionMonitorSourceStatusInactive, ConnectionMonitorSourceStatusUnknown}
}

// ConnectionMonitorTestConfigurationProtocol enumerates the values for connection monitor test configuration
// protocol.
type ConnectionMonitorTestConfigurationProtocol string

const (
	// ConnectionMonitorTestConfigurationProtocolHTTP ...
	ConnectionMonitorTestConfigurationProtocolHTTP ConnectionMonitorTestConfigurationProtocol = "Http"
	// ConnectionMonitorTestConfigurationProtocolIcmp ...
	ConnectionMonitorTestConfigurationProtocolIcmp ConnectionMonitorTestConfigurationProtocol = "Icmp"
	// ConnectionMonitorTestConfigurationProtocolTCP ...
	ConnectionMonitorTestConfigurationProtocolTCP ConnectionMonitorTestConfigurationProtocol = "Tcp"
)

// PossibleConnectionMonitorTestConfigurationProtocolValues returns an array of possible values for the ConnectionMonitorTestConfigurationProtocol const type.
func PossibleConnectionMonitorTestConfigurationProtocolValues() []ConnectionMonitorTestConfigurationProtocol {
	return []ConnectionMonitorTestConfigurationProtocol{ConnectionMonitorTestConfigurationProtocolHTTP, ConnectionMonitorTestConfigurationProtocolIcmp, ConnectionMonitorTestConfigurationProtocolTCP}
}

// ConnectionMonitorType enumerates the values for connection monitor type.
type ConnectionMonitorType string

const (
	// ConnectionMonitorTypeMultiEndpoint ...
	ConnectionMonitorTypeMultiEndpoint ConnectionMonitorType = "MultiEndpoint"
	// ConnectionMonitorTypeSingleSourceDestination ...
	ConnectionMonitorTypeSingleSourceDestination ConnectionMonitorType = "SingleSourceDestination"
)

// PossibleConnectionMonitorTypeValues returns an array of possible values for the ConnectionMonitorType const type.
func PossibleConnectionMonitorTypeValues() []ConnectionMonitorType {
	return []ConnectionMonitorType{ConnectionMonitorTypeMultiEndpoint, ConnectionMonitorTypeSingleSourceDestination}
}

// ConnectionState enumerates the values for connection state.
type ConnectionState string

const (
	// ConnectionStateReachable ...
	ConnectionStateReachable ConnectionState = "Reachable"
	// ConnectionStateUnknown ...
	ConnectionStateUnknown ConnectionState = "Unknown"
	// ConnectionStateUnreachable ...
	ConnectionStateUnreachable ConnectionState = "Unreachable"
)

// PossibleConnectionStateValues returns an array of possible values for the ConnectionState const type.
func PossibleConnectionStateValues() []ConnectionState {
	return []ConnectionState{ConnectionStateReachable, ConnectionStateUnknown, ConnectionStateUnreachable}
}

// ConnectionStatus enumerates the values for connection status.
type ConnectionStatus string

const (
	// ConnectionStatusConnected ...
	ConnectionStatusConnected ConnectionStatus = "Connected"
	// ConnectionStatusDegraded ...
	ConnectionStatusDegraded ConnectionStatus = "Degraded"
	// ConnectionStatusDisconnected ...
	ConnectionStatusDisconnected ConnectionStatus = "Disconnected"
	// ConnectionStatusUnknown ...
	ConnectionStatusUnknown ConnectionStatus = "Unknown"
)

// PossibleConnectionStatusValues returns an array of possible values for the ConnectionStatus const type.
func PossibleConnectionStatusValues() []ConnectionStatus {
	return []ConnectionStatus{ConnectionStatusConnected, ConnectionStatusDegraded, ConnectionStatusDisconnected, ConnectionStatusUnknown}
}

// CoverageLevel enumerates the values for coverage level.
type CoverageLevel string

const (
	// CoverageLevelAboveAverage ...
	CoverageLevelAboveAverage CoverageLevel = "AboveAverage"
	// CoverageLevelAverage ...
	CoverageLevelAverage CoverageLevel = "Average"
	// CoverageLevelBelowAverage ...
	CoverageLevelBelowAverage CoverageLevel = "BelowAverage"
	// CoverageLevelDefault ...
	CoverageLevelDefault CoverageLevel = "Default"
	// CoverageLevelFull ...
	CoverageLevelFull CoverageLevel = "Full"
	// CoverageLevelLow ...
	CoverageLevelLow CoverageLevel = "Low"
)

// PossibleCoverageLevelValues returns an array of possible values for the CoverageLevel const type.
func PossibleCoverageLevelValues() []CoverageLevel {
	return []CoverageLevel{CoverageLevelAboveAverage, CoverageLevelAverage, CoverageLevelBelowAverage, CoverageLevelDefault, CoverageLevelFull, CoverageLevelLow}
}

// DdosCustomPolicyProtocol enumerates the values for ddos custom policy protocol.
type DdosCustomPolicyProtocol string

const (
	// DdosCustomPolicyProtocolSyn ...
	DdosCustomPolicyProtocolSyn DdosCustomPolicyProtocol = "Syn"
	// DdosCustomPolicyProtocolTCP ...
	DdosCustomPolicyProtocolTCP DdosCustomPolicyProtocol = "Tcp"
	// DdosCustomPolicyProtocolUDP ...
	DdosCustomPolicyProtocolUDP DdosCustomPolicyProtocol = "Udp"
)

// PossibleDdosCustomPolicyProtocolValues returns an array of possible values for the DdosCustomPolicyProtocol const type.
func PossibleDdosCustomPolicyProtocolValues() []DdosCustomPolicyProtocol {
	return []DdosCustomPolicyProtocol{DdosCustomPolicyProtocolSyn, DdosCustomPolicyProtocolTCP, DdosCustomPolicyProtocolUDP}
}

// DdosCustomPolicyTriggerSensitivityOverride enumerates the values for ddos custom policy trigger sensitivity
// override.
type DdosCustomPolicyTriggerSensitivityOverride string

const (
	// DdosCustomPolicyTriggerSensitivityOverrideDefault ...
	DdosCustomPolicyTriggerSensitivityOverrideDefault DdosCustomPolicyTriggerSensitivityOverride = "Default"
	// DdosCustomPolicyTriggerSensitivityOverrideHigh ...
	DdosCustomPolicyTriggerSensitivityOverrideHigh DdosCustomPolicyTriggerSensitivityOverride = "High"
	// DdosCustomPolicyTriggerSensitivityOverrideLow ...
	DdosCustomPolicyTriggerSensitivityOverrideLow DdosCustomPolicyTriggerSensitivityOverride = "Low"
	// DdosCustomPolicyTriggerSensitivityOverrideRelaxed ...
	DdosCustomPolicyTriggerSensitivityOverrideRelaxed DdosCustomPolicyTriggerSensitivityOverride = "Relaxed"
)

// PossibleDdosCustomPolicyTriggerSensitivityOverrideValues returns an array of possible values for the DdosCustomPolicyTriggerSensitivityOverride const type.
func PossibleDdosCustomPolicyTriggerSensitivityOverrideValues() []DdosCustomPolicyTriggerSensitivityOverride {
	return []DdosCustomPolicyTriggerSensitivityOverride{DdosCustomPolicyTriggerSensitivityOverrideDefault, DdosCustomPolicyTriggerSensitivityOverrideHigh, DdosCustomPolicyTriggerSensitivityOverrideLow, DdosCustomPolicyTriggerSensitivityOverrideRelaxed}
}

// DdosSettingsProtectionCoverage enumerates the values for ddos settings protection coverage.
type DdosSettingsProtectionCoverage string

const (
	// DdosSettingsProtectionCoverageBasic ...
	DdosSettingsProtectionCoverageBasic DdosSettingsProtectionCoverage = "Basic"
	// DdosSettingsProtectionCoverageStandard ...
	DdosSettingsProtectionCoverageStandard DdosSettingsProtectionCoverage = "Standard"
)

// PossibleDdosSettingsProtectionCoverageValues returns an array of possible values for the DdosSettingsProtectionCoverage const type.
func PossibleDdosSettingsProtectionCoverageValues() []DdosSettingsProtectionCoverage {
	return []DdosSettingsProtectionCoverage{DdosSettingsProtectionCoverageBasic, DdosSettingsProtectionCoverageStandard}
}

// DeleteOptions enumerates the values for delete options.
type DeleteOptions string

const (
	// DeleteOptionsDelete ...
	DeleteOptionsDelete DeleteOptions = "Delete"
	// DeleteOptionsDetach ...
	DeleteOptionsDetach DeleteOptions = "Detach"
)

// PossibleDeleteOptionsValues returns an array of possible values for the DeleteOptions const type.
func PossibleDeleteOptionsValues() []DeleteOptions {
	return []DeleteOptions{DeleteOptionsDelete, DeleteOptionsDetach}
}

// DestinationPortBehavior enumerates the values for destination port behavior.
type DestinationPortBehavior string

const (
	// DestinationPortBehaviorListenIfAvailable ...
	DestinationPortBehaviorListenIfAvailable DestinationPortBehavior = "ListenIfAvailable"
	// DestinationPortBehaviorNone ...
	DestinationPortBehaviorNone DestinationPortBehavior = "None"
)

// PossibleDestinationPortBehaviorValues returns an array of possible values for the DestinationPortBehavior const type.
func PossibleDestinationPortBehaviorValues() []DestinationPortBehavior {
	return []DestinationPortBehavior{DestinationPortBehaviorListenIfAvailable, DestinationPortBehaviorNone}
}

// DhGroup enumerates the values for dh group.
type DhGroup string

const (
	// DhGroupDHGroup1 ...
	DhGroupDHGroup1 DhGroup = "DHGroup1"
	// DhGroupDHGroup14 ...
	DhGroupDHGroup14 DhGroup = "DHGroup14"
	// DhGroupDHGroup2 ...
	DhGroupDHGroup2 DhGroup = "DHGroup2"
	// DhGroupDHGroup2048 ...
	DhGroupDHGroup2048 DhGroup = "DHGroup2048"
	// DhGroupDHGroup24 ...
	DhGroupDHGroup24 DhGroup = "DHGroup24"
	// DhGroupECP256 ...
	DhGroupECP256 DhGroup = "ECP256"
	// DhGroupECP384 ...
	DhGroupECP384 DhGroup = "ECP384"
	// DhGroupNone ...
	DhGroupNone DhGroup = "None"
)

// PossibleDhGroupValues returns an array of possible values for the DhGroup const type.
func PossibleDhGroupValues() []DhGroup {
	return []DhGroup{DhGroupDHGroup1, DhGroupDHGroup14, DhGroupDHGroup2, DhGroupDHGroup2048, DhGroupDHGroup24, DhGroupECP256, DhGroupECP384, DhGroupNone}
}

// Direction enumerates the values for direction.
type Direction string

const (
	// DirectionInbound ...
	DirectionInbound Direction = "Inbound"
	// DirectionOutbound ...
	DirectionOutbound Direction = "Outbound"
)

// PossibleDirectionValues returns an array of possible values for the Direction const type.
func PossibleDirectionValues() []Direction {
	return []Direction{DirectionInbound, DirectionOutbound}
}

// EffectiveRouteSource enumerates the values for effective route source.
type EffectiveRouteSource string

const (
	// EffectiveRouteSourceDefault ...
	EffectiveRouteSourceDefault EffectiveRouteSource = "Default"
	// EffectiveRouteSourceUnknown ...
	EffectiveRouteSourceUnknown EffectiveRouteSource = "Unknown"
	// EffectiveRouteSourceUser ...
	EffectiveRouteSourceUser EffectiveRouteSource = "User"
	// EffectiveRouteSourceVirtualNetworkGateway ...
	EffectiveRouteSourceVirtualNetworkGateway EffectiveRouteSource = "VirtualNetworkGateway"
)

// PossibleEffectiveRouteSourceValues returns an array of possible values for the EffectiveRouteSource const type.
func PossibleEffectiveRouteSourceValues() []EffectiveRouteSource {
	return []EffectiveRouteSource{EffectiveRouteSourceDefault, EffectiveRouteSourceUnknown, EffectiveRouteSourceUser, EffectiveRouteSourceVirtualNetworkGateway}
}

// EffectiveRouteState enumerates the values for effective route state.
type EffectiveRouteState string

const (
	// EffectiveRouteStateActive ...
	EffectiveRouteStateActive EffectiveRouteState = "Active"
	// EffectiveRouteStateInvalid ...
	EffectiveRouteStateInvalid EffectiveRouteState = "Invalid"
)

// PossibleEffectiveRouteStateValues returns an array of possible values for the EffectiveRouteState const type.
func PossibleEffectiveRouteStateValues() []EffectiveRouteState {
	return []EffectiveRouteState{EffectiveRouteStateActive, EffectiveRouteStateInvalid}
}

// EffectiveSecurityRuleProtocol enumerates the values for effective security rule protocol.
type EffectiveSecurityRuleProtocol string

const (
	// EffectiveSecurityRuleProtocolAll ...
	EffectiveSecurityRuleProtocolAll EffectiveSecurityRuleProtocol = "All"
	// EffectiveSecurityRuleProtocolTCP ...
	EffectiveSecurityRuleProtocolTCP EffectiveSecurityRuleProtocol = "Tcp"
	// EffectiveSecurityRuleProtocolUDP ...
	EffectiveSecurityRuleProtocolUDP EffectiveSecurityRuleProtocol = "Udp"
)

// PossibleEffectiveSecurityRuleProtocolValues returns an array of possible values for the EffectiveSecurityRuleProtocol const type.
func PossibleEffectiveSecurityRuleProtocolValues() []EffectiveSecurityRuleProtocol {
	return []EffectiveSecurityRuleProtocol{EffectiveSecurityRuleProtocolAll, EffectiveSecurityRuleProtocolTCP, EffectiveSecurityRuleProtocolUDP}
}

// EndpointType enumerates the values for endpoint type.
type EndpointType string

const (
	// EndpointTypeAzureSubnet ...
	EndpointTypeAzureSubnet EndpointType = "AzureSubnet"
	// EndpointTypeAzureVM ...
	EndpointTypeAzureVM EndpointType = "AzureVM"
	// EndpointTypeAzureVNet ...
	EndpointTypeAzureVNet EndpointType = "AzureVNet"
	// EndpointTypeExternalAddress ...
	EndpointTypeExternalAddress EndpointType = "ExternalAddress"
	// EndpointTypeMMAWorkspaceMachine ...
	EndpointTypeMMAWorkspaceMachine EndpointType = "MMAWorkspaceMachine"
	// EndpointTypeMMAWorkspaceNetwork ...
	EndpointTypeMMAWorkspaceNetwork EndpointType = "MMAWorkspaceNetwork"
)

// PossibleEndpointTypeValues returns an array of possible values for the EndpointType const type.
func PossibleEndpointTypeValues() []EndpointType {
	return []EndpointType{EndpointTypeAzureSubnet, EndpointTypeAzureVM, EndpointTypeAzureVNet, EndpointTypeExternalAddress, EndpointTypeMMAWorkspaceMachine, EndpointTypeMMAWorkspaceNetwork}
}

// EvaluationState enumerates the values for evaluation state.
type EvaluationState string

const (
	// EvaluationStateCompleted ...
	EvaluationStateCompleted EvaluationState = "Completed"
	// EvaluationStateInProgress ...
	EvaluationStateInProgress EvaluationState = "InProgress"
	// EvaluationStateNotStarted ...
	EvaluationStateNotStarted EvaluationState = "NotStarted"
)

// PossibleEvaluationStateValues returns an array of possible values for the EvaluationState const type.
func PossibleEvaluationStateValues() []EvaluationState {
	return []EvaluationState{EvaluationStateCompleted, EvaluationStateInProgress, EvaluationStateNotStarted}
}

// ExpressRouteCircuitPeeringAdvertisedPublicPrefixState enumerates the values for express route circuit
// peering advertised public prefix state.
type ExpressRouteCircuitPeeringAdvertisedPublicPrefixState string

const (
	// ExpressRouteCircuitPeeringAdvertisedPublicPrefixStateConfigured ...
	ExpressRouteCircuitPeeringAdvertisedPublicPrefixStateConfigured ExpressRouteCircuitPeeringAdvertisedPublicPrefixState = "Configured"
	// ExpressRouteCircuitPeeringAdvertisedPublicPrefixStateConfiguring ...
	ExpressRouteCircuitPeeringAdvertisedPublicPrefixStateConfiguring ExpressRouteCircuitPeeringAdvertisedPublicPrefixState = "Configuring"
	// ExpressRouteCircuitPeeringAdvertisedPublicPrefixStateNotConfigured ...
	ExpressRouteCircuitPeeringAdvertisedPublicPrefixStateNotConfigured ExpressRouteCircuitPeeringAdvertisedPublicPrefixState = "NotConfigured"
	// ExpressRouteCircuitPeeringAdvertisedPublicPrefixStateValidationNeeded ...
	ExpressRouteCircuitPeeringAdvertisedPublicPrefixStateValidationNeeded ExpressRouteCircuitPeeringAdvertisedPublicPrefixState = "ValidationNeeded"
)

// PossibleExpressRouteCircuitPeeringAdvertisedPublicPrefixStateValues returns an array of possible values for the ExpressRouteCircuitPeeringAdvertisedPublicPrefixState const type.
func PossibleExpressRouteCircuitPeeringAdvertisedPublicPrefixStateValues() []ExpressRouteCircuitPeeringAdvertisedPublicPrefixState {
	return []ExpressRouteCircuitPeeringAdvertisedPublicPrefixState{ExpressRouteCircuitPeeringAdvertisedPublicPrefixStateConfigured, ExpressRouteCircuitPeeringAdvertisedPublicPrefixStateConfiguring, ExpressRouteCircuitPeeringAdvertisedPublicPrefixStateNotConfigured, ExpressRouteCircuitPeeringAdvertisedPublicPrefixStateValidationNeeded}
}

// ExpressRouteCircuitPeeringState enumerates the values for express route circuit peering state.
type ExpressRouteCircuitPeeringState string

const (
	// ExpressRouteCircuitPeeringStateDisabled ...
	ExpressRouteCircuitPeeringStateDisabled ExpressRouteCircuitPeeringState = "Disabled"
	// ExpressRouteCircuitPeeringStateEnabled ...
	ExpressRouteCircuitPeeringStateEnabled ExpressRouteCircuitPeeringState = "Enabled"
)

// PossibleExpressRouteCircuitPeeringStateValues returns an array of possible values for the ExpressRouteCircuitPeeringState const type.
func PossibleExpressRouteCircuitPeeringStateValues() []ExpressRouteCircuitPeeringState {
	return []ExpressRouteCircuitPeeringState{ExpressRouteCircuitPeeringStateDisabled, ExpressRouteCircuitPeeringStateEnabled}
}

// ExpressRouteCircuitSkuFamily enumerates the values for express route circuit sku family.
type ExpressRouteCircuitSkuFamily string

const (
	// ExpressRouteCircuitSkuFamilyMeteredData ...
	ExpressRouteCircuitSkuFamilyMeteredData ExpressRouteCircuitSkuFamily = "MeteredData"
	// ExpressRouteCircuitSkuFamilyUnlimitedData ...
	ExpressRouteCircuitSkuFamilyUnlimitedData ExpressRouteCircuitSkuFamily = "UnlimitedData"
)

// PossibleExpressRouteCircuitSkuFamilyValues returns an array of possible values for the ExpressRouteCircuitSkuFamily const type.
func PossibleExpressRouteCircuitSkuFamilyValues() []ExpressRouteCircuitSkuFamily {
	return []ExpressRouteCircuitSkuFamily{ExpressRouteCircuitSkuFamilyMeteredData, ExpressRouteCircuitSkuFamilyUnlimitedData}
}

// ExpressRouteCircuitSkuTier enumerates the values for express route circuit sku tier.
type ExpressRouteCircuitSkuTier string

const (
	// ExpressRouteCircuitSkuTierBasic ...
	ExpressRouteCircuitSkuTierBasic ExpressRouteCircuitSkuTier = "Basic"
	// ExpressRouteCircuitSkuTierLocal ...
	ExpressRouteCircuitSkuTierLocal ExpressRouteCircuitSkuTier = "Local"
	// ExpressRouteCircuitSkuTierPremium ...
	ExpressRouteCircuitSkuTierPremium ExpressRouteCircuitSkuTier = "Premium"
	// ExpressRouteCircuitSkuTierStandard ...
	ExpressRouteCircuitSkuTierStandard ExpressRouteCircuitSkuTier = "Standard"
)

// PossibleExpressRouteCircuitSkuTierValues returns an array of possible values for the ExpressRouteCircuitSkuTier const type.
func PossibleExpressRouteCircuitSkuTierValues() []ExpressRouteCircuitSkuTier {
	return []ExpressRouteCircuitSkuTier{ExpressRouteCircuitSkuTierBasic, ExpressRouteCircuitSkuTierLocal, ExpressRouteCircuitSkuTierPremium, ExpressRouteCircuitSkuTierStandard}
}

// ExpressRouteLinkAdminState enumerates the values for express route link admin state.
type ExpressRouteLinkAdminState string

const (
	// ExpressRouteLinkAdminStateDisabled ...
	ExpressRouteLinkAdminStateDisabled ExpressRouteLinkAdminState = "Disabled"
	// ExpressRouteLinkAdminStateEnabled ...
	ExpressRouteLinkAdminStateEnabled ExpressRouteLinkAdminState = "Enabled"
)

// PossibleExpressRouteLinkAdminStateValues returns an array of possible values for the ExpressRouteLinkAdminState const type.
func PossibleExpressRouteLinkAdminStateValues() []ExpressRouteLinkAdminState {
	return []ExpressRouteLinkAdminState{ExpressRouteLinkAdminStateDisabled, ExpressRouteLinkAdminStateEnabled}
}

// ExpressRouteLinkConnectorType enumerates the values for express route link connector type.
type ExpressRouteLinkConnectorType string

const (
	// ExpressRouteLinkConnectorTypeLC ...
	ExpressRouteLinkConnectorTypeLC ExpressRouteLinkConnectorType = "LC"
	// ExpressRouteLinkConnectorTypeSC ...
	ExpressRouteLinkConnectorTypeSC ExpressRouteLinkConnectorType = "SC"
)

// PossibleExpressRouteLinkConnectorTypeValues returns an array of possible values for the ExpressRouteLinkConnectorType const type.
func PossibleExpressRouteLinkConnectorTypeValues() []ExpressRouteLinkConnectorType {
	return []ExpressRouteLinkConnectorType{ExpressRouteLinkConnectorTypeLC, ExpressRouteLinkConnectorTypeSC}
}

// ExpressRouteLinkMacSecCipher enumerates the values for express route link mac sec cipher.
type ExpressRouteLinkMacSecCipher string

const (
	// ExpressRouteLinkMacSecCipherGcmAes128 ...
	ExpressRouteLinkMacSecCipherGcmAes128 ExpressRouteLinkMacSecCipher = "GcmAes128"
	// ExpressRouteLinkMacSecCipherGcmAes256 ...
	ExpressRouteLinkMacSecCipherGcmAes256 ExpressRouteLinkMacSecCipher = "GcmAes256"
	// ExpressRouteLinkMacSecCipherGcmAesXpn128 ...
	ExpressRouteLinkMacSecCipherGcmAesXpn128 ExpressRouteLinkMacSecCipher = "GcmAesXpn128"
	// ExpressRouteLinkMacSecCipherGcmAesXpn256 ...
	ExpressRouteLinkMacSecCipherGcmAesXpn256 ExpressRouteLinkMacSecCipher = "GcmAesXpn256"
)

// PossibleExpressRouteLinkMacSecCipherValues returns an array of possible values for the ExpressRouteLinkMacSecCipher const type.
func PossibleExpressRouteLinkMacSecCipherValues() []ExpressRouteLinkMacSecCipher {
	return []ExpressRouteLinkMacSecCipher{ExpressRouteLinkMacSecCipherGcmAes128, ExpressRouteLinkMacSecCipherGcmAes256, ExpressRouteLinkMacSecCipherGcmAesXpn128, ExpressRouteLinkMacSecCipherGcmAesXpn256}
}

// ExpressRouteLinkMacSecSciState enumerates the values for express route link mac sec sci state.
type ExpressRouteLinkMacSecSciState string

const (
	// ExpressRouteLinkMacSecSciStateDisabled ...
	ExpressRouteLinkMacSecSciStateDisabled ExpressRouteLinkMacSecSciState = "Disabled"
	// ExpressRouteLinkMacSecSciStateEnabled ...
	ExpressRouteLinkMacSecSciStateEnabled ExpressRouteLinkMacSecSciState = "Enabled"
)

// PossibleExpressRouteLinkMacSecSciStateValues returns an array of possible values for the ExpressRouteLinkMacSecSciState const type.
func PossibleExpressRouteLinkMacSecSciStateValues() []ExpressRouteLinkMacSecSciState {
	return []ExpressRouteLinkMacSecSciState{ExpressRouteLinkMacSecSciStateDisabled, ExpressRouteLinkMacSecSciStateEnabled}
}

// ExpressRoutePeeringState enumerates the values for express route peering state.
type ExpressRoutePeeringState string

const (
	// ExpressRoutePeeringStateDisabled ...
	ExpressRoutePeeringStateDisabled ExpressRoutePeeringState = "Disabled"
	// ExpressRoutePeeringStateEnabled ...
	ExpressRoutePeeringStateEnabled ExpressRoutePeeringState = "Enabled"
)

// PossibleExpressRoutePeeringStateValues returns an array of possible values for the ExpressRoutePeeringState const type.
func PossibleExpressRoutePeeringStateValues() []ExpressRoutePeeringState {
	return []ExpressRoutePeeringState{ExpressRoutePeeringStateDisabled, ExpressRoutePeeringStateEnabled}
}

// ExpressRoutePeeringType enumerates the values for express route peering type.
type ExpressRoutePeeringType string

const (
	// ExpressRoutePeeringTypeAzurePrivatePeering ...
	ExpressRoutePeeringTypeAzurePrivatePeering ExpressRoutePeeringType = "AzurePrivatePeering"
	// ExpressRoutePeeringTypeAzurePublicPeering ...
	ExpressRoutePeeringTypeAzurePublicPeering ExpressRoutePeeringType = "AzurePublicPeering"
	// ExpressRoutePeeringTypeMicrosoftPeering ...
	ExpressRoutePeeringTypeMicrosoftPeering ExpressRoutePeeringType = "MicrosoftPeering"
)

// PossibleExpressRoutePeeringTypeValues returns an array of possible values for the ExpressRoutePeeringType const type.
func PossibleExpressRoutePeeringTypeValues() []ExpressRoutePeeringType {
	return []ExpressRoutePeeringType{ExpressRoutePeeringTypeAzurePrivatePeering, ExpressRoutePeeringTypeAzurePublicPeering, ExpressRoutePeeringTypeMicrosoftPeering}
}

// ExpressRoutePortsEncapsulation enumerates the values for express route ports encapsulation.
type ExpressRoutePortsEncapsulation string

const (
	// ExpressRoutePortsEncapsulationDot1Q ...
	ExpressRoutePortsEncapsulationDot1Q ExpressRoutePortsEncapsulation = "Dot1Q"
	// ExpressRoutePortsEncapsulationQinQ ...
	ExpressRoutePortsEncapsulationQinQ ExpressRoutePortsEncapsulation = "QinQ"
)

// PossibleExpressRoutePortsEncapsulationValues returns an array of possible values for the ExpressRoutePortsEncapsulation const type.
func PossibleExpressRoutePortsEncapsulationValues() []ExpressRoutePortsEncapsulation {
	return []ExpressRoutePortsEncapsulation{ExpressRoutePortsEncapsulationDot1Q, ExpressRoutePortsEncapsulationQinQ}
}

// ExtendedLocationTypes enumerates the values for extended location types.
type ExtendedLocationTypes string

const (
	// ExtendedLocationTypesEdgeZone ...
	ExtendedLocationTypesEdgeZone ExtendedLocationTypes = "EdgeZone"
)

// PossibleExtendedLocationTypesValues returns an array of possible values for the ExtendedLocationTypes const type.
func PossibleExtendedLocationTypesValues() []ExtendedLocationTypes {
	return []ExtendedLocationTypes{ExtendedLocationTypesEdgeZone}
}

// FirewallPolicyFilterRuleCollectionActionType enumerates the values for firewall policy filter rule
// collection action type.
type FirewallPolicyFilterRuleCollectionActionType string

const (
	// FirewallPolicyFilterRuleCollectionActionTypeAllow ...
	FirewallPolicyFilterRuleCollectionActionTypeAllow FirewallPolicyFilterRuleCollectionActionType = "Allow"
	// FirewallPolicyFilterRuleCollectionActionTypeDeny ...
	FirewallPolicyFilterRuleCollectionActionTypeDeny FirewallPolicyFilterRuleCollectionActionType = "Deny"
)

// PossibleFirewallPolicyFilterRuleCollectionActionTypeValues returns an array of possible values for the FirewallPolicyFilterRuleCollectionActionType const type.
func PossibleFirewallPolicyFilterRuleCollectionActionTypeValues() []FirewallPolicyFilterRuleCollectionActionType {
	return []FirewallPolicyFilterRuleCollectionActionType{FirewallPolicyFilterRuleCollectionActionTypeAllow, FirewallPolicyFilterRuleCollectionActionTypeDeny}
}

// FirewallPolicyIntrusionDetectionProtocol enumerates the values for firewall policy intrusion detection
// protocol.
type FirewallPolicyIntrusionDetectionProtocol string

const (
	// FirewallPolicyIntrusionDetectionProtocolANY ...
	FirewallPolicyIntrusionDetectionProtocolANY FirewallPolicyIntrusionDetectionProtocol = "ANY"
	// FirewallPolicyIntrusionDetectionProtocolICMP ...
	FirewallPolicyIntrusionDetectionProtocolICMP FirewallPolicyIntrusionDetectionProtocol = "ICMP"
	// FirewallPolicyIntrusionDetectionProtocolTCP ...
	FirewallPolicyIntrusionDetectionProtocolTCP FirewallPolicyIntrusionDetectionProtocol = "TCP"
	// FirewallPolicyIntrusionDetectionProtocolUDP ...
	FirewallPolicyIntrusionDetectionProtocolUDP FirewallPolicyIntrusionDetectionProtocol = "UDP"
)

// PossibleFirewallPolicyIntrusionDetectionProtocolValues returns an array of possible values for the FirewallPolicyIntrusionDetectionProtocol const type.
func PossibleFirewallPolicyIntrusionDetectionProtocolValues() []FirewallPolicyIntrusionDetectionProtocol {
	return []FirewallPolicyIntrusionDetectionProtocol{FirewallPolicyIntrusionDetectionProtocolANY, FirewallPolicyIntrusionDetectionProtocolICMP, FirewallPolicyIntrusionDetectionProtocolTCP, FirewallPolicyIntrusionDetectionProtocolUDP}
}

// FirewallPolicyIntrusionDetectionStateType enumerates the values for firewall policy intrusion detection
// state type.
type FirewallPolicyIntrusionDetectionStateType string

const (
	// FirewallPolicyIntrusionDetectionStateTypeAlert ...
	FirewallPolicyIntrusionDetectionStateTypeAlert FirewallPolicyIntrusionDetectionStateType = "Alert"
	// FirewallPolicyIntrusionDetectionStateTypeDeny ...
	FirewallPolicyIntrusionDetectionStateTypeDeny FirewallPolicyIntrusionDetectionStateType = "Deny"
	// FirewallPolicyIntrusionDetectionStateTypeOff ...
	FirewallPolicyIntrusionDetectionStateTypeOff FirewallPolicyIntrusionDetectionStateType = "Off"
)

// PossibleFirewallPolicyIntrusionDetectionStateTypeValues returns an array of possible values for the FirewallPolicyIntrusionDetectionStateType const type.
func PossibleFirewallPolicyIntrusionDetectionStateTypeValues() []FirewallPolicyIntrusionDetectionStateType {
	return []FirewallPolicyIntrusionDetectionStateType{FirewallPolicyIntrusionDetectionStateTypeAlert, FirewallPolicyIntrusionDetectionStateTypeDeny, FirewallPolicyIntrusionDetectionStateTypeOff}
}

// FirewallPolicyNatRuleCollectionActionType enumerates the values for firewall policy nat rule collection
// action type.
type FirewallPolicyNatRuleCollectionActionType string

const (
	// FirewallPolicyNatRuleCollectionActionTypeDNAT ...
	FirewallPolicyNatRuleCollectionActionTypeDNAT FirewallPolicyNatRuleCollectionActionType = "DNAT"
)

// PossibleFirewallPolicyNatRuleCollectionActionTypeValues returns an array of possible values for the FirewallPolicyNatRuleCollectionActionType const type.
func PossibleFirewallPolicyNatRuleCollectionActionTypeValues() []FirewallPolicyNatRuleCollectionActionType {
	return []FirewallPolicyNatRuleCollectionActionType{FirewallPolicyNatRuleCollectionActionTypeDNAT}
}

// FirewallPolicyRuleApplicationProtocolType enumerates the values for firewall policy rule application
// protocol type.
type FirewallPolicyRuleApplicationProtocolType string

const (
	// FirewallPolicyRuleApplicationProtocolTypeHTTP ...
	FirewallPolicyRuleApplicationProtocolTypeHTTP FirewallPolicyRuleApplicationProtocolType = "Http"
	// FirewallPolicyRuleApplicationProtocolTypeHTTPS ...
	FirewallPolicyRuleApplicationProtocolTypeHTTPS FirewallPolicyRuleApplicationProtocolType = "Https"
)

// PossibleFirewallPolicyRuleApplicationProtocolTypeValues returns an array of possible values for the FirewallPolicyRuleApplicationProtocolType const type.
func PossibleFirewallPolicyRuleApplicationProtocolTypeValues() []FirewallPolicyRuleApplicationProtocolType {
	return []FirewallPolicyRuleApplicationProtocolType{FirewallPolicyRuleApplicationProtocolTypeHTTP, FirewallPolicyRuleApplicationProtocolTypeHTTPS}
}

// FirewallPolicyRuleNetworkProtocol enumerates the values for firewall policy rule network protocol.
type FirewallPolicyRuleNetworkProtocol string

const (
	// FirewallPolicyRuleNetworkProtocolAny ...
	FirewallPolicyRuleNetworkProtocolAny FirewallPolicyRuleNetworkProtocol = "Any"
	// FirewallPolicyRuleNetworkProtocolICMP ...
	FirewallPolicyRuleNetworkProtocolICMP FirewallPolicyRuleNetworkProtocol = "ICMP"
	// FirewallPolicyRuleNetworkProtocolTCP ...
	FirewallPolicyRuleNetworkProtocolTCP FirewallPolicyRuleNetworkProtocol = "TCP"
	// FirewallPolicyRuleNetworkProtocolUDP ...
	FirewallPolicyRuleNetworkProtocolUDP FirewallPolicyRuleNetworkProtocol = "UDP"
)

// PossibleFirewallPolicyRuleNetworkProtocolValues returns an array of possible values for the FirewallPolicyRuleNetworkProtocol const type.
func PossibleFirewallPolicyRuleNetworkProtocolValues() []FirewallPolicyRuleNetworkProtocol {
	return []FirewallPolicyRuleNetworkProtocol{FirewallPolicyRuleNetworkProtocolAny, FirewallPolicyRuleNetworkProtocolICMP, FirewallPolicyRuleNetworkProtocolTCP, FirewallPolicyRuleNetworkProtocolUDP}
}

// FirewallPolicySkuTier enumerates the values for firewall policy sku tier.
type FirewallPolicySkuTier string

const (
	// FirewallPolicySkuTierBasic ...
	FirewallPolicySkuTierBasic FirewallPolicySkuTier = "Basic"
	// FirewallPolicySkuTierPremium ...
	FirewallPolicySkuTierPremium FirewallPolicySkuTier = "Premium"
	// FirewallPolicySkuTierStandard ...
	FirewallPolicySkuTierStandard FirewallPolicySkuTier = "Standard"
)

// PossibleFirewallPolicySkuTierValues returns an array of possible values for the FirewallPolicySkuTier const type.
func PossibleFirewallPolicySkuTierValues() []FirewallPolicySkuTier {
	return []FirewallPolicySkuTier{FirewallPolicySkuTierBasic, FirewallPolicySkuTierPremium, FirewallPolicySkuTierStandard}
}

// FlowLogFormatType enumerates the values for flow log format type.
type FlowLogFormatType string

const (
	// FlowLogFormatTypeJSON ...
	FlowLogFormatTypeJSON FlowLogFormatType = "JSON"
)

// PossibleFlowLogFormatTypeValues returns an array of possible values for the FlowLogFormatType const type.
func PossibleFlowLogFormatTypeValues() []FlowLogFormatType {
	return []FlowLogFormatType{FlowLogFormatTypeJSON}
}

// GatewayLoadBalancerTunnelInterfaceType enumerates the values for gateway load balancer tunnel interface
// type.
type GatewayLoadBalancerTunnelInterfaceType string

const (
	// GatewayLoadBalancerTunnelInterfaceTypeExternal ...
	GatewayLoadBalancerTunnelInterfaceTypeExternal GatewayLoadBalancerTunnelInterfaceType = "External"
	// GatewayLoadBalancerTunnelInterfaceTypeInternal ...
	GatewayLoadBalancerTunnelInterfaceTypeInternal GatewayLoadBalancerTunnelInterfaceType = "Internal"
	// GatewayLoadBalancerTunnelInterfaceTypeNone ...
	GatewayLoadBalancerTunnelInterfaceTypeNone GatewayLoadBalancerTunnelInterfaceType = "None"
)

// PossibleGatewayLoadBalancerTunnelInterfaceTypeValues returns an array of possible values for the GatewayLoadBalancerTunnelInterfaceType const type.
func PossibleGatewayLoadBalancerTunnelInterfaceTypeValues() []GatewayLoadBalancerTunnelInterfaceType {
	return []GatewayLoadBalancerTunnelInterfaceType{GatewayLoadBalancerTunnelInterfaceTypeExternal, GatewayLoadBalancerTunnelInterfaceTypeInternal, GatewayLoadBalancerTunnelInterfaceTypeNone}
}

// GatewayLoadBalancerTunnelProtocol enumerates the values for gateway load balancer tunnel protocol.
type GatewayLoadBalancerTunnelProtocol string

const (
	// GatewayLoadBalancerTunnelProtocolNative ...
	GatewayLoadBalancerTunnelProtocolNative GatewayLoadBalancerTunnelProtocol = "Native"
	// GatewayLoadBalancerTunnelProtocolNone ...
	GatewayLoadBalancerTunnelProtocolNone GatewayLoadBalancerTunnelProtocol = "None"
	// GatewayLoadBalancerTunnelProtocolVXLAN ...
	GatewayLoadBalancerTunnelProtocolVXLAN GatewayLoadBalancerTunnelProtocol = "VXLAN"
)

// PossibleGatewayLoadBalancerTunnelProtocolValues returns an array of possible values for the GatewayLoadBalancerTunnelProtocol const type.
func PossibleGatewayLoadBalancerTunnelProtocolValues() []GatewayLoadBalancerTunnelProtocol {
	return []GatewayLoadBalancerTunnelProtocol{GatewayLoadBalancerTunnelProtocolNative, GatewayLoadBalancerTunnelProtocolNone, GatewayLoadBalancerTunnelProtocolVXLAN}
}

// HTTPConfigurationMethod enumerates the values for http configuration method.
type HTTPConfigurationMethod string

const (
	// HTTPConfigurationMethodGet ...
	HTTPConfigurationMethodGet HTTPConfigurationMethod = "Get"
	// HTTPConfigurationMethodPost ...
	HTTPConfigurationMethodPost HTTPConfigurationMethod = "Post"
)

// PossibleHTTPConfigurationMethodValues returns an array of possible values for the HTTPConfigurationMethod const type.
func PossibleHTTPConfigurationMethodValues() []HTTPConfigurationMethod {
	return []HTTPConfigurationMethod{HTTPConfigurationMethodGet, HTTPConfigurationMethodPost}
}

// HTTPMethod enumerates the values for http method.
type HTTPMethod string

const (
	// HTTPMethodGet ...
	HTTPMethodGet HTTPMethod = "Get"
)

// PossibleHTTPMethodValues returns an array of possible values for the HTTPMethod const type.
func PossibleHTTPMethodValues() []HTTPMethod {
	return []HTTPMethod{HTTPMethodGet}
}

// HubBgpConnectionStatus enumerates the values for hub bgp connection status.
type HubBgpConnectionStatus string

const (
	// HubBgpConnectionStatusConnected ...
	HubBgpConnectionStatusConnected HubBgpConnectionStatus = "Connected"
	// HubBgpConnectionStatusConnecting ...
	HubBgpConnectionStatusConnecting HubBgpConnectionStatus = "Connecting"
	// HubBgpConnectionStatusNotConnected ...
	HubBgpConnectionStatusNotConnected HubBgpConnectionStatus = "NotConnected"
	// HubBgpConnectionStatusUnknown ...
	HubBgpConnectionStatusUnknown HubBgpConnectionStatus = "Unknown"
)

// PossibleHubBgpConnectionStatusValues returns an array of possible values for the HubBgpConnectionStatus const type.
func PossibleHubBgpConnectionStatusValues() []HubBgpConnectionStatus {
	return []HubBgpConnectionStatus{HubBgpConnectionStatusConnected, HubBgpConnectionStatusConnecting, HubBgpConnectionStatusNotConnected, HubBgpConnectionStatusUnknown}
}

// HubVirtualNetworkConnectionStatus enumerates the values for hub virtual network connection status.
type HubVirtualNetworkConnectionStatus string

const (
	// HubVirtualNetworkConnectionStatusConnected ...
	HubVirtualNetworkConnectionStatusConnected HubVirtualNetworkConnectionStatus = "Connected"
	// HubVirtualNetworkConnectionStatusConnecting ...
	HubVirtualNetworkConnectionStatusConnecting HubVirtualNetworkConnectionStatus = "Connecting"
	// HubVirtualNetworkConnectionStatusNotConnected ...
	HubVirtualNetworkConnectionStatusNotConnected HubVirtualNetworkConnectionStatus = "NotConnected"
	// HubVirtualNetworkConnectionStatusUnknown ...
	HubVirtualNetworkConnectionStatusUnknown HubVirtualNetworkConnectionStatus = "Unknown"
)

// PossibleHubVirtualNetworkConnectionStatusValues returns an array of possible values for the HubVirtualNetworkConnectionStatus const type.
func PossibleHubVirtualNetworkConnectionStatusValues() []HubVirtualNetworkConnectionStatus {
	return []HubVirtualNetworkConnectionStatus{HubVirtualNetworkConnectionStatusConnected, HubVirtualNetworkConnectionStatusConnecting, HubVirtualNetworkConnectionStatusNotConnected, HubVirtualNetworkConnectionStatusUnknown}
}

// IkeEncryption enumerates the values for ike encryption.
type IkeEncryption string

const (
	// IkeEncryptionAES128 ...
	IkeEncryptionAES128 IkeEncryption = "AES128"
	// IkeEncryptionAES192 ...
	IkeEncryptionAES192 IkeEncryption = "AES192"
	// IkeEncryptionAES256 ...
	IkeEncryptionAES256 IkeEncryption = "AES256"
	// IkeEncryptionDES ...
	IkeEncryptionDES IkeEncryption = "DES"
	// IkeEncryptionDES3 ...
	IkeEncryptionDES3 IkeEncryption = "DES3"
	// IkeEncryptionGCMAES128 ...
	IkeEncryptionGCMAES128 IkeEncryption = "GCMAES128"
	// IkeEncryptionGCMAES256 ...
	IkeEncryptionGCMAES256 IkeEncryption = "GCMAES256"
)

// PossibleIkeEncryptionValues returns an array of possible values for the IkeEncryption const type.
func PossibleIkeEncryptionValues() []IkeEncryption {
	return []IkeEncryption{IkeEncryptionAES128, IkeEncryptionAES192, IkeEncryptionAES256, IkeEncryptionDES, IkeEncryptionDES3, IkeEncryptionGCMAES128, IkeEncryptionGCMAES256}
}

// IkeIntegrity enumerates the values for ike integrity.
type IkeIntegrity string

const (
	// IkeIntegrityGCMAES128 ...
	IkeIntegrityGCMAES128 IkeIntegrity = "GCMAES128"
	// IkeIntegrityGCMAES256 ...
	IkeIntegrityGCMAES256 IkeIntegrity = "GCMAES256"
	// IkeIntegrityMD5 ...
	IkeIntegrityMD5 IkeIntegrity = "MD5"
	// IkeIntegritySHA1 ...
	IkeIntegritySHA1 IkeIntegrity = "SHA1"
	// IkeIntegritySHA256 ...
	IkeIntegritySHA256 IkeIntegrity = "SHA256"
	// IkeIntegritySHA384 ...
	IkeIntegritySHA384 IkeIntegrity = "SHA384"
)

// PossibleIkeIntegrityValues returns an array of possible values for the IkeIntegrity const type.
func PossibleIkeIntegrityValues() []IkeIntegrity {
	return []IkeIntegrity{IkeIntegrityGCMAES128, IkeIntegrityGCMAES256, IkeIntegrityMD5, IkeIntegritySHA1, IkeIntegritySHA256, IkeIntegritySHA384}
}

// InboundSecurityRulesProtocol enumerates the values for inbound security rules protocol.
type InboundSecurityRulesProtocol string

const (
	// InboundSecurityRulesProtocolTCP ...
	InboundSecurityRulesProtocolTCP InboundSecurityRulesProtocol = "TCP"
	// InboundSecurityRulesProtocolUDP ...
	InboundSecurityRulesProtocolUDP InboundSecurityRulesProtocol = "UDP"
)

// PossibleInboundSecurityRulesProtocolValues returns an array of possible values for the InboundSecurityRulesProtocol const type.
func PossibleInboundSecurityRulesProtocolValues() []InboundSecurityRulesProtocol {
	return []InboundSecurityRulesProtocol{InboundSecurityRulesProtocolTCP, InboundSecurityRulesProtocolUDP}
}

// InterfaceMigrationPhase enumerates the values for interface migration phase.
type InterfaceMigrationPhase string

const (
	// InterfaceMigrationPhaseAbort ...
	InterfaceMigrationPhaseAbort InterfaceMigrationPhase = "Abort"
	// InterfaceMigrationPhaseCommit ...
	InterfaceMigrationPhaseCommit InterfaceMigrationPhase = "Commit"
	// InterfaceMigrationPhaseCommitted ...
	InterfaceMigrationPhaseCommitted InterfaceMigrationPhase = "Committed"
	// InterfaceMigrationPhaseNone ...
	InterfaceMigrationPhaseNone InterfaceMigrationPhase = "None"
	// InterfaceMigrationPhasePrepare ...
	InterfaceMigrationPhasePrepare InterfaceMigrationPhase = "Prepare"
)

// PossibleInterfaceMigrationPhaseValues returns an array of possible values for the InterfaceMigrationPhase const type.
func PossibleInterfaceMigrationPhaseValues() []InterfaceMigrationPhase {
	return []InterfaceMigrationPhase{InterfaceMigrationPhaseAbort, InterfaceMigrationPhaseCommit, InterfaceMigrationPhaseCommitted, InterfaceMigrationPhaseNone, InterfaceMigrationPhasePrepare}
}

// InterfaceNicType enumerates the values for interface nic type.
type InterfaceNicType string

const (
	// InterfaceNicTypeElastic ...
	InterfaceNicTypeElastic InterfaceNicType = "Elastic"
	// InterfaceNicTypeStandard ...
	InterfaceNicTypeStandard InterfaceNicType = "Standard"
)

// PossibleInterfaceNicTypeValues returns an array of possible values for the InterfaceNicType const type.
func PossibleInterfaceNicTypeValues() []InterfaceNicType {
	return []InterfaceNicType{InterfaceNicTypeElastic, InterfaceNicTypeStandard}
}

// IPAllocationMethod enumerates the values for ip allocation method.
type IPAllocationMethod string

const (
	// IPAllocationMethodDynamic ...
	IPAllocationMethodDynamic IPAllocationMethod = "Dynamic"
	// IPAllocationMethodStatic ...
	IPAllocationMethodStatic IPAllocationMethod = "Static"
)

// PossibleIPAllocationMethodValues returns an array of possible values for the IPAllocationMethod const type.
func PossibleIPAllocationMethodValues() []IPAllocationMethod {
	return []IPAllocationMethod{IPAllocationMethodDynamic, IPAllocationMethodStatic}
}

// IPAllocationType enumerates the values for ip allocation type.
type IPAllocationType string

const (
	// IPAllocationTypeHypernet ...
	IPAllocationTypeHypernet IPAllocationType = "Hypernet"
	// IPAllocationTypeUndefined ...
	IPAllocationTypeUndefined IPAllocationType = "Undefined"
)

// PossibleIPAllocationTypeValues returns an array of possible values for the IPAllocationType const type.
func PossibleIPAllocationTypeValues() []IPAllocationType {
	return []IPAllocationType{IPAllocationTypeHypernet, IPAllocationTypeUndefined}
}

// IPFlowProtocol enumerates the values for ip flow protocol.
type IPFlowProtocol string

const (
	// IPFlowProtocolTCP ...
	IPFlowProtocolTCP IPFlowProtocol = "TCP"
	// IPFlowProtocolUDP ...
	IPFlowProtocolUDP IPFlowProtocol = "UDP"
)

// PossibleIPFlowProtocolValues returns an array of possible values for the IPFlowProtocol const type.
func PossibleIPFlowProtocolValues() []IPFlowProtocol {
	return []IPFlowProtocol{IPFlowProtocolTCP, IPFlowProtocolUDP}
}

// IpsecEncryption enumerates the values for ipsec encryption.
type IpsecEncryption string

const (
	// IpsecEncryptionAES128 ...
	IpsecEncryptionAES128 IpsecEncryption = "AES128"
	// IpsecEncryptionAES192 ...
	IpsecEncryptionAES192 IpsecEncryption = "AES192"
	// IpsecEncryptionAES256 ...
	IpsecEncryptionAES256 IpsecEncryption = "AES256"
	// IpsecEncryptionDES ...
	IpsecEncryptionDES IpsecEncryption = "DES"
	// IpsecEncryptionDES3 ...
	IpsecEncryptionDES3 IpsecEncryption = "DES3"
	// IpsecEncryptionGCMAES128 ...
	IpsecEncryptionGCMAES128 IpsecEncryption = "GCMAES128"
	// IpsecEncryptionGCMAES192 ...
	IpsecEncryptionGCMAES192 IpsecEncryption = "GCMAES192"
	// IpsecEncryptionGCMAES256 ...
	IpsecEncryptionGCMAES256 IpsecEncryption = "GCMAES256"
	// IpsecEncryptionNone ...
	IpsecEncryptionNone IpsecEncryption = "None"
)

// PossibleIpsecEncryptionValues returns an array of possible values for the IpsecEncryption const type.
func PossibleIpsecEncryptionValues() []IpsecEncryption {
	return []IpsecEncryption{IpsecEncryptionAES128, IpsecEncryptionAES192, IpsecEncryptionAES256, IpsecEncryptionDES, IpsecEncryptionDES3, IpsecEncryptionGCMAES128, IpsecEncryptionGCMAES192, IpsecEncryptionGCMAES256, IpsecEncryptionNone}
}

// IpsecIntegrity enumerates the values for ipsec integrity.
type IpsecIntegrity string

const (
	// IpsecIntegrityGCMAES128 ...
	IpsecIntegrityGCMAES128 IpsecIntegrity = "GCMAES128"
	// IpsecIntegrityGCMAES192 ...
	IpsecIntegrityGCMAES192 IpsecIntegrity = "GCMAES192"
	// IpsecIntegrityGCMAES256 ...
	IpsecIntegrityGCMAES256 IpsecIntegrity = "GCMAES256"
	// IpsecIntegrityMD5 ...
	IpsecIntegrityMD5 IpsecIntegrity = "MD5"
	// IpsecIntegritySHA1 ...
	IpsecIntegritySHA1 IpsecIntegrity = "SHA1"
	// IpsecIntegritySHA256 ...
	IpsecIntegritySHA256 IpsecIntegrity = "SHA256"
)

// PossibleIpsecIntegrityValues returns an array of possible values for the IpsecIntegrity const type.
func PossibleIpsecIntegrityValues() []IpsecIntegrity {
	return []IpsecIntegrity{IpsecIntegrityGCMAES128, IpsecIntegrityGCMAES192, IpsecIntegrityGCMAES256, IpsecIntegrityMD5, IpsecIntegritySHA1, IpsecIntegritySHA256}
}

// IPVersion enumerates the values for ip version.
type IPVersion string

const (
	// IPVersionIPv4 ...
	IPVersionIPv4 IPVersion = "IPv4"
	// IPVersionIPv6 ...
	IPVersionIPv6 IPVersion = "IPv6"
)

// PossibleIPVersionValues returns an array of possible values for the IPVersion const type.
func PossibleIPVersionValues() []IPVersion {
	return []IPVersion{IPVersionIPv4, IPVersionIPv6}
}

// IssueType enumerates the values for issue type.
type IssueType string

const (
	// IssueTypeAgentStopped ...
	IssueTypeAgentStopped IssueType = "AgentStopped"
	// IssueTypeDNSResolution ...
	IssueTypeDNSResolution IssueType = "DnsResolution"
	// IssueTypeGuestFirewall ...
	IssueTypeGuestFirewall IssueType = "GuestFirewall"
	// IssueTypeNetworkSecurityRule ...
	IssueTypeNetworkSecurityRule IssueType = "NetworkSecurityRule"
	// IssueTypePlatform ...
	IssueTypePlatform IssueType = "Platform"
	// IssueTypePortThrottled ...
	IssueTypePortThrottled IssueType = "PortThrottled"
	// IssueTypeSocketBind ...
	IssueTypeSocketBind IssueType = "SocketBind"
	// IssueTypeUnknown ...
	IssueTypeUnknown IssueType = "Unknown"
	// IssueTypeUserDefinedRoute ...
	IssueTypeUserDefinedRoute IssueType = "UserDefinedRoute"
)

// PossibleIssueTypeValues returns an array of possible values for the IssueType const type.
func PossibleIssueTypeValues() []IssueType {
	return []IssueType{IssueTypeAgentStopped, IssueTypeDNSResolution, IssueTypeGuestFirewall, IssueTypeNetworkSecurityRule, IssueTypePlatform, IssueTypePortThrottled, IssueTypeSocketBind, IssueTypeUnknown, IssueTypeUserDefinedRoute}
}

// LoadBalancerOutboundRuleProtocol enumerates the values for load balancer outbound rule protocol.
type LoadBalancerOutboundRuleProtocol string

const (
	// LoadBalancerOutboundRuleProtocolAll ...
	LoadBalancerOutboundRuleProtocolAll LoadBalancerOutboundRuleProtocol = "All"
	// LoadBalancerOutboundRuleProtocolTCP ...
	LoadBalancerOutboundRuleProtocolTCP LoadBalancerOutboundRuleProtocol = "Tcp"
	// LoadBalancerOutboundRuleProtocolUDP ...
	LoadBalancerOutboundRuleProtocolUDP LoadBalancerOutboundRuleProtocol = "Udp"
)

// PossibleLoadBalancerOutboundRuleProtocolValues returns an array of possible values for the LoadBalancerOutboundRuleProtocol const type.
func PossibleLoadBalancerOutboundRuleProtocolValues() []LoadBalancerOutboundRuleProtocol {
	return []LoadBalancerOutboundRuleProtocol{LoadBalancerOutboundRuleProtocolAll, LoadBalancerOutboundRuleProtocolTCP, LoadBalancerOutboundRuleProtocolUDP}
}

// LoadBalancerSkuName enumerates the values for load balancer sku name.
type LoadBalancerSkuName string

const (
	// LoadBalancerSkuNameBasic ...
	LoadBalancerSkuNameBasic LoadBalancerSkuName = "Basic"
	// LoadBalancerSkuNameGateway ...
	LoadBalancerSkuNameGateway LoadBalancerSkuName = "Gateway"
	// LoadBalancerSkuNameStandard ...
	LoadBalancerSkuNameStandard LoadBalancerSkuName = "Standard"
)

// PossibleLoadBalancerSkuNameValues returns an array of possible values for the LoadBalancerSkuName const type.
func PossibleLoadBalancerSkuNameValues() []LoadBalancerSkuName {
	return []LoadBalancerSkuName{LoadBalancerSkuNameBasic, LoadBalancerSkuNameGateway, LoadBalancerSkuNameStandard}
}

// LoadBalancerSkuTier enumerates the values for load balancer sku tier.
type LoadBalancerSkuTier string

const (
	// LoadBalancerSkuTierGlobal ...
	LoadBalancerSkuTierGlobal LoadBalancerSkuTier = "Global"
	// LoadBalancerSkuTierRegional ...
	LoadBalancerSkuTierRegional LoadBalancerSkuTier = "Regional"
)

// PossibleLoadBalancerSkuTierValues returns an array of possible values for the LoadBalancerSkuTier const type.
func PossibleLoadBalancerSkuTierValues() []LoadBalancerSkuTier {
	return []LoadBalancerSkuTier{LoadBalancerSkuTierGlobal, LoadBalancerSkuTierRegional}
}

// LoadDistribution enumerates the values for load distribution.
type LoadDistribution string

const (
	// LoadDistributionDefault ...
	LoadDistributionDefault LoadDistribution = "Default"
	// LoadDistributionSourceIP ...
	LoadDistributionSourceIP LoadDistribution = "SourceIP"
	// LoadDistributionSourceIPProtocol ...
	LoadDistributionSourceIPProtocol LoadDistribution = "SourceIPProtocol"
)

// PossibleLoadDistributionValues returns an array of possible values for the LoadDistribution const type.
func PossibleLoadDistributionValues() []LoadDistribution {
	return []LoadDistribution{LoadDistributionDefault, LoadDistributionSourceIP, LoadDistributionSourceIPProtocol}
}

// ManagedRuleEnabledState enumerates the values for managed rule enabled state.
type ManagedRuleEnabledState string

const (
	// ManagedRuleEnabledStateDisabled ...
	ManagedRuleEnabledStateDisabled ManagedRuleEnabledState = "Disabled"
)

// PossibleManagedRuleEnabledStateValues returns an array of possible values for the ManagedRuleEnabledState const type.
func PossibleManagedRuleEnabledStateValues() []ManagedRuleEnabledState {
	return []ManagedRuleEnabledState{ManagedRuleEnabledStateDisabled}
}

// NatGatewaySkuName enumerates the values for nat gateway sku name.
type NatGatewaySkuName string

const (
	// NatGatewaySkuNameStandard ...
	NatGatewaySkuNameStandard NatGatewaySkuName = "Standard"
)

// PossibleNatGatewaySkuNameValues returns an array of possible values for the NatGatewaySkuName const type.
func PossibleNatGatewaySkuNameValues() []NatGatewaySkuName {
	return []NatGatewaySkuName{NatGatewaySkuNameStandard}
}

// NextHopType enumerates the values for next hop type.
type NextHopType string

const (
	// NextHopTypeHyperNetGateway ...
	NextHopTypeHyperNetGateway NextHopType = "HyperNetGateway"
	// NextHopTypeInternet ...
	NextHopTypeInternet NextHopType = "Internet"
	// NextHopTypeNone ...
	NextHopTypeNone NextHopType = "None"
	// NextHopTypeVirtualAppliance ...
	NextHopTypeVirtualAppliance NextHopType = "VirtualAppliance"
	// NextHopTypeVirtualNetworkGateway ...
	NextHopTypeVirtualNetworkGateway NextHopType = "VirtualNetworkGateway"
	// NextHopTypeVnetLocal ...
	NextHopTypeVnetLocal NextHopType = "VnetLocal"
)

// PossibleNextHopTypeValues returns an array of possible values for the NextHopType const type.
func PossibleNextHopTypeValues() []NextHopType {
	return []NextHopType{NextHopTypeHyperNetGateway, NextHopTypeInternet, NextHopTypeNone, NextHopTypeVirtualAppliance, NextHopTypeVirtualNetworkGateway, NextHopTypeVnetLocal}
}

// OfficeTrafficCategory enumerates the values for office traffic category.
type OfficeTrafficCategory string

const (
	// OfficeTrafficCategoryAll ...
	OfficeTrafficCategoryAll OfficeTrafficCategory = "All"
	// OfficeTrafficCategoryNone ...
	OfficeTrafficCategoryNone OfficeTrafficCategory = "None"
	// OfficeTrafficCategoryOptimize ...
	OfficeTrafficCategoryOptimize OfficeTrafficCategory = "Optimize"
	// OfficeTrafficCategoryOptimizeAndAllow ...
	OfficeTrafficCategoryOptimizeAndAllow OfficeTrafficCategory = "OptimizeAndAllow"
)

// PossibleOfficeTrafficCategoryValues returns an array of possible values for the OfficeTrafficCategory const type.
func PossibleOfficeTrafficCategoryValues() []OfficeTrafficCategory {
	return []OfficeTrafficCategory{OfficeTrafficCategoryAll, OfficeTrafficCategoryNone, OfficeTrafficCategoryOptimize, OfficeTrafficCategoryOptimizeAndAllow}
}

// OperationStatus enumerates the values for operation status.
type OperationStatus string

const (
	// OperationStatusFailed ...
	OperationStatusFailed OperationStatus = "Failed"
	// OperationStatusInProgress ...
	OperationStatusInProgress OperationStatus = "InProgress"
	// OperationStatusSucceeded ...
	OperationStatusSucceeded OperationStatus = "Succeeded"
)

// PossibleOperationStatusValues returns an array of possible values for the OperationStatus const type.
func PossibleOperationStatusValues() []OperationStatus {
	return []OperationStatus{OperationStatusFailed, OperationStatusInProgress, OperationStatusSucceeded}
}

// Order enumerates the values for order.
type Order string

const (
	// OrderAscending ...
	OrderAscending Order = "Ascending"
	// OrderDescending ...
	OrderDescending Order = "Descending"
)

// PossibleOrderValues returns an array of possible values for the Order const type.
func PossibleOrderValues() []Order {
	return []Order{OrderAscending, OrderDescending}
}

// Origin enumerates the values for origin.
type Origin string

const (
	// OriginInbound ...
	OriginInbound Origin = "Inbound"
	// OriginLocal ...
	OriginLocal Origin = "Local"
	// OriginOutbound ...
	OriginOutbound Origin = "Outbound"
)

// PossibleOriginValues returns an array of possible values for the Origin const type.
func PossibleOriginValues() []Origin {
	return []Origin{OriginInbound, OriginLocal, OriginOutbound}
}

// OutputType enumerates the values for output type.
type OutputType string

const (
	// OutputTypeWorkspace ...
	OutputTypeWorkspace OutputType = "Workspace"
)

// PossibleOutputTypeValues returns an array of possible values for the OutputType const type.
func PossibleOutputTypeValues() []OutputType {
	return []OutputType{OutputTypeWorkspace}
}

// OwaspCrsExclusionEntryMatchVariable enumerates the values for owasp crs exclusion entry match variable.
type OwaspCrsExclusionEntryMatchVariable string

const (
	// OwaspCrsExclusionEntryMatchVariableRequestArgKeys ...
	OwaspCrsExclusionEntryMatchVariableRequestArgKeys OwaspCrsExclusionEntryMatchVariable = "RequestArgKeys"
	// OwaspCrsExclusionEntryMatchVariableRequestArgNames ...
	OwaspCrsExclusionEntryMatchVariableRequestArgNames OwaspCrsExclusionEntryMatchVariable = "RequestArgNames"
	// OwaspCrsExclusionEntryMatchVariableRequestArgValues ...
	OwaspCrsExclusionEntryMatchVariableRequestArgValues OwaspCrsExclusionEntryMatchVariable = "RequestArgValues"
	// OwaspCrsExclusionEntryMatchVariableRequestCookieKeys ...
	OwaspCrsExclusionEntryMatchVariableRequestCookieKeys OwaspCrsExclusionEntryMatchVariable = "RequestCookieKeys"
	// OwaspCrsExclusionEntryMatchVariableRequestCookieNames ...
	OwaspCrsExclusionEntryMatchVariableRequestCookieNames OwaspCrsExclusionEntryMatchVariable = "RequestCookieNames"
	// OwaspCrsExclusionEntryMatchVariableRequestCookieValues ...
	OwaspCrsExclusionEntryMatchVariableRequestCookieValues OwaspCrsExclusionEntryMatchVariable = "RequestCookieValues"
	// OwaspCrsExclusionEntryMatchVariableRequestHeaderKeys ...
	OwaspCrsExclusionEntryMatchVariableRequestHeaderKeys OwaspCrsExclusionEntryMatchVariable = "RequestHeaderKeys"
	// OwaspCrsExclusionEntryMatchVariableRequestHeaderNames ...
	OwaspCrsExclusionEntryMatchVariableRequestHeaderNames OwaspCrsExclusionEntryMatchVariable = "RequestHeaderNames"
	// OwaspCrsExclusionEntryMatchVariableRequestHeaderValues ...
	OwaspCrsExclusionEntryMatchVariableRequestHeaderValues OwaspCrsExclusionEntryMatchVariable = "RequestHeaderValues"
)

// PossibleOwaspCrsExclusionEntryMatchVariableValues returns an array of possible values for the OwaspCrsExclusionEntryMatchVariable const type.
func PossibleOwaspCrsExclusionEntryMatchVariableValues() []OwaspCrsExclusionEntryMatchVariable {
	return []OwaspCrsExclusionEntryMatchVariable{OwaspCrsExclusionEntryMatchVariableRequestArgKeys, OwaspCrsExclusionEntryMatchVariableRequestArgNames, OwaspCrsExclusionEntryMatchVariableRequestArgValues, OwaspCrsExclusionEntryMatchVariableRequestCookieKeys, OwaspCrsExclusionEntryMatchVariableRequestCookieNames, OwaspCrsExclusionEntryMatchVariableRequestCookieValues, OwaspCrsExclusionEntryMatchVariableRequestHeaderKeys, OwaspCrsExclusionEntryMatchVariableRequestHeaderNames, OwaspCrsExclusionEntryMatchVariableRequestHeaderValues}
}

// OwaspCrsExclusionEntrySelectorMatchOperator enumerates the values for owasp crs exclusion entry selector
// match operator.
type OwaspCrsExclusionEntrySelectorMatchOperator string

const (
	// OwaspCrsExclusionEntrySelectorMatchOperatorContains ...
	OwaspCrsExclusionEntrySelectorMatchOperatorContains OwaspCrsExclusionEntrySelectorMatchOperator = "Contains"
	// OwaspCrsExclusionEntrySelectorMatchOperatorEndsWith ...
	OwaspCrsExclusionEntrySelectorMatchOperatorEndsWith OwaspCrsExclusionEntrySelectorMatchOperator = "EndsWith"
	// OwaspCrsExclusionEntrySelectorMatchOperatorEquals ...
	OwaspCrsExclusionEntrySelectorMatchOperatorEquals OwaspCrsExclusionEntrySelectorMatchOperator = "Equals"
	// OwaspCrsExclusionEntrySelectorMatchOperatorEqualsAny ...
	OwaspCrsExclusionEntrySelectorMatchOperatorEqualsAny OwaspCrsExclusionEntrySelectorMatchOperator = "EqualsAny"
	// OwaspCrsExclusionEntrySelectorMatchOperatorStartsWith ...
	OwaspCrsExclusionEntrySelectorMatchOperatorStartsWith OwaspCrsExclusionEntrySelectorMatchOperator = "StartsWith"
)

// PossibleOwaspCrsExclusionEntrySelectorMatchOperatorValues returns an array of possible values for the OwaspCrsExclusionEntrySelectorMatchOperator const type.
func PossibleOwaspCrsExclusionEntrySelectorMatchOperatorValues() []OwaspCrsExclusionEntrySelectorMatchOperator {
	return []OwaspCrsExclusionEntrySelectorMatchOperator{OwaspCrsExclusionEntrySelectorMatchOperatorContains, OwaspCrsExclusionEntrySelectorMatchOperatorEndsWith, OwaspCrsExclusionEntrySelectorMatchOperatorEquals, OwaspCrsExclusionEntrySelectorMatchOperatorEqualsAny, OwaspCrsExclusionEntrySelectorMatchOperatorStartsWith}
}

// PcError enumerates the values for pc error.
type PcError string

const (
	// PcErrorAgentStopped ...
	PcErrorAgentStopped PcError = "AgentStopped"
	// PcErrorCaptureFailed ...
	PcErrorCaptureFailed PcError = "CaptureFailed"
	// PcErrorInternalError ...
	PcErrorInternalError PcError = "InternalError"
	// PcErrorLocalFileFailed ...
	PcErrorLocalFileFailed PcError = "LocalFileFailed"
	// PcErrorStorageFailed ...
	PcErrorStorageFailed PcError = "StorageFailed"
)

// PossiblePcErrorValues returns an array of possible values for the PcError const type.
func PossiblePcErrorValues() []PcError {
	return []PcError{PcErrorAgentStopped, PcErrorCaptureFailed, PcErrorInternalError, PcErrorLocalFileFailed, PcErrorStorageFailed}
}

// PcProtocol enumerates the values for pc protocol.
type PcProtocol string

const (
	// PcProtocolAny ...
	PcProtocolAny PcProtocol = "Any"
	// PcProtocolTCP ...
	PcProtocolTCP PcProtocol = "TCP"
	// PcProtocolUDP ...
	PcProtocolUDP PcProtocol = "UDP"
)

// PossiblePcProtocolValues returns an array of possible values for the PcProtocol const type.
func PossiblePcProtocolValues() []PcProtocol {
	return []PcProtocol{PcProtocolAny, PcProtocolTCP, PcProtocolUDP}
}

// PcStatus enumerates the values for pc status.
type PcStatus string

const (
	// PcStatusError ...
	PcStatusError PcStatus = "Error"
	// PcStatusNotStarted ...
	PcStatusNotStarted PcStatus = "NotStarted"
	// PcStatusRunning ...
	PcStatusRunning PcStatus = "Running"
	// PcStatusStopped ...
	PcStatusStopped PcStatus = "Stopped"
	// PcStatusUnknown ...
	PcStatusUnknown PcStatus = "Unknown"
)

// PossiblePcStatusValues returns an array of possible values for the PcStatus const type.
func PossiblePcStatusValues() []PcStatus {
	return []PcStatus{PcStatusError, PcStatusNotStarted, PcStatusRunning, PcStatusStopped, PcStatusUnknown}
}

// PfsGroup enumerates the values for pfs group.
type PfsGroup string

const (
	// PfsGroupECP256 ...
	PfsGroupECP256 PfsGroup = "ECP256"
	// PfsGroupECP384 ...
	PfsGroupECP384 PfsGroup = "ECP384"
	// PfsGroupNone ...
	PfsGroupNone PfsGroup = "None"
	// PfsGroupPFS1 ...
	PfsGroupPFS1 PfsGroup = "PFS1"
	// PfsGroupPFS14 ...
	PfsGroupPFS14 PfsGroup = "PFS14"
	// PfsGroupPFS2 ...
	PfsGroupPFS2 PfsGroup = "PFS2"
	// PfsGroupPFS2048 ...
	PfsGroupPFS2048 PfsGroup = "PFS2048"
	// PfsGroupPFS24 ...
	PfsGroupPFS24 PfsGroup = "PFS24"
	// PfsGroupPFSMM ...
	PfsGroupPFSMM PfsGroup = "PFSMM"
)

// PossiblePfsGroupValues returns an array of possible values for the PfsGroup const type.
func PossiblePfsGroupValues() []PfsGroup {
	return []PfsGroup{PfsGroupECP256, PfsGroupECP384, PfsGroupNone, PfsGroupPFS1, PfsGroupPFS14, PfsGroupPFS2, PfsGroupPFS2048, PfsGroupPFS24, PfsGroupPFSMM}
}

// PreferredIPVersion enumerates the values for preferred ip version.
type PreferredIPVersion string

const (
	// PreferredIPVersionIPv4 ...
	PreferredIPVersionIPv4 PreferredIPVersion = "IPv4"
	// PreferredIPVersionIPv6 ...
	PreferredIPVersionIPv6 PreferredIPVersion = "IPv6"
)

// PossiblePreferredIPVersionValues returns an array of possible values for the PreferredIPVersion const type.
func PossiblePreferredIPVersionValues() []PreferredIPVersion {
	return []PreferredIPVersion{PreferredIPVersionIPv4, PreferredIPVersionIPv6}
}

// PreferredRoutingGateway enumerates the values for preferred routing gateway.
type PreferredRoutingGateway string

const (
	// PreferredRoutingGatewayExpressRoute ...
	PreferredRoutingGatewayExpressRoute PreferredRoutingGateway = "ExpressRoute"
	// PreferredRoutingGatewayNone ...
	PreferredRoutingGatewayNone PreferredRoutingGateway = "None"
	// PreferredRoutingGatewayVpnGateway ...
	PreferredRoutingGatewayVpnGateway PreferredRoutingGateway = "VpnGateway"
)

// PossiblePreferredRoutingGatewayValues returns an array of possible values for the PreferredRoutingGateway const type.
func PossiblePreferredRoutingGatewayValues() []PreferredRoutingGateway {
	return []PreferredRoutingGateway{PreferredRoutingGatewayExpressRoute, PreferredRoutingGatewayNone, PreferredRoutingGatewayVpnGateway}
}

// ProbeProtocol enumerates the values for probe protocol.
type ProbeProtocol string

const (
	// ProbeProtocolHTTP ...
	ProbeProtocolHTTP ProbeProtocol = "Http"
	// ProbeProtocolHTTPS ...
	ProbeProtocolHTTPS ProbeProtocol = "Https"
	// ProbeProtocolTCP ...
	ProbeProtocolTCP ProbeProtocol = "Tcp"
)

// PossibleProbeProtocolValues returns an array of possible values for the ProbeProtocol const type.
func PossibleProbeProtocolValues() []ProbeProtocol {
	return []ProbeProtocol{ProbeProtocolHTTP, ProbeProtocolHTTPS, ProbeProtocolTCP}
}

// ProcessorArchitecture enumerates the values for processor architecture.
type ProcessorArchitecture string

const (
	// ProcessorArchitectureAmd64 ...
	ProcessorArchitectureAmd64 ProcessorArchitecture = "Amd64"
	// ProcessorArchitectureX86 ...
	ProcessorArchitectureX86 ProcessorArchitecture = "X86"
)

// PossibleProcessorArchitectureValues returns an array of possible values for the ProcessorArchitecture const type.
func PossibleProcessorArchitectureValues() []ProcessorArchitecture {
	return []ProcessorArchitecture{ProcessorArchitectureAmd64, ProcessorArchitectureX86}
}

// Protocol enumerates the values for protocol.
type Protocol string

const (
	// ProtocolHTTP ...
	ProtocolHTTP Protocol = "Http"
	// ProtocolHTTPS ...
	ProtocolHTTPS Protocol = "Https"
	// ProtocolIcmp ...
	ProtocolIcmp Protocol = "Icmp"
	// ProtocolTCP ...
	ProtocolTCP Protocol = "Tcp"
)

// PossibleProtocolValues returns an array of possible values for the Protocol const type.
func PossibleProtocolValues() []Protocol {
	return []Protocol{ProtocolHTTP, ProtocolHTTPS, ProtocolIcmp, ProtocolTCP}
}

// ProtocolType enumerates the values for protocol type.
type ProtocolType string

const (
	// ProtocolTypeAh ...
	ProtocolTypeAh ProtocolType = "Ah"
	// ProtocolTypeAll ...
	ProtocolTypeAll ProtocolType = "All"
	// ProtocolTypeDoNotUse ...
	ProtocolTypeDoNotUse ProtocolType = "DoNotUse"
	// ProtocolTypeEsp ...
	ProtocolTypeEsp ProtocolType = "Esp"
	// ProtocolTypeGre ...
	ProtocolTypeGre ProtocolType = "Gre"
	// ProtocolTypeIcmp ...
	ProtocolTypeIcmp ProtocolType = "Icmp"
	// ProtocolTypeTCP ...
	ProtocolTypeTCP ProtocolType = "Tcp"
	// ProtocolTypeUDP ...
	ProtocolTypeUDP ProtocolType = "Udp"
	// ProtocolTypeVxlan ...
	ProtocolTypeVxlan ProtocolType = "Vxlan"
)

// PossibleProtocolTypeValues returns an array of possible values for the ProtocolType const type.
func PossibleProtocolTypeValues() []ProtocolType {
	return []ProtocolType{ProtocolTypeAh, ProtocolTypeAll, ProtocolTypeDoNotUse, ProtocolTypeEsp, ProtocolTypeGre, ProtocolTypeIcmp, ProtocolTypeTCP, ProtocolTypeUDP, ProtocolTypeVxlan}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateDeleting ...
	ProvisioningStateDeleting ProvisioningState = "Deleting"
	// ProvisioningStateFailed ...
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateSucceeded ...
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
	// ProvisioningStateUpdating ...
	ProvisioningStateUpdating ProvisioningState = "Updating"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateDeleting, ProvisioningStateFailed, ProvisioningStateSucceeded, ProvisioningStateUpdating}
}

// PublicIPAddressMigrationPhase enumerates the values for public ip address migration phase.
type PublicIPAddressMigrationPhase string

const (
	// PublicIPAddressMigrationPhaseAbort ...
	PublicIPAddressMigrationPhaseAbort PublicIPAddressMigrationPhase = "Abort"
	// PublicIPAddressMigrationPhaseCommit ...
	PublicIPAddressMigrationPhaseCommit PublicIPAddressMigrationPhase = "Commit"
	// PublicIPAddressMigrationPhaseCommitted ...
	PublicIPAddressMigrationPhaseCommitted PublicIPAddressMigrationPhase = "Committed"
	// PublicIPAddressMigrationPhaseNone ...
	PublicIPAddressMigrationPhaseNone PublicIPAddressMigrationPhase = "None"
	// PublicIPAddressMigrationPhasePrepare ...
	PublicIPAddressMigrationPhasePrepare PublicIPAddressMigrationPhase = "Prepare"
)

// PossiblePublicIPAddressMigrationPhaseValues returns an array of possible values for the PublicIPAddressMigrationPhase const type.
func PossiblePublicIPAddressMigrationPhaseValues() []PublicIPAddressMigrationPhase {
	return []PublicIPAddressMigrationPhase{PublicIPAddressMigrationPhaseAbort, PublicIPAddressMigrationPhaseCommit, PublicIPAddressMigrationPhaseCommitted, PublicIPAddressMigrationPhaseNone, PublicIPAddressMigrationPhasePrepare}
}

// PublicIPAddressSkuName enumerates the values for public ip address sku name.
type PublicIPAddressSkuName string

const (
	// PublicIPAddressSkuNameBasic ...
	PublicIPAddressSkuNameBasic PublicIPAddressSkuName = "Basic"
	// PublicIPAddressSkuNameStandard ...
	PublicIPAddressSkuNameStandard PublicIPAddressSkuName = "Standard"
)

// PossiblePublicIPAddressSkuNameValues returns an array of possible values for the PublicIPAddressSkuName const type.
func PossiblePublicIPAddressSkuNameValues() []PublicIPAddressSkuName {
	return []PublicIPAddressSkuName{PublicIPAddressSkuNameBasic, PublicIPAddressSkuNameStandard}
}

// PublicIPAddressSkuTier enumerates the values for public ip address sku tier.
type PublicIPAddressSkuTier string

const (
	// PublicIPAddressSkuTierGlobal ...
	PublicIPAddressSkuTierGlobal PublicIPAddressSkuTier = "Global"
	// PublicIPAddressSkuTierRegional ...
	PublicIPAddressSkuTierRegional PublicIPAddressSkuTier = "Regional"
)

// PossiblePublicIPAddressSkuTierValues returns an array of possible values for the PublicIPAddressSkuTier const type.
func PossiblePublicIPAddressSkuTierValues() []PublicIPAddressSkuTier {
	return []PublicIPAddressSkuTier{PublicIPAddressSkuTierGlobal, PublicIPAddressSkuTierRegional}
}

// PublicIPPrefixSkuName enumerates the values for public ip prefix sku name.
type PublicIPPrefixSkuName string

const (
	// PublicIPPrefixSkuNameStandard ...
	PublicIPPrefixSkuNameStandard PublicIPPrefixSkuName = "Standard"
)

// PossiblePublicIPPrefixSkuNameValues returns an array of possible values for the PublicIPPrefixSkuName const type.
func PossiblePublicIPPrefixSkuNameValues() []PublicIPPrefixSkuName {
	return []PublicIPPrefixSkuName{PublicIPPrefixSkuNameStandard}
}

// PublicIPPrefixSkuTier enumerates the values for public ip prefix sku tier.
type PublicIPPrefixSkuTier string

const (
	// PublicIPPrefixSkuTierGlobal ...
	PublicIPPrefixSkuTierGlobal PublicIPPrefixSkuTier = "Global"
	// PublicIPPrefixSkuTierRegional ...
	PublicIPPrefixSkuTierRegional PublicIPPrefixSkuTier = "Regional"
)

// PossiblePublicIPPrefixSkuTierValues returns an array of possible values for the PublicIPPrefixSkuTier const type.
func PossiblePublicIPPrefixSkuTierValues() []PublicIPPrefixSkuTier {
	return []PublicIPPrefixSkuTier{PublicIPPrefixSkuTierGlobal, PublicIPPrefixSkuTierRegional}
}

// ResourceIdentityType enumerates the values for resource identity type.
type ResourceIdentityType string

const (
	// ResourceIdentityTypeNone ...
	ResourceIdentityTypeNone ResourceIdentityType = "None"
	// ResourceIdentityTypeSystemAssigned ...
	ResourceIdentityTypeSystemAssigned ResourceIdentityType = "SystemAssigned"
	// ResourceIdentityTypeSystemAssignedUserAssigned ...
	ResourceIdentityTypeSystemAssignedUserAssigned ResourceIdentityType = "SystemAssigned, UserAssigned"
	// ResourceIdentityTypeUserAssigned ...
	ResourceIdentityTypeUserAssigned ResourceIdentityType = "UserAssigned"
)

// PossibleResourceIdentityTypeValues returns an array of possible values for the ResourceIdentityType const type.
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return []ResourceIdentityType{ResourceIdentityTypeNone, ResourceIdentityTypeSystemAssigned, ResourceIdentityTypeSystemAssignedUserAssigned, ResourceIdentityTypeUserAssigned}
}

// RouteNextHopType enumerates the values for route next hop type.
type RouteNextHopType string

const (
	// RouteNextHopTypeInternet ...
	RouteNextHopTypeInternet RouteNextHopType = "Internet"
	// RouteNextHopTypeNone ...
	RouteNextHopTypeNone RouteNextHopType = "None"
	// RouteNextHopTypeVirtualAppliance ...
	RouteNextHopTypeVirtualAppliance RouteNextHopType = "VirtualAppliance"
	// RouteNextHopTypeVirtualNetworkGateway ...
	RouteNextHopTypeVirtualNetworkGateway RouteNextHopType = "VirtualNetworkGateway"
	// RouteNextHopTypeVnetLocal ...
	RouteNextHopTypeVnetLocal RouteNextHopType = "VnetLocal"
)

// PossibleRouteNextHopTypeValues returns an array of possible values for the RouteNextHopType const type.
func PossibleRouteNextHopTypeValues() []RouteNextHopType {
	return []RouteNextHopType{RouteNextHopTypeInternet, RouteNextHopTypeNone, RouteNextHopTypeVirtualAppliance, RouteNextHopTypeVirtualNetworkGateway, RouteNextHopTypeVnetLocal}
}

// RoutingState enumerates the values for routing state.
type RoutingState string

const (
	// RoutingStateFailed ...
	RoutingStateFailed RoutingState = "Failed"
	// RoutingStateNone ...
	RoutingStateNone RoutingState = "None"
	// RoutingStateProvisioned ...
	RoutingStateProvisioned RoutingState = "Provisioned"
	// RoutingStateProvisioning ...
	RoutingStateProvisioning RoutingState = "Provisioning"
)

// PossibleRoutingStateValues returns an array of possible values for the RoutingState const type.
func PossibleRoutingStateValues() []RoutingState {
	return []RoutingState{RoutingStateFailed, RoutingStateNone, RoutingStateProvisioned, RoutingStateProvisioning}
}

// RuleCollectionType enumerates the values for rule collection type.
type RuleCollectionType string

const (
	// RuleCollectionTypeFirewallPolicyFilterRuleCollection ...
	RuleCollectionTypeFirewallPolicyFilterRuleCollection RuleCollectionType = "FirewallPolicyFilterRuleCollection"
	// RuleCollectionTypeFirewallPolicyNatRuleCollection ...
	RuleCollectionTypeFirewallPolicyNatRuleCollection RuleCollectionType = "FirewallPolicyNatRuleCollection"
	// RuleCollectionTypeFirewallPolicyRuleCollection ...
	RuleCollectionTypeFirewallPolicyRuleCollection RuleCollectionType = "FirewallPolicyRuleCollection"
)

// PossibleRuleCollectionTypeValues returns an array of possible values for the RuleCollectionType const type.
func PossibleRuleCollectionTypeValues() []RuleCollectionType {
	return []RuleCollectionType{RuleCollectionTypeFirewallPolicyFilterRuleCollection, RuleCollectionTypeFirewallPolicyNatRuleCollection, RuleCollectionTypeFirewallPolicyRuleCollection}
}

// RuleType enumerates the values for rule type.
type RuleType string

const (
	// RuleTypeApplicationRule ...
	RuleTypeApplicationRule RuleType = "ApplicationRule"
	// RuleTypeFirewallPolicyRule ...
	RuleTypeFirewallPolicyRule RuleType = "FirewallPolicyRule"
	// RuleTypeNatRule ...
	RuleTypeNatRule RuleType = "NatRule"
	// RuleTypeNetworkRule ...
	RuleTypeNetworkRule RuleType = "NetworkRule"
)

// PossibleRuleTypeValues returns an array of possible values for the RuleType const type.
func PossibleRuleTypeValues() []RuleType {
	return []RuleType{RuleTypeApplicationRule, RuleTypeFirewallPolicyRule, RuleTypeNatRule, RuleTypeNetworkRule}
}

// SecurityPartnerProviderConnectionStatus enumerates the values for security partner provider connection
// status.
type SecurityPartnerProviderConnectionStatus string

const (
	// SecurityPartnerProviderConnectionStatusConnected ...
	SecurityPartnerProviderConnectionStatusConnected SecurityPartnerProviderConnectionStatus = "Connected"
	// SecurityPartnerProviderConnectionStatusNotConnected ...
	SecurityPartnerProviderConnectionStatusNotConnected SecurityPartnerProviderConnectionStatus = "NotConnected"
	// SecurityPartnerProviderConnectionStatusPartiallyConnected ...
	SecurityPartnerProviderConnectionStatusPartiallyConnected SecurityPartnerProviderConnectionStatus = "PartiallyConnected"
	// SecurityPartnerProviderConnectionStatusUnknown ...
	SecurityPartnerProviderConnectionStatusUnknown SecurityPartnerProviderConnectionStatus = "Unknown"
)

// PossibleSecurityPartnerProviderConnectionStatusValues returns an array of possible values for the SecurityPartnerProviderConnectionStatus const type.
func PossibleSecurityPartnerProviderConnectionStatusValues() []SecurityPartnerProviderConnectionStatus {
	return []SecurityPartnerProviderConnectionStatus{SecurityPartnerProviderConnectionStatusConnected, SecurityPartnerProviderConnectionStatusNotConnected, SecurityPartnerProviderConnectionStatusPartiallyConnected, SecurityPartnerProviderConnectionStatusUnknown}
}

// SecurityProviderName enumerates the values for security provider name.
type SecurityProviderName string

const (
	// SecurityProviderNameCheckpoint ...
	SecurityProviderNameCheckpoint SecurityProviderName = "Checkpoint"
	// SecurityProviderNameIBoss ...
	SecurityProviderNameIBoss SecurityProviderName = "IBoss"
	// SecurityProviderNameZScaler ...
	SecurityProviderNameZScaler SecurityProviderName = "ZScaler"
)

// PossibleSecurityProviderNameValues returns an array of possible values for the SecurityProviderName const type.
func PossibleSecurityProviderNameValues() []SecurityProviderName {
	return []SecurityProviderName{SecurityProviderNameCheckpoint, SecurityProviderNameIBoss, SecurityProviderNameZScaler}
}

// SecurityRuleAccess enumerates the values for security rule access.
type SecurityRuleAccess string

const (
	// SecurityRuleAccessAllow ...
	SecurityRuleAccessAllow SecurityRuleAccess = "Allow"
	// SecurityRuleAccessDeny ...
	SecurityRuleAccessDeny SecurityRuleAccess = "Deny"
)

// PossibleSecurityRuleAccessValues returns an array of possible values for the SecurityRuleAccess const type.
func PossibleSecurityRuleAccessValues() []SecurityRuleAccess {
	return []SecurityRuleAccess{SecurityRuleAccessAllow, SecurityRuleAccessDeny}
}

// SecurityRuleDirection enumerates the values for security rule direction.
type SecurityRuleDirection string

const (
	// SecurityRuleDirectionInbound ...
	SecurityRuleDirectionInbound SecurityRuleDirection = "Inbound"
	// SecurityRuleDirectionOutbound ...
	SecurityRuleDirectionOutbound SecurityRuleDirection = "Outbound"
)

// PossibleSecurityRuleDirectionValues returns an array of possible values for the SecurityRuleDirection const type.
func PossibleSecurityRuleDirectionValues() []SecurityRuleDirection {
	return []SecurityRuleDirection{SecurityRuleDirectionInbound, SecurityRuleDirectionOutbound}
}

// SecurityRuleProtocol enumerates the values for security rule protocol.
type SecurityRuleProtocol string

const (
	// SecurityRuleProtocolAh ...
	SecurityRuleProtocolAh SecurityRuleProtocol = "Ah"
	// SecurityRuleProtocolAsterisk ...
	SecurityRuleProtocolAsterisk SecurityRuleProtocol = "*"
	// SecurityRuleProtocolEsp ...
	SecurityRuleProtocolEsp SecurityRuleProtocol = "Esp"
	// SecurityRuleProtocolIcmp ...
	SecurityRuleProtocolIcmp SecurityRuleProtocol = "Icmp"
	// SecurityRuleProtocolTCP ...
	SecurityRuleProtocolTCP SecurityRuleProtocol = "Tcp"
	// SecurityRuleProtocolUDP ...
	SecurityRuleProtocolUDP SecurityRuleProtocol = "Udp"
)

// PossibleSecurityRuleProtocolValues returns an array of possible values for the SecurityRuleProtocol const type.
func PossibleSecurityRuleProtocolValues() []SecurityRuleProtocol {
	return []SecurityRuleProtocol{SecurityRuleProtocolAh, SecurityRuleProtocolAsterisk, SecurityRuleProtocolEsp, SecurityRuleProtocolIcmp, SecurityRuleProtocolTCP, SecurityRuleProtocolUDP}
}

// ServiceProviderProvisioningState enumerates the values for service provider provisioning state.
type ServiceProviderProvisioningState string

const (
	// ServiceProviderProvisioningStateDeprovisioning ...
	ServiceProviderProvisioningStateDeprovisioning ServiceProviderProvisioningState = "Deprovisioning"
	// ServiceProviderProvisioningStateNotProvisioned ...
	ServiceProviderProvisioningStateNotProvisioned ServiceProviderProvisioningState = "NotProvisioned"
	// ServiceProviderProvisioningStateProvisioned ...
	ServiceProviderProvisioningStateProvisioned ServiceProviderProvisioningState = "Provisioned"
	// ServiceProviderProvisioningStateProvisioning ...
	ServiceProviderProvisioningStateProvisioning ServiceProviderProvisioningState = "Provisioning"
)

// PossibleServiceProviderProvisioningStateValues returns an array of possible values for the ServiceProviderProvisioningState const type.
func PossibleServiceProviderProvisioningStateValues() []ServiceProviderProvisioningState {
	return []ServiceProviderProvisioningState{ServiceProviderProvisioningStateDeprovisioning, ServiceProviderProvisioningStateNotProvisioned, ServiceProviderProvisioningStateProvisioned, ServiceProviderProvisioningStateProvisioning}
}

// Severity enumerates the values for severity.
type Severity string

const (
	// SeverityError ...
	SeverityError Severity = "Error"
	// SeverityWarning ...
	SeverityWarning Severity = "Warning"
)

// PossibleSeverityValues returns an array of possible values for the Severity const type.
func PossibleSeverityValues() []Severity {
	return []Severity{SeverityError, SeverityWarning}
}

// SyncRemoteAddressSpace enumerates the values for sync remote address space.
type SyncRemoteAddressSpace string

const (
	// SyncRemoteAddressSpaceTrue ...
	SyncRemoteAddressSpaceTrue SyncRemoteAddressSpace = "true"
)

// PossibleSyncRemoteAddressSpaceValues returns an array of possible values for the SyncRemoteAddressSpace const type.
func PossibleSyncRemoteAddressSpaceValues() []SyncRemoteAddressSpace {
	return []SyncRemoteAddressSpace{SyncRemoteAddressSpaceTrue}
}

// TransportProtocol enumerates the values for transport protocol.
type TransportProtocol string

const (
	// TransportProtocolAll ...
	TransportProtocolAll TransportProtocol = "All"
	// TransportProtocolTCP ...
	TransportProtocolTCP TransportProtocol = "Tcp"
	// TransportProtocolUDP ...
	TransportProtocolUDP TransportProtocol = "Udp"
)

// PossibleTransportProtocolValues returns an array of possible values for the TransportProtocol const type.
func PossibleTransportProtocolValues() []TransportProtocol {
	return []TransportProtocol{TransportProtocolAll, TransportProtocolTCP, TransportProtocolUDP}
}

// TunnelConnectionStatus enumerates the values for tunnel connection status.
type TunnelConnectionStatus string

const (
	// TunnelConnectionStatusConnected ...
	TunnelConnectionStatusConnected TunnelConnectionStatus = "Connected"
	// TunnelConnectionStatusConnecting ...
	TunnelConnectionStatusConnecting TunnelConnectionStatus = "Connecting"
	// TunnelConnectionStatusNotConnected ...
	TunnelConnectionStatusNotConnected TunnelConnectionStatus = "NotConnected"
	// TunnelConnectionStatusUnknown ...
	TunnelConnectionStatusUnknown TunnelConnectionStatus = "Unknown"
)

// PossibleTunnelConnectionStatusValues returns an array of possible values for the TunnelConnectionStatus const type.
func PossibleTunnelConnectionStatusValues() []TunnelConnectionStatus {
	return []TunnelConnectionStatus{TunnelConnectionStatusConnected, TunnelConnectionStatusConnecting, TunnelConnectionStatusNotConnected, TunnelConnectionStatusUnknown}
}

// VerbosityLevel enumerates the values for verbosity level.
type VerbosityLevel string

const (
	// VerbosityLevelFull ...
	VerbosityLevelFull VerbosityLevel = "Full"
	// VerbosityLevelMinimum ...
	VerbosityLevelMinimum VerbosityLevel = "Minimum"
	// VerbosityLevelNormal ...
	VerbosityLevelNormal VerbosityLevel = "Normal"
)

// PossibleVerbosityLevelValues returns an array of possible values for the VerbosityLevel const type.
func PossibleVerbosityLevelValues() []VerbosityLevel {
	return []VerbosityLevel{VerbosityLevelFull, VerbosityLevelMinimum, VerbosityLevelNormal}
}

// VirtualNetworkEncryptionEnforcement enumerates the values for virtual network encryption enforcement.
type VirtualNetworkEncryptionEnforcement string

const (
	// VirtualNetworkEncryptionEnforcementAllowUnencrypted ...
	VirtualNetworkEncryptionEnforcementAllowUnencrypted VirtualNetworkEncryptionEnforcement = "AllowUnencrypted"
	// VirtualNetworkEncryptionEnforcementDropUnencrypted ...
	VirtualNetworkEncryptionEnforcementDropUnencrypted VirtualNetworkEncryptionEnforcement = "DropUnencrypted"
)

// PossibleVirtualNetworkEncryptionEnforcementValues returns an array of possible values for the VirtualNetworkEncryptionEnforcement const type.
func PossibleVirtualNetworkEncryptionEnforcementValues() []VirtualNetworkEncryptionEnforcement {
	return []VirtualNetworkEncryptionEnforcement{VirtualNetworkEncryptionEnforcementAllowUnencrypted, VirtualNetworkEncryptionEnforcementDropUnencrypted}
}

// VirtualNetworkGatewayConnectionMode enumerates the values for virtual network gateway connection mode.
type VirtualNetworkGatewayConnectionMode string

const (
	// VirtualNetworkGatewayConnectionModeDefault ...
	VirtualNetworkGatewayConnectionModeDefault VirtualNetworkGatewayConnectionMode = "Default"
	// VirtualNetworkGatewayConnectionModeInitiatorOnly ...
	VirtualNetworkGatewayConnectionModeInitiatorOnly VirtualNetworkGatewayConnectionMode = "InitiatorOnly"
	// VirtualNetworkGatewayConnectionModeResponderOnly ...
	VirtualNetworkGatewayConnectionModeResponderOnly VirtualNetworkGatewayConnectionMode = "ResponderOnly"
)

// PossibleVirtualNetworkGatewayConnectionModeValues returns an array of possible values for the VirtualNetworkGatewayConnectionMode const type.
func PossibleVirtualNetworkGatewayConnectionModeValues() []VirtualNetworkGatewayConnectionMode {
	return []VirtualNetworkGatewayConnectionMode{VirtualNetworkGatewayConnectionModeDefault, VirtualNetworkGatewayConnectionModeInitiatorOnly, VirtualNetworkGatewayConnectionModeResponderOnly}
}

// VirtualNetworkGatewayConnectionProtocol enumerates the values for virtual network gateway connection
// protocol.
type VirtualNetworkGatewayConnectionProtocol string

const (
	// VirtualNetworkGatewayConnectionProtocolIKEv1 ...
	VirtualNetworkGatewayConnectionProtocolIKEv1 VirtualNetworkGatewayConnectionProtocol = "IKEv1"
	// VirtualNetworkGatewayConnectionProtocolIKEv2 ...
	VirtualNetworkGatewayConnectionProtocolIKEv2 VirtualNetworkGatewayConnectionProtocol = "IKEv2"
)

// PossibleVirtualNetworkGatewayConnectionProtocolValues returns an array of possible values for the VirtualNetworkGatewayConnectionProtocol const type.
func PossibleVirtualNetworkGatewayConnectionProtocolValues() []VirtualNetworkGatewayConnectionProtocol {
	return []VirtualNetworkGatewayConnectionProtocol{VirtualNetworkGatewayConnectionProtocolIKEv1, VirtualNetworkGatewayConnectionProtocolIKEv2}
}

// VirtualNetworkGatewayConnectionStatus enumerates the values for virtual network gateway connection status.
type VirtualNetworkGatewayConnectionStatus string

const (
	// VirtualNetworkGatewayConnectionStatusConnected ...
	VirtualNetworkGatewayConnectionStatusConnected VirtualNetworkGatewayConnectionStatus = "Connected"
	// VirtualNetworkGatewayConnectionStatusConnecting ...
	VirtualNetworkGatewayConnectionStatusConnecting VirtualNetworkGatewayConnectionStatus = "Connecting"
	// VirtualNetworkGatewayConnectionStatusNotConnected ...
	VirtualNetworkGatewayConnectionStatusNotConnected VirtualNetworkGatewayConnectionStatus = "NotConnected"
	// VirtualNetworkGatewayConnectionStatusUnknown ...
	VirtualNetworkGatewayConnectionStatusUnknown VirtualNetworkGatewayConnectionStatus = "Unknown"
)

// PossibleVirtualNetworkGatewayConnectionStatusValues returns an array of possible values for the VirtualNetworkGatewayConnectionStatus const type.
func PossibleVirtualNetworkGatewayConnectionStatusValues() []VirtualNetworkGatewayConnectionStatus {
	return []VirtualNetworkGatewayConnectionStatus{VirtualNetworkGatewayConnectionStatusConnected, VirtualNetworkGatewayConnectionStatusConnecting, VirtualNetworkGatewayConnectionStatusNotConnected, VirtualNetworkGatewayConnectionStatusUnknown}
}

// VirtualNetworkGatewayConnectionType enumerates the values for virtual network gateway connection type.
type VirtualNetworkGatewayConnectionType string

const (
	// VirtualNetworkGatewayConnectionTypeExpressRoute ...
	VirtualNetworkGatewayConnectionTypeExpressRoute VirtualNetworkGatewayConnectionType = "ExpressRoute"
	// VirtualNetworkGatewayConnectionTypeIPsec ...
	VirtualNetworkGatewayConnectionTypeIPsec VirtualNetworkGatewayConnectionType = "IPsec"
	// VirtualNetworkGatewayConnectionTypeVnet2Vnet ...
	VirtualNetworkGatewayConnectionTypeVnet2Vnet VirtualNetworkGatewayConnectionType = "Vnet2Vnet"
	// VirtualNetworkGatewayConnectionTypeVPNClient ...
	VirtualNetworkGatewayConnectionTypeVPNClient VirtualNetworkGatewayConnectionType = "VPNClient"
)

// PossibleVirtualNetworkGatewayConnectionTypeValues returns an array of possible values for the VirtualNetworkGatewayConnectionType const type.
func PossibleVirtualNetworkGatewayConnectionTypeValues() []VirtualNetworkGatewayConnectionType {
	return []VirtualNetworkGatewayConnectionType{VirtualNetworkGatewayConnectionTypeExpressRoute, VirtualNetworkGatewayConnectionTypeIPsec, VirtualNetworkGatewayConnectionTypeVnet2Vnet, VirtualNetworkGatewayConnectionTypeVPNClient}
}

// VirtualNetworkGatewaySkuName enumerates the values for virtual network gateway sku name.
type VirtualNetworkGatewaySkuName string

const (
	// VirtualNetworkGatewaySkuNameBasic ...
	VirtualNetworkGatewaySkuNameBasic VirtualNetworkGatewaySkuName = "Basic"
	// VirtualNetworkGatewaySkuNameErGw1AZ ...
	VirtualNetworkGatewaySkuNameErGw1AZ VirtualNetworkGatewaySkuName = "ErGw1AZ"
	// VirtualNetworkGatewaySkuNameErGw2AZ ...
	VirtualNetworkGatewaySkuNameErGw2AZ VirtualNetworkGatewaySkuName = "ErGw2AZ"
	// VirtualNetworkGatewaySkuNameErGw3AZ ...
	VirtualNetworkGatewaySkuNameErGw3AZ VirtualNetworkGatewaySkuName = "ErGw3AZ"
	// VirtualNetworkGatewaySkuNameHighPerformance ...
	VirtualNetworkGatewaySkuNameHighPerformance VirtualNetworkGatewaySkuName = "HighPerformance"
	// VirtualNetworkGatewaySkuNameStandard ...
	VirtualNetworkGatewaySkuNameStandard VirtualNetworkGatewaySkuName = "Standard"
	// VirtualNetworkGatewaySkuNameUltraPerformance ...
	VirtualNetworkGatewaySkuNameUltraPerformance VirtualNetworkGatewaySkuName = "UltraPerformance"
	// VirtualNetworkGatewaySkuNameVpnGw1 ...
	VirtualNetworkGatewaySkuNameVpnGw1 VirtualNetworkGatewaySkuName = "VpnGw1"
	// VirtualNetworkGatewaySkuNameVpnGw1AZ ...
	VirtualNetworkGatewaySkuNameVpnGw1AZ VirtualNetworkGatewaySkuName = "VpnGw1AZ"
	// VirtualNetworkGatewaySkuNameVpnGw2 ...
	VirtualNetworkGatewaySkuNameVpnGw2 VirtualNetworkGatewaySkuName = "VpnGw2"
	// VirtualNetworkGatewaySkuNameVpnGw2AZ ...
	VirtualNetworkGatewaySkuNameVpnGw2AZ VirtualNetworkGatewaySkuName = "VpnGw2AZ"
	// VirtualNetworkGatewaySkuNameVpnGw3 ...
	VirtualNetworkGatewaySkuNameVpnGw3 VirtualNetworkGatewaySkuName = "VpnGw3"
	// VirtualNetworkGatewaySkuNameVpnGw3AZ ...
	VirtualNetworkGatewaySkuNameVpnGw3AZ VirtualNetworkGatewaySkuName = "VpnGw3AZ"
	// VirtualNetworkGatewaySkuNameVpnGw4 ...
	VirtualNetworkGatewaySkuNameVpnGw4 VirtualNetworkGatewaySkuName = "VpnGw4"
	// VirtualNetworkGatewaySkuNameVpnGw4AZ ...
	VirtualNetworkGatewaySkuNameVpnGw4AZ VirtualNetworkGatewaySkuName = "VpnGw4AZ"
	// VirtualNetworkGatewaySkuNameVpnGw5 ...
	VirtualNetworkGatewaySkuNameVpnGw5 VirtualNetworkGatewaySkuName = "VpnGw5"
	// VirtualNetworkGatewaySkuNameVpnGw5AZ ...
	VirtualNetworkGatewaySkuNameVpnGw5AZ VirtualNetworkGatewaySkuName = "VpnGw5AZ"
)

// PossibleVirtualNetworkGatewaySkuNameValues returns an array of possible values for the VirtualNetworkGatewaySkuName const type.
func PossibleVirtualNetworkGatewaySkuNameValues() []VirtualNetworkGatewaySkuName {
	return []VirtualNetworkGatewaySkuName{VirtualNetworkGatewaySkuNameBasic, VirtualNetworkGatewaySkuNameErGw1AZ, VirtualNetworkGatewaySkuNameErGw2AZ, VirtualNetworkGatewaySkuNameErGw3AZ, VirtualNetworkGatewaySkuNameHighPerformance, VirtualNetworkGatewaySkuNameStandard, VirtualNetworkGatewaySkuNameUltraPerformance, VirtualNetworkGatewaySkuNameVpnGw1, VirtualNetworkGatewaySkuNameVpnGw1AZ, VirtualNetworkGatewaySkuNameVpnGw2, VirtualNetworkGatewaySkuNameVpnGw2AZ, VirtualNetworkGatewaySkuNameVpnGw3, VirtualNetworkGatewaySkuNameVpnGw3AZ, VirtualNetworkGatewaySkuNameVpnGw4, VirtualNetworkGatewaySkuNameVpnGw4AZ, VirtualNetworkGatewaySkuNameVpnGw5, VirtualNetworkGatewaySkuNameVpnGw5AZ}
}

// VirtualNetworkGatewaySkuTier enumerates the values for virtual network gateway sku tier.
type VirtualNetworkGatewaySkuTier string

const (
	// VirtualNetworkGatewaySkuTierBasic ...
	VirtualNetworkGatewaySkuTierBasic VirtualNetworkGatewaySkuTier = "Basic"
	// VirtualNetworkGatewaySkuTierErGw1AZ ...
	VirtualNetworkGatewaySkuTierErGw1AZ VirtualNetworkGatewaySkuTier = "ErGw1AZ"
	// VirtualNetworkGatewaySkuTierErGw2AZ ...
	VirtualNetworkGatewaySkuTierErGw2AZ VirtualNetworkGatewaySkuTier = "ErGw2AZ"
	// VirtualNetworkGatewaySkuTierErGw3AZ ...
	VirtualNetworkGatewaySkuTierErGw3AZ VirtualNetworkGatewaySkuTier = "ErGw3AZ"
	// VirtualNetworkGatewaySkuTierHighPerformance ...
	VirtualNetworkGatewaySkuTierHighPerformance VirtualNetworkGatewaySkuTier = "HighPerformance"
	// VirtualNetworkGatewaySkuTierStandard ...
	VirtualNetworkGatewaySkuTierStandard VirtualNetworkGatewaySkuTier = "Standard"
	// VirtualNetworkGatewaySkuTierUltraPerformance ...
	VirtualNetworkGatewaySkuTierUltraPerformance VirtualNetworkGatewaySkuTier = "UltraPerformance"
	// VirtualNetworkGatewaySkuTierVpnGw1 ...
	VirtualNetworkGatewaySkuTierVpnGw1 VirtualNetworkGatewaySkuTier = "VpnGw1"
	// VirtualNetworkGatewaySkuTierVpnGw1AZ ...
	VirtualNetworkGatewaySkuTierVpnGw1AZ VirtualNetworkGatewaySkuTier = "VpnGw1AZ"
	// VirtualNetworkGatewaySkuTierVpnGw2 ...
	VirtualNetworkGatewaySkuTierVpnGw2 VirtualNetworkGatewaySkuTier = "VpnGw2"
	// VirtualNetworkGatewaySkuTierVpnGw2AZ ...
	VirtualNetworkGatewaySkuTierVpnGw2AZ VirtualNetworkGatewaySkuTier = "VpnGw2AZ"
	// VirtualNetworkGatewaySkuTierVpnGw3 ...
	VirtualNetworkGatewaySkuTierVpnGw3 VirtualNetworkGatewaySkuTier = "VpnGw3"
	// VirtualNetworkGatewaySkuTierVpnGw3AZ ...
	VirtualNetworkGatewaySkuTierVpnGw3AZ VirtualNetworkGatewaySkuTier = "VpnGw3AZ"
	// VirtualNetworkGatewaySkuTierVpnGw4 ...
	VirtualNetworkGatewaySkuTierVpnGw4 VirtualNetworkGatewaySkuTier = "VpnGw4"
	// VirtualNetworkGatewaySkuTierVpnGw4AZ ...
	VirtualNetworkGatewaySkuTierVpnGw4AZ VirtualNetworkGatewaySkuTier = "VpnGw4AZ"
	// VirtualNetworkGatewaySkuTierVpnGw5 ...
	VirtualNetworkGatewaySkuTierVpnGw5 VirtualNetworkGatewaySkuTier = "VpnGw5"
	// VirtualNetworkGatewaySkuTierVpnGw5AZ ...
	VirtualNetworkGatewaySkuTierVpnGw5AZ VirtualNetworkGatewaySkuTier = "VpnGw5AZ"
)

// PossibleVirtualNetworkGatewaySkuTierValues returns an array of possible values for the VirtualNetworkGatewaySkuTier const type.
func PossibleVirtualNetworkGatewaySkuTierValues() []VirtualNetworkGatewaySkuTier {
	return []VirtualNetworkGatewaySkuTier{VirtualNetworkGatewaySkuTierBasic, VirtualNetworkGatewaySkuTierErGw1AZ, VirtualNetworkGatewaySkuTierErGw2AZ, VirtualNetworkGatewaySkuTierErGw3AZ, VirtualNetworkGatewaySkuTierHighPerformance, VirtualNetworkGatewaySkuTierStandard, VirtualNetworkGatewaySkuTierUltraPerformance, VirtualNetworkGatewaySkuTierVpnGw1, VirtualNetworkGatewaySkuTierVpnGw1AZ, VirtualNetworkGatewaySkuTierVpnGw2, VirtualNetworkGatewaySkuTierVpnGw2AZ, VirtualNetworkGatewaySkuTierVpnGw3, VirtualNetworkGatewaySkuTierVpnGw3AZ, VirtualNetworkGatewaySkuTierVpnGw4, VirtualNetworkGatewaySkuTierVpnGw4AZ, VirtualNetworkGatewaySkuTierVpnGw5, VirtualNetworkGatewaySkuTierVpnGw5AZ}
}

// VirtualNetworkGatewayType enumerates the values for virtual network gateway type.
type VirtualNetworkGatewayType string

const (
	// VirtualNetworkGatewayTypeExpressRoute ...
	VirtualNetworkGatewayTypeExpressRoute VirtualNetworkGatewayType = "ExpressRoute"
	// VirtualNetworkGatewayTypeLocalGateway ...
	VirtualNetworkGatewayTypeLocalGateway VirtualNetworkGatewayType = "LocalGateway"
	// VirtualNetworkGatewayTypeVpn ...
	VirtualNetworkGatewayTypeVpn VirtualNetworkGatewayType = "Vpn"
)

// PossibleVirtualNetworkGatewayTypeValues returns an array of possible values for the VirtualNetworkGatewayType const type.
func PossibleVirtualNetworkGatewayTypeValues() []VirtualNetworkGatewayType {
	return []VirtualNetworkGatewayType{VirtualNetworkGatewayTypeExpressRoute, VirtualNetworkGatewayTypeLocalGateway, VirtualNetworkGatewayTypeVpn}
}

// VirtualNetworkPeeringLevel enumerates the values for virtual network peering level.
type VirtualNetworkPeeringLevel string

const (
	// VirtualNetworkPeeringLevelFullyInSync ...
	VirtualNetworkPeeringLevelFullyInSync VirtualNetworkPeeringLevel = "FullyInSync"
	// VirtualNetworkPeeringLevelLocalAndRemoteNotInSync ...
	VirtualNetworkPeeringLevelLocalAndRemoteNotInSync VirtualNetworkPeeringLevel = "LocalAndRemoteNotInSync"
	// VirtualNetworkPeeringLevelLocalNotInSync ...
	VirtualNetworkPeeringLevelLocalNotInSync VirtualNetworkPeeringLevel = "LocalNotInSync"
	// VirtualNetworkPeeringLevelRemoteNotInSync ...
	VirtualNetworkPeeringLevelRemoteNotInSync VirtualNetworkPeeringLevel = "RemoteNotInSync"
)

// PossibleVirtualNetworkPeeringLevelValues returns an array of possible values for the VirtualNetworkPeeringLevel const type.
func PossibleVirtualNetworkPeeringLevelValues() []VirtualNetworkPeeringLevel {
	return []VirtualNetworkPeeringLevel{VirtualNetworkPeeringLevelFullyInSync, VirtualNetworkPeeringLevelLocalAndRemoteNotInSync, VirtualNetworkPeeringLevelLocalNotInSync, VirtualNetworkPeeringLevelRemoteNotInSync}
}

// VirtualNetworkPeeringState enumerates the values for virtual network peering state.
type VirtualNetworkPeeringState string

const (
	// VirtualNetworkPeeringStateConnected ...
	VirtualNetworkPeeringStateConnected VirtualNetworkPeeringState = "Connected"
	// VirtualNetworkPeeringStateDisconnected ...
	VirtualNetworkPeeringStateDisconnected VirtualNetworkPeeringState = "Disconnected"
	// VirtualNetworkPeeringStateInitiated ...
	VirtualNetworkPeeringStateInitiated VirtualNetworkPeeringState = "Initiated"
)

// PossibleVirtualNetworkPeeringStateValues returns an array of possible values for the VirtualNetworkPeeringState const type.
func PossibleVirtualNetworkPeeringStateValues() []VirtualNetworkPeeringState {
	return []VirtualNetworkPeeringState{VirtualNetworkPeeringStateConnected, VirtualNetworkPeeringStateDisconnected, VirtualNetworkPeeringStateInitiated}
}

// VirtualNetworkPrivateEndpointNetworkPolicies enumerates the values for virtual network private endpoint
// network policies.
type VirtualNetworkPrivateEndpointNetworkPolicies string

const (
	// VirtualNetworkPrivateEndpointNetworkPoliciesDisabled ...
	VirtualNetworkPrivateEndpointNetworkPoliciesDisabled VirtualNetworkPrivateEndpointNetworkPolicies = "Disabled"
	// VirtualNetworkPrivateEndpointNetworkPoliciesEnabled ...
	VirtualNetworkPrivateEndpointNetworkPoliciesEnabled VirtualNetworkPrivateEndpointNetworkPolicies = "Enabled"
)

// PossibleVirtualNetworkPrivateEndpointNetworkPoliciesValues returns an array of possible values for the VirtualNetworkPrivateEndpointNetworkPolicies const type.
func PossibleVirtualNetworkPrivateEndpointNetworkPoliciesValues() []VirtualNetworkPrivateEndpointNetworkPolicies {
	return []VirtualNetworkPrivateEndpointNetworkPolicies{VirtualNetworkPrivateEndpointNetworkPoliciesDisabled, VirtualNetworkPrivateEndpointNetworkPoliciesEnabled}
}

// VirtualNetworkPrivateLinkServiceNetworkPolicies enumerates the values for virtual network private link
// service network policies.
type VirtualNetworkPrivateLinkServiceNetworkPolicies string

const (
	// VirtualNetworkPrivateLinkServiceNetworkPoliciesDisabled ...
	VirtualNetworkPrivateLinkServiceNetworkPoliciesDisabled VirtualNetworkPrivateLinkServiceNetworkPolicies = "Disabled"
	// VirtualNetworkPrivateLinkServiceNetworkPoliciesEnabled ...
	VirtualNetworkPrivateLinkServiceNetworkPoliciesEnabled VirtualNetworkPrivateLinkServiceNetworkPolicies = "Enabled"
)

// PossibleVirtualNetworkPrivateLinkServiceNetworkPoliciesValues returns an array of possible values for the VirtualNetworkPrivateLinkServiceNetworkPolicies const type.
func PossibleVirtualNetworkPrivateLinkServiceNetworkPoliciesValues() []VirtualNetworkPrivateLinkServiceNetworkPolicies {
	return []VirtualNetworkPrivateLinkServiceNetworkPolicies{VirtualNetworkPrivateLinkServiceNetworkPoliciesDisabled, VirtualNetworkPrivateLinkServiceNetworkPoliciesEnabled}
}

// VirtualWanSecurityProviderType enumerates the values for virtual wan security provider type.
type VirtualWanSecurityProviderType string

const (
	// VirtualWanSecurityProviderTypeExternal ...
	VirtualWanSecurityProviderTypeExternal VirtualWanSecurityProviderType = "External"
	// VirtualWanSecurityProviderTypeNative ...
	VirtualWanSecurityProviderTypeNative VirtualWanSecurityProviderType = "Native"
)

// PossibleVirtualWanSecurityProviderTypeValues returns an array of possible values for the VirtualWanSecurityProviderType const type.
func PossibleVirtualWanSecurityProviderTypeValues() []VirtualWanSecurityProviderType {
	return []VirtualWanSecurityProviderType{VirtualWanSecurityProviderTypeExternal, VirtualWanSecurityProviderTypeNative}
}

// VpnAuthenticationType enumerates the values for vpn authentication type.
type VpnAuthenticationType string

const (
	// VpnAuthenticationTypeAAD ...
	VpnAuthenticationTypeAAD VpnAuthenticationType = "AAD"
	// VpnAuthenticationTypeCertificate ...
	VpnAuthenticationTypeCertificate VpnAuthenticationType = "Certificate"
	// VpnAuthenticationTypeRadius ...
	VpnAuthenticationTypeRadius VpnAuthenticationType = "Radius"
)

// PossibleVpnAuthenticationTypeValues returns an array of possible values for the VpnAuthenticationType const type.
func PossibleVpnAuthenticationTypeValues() []VpnAuthenticationType {
	return []VpnAuthenticationType{VpnAuthenticationTypeAAD, VpnAuthenticationTypeCertificate, VpnAuthenticationTypeRadius}
}

// VpnClientProtocol enumerates the values for vpn client protocol.
type VpnClientProtocol string

const (
	// VpnClientProtocolIkeV2 ...
	VpnClientProtocolIkeV2 VpnClientProtocol = "IkeV2"
	// VpnClientProtocolOpenVPN ...
	VpnClientProtocolOpenVPN VpnClientProtocol = "OpenVPN"
	// VpnClientProtocolSSTP ...
	VpnClientProtocolSSTP VpnClientProtocol = "SSTP"
)

// PossibleVpnClientProtocolValues returns an array of possible values for the VpnClientProtocol const type.
func PossibleVpnClientProtocolValues() []VpnClientProtocol {
	return []VpnClientProtocol{VpnClientProtocolIkeV2, VpnClientProtocolOpenVPN, VpnClientProtocolSSTP}
}

// VpnConnectionStatus enumerates the values for vpn connection status.
type VpnConnectionStatus string

const (
	// VpnConnectionStatusConnected ...
	VpnConnectionStatusConnected VpnConnectionStatus = "Connected"
	// VpnConnectionStatusConnecting ...
	VpnConnectionStatusConnecting VpnConnectionStatus = "Connecting"
	// VpnConnectionStatusNotConnected ...
	VpnConnectionStatusNotConnected VpnConnectionStatus = "NotConnected"
	// VpnConnectionStatusUnknown ...
	VpnConnectionStatusUnknown VpnConnectionStatus = "Unknown"
)

// PossibleVpnConnectionStatusValues returns an array of possible values for the VpnConnectionStatus const type.
func PossibleVpnConnectionStatusValues() []VpnConnectionStatus {
	return []VpnConnectionStatus{VpnConnectionStatusConnected, VpnConnectionStatusConnecting, VpnConnectionStatusNotConnected, VpnConnectionStatusUnknown}
}

// VpnGatewayGeneration enumerates the values for vpn gateway generation.
type VpnGatewayGeneration string

const (
	// VpnGatewayGenerationGeneration1 ...
	VpnGatewayGenerationGeneration1 VpnGatewayGeneration = "Generation1"
	// VpnGatewayGenerationGeneration2 ...
	VpnGatewayGenerationGeneration2 VpnGatewayGeneration = "Generation2"
	// VpnGatewayGenerationNone ...
	VpnGatewayGenerationNone VpnGatewayGeneration = "None"
)

// PossibleVpnGatewayGenerationValues returns an array of possible values for the VpnGatewayGeneration const type.
func PossibleVpnGatewayGenerationValues() []VpnGatewayGeneration {
	return []VpnGatewayGeneration{VpnGatewayGenerationGeneration1, VpnGatewayGenerationGeneration2, VpnGatewayGenerationNone}
}

// VpnGatewayTunnelingProtocol enumerates the values for vpn gateway tunneling protocol.
type VpnGatewayTunnelingProtocol string

const (
	// VpnGatewayTunnelingProtocolIkeV2 ...
	VpnGatewayTunnelingProtocolIkeV2 VpnGatewayTunnelingProtocol = "IkeV2"
	// VpnGatewayTunnelingProtocolOpenVPN ...
	VpnGatewayTunnelingProtocolOpenVPN VpnGatewayTunnelingProtocol = "OpenVPN"
)

// PossibleVpnGatewayTunnelingProtocolValues returns an array of possible values for the VpnGatewayTunnelingProtocol const type.
func PossibleVpnGatewayTunnelingProtocolValues() []VpnGatewayTunnelingProtocol {
	return []VpnGatewayTunnelingProtocol{VpnGatewayTunnelingProtocolIkeV2, VpnGatewayTunnelingProtocolOpenVPN}
}

// VpnLinkConnectionMode enumerates the values for vpn link connection mode.
type VpnLinkConnectionMode string

const (
	// VpnLinkConnectionModeDefault ...
	VpnLinkConnectionModeDefault VpnLinkConnectionMode = "Default"
	// VpnLinkConnectionModeInitiatorOnly ...
	VpnLinkConnectionModeInitiatorOnly VpnLinkConnectionMode = "InitiatorOnly"
	// VpnLinkConnectionModeResponderOnly ...
	VpnLinkConnectionModeResponderOnly VpnLinkConnectionMode = "ResponderOnly"
)

// PossibleVpnLinkConnectionModeValues returns an array of possible values for the VpnLinkConnectionMode const type.
func PossibleVpnLinkConnectionModeValues() []VpnLinkConnectionMode {
	return []VpnLinkConnectionMode{VpnLinkConnectionModeDefault, VpnLinkConnectionModeInitiatorOnly, VpnLinkConnectionModeResponderOnly}
}

// VpnNatRuleMode enumerates the values for vpn nat rule mode.
type VpnNatRuleMode string

const (
	// VpnNatRuleModeEgressSnat ...
	VpnNatRuleModeEgressSnat VpnNatRuleMode = "EgressSnat"
	// VpnNatRuleModeIngressSnat ...
	VpnNatRuleModeIngressSnat VpnNatRuleMode = "IngressSnat"
)

// PossibleVpnNatRuleModeValues returns an array of possible values for the VpnNatRuleMode const type.
func PossibleVpnNatRuleModeValues() []VpnNatRuleMode {
	return []VpnNatRuleMode{VpnNatRuleModeEgressSnat, VpnNatRuleModeIngressSnat}
}

// VpnNatRuleType enumerates the values for vpn nat rule type.
type VpnNatRuleType string

const (
	// VpnNatRuleTypeDynamic ...
	VpnNatRuleTypeDynamic VpnNatRuleType = "Dynamic"
	// VpnNatRuleTypeStatic ...
	VpnNatRuleTypeStatic VpnNatRuleType = "Static"
)

// PossibleVpnNatRuleTypeValues returns an array of possible values for the VpnNatRuleType const type.
func PossibleVpnNatRuleTypeValues() []VpnNatRuleType {
	return []VpnNatRuleType{VpnNatRuleTypeDynamic, VpnNatRuleTypeStatic}
}

// VpnType enumerates the values for vpn type.
type VpnType string

const (
	// VpnTypePolicyBased ...
	VpnTypePolicyBased VpnType = "PolicyBased"
	// VpnTypeRouteBased ...
	VpnTypeRouteBased VpnType = "RouteBased"
)

// PossibleVpnTypeValues returns an array of possible values for the VpnType const type.
func PossibleVpnTypeValues() []VpnType {
	return []VpnType{VpnTypePolicyBased, VpnTypeRouteBased}
}

// WebApplicationFirewallAction enumerates the values for web application firewall action.
type WebApplicationFirewallAction string

const (
	// WebApplicationFirewallActionAllow ...
	WebApplicationFirewallActionAllow WebApplicationFirewallAction = "Allow"
	// WebApplicationFirewallActionBlock ...
	WebApplicationFirewallActionBlock WebApplicationFirewallAction = "Block"
	// WebApplicationFirewallActionLog ...
	WebApplicationFirewallActionLog WebApplicationFirewallAction = "Log"
)

// PossibleWebApplicationFirewallActionValues returns an array of possible values for the WebApplicationFirewallAction const type.
func PossibleWebApplicationFirewallActionValues() []WebApplicationFirewallAction {
	return []WebApplicationFirewallAction{WebApplicationFirewallActionAllow, WebApplicationFirewallActionBlock, WebApplicationFirewallActionLog}
}

// WebApplicationFirewallEnabledState enumerates the values for web application firewall enabled state.
type WebApplicationFirewallEnabledState string

const (
	// WebApplicationFirewallEnabledStateDisabled ...
	WebApplicationFirewallEnabledStateDisabled WebApplicationFirewallEnabledState = "Disabled"
	// WebApplicationFirewallEnabledStateEnabled ...
	WebApplicationFirewallEnabledStateEnabled WebApplicationFirewallEnabledState = "Enabled"
)

// PossibleWebApplicationFirewallEnabledStateValues returns an array of possible values for the WebApplicationFirewallEnabledState const type.
func PossibleWebApplicationFirewallEnabledStateValues() []WebApplicationFirewallEnabledState {
	return []WebApplicationFirewallEnabledState{WebApplicationFirewallEnabledStateDisabled, WebApplicationFirewallEnabledStateEnabled}
}

// WebApplicationFirewallMatchVariable enumerates the values for web application firewall match variable.
type WebApplicationFirewallMatchVariable string

const (
	// WebApplicationFirewallMatchVariablePostArgs ...
	WebApplicationFirewallMatchVariablePostArgs WebApplicationFirewallMatchVariable = "PostArgs"
	// WebApplicationFirewallMatchVariableQueryString ...
	WebApplicationFirewallMatchVariableQueryString WebApplicationFirewallMatchVariable = "QueryString"
	// WebApplicationFirewallMatchVariableRemoteAddr ...
	WebApplicationFirewallMatchVariableRemoteAddr WebApplicationFirewallMatchVariable = "RemoteAddr"
	// WebApplicationFirewallMatchVariableRequestBody ...
	WebApplicationFirewallMatchVariableRequestBody WebApplicationFirewallMatchVariable = "RequestBody"
	// WebApplicationFirewallMatchVariableRequestCookies ...
	WebApplicationFirewallMatchVariableRequestCookies WebApplicationFirewallMatchVariable = "RequestCookies"
	// WebApplicationFirewallMatchVariableRequestHeaders ...
	WebApplicationFirewallMatchVariableRequestHeaders WebApplicationFirewallMatchVariable = "RequestHeaders"
	// WebApplicationFirewallMatchVariableRequestMethod ...
	WebApplicationFirewallMatchVariableRequestMethod WebApplicationFirewallMatchVariable = "RequestMethod"
	// WebApplicationFirewallMatchVariableRequestURI ...
	WebApplicationFirewallMatchVariableRequestURI WebApplicationFirewallMatchVariable = "RequestUri"
)

// PossibleWebApplicationFirewallMatchVariableValues returns an array of possible values for the WebApplicationFirewallMatchVariable const type.
func PossibleWebApplicationFirewallMatchVariableValues() []WebApplicationFirewallMatchVariable {
	return []WebApplicationFirewallMatchVariable{WebApplicationFirewallMatchVariablePostArgs, WebApplicationFirewallMatchVariableQueryString, WebApplicationFirewallMatchVariableRemoteAddr, WebApplicationFirewallMatchVariableRequestBody, WebApplicationFirewallMatchVariableRequestCookies, WebApplicationFirewallMatchVariableRequestHeaders, WebApplicationFirewallMatchVariableRequestMethod, WebApplicationFirewallMatchVariableRequestURI}
}

// WebApplicationFirewallMode enumerates the values for web application firewall mode.
type WebApplicationFirewallMode string

const (
	// WebApplicationFirewallModeDetection ...
	WebApplicationFirewallModeDetection WebApplicationFirewallMode = "Detection"
	// WebApplicationFirewallModePrevention ...
	WebApplicationFirewallModePrevention WebApplicationFirewallMode = "Prevention"
)

// PossibleWebApplicationFirewallModeValues returns an array of possible values for the WebApplicationFirewallMode const type.
func PossibleWebApplicationFirewallModeValues() []WebApplicationFirewallMode {
	return []WebApplicationFirewallMode{WebApplicationFirewallModeDetection, WebApplicationFirewallModePrevention}
}

// WebApplicationFirewallOperator enumerates the values for web application firewall operator.
type WebApplicationFirewallOperator string

const (
	// WebApplicationFirewallOperatorBeginsWith ...
	WebApplicationFirewallOperatorBeginsWith WebApplicationFirewallOperator = "BeginsWith"
	// WebApplicationFirewallOperatorContains ...
	WebApplicationFirewallOperatorContains WebApplicationFirewallOperator = "Contains"
	// WebApplicationFirewallOperatorEndsWith ...
	WebApplicationFirewallOperatorEndsWith WebApplicationFirewallOperator = "EndsWith"
	// WebApplicationFirewallOperatorEqual ...
	WebApplicationFirewallOperatorEqual WebApplicationFirewallOperator = "Equal"
	// WebApplicationFirewallOperatorGeoMatch ...
	WebApplicationFirewallOperatorGeoMatch WebApplicationFirewallOperator = "GeoMatch"
	// WebApplicationFirewallOperatorGreaterThan ...
	WebApplicationFirewallOperatorGreaterThan WebApplicationFirewallOperator = "GreaterThan"
	// WebApplicationFirewallOperatorGreaterThanOrEqual ...
	WebApplicationFirewallOperatorGreaterThanOrEqual WebApplicationFirewallOperator = "GreaterThanOrEqual"
	// WebApplicationFirewallOperatorIPMatch ...
	WebApplicationFirewallOperatorIPMatch WebApplicationFirewallOperator = "IPMatch"
	// WebApplicationFirewallOperatorLessThan ...
	WebApplicationFirewallOperatorLessThan WebApplicationFirewallOperator = "LessThan"
	// WebApplicationFirewallOperatorLessThanOrEqual ...
	WebApplicationFirewallOperatorLessThanOrEqual WebApplicationFirewallOperator = "LessThanOrEqual"
	// WebApplicationFirewallOperatorRegex ...
	WebApplicationFirewallOperatorRegex WebApplicationFirewallOperator = "Regex"
)

// PossibleWebApplicationFirewallOperatorValues returns an array of possible values for the WebApplicationFirewallOperator const type.
func PossibleWebApplicationFirewallOperatorValues() []WebApplicationFirewallOperator {
	return []WebApplicationFirewallOperator{WebApplicationFirewallOperatorBeginsWith, WebApplicationFirewallOperatorContains, WebApplicationFirewallOperatorEndsWith, WebApplicationFirewallOperatorEqual, WebApplicationFirewallOperatorGeoMatch, WebApplicationFirewallOperatorGreaterThan, WebApplicationFirewallOperatorGreaterThanOrEqual, WebApplicationFirewallOperatorIPMatch, WebApplicationFirewallOperatorLessThan, WebApplicationFirewallOperatorLessThanOrEqual, WebApplicationFirewallOperatorRegex}
}

// WebApplicationFirewallPolicyResourceState enumerates the values for web application firewall policy resource
// state.
type WebApplicationFirewallPolicyResourceState string

const (
	// WebApplicationFirewallPolicyResourceStateCreating ...
	WebApplicationFirewallPolicyResourceStateCreating WebApplicationFirewallPolicyResourceState = "Creating"
	// WebApplicationFirewallPolicyResourceStateDeleting ...
	WebApplicationFirewallPolicyResourceStateDeleting WebApplicationFirewallPolicyResourceState = "Deleting"
	// WebApplicationFirewallPolicyResourceStateDisabled ...
	WebApplicationFirewallPolicyResourceStateDisabled WebApplicationFirewallPolicyResourceState = "Disabled"
	// WebApplicationFirewallPolicyResourceStateDisabling ...
	WebApplicationFirewallPolicyResourceStateDisabling WebApplicationFirewallPolicyResourceState = "Disabling"
	// WebApplicationFirewallPolicyResourceStateEnabled ...
	WebApplicationFirewallPolicyResourceStateEnabled WebApplicationFirewallPolicyResourceState = "Enabled"
	// WebApplicationFirewallPolicyResourceStateEnabling ...
	WebApplicationFirewallPolicyResourceStateEnabling WebApplicationFirewallPolicyResourceState = "Enabling"
)

// PossibleWebApplicationFirewallPolicyResourceStateValues returns an array of possible values for the WebApplicationFirewallPolicyResourceState const type.
func PossibleWebApplicationFirewallPolicyResourceStateValues() []WebApplicationFirewallPolicyResourceState {
	return []WebApplicationFirewallPolicyResourceState{WebApplicationFirewallPolicyResourceStateCreating, WebApplicationFirewallPolicyResourceStateDeleting, WebApplicationFirewallPolicyResourceStateDisabled, WebApplicationFirewallPolicyResourceStateDisabling, WebApplicationFirewallPolicyResourceStateEnabled, WebApplicationFirewallPolicyResourceStateEnabling}
}

// WebApplicationFirewallRuleType enumerates the values for web application firewall rule type.
type WebApplicationFirewallRuleType string

const (
	// WebApplicationFirewallRuleTypeInvalid ...
	WebApplicationFirewallRuleTypeInvalid WebApplicationFirewallRuleType = "Invalid"
	// WebApplicationFirewallRuleTypeMatchRule ...
	WebApplicationFirewallRuleTypeMatchRule WebApplicationFirewallRuleType = "MatchRule"
)

// PossibleWebApplicationFirewallRuleTypeValues returns an array of possible values for the WebApplicationFirewallRuleType const type.
func PossibleWebApplicationFirewallRuleTypeValues() []WebApplicationFirewallRuleType {
	return []WebApplicationFirewallRuleType{WebApplicationFirewallRuleTypeInvalid, WebApplicationFirewallRuleTypeMatchRule}
}

// WebApplicationFirewallTransform enumerates the values for web application firewall transform.
type WebApplicationFirewallTransform string

const (
	// WebApplicationFirewallTransformHTMLEntityDecode ...
	WebApplicationFirewallTransformHTMLEntityDecode WebApplicationFirewallTransform = "HtmlEntityDecode"
	// WebApplicationFirewallTransformLowercase ...
	WebApplicationFirewallTransformLowercase WebApplicationFirewallTransform = "Lowercase"
	// WebApplicationFirewallTransformRemoveNulls ...
	WebApplicationFirewallTransformRemoveNulls WebApplicationFirewallTransform = "RemoveNulls"
	// WebApplicationFirewallTransformTrim ...
	WebApplicationFirewallTransformTrim WebApplicationFirewallTransform = "Trim"
	// WebApplicationFirewallTransformURLDecode ...
	WebApplicationFirewallTransformURLDecode WebApplicationFirewallTransform = "UrlDecode"
	// WebApplicationFirewallTransformURLEncode ...
	WebApplicationFirewallTransformURLEncode WebApplicationFirewallTransform = "UrlEncode"
)

// PossibleWebApplicationFirewallTransformValues returns an array of possible values for the WebApplicationFirewallTransform const type.
func PossibleWebApplicationFirewallTransformValues() []WebApplicationFirewallTransform {
	return []WebApplicationFirewallTransform{WebApplicationFirewallTransformHTMLEntityDecode, WebApplicationFirewallTransformLowercase, WebApplicationFirewallTransformRemoveNulls, WebApplicationFirewallTransformTrim, WebApplicationFirewallTransformURLDecode, WebApplicationFirewallTransformURLEncode}
}
