package documentdb

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// RestorableGremlinGraphsClient is the client for the RestorableGremlinGraphs methods of the Documentdb service.
type RestorableGremlinGraphsClient struct {
	BaseClient
}

// NewRestorableGremlinGraphsClient creates an instance of the RestorableGremlinGraphsClient client.
func NewRestorableGremlinGraphsClient(subscriptionID string) RestorableGremlinGraphsClient {
	return NewRestorableGremlinGraphsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewRestorableGremlinGraphsClientWithBaseURI creates an instance of the RestorableGremlinGraphsClient client using a
// custom endpoint.  Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds,
// Azure stack).
func NewRestorableGremlinGraphsClientWithBaseURI(baseURI string, subscriptionID string) RestorableGremlinGraphsClient {
	return RestorableGremlinGraphsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// List show the event feed of all mutations done on all the Azure Cosmos DB Gremlin graphs under a specific database.
// This helps in scenario where container was accidentally deleted. This API requires
// 'Microsoft.DocumentDB/locations/restorableDatabaseAccounts/.../read' permission
// Parameters:
// location - cosmos DB region, with spaces between words and each word capitalized.
// instanceID - the instanceId GUID of a restorable database account.
// restorableGremlinDatabaseRid - the resource ID of the Gremlin database.
// startTime - restorable Gremlin graphs event feed start time.
// endTime - restorable Gremlin graphs event feed end time.
func (client RestorableGremlinGraphsClient) List(ctx context.Context, location string, instanceID string, restorableGremlinDatabaseRid string, startTime string, endTime string) (result RestorableGremlinGraphsListResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RestorableGremlinGraphsClient.List")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("documentdb.RestorableGremlinGraphsClient", "List", err.Error())
	}

	req, err := client.ListPreparer(ctx, location, instanceID, restorableGremlinDatabaseRid, startTime, endTime)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.RestorableGremlinGraphsClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "documentdb.RestorableGremlinGraphsClient", "List", resp, "Failure sending request")
		return
	}

	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.RestorableGremlinGraphsClient", "List", resp, "Failure responding to request")
		return
	}

	return
}

// ListPreparer prepares the List request.
func (client RestorableGremlinGraphsClient) ListPreparer(ctx context.Context, location string, instanceID string, restorableGremlinDatabaseRid string, startTime string, endTime string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instanceId":     autorest.Encode("path", instanceID),
		"location":       autorest.Encode("path", location),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-11-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(restorableGremlinDatabaseRid) > 0 {
		queryParameters["restorableGremlinDatabaseRid"] = autorest.Encode("query", restorableGremlinDatabaseRid)
	}
	if len(startTime) > 0 {
		queryParameters["startTime"] = autorest.Encode("query", startTime)
	}
	if len(endTime) > 0 {
		queryParameters["endTime"] = autorest.Encode("query", endTime)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.DocumentDB/locations/{location}/restorableDatabaseAccounts/{instanceId}/restorableGraphs", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client RestorableGremlinGraphsClient) ListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client RestorableGremlinGraphsClient) ListResponder(resp *http.Response) (result RestorableGremlinGraphsListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
