local n = require('test.functional.testnvim')()
local Screen = require('test.functional.ui.screen')

local clear = n.clear
local command = n.command
local exec = n.exec
local feed = n.feed

describe("'number' and 'relativenumber'", function()
  before_each(clear)

  -- oldtest: Test_relativenumber_colors()
  it('LineNr, LineNrAbove and LineNrBelow', function()
    local screen = Screen.new(50, 10)
    screen:add_extra_attr_ids {
      [100] = { foreground = Screen.colors.WebGreen },
    }
    exec([[
      call setline(1, range(200))
      111
      set number relativenumber
      hi LineNr guifg=red
    ]])
    screen:expect([[
      {19:  4 }106                                           |
      {19:  3 }107                                           |
      {19:  2 }108                                           |
      {19:  1 }109                                           |
      {19:111 }^110                                           |
      {19:  1 }111                                           |
      {19:  2 }112                                           |
      {19:  3 }113                                           |
      {19:  4 }114                                           |
                                                        |
    ]])
    command('hi LineNrAbove guifg=blue')
    screen:expect([[
      {18:  4 }106                                           |
      {18:  3 }107                                           |
      {18:  2 }108                                           |
      {18:  1 }109                                           |
      {19:111 }^110                                           |
      {19:  1 }111                                           |
      {19:  2 }112                                           |
      {19:  3 }113                                           |
      {19:  4 }114                                           |
                                                        |
    ]])
    command('hi LineNrBelow guifg=green')
    screen:expect([[
      {18:  4 }106                                           |
      {18:  3 }107                                           |
      {18:  2 }108                                           |
      {18:  1 }109                                           |
      {19:111 }^110                                           |
      {100:  1 }111                                           |
      {100:  2 }112                                           |
      {100:  3 }113                                           |
      {100:  4 }114                                           |
                                                        |
    ]])
    command('hi clear LineNrAbove')
    screen:expect([[
      {19:  4 }106                                           |
      {19:  3 }107                                           |
      {19:  2 }108                                           |
      {19:  1 }109                                           |
      {19:111 }^110                                           |
      {100:  1 }111                                           |
      {100:  2 }112                                           |
      {100:  3 }113                                           |
      {100:  4 }114                                           |
                                                        |
    ]])
  end)

  -- oldtest: Test_relativenumber_colors_wrapped()
  it('LineNr, LineNrAbove and LineNrBelow with wrapped lines', function()
    local screen = Screen.new(50, 20)
    screen:add_extra_attr_ids {
      [100] = { foreground = Screen.colors.Gray0, background = Screen.colors.Red },
      [101] = { foreground = Screen.colors.Gray0, background = Screen.colors.Blue1 },
      [102] = { foreground = Screen.colors.Gray0, background = Screen.colors.WebGreen },
    }
    exec([[
      set display=lastline scrolloff=0
      call setline(1, range(200)->map('v:val->string()->repeat(40)'))
      111
      set number relativenumber
      hi LineNr guibg=red guifg=black
      hi LineNrAbove guibg=blue guifg=black
      hi LineNrBelow guibg=green guifg=black
    ]])
    screen:expect([[
      {101:  2 }1081081081081081081081081081081081081081081081|
      {101:    }0810810810810810810810810810810810810810810810|
      {101:    }8108108108108108108108108108                  |
      {101:  1 }1091091091091091091091091091091091091091091091|
      {101:    }0910910910910910910910910910910910910910910910|
      {101:    }9109109109109109109109109109                  |
      {100:111 }^1101101101101101101101101101101101101101101101|
      {100:    }1011011011011011011011011011011011011011011011|
      {100:    }0110110110110110110110110110                  |
      {102:  1 }1111111111111111111111111111111111111111111111|
      {102:    }1111111111111111111111111111111111111111111111|
      {102:    }1111111111111111111111111111                  |
      {102:  2 }1121121121121121121121121121121121121121121121|
      {102:    }1211211211211211211211211211211211211211211211|
      {102:    }2112112112112112112112112112                  |
      {102:  3 }1131131131131131131131131131131131131131131131|
      {102:    }1311311311311311311311311311311311311311311311|
      {102:    }3113113113113113113113113113                  |
      {102:  4 }1141141141141141141141141141141141141141141{1:@@@}|
                                                        |
    ]])
    feed('k')
    screen:expect([[
      {101:  1 }1081081081081081081081081081081081081081081081|
      {101:    }0810810810810810810810810810810810810810810810|
      {101:    }8108108108108108108108108108                  |
      {100:110 }^1091091091091091091091091091091091091091091091|
      {100:    }0910910910910910910910910910910910910910910910|
      {100:    }9109109109109109109109109109                  |
      {102:  1 }1101101101101101101101101101101101101101101101|
      {102:    }1011011011011011011011011011011011011011011011|
      {102:    }0110110110110110110110110110                  |
      {102:  2 }1111111111111111111111111111111111111111111111|
      {102:    }1111111111111111111111111111111111111111111111|
      {102:    }1111111111111111111111111111                  |
      {102:  3 }1121121121121121121121121121121121121121121121|
      {102:    }1211211211211211211211211211211211211211211211|
      {102:    }2112112112112112112112112112                  |
      {102:  4 }1131131131131131131131131131131131131131131131|
      {102:    }1311311311311311311311311311311311311311311311|
      {102:    }3113113113113113113113113113                  |
      {102:  5 }1141141141141141141141141141141141141141141{1:@@@}|
                                                        |
    ]])
    feed('2j')
    screen:expect([[
      {101:  3 }1081081081081081081081081081081081081081081081|
      {101:    }0810810810810810810810810810810810810810810810|
      {101:    }8108108108108108108108108108                  |
      {101:  2 }1091091091091091091091091091091091091091091091|
      {101:    }0910910910910910910910910910910910910910910910|
      {101:    }9109109109109109109109109109                  |
      {101:  1 }1101101101101101101101101101101101101101101101|
      {101:    }1011011011011011011011011011011011011011011011|
      {101:    }0110110110110110110110110110                  |
      {100:112 }^1111111111111111111111111111111111111111111111|
      {100:    }1111111111111111111111111111111111111111111111|
      {100:    }1111111111111111111111111111                  |
      {102:  1 }1121121121121121121121121121121121121121121121|
      {102:    }1211211211211211211211211211211211211211211211|
      {102:    }2112112112112112112112112112                  |
      {102:  2 }1131131131131131131131131131131131131131131131|
      {102:    }1311311311311311311311311311311311311311311311|
      {102:    }3113113113113113113113113113                  |
      {102:  3 }1141141141141141141141141141141141141141141{1:@@@}|
                                                        |
    ]])
    feed('2j')
    screen:expect([[
      {101:  5 }1081081081081081081081081081081081081081081081|
      {101:    }0810810810810810810810810810810810810810810810|
      {101:    }8108108108108108108108108108                  |
      {101:  4 }1091091091091091091091091091091091091091091091|
      {101:    }0910910910910910910910910910910910910910910910|
      {101:    }9109109109109109109109109109                  |
      {101:  3 }1101101101101101101101101101101101101101101101|
      {101:    }1011011011011011011011011011011011011011011011|
      {101:    }0110110110110110110110110110                  |
      {101:  2 }1111111111111111111111111111111111111111111111|
      {101:    }1111111111111111111111111111111111111111111111|
      {101:    }1111111111111111111111111111                  |
      {101:  1 }1121121121121121121121121121121121121121121121|
      {101:    }1211211211211211211211211211211211211211211211|
      {101:    }2112112112112112112112112112                  |
      {100:114 }^1131131131131131131131131131131131131131131131|
      {100:    }1311311311311311311311311311311311311311311311|
      {100:    }3113113113113113113113113113                  |
      {102:  1 }1141141141141141141141141141141141141141141{1:@@@}|
                                                        |
    ]])
    feed('k')
    screen:expect([[
      {101:  4 }1081081081081081081081081081081081081081081081|
      {101:    }0810810810810810810810810810810810810810810810|
      {101:    }8108108108108108108108108108                  |
      {101:  3 }1091091091091091091091091091091091091091091091|
      {101:    }0910910910910910910910910910910910910910910910|
      {101:    }9109109109109109109109109109                  |
      {101:  2 }1101101101101101101101101101101101101101101101|
      {101:    }1011011011011011011011011011011011011011011011|
      {101:    }0110110110110110110110110110                  |
      {101:  1 }1111111111111111111111111111111111111111111111|
      {101:    }1111111111111111111111111111111111111111111111|
      {101:    }1111111111111111111111111111                  |
      {100:113 }^1121121121121121121121121121121121121121121121|
      {100:    }1211211211211211211211211211211211211211211211|
      {100:    }2112112112112112112112112112                  |
      {102:  1 }1131131131131131131131131131131131131131131131|
      {102:    }1311311311311311311311311311311311311311311311|
      {102:    }3113113113113113113113113113                  |
      {102:  2 }1141141141141141141141141141141141141141141{1:@@@}|
                                                        |
    ]])
  end)

  -- oldtest: Test_relativenumber_callback()
  it('relative line numbers are updated if cursor is moved from timer', function()
    local screen = Screen.new(50, 8)
    exec([[
      call setline(1, ['aaaaa', 'bbbbb', 'ccccc', 'ddddd'])
      set relativenumber
      call cursor(4, 1)

      func Func(timer)
        call cursor(1, 1)
      endfunc
    ]])
    screen:expect([[
      {8:  3 }aaaaa                                         |
      {8:  2 }bbbbb                                         |
      {8:  1 }ccccc                                         |
      {8:  0 }^ddddd                                         |
      {1:~                                                 }|*3
                                                        |
    ]])
    command([[call timer_start(300, 'Func')]])
    screen:expect_unchanged(false, 100)
    screen:expect([[
      {8:  0 }^aaaaa                                         |
      {8:  1 }bbbbb                                         |
      {8:  2 }ccccc                                         |
      {8:  3 }ddddd                                         |
      {1:~                                                 }|*3
                                                        |
    ]])
  end)

  -- oldtest: Test_number_insert_delete_lines()
  it('line numbers are updated when deleting/inserting lines', function()
    local screen = Screen.new(50, 8)
    exec([[
      call setline(1, range(1, 7))
      set number
      call cursor(2, 1)
    ]])
    local snapshot1 = [[
      {8:  1 }1                                             |
      {8:  2 }^2                                             |
      {8:  3 }3                                             |
      {8:  4 }4                                             |
      {8:  5 }5                                             |
      {8:  6 }6                                             |
      {8:  7 }7                                             |
                                                        |
    ]]
    screen:expect(snapshot1)
    feed('dd')
    screen:expect([[
      {8:  1 }1                                             |
      {8:  2 }^3                                             |
      {8:  3 }4                                             |
      {8:  4 }5                                             |
      {8:  5 }6                                             |
      {8:  6 }7                                             |
      {1:~                                                 }|
                                                        |
    ]])
    feed('P')
    screen:expect(snapshot1)
    feed('2dd')
    screen:expect([[
      {8:  1 }1                                             |
      {8:  2 }^4                                             |
      {8:  3 }5                                             |
      {8:  4 }6                                             |
      {8:  5 }7                                             |
      {1:~                                                 }|*2
                                                        |
    ]])
    feed('P')
    screen:expect(snapshot1)
  end)
end)
