from doxygen_autodoc_docstring import *
import inspect
import string
import os
import sys
import comment_verifier

# documentation from autogenerated 'feature:autodoc'
comment_verifier.check(inspect.getdoc(ClassWithoutDoxygenComment),
    "::ClassWithoutDoxygenComment" if is_python_builtin() else "Proxy of C++ ClassWithoutDoxygenComment class.")
comment_verifier.check(inspect.getdoc(functionWithoutDoxygenComment),
    "functionWithoutDoxygenComment(int number)")

# documentation from doxygen comments
comment_verifier.check(inspect.getdoc(ClassWithDoxygenComment),
    "Class doxygen comment")
comment_verifier.check(inspect.getdoc(functionWithDoxygenComment),
    "Function doxygen comment")

# documentation from 'feature:docstring'
comment_verifier.check(inspect.getdoc(ClassWithDocString),
    "Class doc from docstring")
comment_verifier.check(inspect.getdoc(functionWithDocString),
    "functionWithDocString(int number)\n"
    "Function doc from docstring")

# documentation from 'feature:docstring' + autodoc (overriding doxycomment)
comment_verifier.check(inspect.getdoc(ClassWithDocStringAndDoxygenComment),
    "Class doc from docstring overriding doxycomment")
comment_verifier.check(inspect.getdoc(functionWithDocStringAndDoxygenComment),
    "functionWithDocStringAndDoxygenComment(int number)\n"
    "Function doc from docstring overriding doxycomment")

# documentation from 'feature:docstring' (overriding doxycomment)
comment_verifier.check(inspect.getdoc(ClassWithDocStringAndDoxygenCommentNoAutodoc),
    "Class doc from docstring overriding doxycomment (no autodoc)")
comment_verifier.check(inspect.getdoc(functionWithDocStringAndDoxygenCommentNoAutodoc),
    "Function doc from docstring overriding doxycomment (no autodoc)")

# documentation from doxygen comments (2) no autodoc feature present
comment_verifier.check(inspect.getdoc(ClassWithDoxygenComment2),
    "Class doxygen comment 2")
comment_verifier.check(inspect.getdoc(functionWithDoxygenComment2),
    "Function doxygen comment 2")
