#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Mopi
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Pokemon Insurgence
# send your bug reports to contact@dotslashplay.it
###

script_version=20230425.1

GAME_ID='pokemon-insurgence'
GAME_NAME='Pokemon Insurgence'

ARCHIVE_BASE_0='Pokemon Insurgence 1.2.5 Core.zip'
ARCHIVE_BASE_0_MD5='d992c31fe67ffc0a72c4274caaa4a977'
ARCHIVE_BASE_0_SIZE='840000'
ARCHIVE_BASE_0_VERSION='1.2.5-insurgence1'
ARCHIVE_BASE_0_URL='https://p-insurgence.com/'

CONTENT_PATH_DEFAULT='Pokemon Insurgence 1.2.5 Core'
CONTENT_GAME_BIN_FILES='
Game.exe
Game.ini
*.dll'
CONTENT_GAME_DATA_FILES='
Audio
Data
Egglocke
Eggs
Fonts
Graphics
Game.rgssad'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/Saved Games/Pokemon Insurgence'

APP_MAIN_EXE='Game.exe'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN_DEPENDENCIES_GSTREAMER_PLUGINS='
audio/mpeg, mpegversion=(int)1, layer=(int)3'

# Ensure availability of fonts expected by the game engine

APP_WINETRICKS="$APP_WINETRICKS arial"

# Load common functions

target_version='2.23'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game icons

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build packages

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
