/* SPDX-License-Identifier: GPL-2.0-only */

#include <memlayout.h>
#include <arch/header.ld>
#include <mainboard/addressmap.h>

SECTIONS
{
	REGION(flash, QEMU_VIRT_FLASH, CONFIG_ROM_SIZE, 0) \

	DRAM_START(QEMU_VIRT_DRAM)
	BOOTBLOCK(QEMU_VIRT_DRAM, 128K)
	OPENSBI(QEMU_VIRT_DRAM + 128K, 256K)
	ROMSTAGE(QEMU_VIRT_DRAM + 128K + 256K, 256K)
	RAMSTAGE(QEMU_VIRT_DRAM + 128K + 256K + 256K, 2M)
	PRERAM_CBMEM_CONSOLE(QEMU_VIRT_DRAM + 128K + 256K + 256K + 2M,  8K)
	FMAP_CACHE(QEMU_VIRT_DRAM + 128K + 256K + 256K + 2M + 8K,  2K)
	CBFS_MCACHE(QEMU_VIRT_DRAM + 128K + 256K + 256K + 2M + 8K + 2K,  10K)
	STACK(QEMU_VIRT_DRAM + 128K + 256K + 256K + 2M + 8K + 2K + 10K, 4M)
}
