/* SPDX-License-Identifier: GPL-2.0-only OR MIT */

#ifndef __SOC_MEDIATEK_MT8196_INCLUDE_SOC_SRCLKEN_RC_H__
#define __SOC_MEDIATEK_MT8196_INCLUDE_SOC_SRCLKEN_RC_H__

/* Channel id: Update this enum for porting */
enum chn_id {
	CHN_SUSPEND = 0,
	CHN_MD1,
	CHN_MD2,
	CHN_MD3,
	CHN_MDRF,
	CHN_MMWAVE,
	CHN_GPS,
	CHN_PCIE_CONN1,
	CHN_VCORE,
	CHN_CONN_MCU,
	CHN_COANT,
	CHN_NFC_CONN2,
	CHN_SUSPEND2,
	CHN_UFS_VREQ,
	CHN_DCXO_L,
	CHN_DCXO_H,
	CHN_UFS_2,
	CHN_PCIE_2,
	CHN_NFC_2,
	CHN_EXT1,
	CHN_EXT2,
	CHN_EXT3,
	CHN_T900,
	CHN_RSV1,
	CHN_RSV2,
	CHN_RSV3,
	CHN_RSV4,
	CHN_RSV5,
	CHN_RSV6,
	CHN_RSV7,
	CHN_RSV8,
	CHN_RSV9,
	MAX_CHN_NUM,
};

struct mtk_rc_regs {
	u32 srclken_rc_cfg;
	u32 rc_central_cfg1;
	u32 rc_central_cfg2;
	u32 rc_cmd_arb_cfg;
	u32 rc_pmic_rcen_addr;
	u32 rc_pmic_rcen_set_clr_addr;
	u32 rc_dcxo_fpm_cfg;
	u32 rc_central_cfg3;
	u32 reserved1[14];
	u32 srclken_sw_con_cfg;
	u32 rc_central_cfg4;
	u32 reserved2;
	u32 rc_debug_cfg;
	u32 reserved3;
	u32 reserved4;
	u32 rc_central_cfg5;
	u32 rc_central_cfg6;
	u32 rcen_mt_m_cfg_0;
	u32 rcen_mt_m_cfg_1;
	u32 rcen_mt_p_cfg_0;
	u32 rcen_mt_p_cfg_1;
	u32 rcen_mt_cfg_0;
	u32 reserved5[32];
	u32 rc_spi_sta_0;
	u32 rc_pi_po_sta;
	u32 reserved6[139];
	u32 central_cfg4_1;
	u32 central_cfg6_1;
	u32 central_cfg6_2;
	u32 reserved7[39];
	u32 subsys_intf_cfg_fpm;
	u32 reserved8[5];
	u32 src_pmrc_starter_bypass_cfg;
	u32 src_pmrc_starter_disable_cfg;
	u32 src_pmrc_multi_master_cfg;
	u32 src_pmrc_starter_mask_cfg;
	u32 src_pmrc_starter_turn_on_cnt_size;
	u32 src_pmrc_starter_turn_off_cnt_size;
	u32 reserved9[58];
	u32 rc_mxx_srclken_cfg[MAX_CHN_NUM];
	u32 rc_mxx_req_sta_0[MAX_CHN_NUM];
};

check_member(mtk_rc_regs, rc_spi_sta_0, 0x10c);

DEFINE_BIT(SW_RESET, 0)
DEFINE_BITFIELD(CG_32K_EN, 3, 1)
DEFINE_BIT(CG_FCLK_EN, 2)
DEFINE_BIT(CG_FCLK_FR_EN, 3)
DEFINE_BIT(MUX_FCLK_FR, 4)
DEFINE_BIT(RC_32K_DCM, 8)
DEFINE_BIT(SRCLKEN_RC_EN, 0)
DEFINE_BIT(RCEN_ISSUE_M, 1)
DEFINE_BIT(RC_SPI_ACTIVE, 2)
DEFINE_BIT(SRCLKEN_RC_EN_SEL, 3)
DEFINE_BITFIELD(VCORE_SETTLE_T, 7, 5)
DEFINE_BITFIELD(ULPOSC_SETTLE_T, 11, 8)
DEFINE_BITFIELD(NON_DCXO_SETTLE_T, 21, 12)
DEFINE_BITFIELD(DCXO_SETTLE_T, 31, 22)
DEFINE_BITFIELD(SRCVOLTEN_CTRL, 3, 0)
DEFINE_BITFIELD(VREQ_CTRL, 7, 4)
DEFINE_BIT(SRCVOLTEN_VREQ_SEL, 8)
DEFINE_BIT(SRCVOLTEN_VREQ_M, 9)
DEFINE_BIT(FORCE_SRCVOLTEN_OFF, 10)
DEFINE_BIT(FORCE_SRCVOLTEN_ON, 11)
DEFINE_BITFIELD(ULPOSC_CTRL_M, 15, 12)
DEFINE_BIT(FORCE_VCORE_RDY, 16)
DEFINE_BIT(FORCE_ULPOSC2ON, 17)
DEFINE_BIT(FORCE_ULPOSC_CLK_EN, 18)
DEFINE_BIT(FORCE_ULPOSC_ON, 19)
DEFINE_BIT(DIS_ULPOSC_RDY_CHK, 20)
DEFINE_BIT(PWRAP_SLP_CTRL_M, 21)
DEFINE_BIT(PWRAP_SLP_MUX_SEL, 25)
DEFINE_BIT(FORCE_PWRAP_ON, 26)
DEFINE_BIT(FORCE_PWRAP_AWK, 27)
DEFINE_BIT(NON_DCXO_REQ_FORCEON, 28)
DEFINE_BIT(NON_DCXO_REQ_FORCEOFF, 29)
DEFINE_BIT(DCXO_REQ_FORCEON, 30)
DEFINE_BIT(DCXO_REQ_FORCEOFF, 31)

DEFINE_BITFIELD(SW_RC_EN, 12, 0)
DEFINE_BITFIELD(SW_RCEN_EN, 25, 13)
DEFINE_BIT(SW_DCXO_M_EN, 28)
DEFINE_BITFIELD(SW_DCXO_M, 31, 29)

DEFINE_BITFIELD(DCXO_FPM_CTRL_M, 3, 0)
DEFINE_BIT(SRCVOLTEN_FPM_MSK_B, 4)
DEFINE_BITFIELD(SUB_SRCLKEN_FPM_MSK_B, 28, 16)

DEFINE_BIT(TO_LPM_SETTLE_EN, 0)
DEFINE_BIT(BLK_SCP_DXCO_MD_TARGET, 1)
DEFINE_BIT(BLK_COANT_DXCO_MD_TARGET, 2)
DEFINE_BIT(TO_BBLPM_SETTLE_EN, 3)
DEFINE_BIT(TO_BBLPM_SETTLE_ND_EN, 4)
DEFINE_BITFIELD(TO_LPM_SETTLE_T, 21, 12)

DEFINE_BIT(DCXO_SETTLE_BLK_EN, 1)
DEFINE_BIT(BYPASS_CMD_EN, 2)
DEFINE_BIT(SW_SRCLKEN_RC, 3)
DEFINE_BIT(SW_SRCLKEN_FPM, 4)
DEFINE_BIT(SW_SRCLKEN_BBLPM, 5)
DEFINE_BIT(XO_SOC_LINKAGE_EN, 6)
DEFINE_BIT(REQ_ACK_LOW_IMD_EN, 7)
DEFINE_BIT(SRCLKEN_TRACK_M_EN, 8)
DEFINE_BITFIELD(CNT_PRD_STEP, 11, 10)
DEFINE_BITFIELD(XO_STABLE_PRD, 21, 12)
DEFINE_BITFIELD(DCXO_STABLE_PRD, 31, 22)

DEFINE_BIT(TACE_EN, 0)
DEFINE_BITFIELD(TIE_SYS_RDY, 4, 1)

DEFINE_BITFIELD(KEEP_RC_SPI_ACTIVE, 12, 0)
DEFINE_BIT(PWRAP_VLD_FORCE, 16)
DEFINE_BIT(SLEEP_VLD_MODE, 17)
DEFINE_BIT(SCP_SLEEP_REQ_MODE, 18)
DEFINE_BIT(SLEEP_REQ_MODE, 20)
DEFINE_BIT(BYPASS_PMIF_M, 24)
DEFINE_BIT(BYPASS_PMIF_P, 25)

DEFINE_BIT(TRACE_MODE_EN, 24)
DEFINE_BIT(DBG_STOP_PROT_EN, 28)

DEFINE_BIT(SPMI_CMD_BYTE_CNT, 0)
DEFINE_BITFIELD(SPMI_M_SLV_ID, 8, 5)
DEFINE_BITFIELD(SPMI_P_SLV_ID, 12, 9)
DEFINE_BIT(SPMI_M_PMIF_ID, 17)
DEFINE_BIT(SPMI_P_PMIF_ID, 18)
DEFINE_BITFIELD(SPMI_M_CMD_TYPE, 21, 19)
DEFINE_BITFIELD(SPMI_P_CMD_TYPE, 22, 21)
DEFINE_BIT(SPMI_M_WRITE_EN, 23)
DEFINE_BIT(SPMI_P_WRITE_EN, 24)
DEFINE_BIT(BROADCAST_MODE_EN, 25)
DEFINE_BIT(MULTI_CMD_MODE_EN, 26)
DEFINE_BIT(DCXO_ENCODE, 27)
DEFINE_BIT(SPMI_M_FIRST, 28)
DEFINE_BIT(SPMI_BYTE_NUM, 29)
DEFINE_BITFIELD(REQ_TO_DCXO_MASK, 15, 0)
DEFINE_BITFIELD(PMIC_M_COUNTER_VAL, 3, 0)
DEFINE_BITFIELD(PMIC_P_COUNTER_VAL, 7, 4)
DEFINE_BITFIELD(SRCLKEN_FPM_MASK_B, 13, 0)
DEFINE_BITFIELD(SRCLKEN_BBLPM_MASK_B, 29, 16)
DEFINE_BIT(FPM_ACK, 1)
DEFINE_BIT(BBLPM_ACK, 3)
DEFINE_BITFIELD(BYPASS_DCXO_VOTE_H, 31, 16)
DEFINE_BITFIELD(BYPASS_DCXO_VOTE_L, 15, 0)

enum {
	SW_SRCLKEN_FPM_MSK = 0x1,
	SW_SRCLKEN_BBLPM_MSK = 0x1,
};

/* RC_CENTRAL_CFG2[8] */
#define SRCLKENAO_MODE			0
#define VREQ_MODE			1

/* RC_CENTRAL_CFG2[25] */
#define RC_32K				0
#define RC_ULPOSC1			1

/* Signal Control Mode */
#define MERGE_OR_MODE			0x0
#define BYPASS_MODE			0x1
#define MERGE_AND_MODE			BIT(1)
#define BYPASS_RC_MODE			(0x2 << 1)
#define BYPASS_OR_MODE			0x3
#define BYPASS_OTHER_MODE		(0x3 << 1)
#define ASYNC_MODE			BIT(3)

#define NO_REQ				0
#define FPM_REQ				BIT(4)
#define BBLPM_REQ			BIT(5)

enum rc_ctrl_m {
	HW_MODE = 0,
	SW_MODE = 1,
};

enum {
	SRLCKEN_RC_BRINGUP = 0,
	SRCLKEN_RC_DISABLE,
	SRCLKEN_RC_ENABLE,
	SRCLKEN_RC_SKIP,
};

struct subsys_rc_con {
	u32 dcxo_prd;
	u32 xo_prd;
	u32 cnt_step;
	u32 track_en;
	u32 req_ack_imd_en;
	u32 xo_soc_link_en;
	u32 sw_bblpm;
	u32 sw_fpm;
	u32 sw_rc;
	u32 bypass_cmd;
	u32 dcxo_settle_blk_en;
};

int srclken_rc_init(void);

#endif
