/** @file

Copyright (c) 2024, Intel Corporation. All rights reserved.<BR>

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above copyright notice, this
  list of conditions and the following disclaimer in the documentation and/or
  other materials provided with the distribution.
* Neither the name of Intel Corporation nor the names of its contributors may
  be used to endorse or promote products derived from this software without
  specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
  THE POSSIBILITY OF SUCH DAMAGE.

  This file is automatically generated. Please do NOT modify !!!

**/

#ifndef __FSPSUPD_H__
#define __FSPSUPD_H__

#include <FspUpd.h>

#pragma pack(1)


///
/// Azalia Header structure
///
typedef struct {
  UINT16 VendorId;           ///< Codec Vendor ID
  UINT16 DeviceId;           ///< Codec Device ID
  UINT8  RevisionId;         ///< Revision ID of the codec. 0xFF matches any revision.
  UINT8  SdiNum;             ///< SDI number, 0xFF matches any SDI.
  UINT16 DataDwords;         ///< Number of data DWORDs pointed by the codec data buffer.
  UINT32 Reserved;           ///< Reserved for future use. Must be set to 0.
} AZALIA_HEADER;

///
/// Audio Azalia Verb Table structure
///
typedef struct {
  AZALIA_HEADER Header;      ///< AZALIA PCH header
  UINT32        *Data;       ///< Pointer to the data buffer. Its length is specified in the header
} AUDIO_AZALIA_VERB_TABLE;

///
/// Refer to the definition of PCH_INT_PIN
///
typedef enum {
  SiPchNoInt,        ///< No Interrupt Pin
  SiPchIntA,
  SiPchIntB,
  SiPchIntC,
  SiPchIntD
} SI_PCH_INT_PIN;
///
/// The PCH_DEVICE_INTERRUPT_CONFIG block describes interrupt pin, IRQ and interrupt mode for PCH device.
///
typedef struct {
  UINT8        Device;                  ///< Device number
  UINT8        Function;                ///< Device function
  UINT8        IntX;                    ///< Interrupt pin: INTA-INTD (see SI_PCH_INT_PIN)
  UINT8        Irq;                     ///< IRQ to be set for device.
} SI_PCH_DEVICE_INTERRUPT_CONFIG;

#define SI_PCH_MAX_DEVICE_INTERRUPT_CONFIG  64       ///< Number of all PCH devices


/** Fsp S Configuration
**/
typedef struct {

/** Offset 0x0040 - Logo Pointer
  Points to PEI Display Logo Image
**/
  UINT64                      LogoPtr;

/** Offset 0x0048 - Logo Size
  Size of PEI Display Logo Image
**/
  UINT32                      LogoSize;

/** Offset 0x004C - Reserved
**/
  UINT8                       Reserved0[4];

/** Offset 0x0050 - Blt Buffer Address
  Address of Blt buffer
**/
  UINT64                      BltBufferAddress;

/** Offset 0x0058 - Blt Buffer Size
  Size of Blt Buffer, is equal to PixelWidth * PixelHeight * 4 bytes (the size of
  EFI_GRAPHICS_OUTPUT_BLT_PIXEL)
**/
  UINT64                      BltBufferSize;

/** Offset 0x0060 - Graphics Configuration Ptr
  Points to VBT
**/
  UINT64                      GraphicsConfigPtr;

/** Offset 0x0068 - Enable Device 4
  Enable/disable Device 4
  $EN_DIS
**/
  UINT8                       Device4Enable;

/** Offset 0x0069 - Show SPI controller
  Enable/disable to show SPI controller.
  $EN_DIS
**/
  UINT8                       ShowSpiController;

/** Offset 0x006A - Reserved
**/
  UINT8                       Reserved1[6];

/** Offset 0x0070 - MicrocodeRegionBase
  Memory Base of Microcode Updates
**/
  UINT64                      MicrocodeRegionBase;

/** Offset 0x0078 - MicrocodeRegionSize
  Size of Microcode Updates
**/
  UINT32                      MicrocodeRegionSize;

/** Offset 0x007C - Turbo Mode
  Enable/Disable processor Turbo Mode. 0:disable, <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       TurboMode;

/** Offset 0x007D - Enable SATA SALP Support
  Enable/disable SATA Aggressive Link Power Management.
  $EN_DIS
**/
  UINT8                       SataSalpSupport;

/** Offset 0x007E - Enable SATA ports
  Enable/disable SATA ports. One byte for each port, byte0 for port0, byte1 for port1,
  and so on.
**/
  UINT8                       SataPortsEnable[8];

/** Offset 0x0086 - Enable SATA DEVSLP Feature
  Enable/disable SATA DEVSLP per port. 0 is disable, 1 is enable. One byte for each
  port, byte0 for port0, byte1 for port1, and so on.
**/
  UINT8                       SataPortsDevSlp[8];

/** Offset 0x008E - Reserved
**/
  UINT8                       Reserved2[34];

/** Offset 0x00B0 - Enable USB2 ports
  Enable/disable per USB2 ports. One byte for each port, byte0 for port0, byte1 for
  port1, and so on.
**/
  UINT8                       PortUsb20Enable[16];

/** Offset 0x00C0 - Enable USB3 ports
  Enable/disable per USB3 ports. One byte for each port, byte0 for port0, byte1 for
  port1, and so on.
**/
  UINT8                       PortUsb30Enable[10];

/** Offset 0x00CA - Enable xDCI controller
  Enable/disable to xDCI controller.
  $EN_DIS
**/
  UINT8                       XdciEnable;

/** Offset 0x00CB - Reserved
**/
  UINT8                       Reserved3;

/** Offset 0x00CC - Address of PCH_DEVICE_INTERRUPT_CONFIG table.
  The address of the table of PCH_DEVICE_INTERRUPT_CONFIG.
**/
  UINT32                      DevIntConfigPtr;

/** Offset 0x00D0 - Number of DevIntConfig Entry
  Number of Device Interrupt Configuration Entry. If this is not zero, the DevIntConfigPtr
  must not be NULL.
**/
  UINT8                       NumOfDevIntConfig;

/** Offset 0x00D1 - PIRQx to IRQx Map Config
  PIRQx to IRQx mapping. The valid value is 0x00 to 0x0F for each. First byte is for
  PIRQA, second byte is for PIRQB, and so on. The setting is only available in Legacy
  8259 PCI mode.
**/
  UINT8                       PxRcConfig[8];

/** Offset 0x00D9 - Select GPIO IRQ Route
  GPIO IRQ Select. The valid value is 14 or 15.
**/
  UINT8                       GpioIrqRoute;

/** Offset 0x00DA - Select SciIrqSelect
  SCI IRQ Select. The valid value is 9, 10, 11, and 20, 21, 22, 23 for APIC only.
**/
  UINT8                       SciIrqSelect;

/** Offset 0x00DB - Select TcoIrqSelect
  TCO IRQ Select. The valid value is 9, 10, 11, 20, 21, 22, 23.
**/
  UINT8                       TcoIrqSelect;

/** Offset 0x00DC - Enable/Disable Tco IRQ
  Enable/disable TCO IRQ
  $EN_DIS
**/
  UINT8                       TcoIrqEnable;

/** Offset 0x00DD - PCH HDA Verb Table Entry Number
  Number of Entries in Verb Table.
**/
  UINT8                       PchHdaVerbTableEntryNum;

/** Offset 0x00DE - Reserved
**/
  UINT8                       Reserved4[2];

/** Offset 0x00E0 - PCH HDA Verb Table Pointer
  Pointer to Array of pointers to Verb Table.
**/
  UINT64                      PchHdaVerbTablePtr;

/** Offset 0x00E8 - PCH HDA Codec Sx Wake Capability
  Capability to detect wake initiated by a codec in Sx
**/
  UINT8                       PchHdaCodecSxWakeCapability;

/** Offset 0x00E9 - Enable SATA
  Enable/disable SATA controller.
  $EN_DIS
**/
  UINT8                       SataEnable;

/** Offset 0x00EA - SATA Mode
  Select SATA controller working mode.
  0:AHCI, 1:RAID
**/
  UINT8                       SataMode;

/** Offset 0x00EB - SPIn Device Mode
  Selects SPI operation mode. N represents controller index: SPI0, SPI1, ... Available
  modes: 0:SerialIoSpiDisabled, 1:SerialIoSpiPci, 2:SerialIoSpiHidden
**/
  UINT8                       SerialIoSpiMode[7];

/** Offset 0x00F2 - SPI<N> Chip Select Polarity
  Sets polarity for each chip Select. Available options: 0:SerialIoSpiCsActiveLow,
  1:SerialIoSpiCsActiveHigh
**/
  UINT8                       SerialIoSpiCsPolarity[14];

/** Offset 0x0100 - SPI<N> Chip Select Enable
  0:Disabled, 1:Enabled. Enables GPIO for CS0 or CS1 if it is Enabled
**/
  UINT8                       SerialIoSpiCsEnable[14];

/** Offset 0x010E - SPIn Default Chip Select Output
  Sets Default CS as Output. N represents controller index: SPI0, SPI1, ... Available
  options: 0:CS0, 1:CS1
**/
  UINT8                       SerialIoSpiDefaultCsOutput[7];

/** Offset 0x0115 - SPIn Default Chip Select Mode HW/SW
  Sets Default CS Mode Hardware or Software. N represents controller index: SPI0,
  SPI1, ... Available options: 0:HW, 1:SW
**/
  UINT8                       SerialIoSpiCsMode[7];

/** Offset 0x011C - SPIn Default Chip Select State Low/High
  Sets Default CS State Low or High. N represents controller index: SPI0, SPI1, ...
  Available options: 0:Low, 1:High
**/
  UINT8                       SerialIoSpiCsState[7];

/** Offset 0x0123 - Reserved
**/
  UINT8                       Reserved5[141];

/** Offset 0x01B0 - UARTn Device Mode
  Selects Uart operation mode. N represents controller index: Uart0, Uart1, ... Available
  modes: 0:SerialIoUartDisabled, 1:SerialIoUartPci, 2:SerialIoUartHidden, 3:SerialIoUartCom,
  4:SerialIoUartSkipInit
**/
  UINT8                       SerialIoUartMode[7];

/** Offset 0x01B7 - Reserved
**/
  UINT8                       Reserved6;

/** Offset 0x01B8 - Default BaudRate for each Serial IO UART
  Set default BaudRate Supported from 0 - default to 6000000
**/
  UINT32                      SerialIoUartBaudRate[7];

/** Offset 0x01D4 - Default ParityType for each Serial IO UART
  Set default Parity. 0: DefaultParity, 1: NoParity, 2: EvenParity, 3: OddParity
**/
  UINT8                       SerialIoUartParity[7];

/** Offset 0x01DB - Default DataBits for each Serial IO UART
  Set default word length. 0: Default, 5,6,7,8
**/
  UINT8                       SerialIoUartDataBits[7];

/** Offset 0x01E2 - Default StopBits for each Serial IO UART
  Set default stop bits. 0: DefaultStopBits, 1: OneStopBit, 2: OneFiveStopBits, 3:
  TwoStopBits
**/
  UINT8                       SerialIoUartStopBits[7];

/** Offset 0x01E9 - Power Gating mode for each Serial IO UART that works in COM mode
  Set Power Gating. 0: Disabled, 1: Enabled, 2: Auto
**/
  UINT8                       SerialIoUartPowerGating[7];

/** Offset 0x01F0 - Enable Dma for each Serial IO UART that supports it
  Set DMA/PIO mode. 0: Disabled, 1: Enabled
**/
  UINT8                       SerialIoUartDmaEnable[7];

/** Offset 0x01F7 - Enables UART hardware flow control, CTS and RTS lines
  Enables UART hardware flow control, CTS and RTS lines.
**/
  UINT8                       SerialIoUartAutoFlow[7];

/** Offset 0x01FE - Reserved
**/
  UINT8                       Reserved7[2];

/** Offset 0x0200 - SerialIoUartRtsPinMuxPolicy
  Select SerialIo Uart Rts pin muxing. Refer to GPIO_*_MUXING_SERIALIO_UARTx_RTS*
  for possible values.
**/
  UINT32                      SerialIoUartRtsPinMuxPolicy[7];

/** Offset 0x021C - SerialIoUartCtsPinMuxPolicy
  Select SerialIo Uart Cts pin muxing. Refer to GPIO_*_MUXING_SERIALIO_UARTx_CTS*
  for possible values.
**/
  UINT32                      SerialIoUartCtsPinMuxPolicy[7];

/** Offset 0x0238 - SerialIoUartRxPinMuxPolicy
  Select SerialIo Uart Rx pin muxing. Refer to GPIO_*_MUXING_SERIALIO_UARTx_RX* for
  possible values.
**/
  UINT32                      SerialIoUartRxPinMuxPolicy[7];

/** Offset 0x0254 - SerialIoUartTxPinMuxPolicy
  Select SerialIo Uart Tx pin muxing. Refer to GPIO_*_MUXING_SERIALIO_UARTx_TX* for
  possible values.
**/
  UINT32                      SerialIoUartTxPinMuxPolicy[7];

/** Offset 0x0270 - Serial IO UART DBG2 table
  Enable or disable Serial Io UART DBG2 table, default is Disable; <b>0: Disable;</b>
  1: Enable.
**/
  UINT8                       SerialIoUartDbg2[7];

/** Offset 0x0277 - I2Cn Device Mode
  Selects I2c operation mode. N represents controller index: I2c0, I2c1, ... Available
  modes: 0:SerialIoI2cDisabled, 1:SerialIoI2cPci, 2:SerialIoI2cHidden
**/
  UINT8                       SerialIoI2cMode[8];

/** Offset 0x027F - Reserved
**/
  UINT8                       Reserved8;

/** Offset 0x0280 - Serial IO I2C SDA Pin Muxing
  Select SerialIo I2c Sda pin muxing. Refer to GPIO_*_MUXING_SERIALIO_I2Cx_SDA* for
  possible values.
**/
  UINT32                      PchSerialIoI2cSdaPinMux[8];

/** Offset 0x02A0 - Serial IO I2C SCL Pin Muxing
  Select SerialIo I2c Scl pin muxing. Refer to GPIO_*_MUXING_SERIALIO_I2Cx_SCL* for
  possible values.
**/
  UINT32                      PchSerialIoI2cSclPinMux[8];

/** Offset 0x02C0 - PCH SerialIo I2C Pads Termination
  0x0: Hardware default, 0x1: None, 0x13: 1kOhm weak pull-up, 0x15: 5kOhm weak pull-up,
  0x19: 20kOhm weak pull-up - Enable/disable SerialIo I2C0,I2C1,... pads termination
  respectively. One byte for each controller, byte0 for I2C0, byte1 for I2C1, and so on.
**/
  UINT8                       PchSerialIoI2cPadsTermination[8];

/** Offset 0x02C8 - I3C Device Mode
  Selects I3c operation mode. Available modes: 0:SerialIoI3cDisabled, 1:SerialIoI3cPci,
  2:SerialIoI3cPhantom (only applicable to I3C1, controlls GPIO enabling)
**/
  UINT8                       SerialIoI3cMode[2];

/** Offset 0x02CA - Reserved
**/
  UINT8                       Reserved9[38];

/** Offset 0x02F0 - ISH GP GPIO Pin Muxing
  Determines ISH GP GPIO Pin muxing. See GPIO_*_MUXING_ISH_GP_x_GPIO_*. 'x' are GP_NUMBER
**/
  UINT32                      IshGpGpioPinMuxing[12];

/** Offset 0x0320 - ISH UART Rx Pin Muxing
  Determines ISH UART Rx Pin muxing. See GPIO_*_MUXING_ISH_UARTx_TXD_*
**/
  UINT32                      IshUartRxPinMuxing[3];

/** Offset 0x032C - ISH UART Tx Pin Muxing
  Determines ISH UART Tx Pin muxing. See GPIO_*_MUXING_ISH_UARTx_RXD_*
**/
  UINT32                      IshUartTxPinMuxing[3];

/** Offset 0x0338 - ISH UART Rts Pin Muxing
  Select ISH UART Rts Pin muxing. Refer to GPIO_*_MUXING_ISH_UARTx_RTS_* for possible values.
**/
  UINT32                      IshUartRtsPinMuxing[3];

/** Offset 0x0344 - ISH UART Rts Pin Muxing
  Select ISH UART Cts Pin muxing. Refer to GPIO_*_MUXING_ISH_UARTx_CTS_* for possible values.
**/
  UINT32                      IshUartCtsPinMuxing[3];

/** Offset 0x0350 - ISH I2C SDA Pin Muxing
  Select ISH I2C SDA Pin muxing. Refer to GPIO_*_MUXING_ISH_I2Cx_SDA_* for possible values.
**/
  UINT32                      IshI2cSdaPinMuxing[3];

/** Offset 0x035C - ISH I2C SCL Pin Muxing
  Select ISH I2C SCL Pin muxing. Refer to GPIO_*_MUXING_ISH_I2Cx_SCL_* for possible values.
**/
  UINT32                      IshI2cSclPinMuxing[3];

/** Offset 0x0368 - Reserved
**/
  UINT8                      Reserved10[8];

/** Offset 0x0370 - ISH SPI MOSI Pin Muxing
  Select ISH SPI MOSI Pin muxing. Refer to GPIO_*_MUXING_ISH_SPIx_MOSI_* for possible values.
**/
  UINT32                      IshSpiMosiPinMuxing[2];

/** Offset 0x0378 - ISH SPI MISO Pin Muxing
  Select ISH SPI MISO Pin muxing. Refer to GPIO_*_MUXING_ISH_SPIx_MISO_* for possible values.
**/
  UINT32                      IshSpiMisoPinMuxing[2];

/** Offset 0x0380 - ISH SPI CLK Pin Muxing
  Select ISH SPI CLK Pin muxing. Refer to GPIO_*_MUXING_ISH_SPIx_CLK_* for possible values.
**/
  UINT32                      IshSpiClkPinMuxing[2];

/** Offset 0x0388 - ISH SPI CS#N Pin Muxing
  Select ISH SPI CS#N Pin muxing. Refer to GPIO_*_MUXING_ISH_SPIx_CS<N>_* for possible
  values. N-SPI number, 0-1.
**/
  UINT32                      IshSpiCsPinMuxing[4];

/** Offset 0x0398 - ISH GP GPIO Pad termination
  0x0: Hardware default, 0x1: None, 0x13: 1kOhm weak pull-up, 0x15: 5kOhm weak pull-up,
  0x19: 20kOhm weak pull-up - Enable/disable SerialIo GP#N GPIO pads termination
  respectively. #N are GP_NUMBER, not strictly relate to indexes of this table. Index
  0-23 -> ISH_GP_0-23, Index 24-25 -> ISH_GP_30-31
**/
  UINT8                       IshGpGpioPadTermination[12];

/** Offset 0x03A4 - ISH UART Rx Pad termination
  0x0: Hardware default, 0x1: None, 0x13: 1kOhm weak pull-up, 0x15: 5kOhm weak pull-up,
  0x19: 20kOhm weak pull-up - Enable/disable SerialIo UART#N Rx pads termination
  respectively. #N-byte for each controller, byte0 for UART0 Rx, byte1 for UART1
  Rx, and so on.
**/
  UINT8                       IshUartRxPadTermination[3];

/** Offset 0x03A7 - ISH UART Tx Pad termination
  0x0: Hardware default, 0x1: None, 0x13: 1kOhm weak pull-up, 0x15: 5kOhm weak pull-up,
  0x19: 20kOhm weak pull-up - Enable/disable SerialIo UART#N Tx pads termination
  respectively. #N-byte for each controller, byte0 for UART0 Tx, byte1 for UART1
  Tx, and so on.
**/
  UINT8                       IshUartTxPadTermination[3];

/** Offset 0x03AA - ISH UART Rts Pad termination
  0x0: Hardware default, 0x1: None, 0x13: 1kOhm weak pull-up, 0x15: 5kOhm weak pull-up,
  0x19: 20kOhm weak pull-up - Enable/disable SerialIo UART#N Rts pads termination
  respectively. #N-byte for each controller, byte0 for UART0 Rts, byte1 for UART1
  Rts, and so on.
**/
  UINT8                       IshUartRtsPadTermination[3];

/** Offset 0x03AD - ISH UART Rts Pad termination
  0x0: Hardware default, 0x1: None, 0x13: 1kOhm weak pull-up, 0x15: 5kOhm weak pull-up,
  0x19: 20kOhm weak pull-up - Enable/disable SerialIo UART#N Cts pads termination
  respectively. #N-byte for each controller, byte0 for UART0 Cts, byte1 for UART1
  Cts, and so on.
**/
  UINT8                       IshUartCtsPadTermination[3];

/** Offset 0x03B0 - ISH I2C SDA Pad termination
  0x0: Hardware default, 0x1: None, 0x13: 1kOhm weak pull-up, 0x15: 5kOhm weak pull-up,
  0x19: 20kOhm weak pull-up - Enable/disable SerialIo I2C#N Sda pads termination
  respectively. #N-byte for each controller, byte0 for I2C0 Sda, byte1 for I2C1 Sda,
  and so on.
**/
  UINT8                       IshI2cSdaPadTermination[3];

/** Offset 0x03B3 - Reserved
**/
  UINT8                       Reserved11;

/** Offset 0x03B4 - ISH I2C SCL Pad termination
  0x0: Hardware default, 0x1: None, 0x13: 1kOhm weak pull-up, 0x15: 5kOhm weak pull-up,
  0x19: 20kOhm weak pull-up - Enable/disable SerialIo I2C#N Scl pads termination
  respectively. #N-byte for each controller, byte0 for I2C0 Scl, byte1 for I2C1 Scl,
  and so on.
**/
  UINT8                       IshI2cSclPadTermination[3];

/** Offset 0x03B7 - Reserved
**/
  UINT8                       Reserved12;

/** Offset 0x03B8 - ISH SPI MOSI Pad termination
  0x0: Hardware default, 0x1: None, 0x13: 1kOhm weak pull-up, 0x15: 5kOhm weak pull-up,
  0x19: 20kOhm weak pull-up - Enable/disable SerialIo SPI#N Mosi pads termination
  respectively. #N-byte for each controller, byte0 for SPI0 Mosi, byte1 for SPI1
  Mosi, and so on.
**/
  UINT8                       IshSpiMosiPadTermination[2];

/** Offset 0x03BA - ISH SPI MISO Pad termination
  0x0: Hardware default, 0x1: None, 0x13: 1kOhm weak pull-up, 0x15: 5kOhm weak pull-up,
  0x19: 20kOhm weak pull-up - Enable/disable SerialIo SPI#N Miso pads termination
  respectively. #N-byte for each controller, byte0 for SPI0 Miso, byte1 for SPI1
  Miso, and so on.
**/
  UINT8                       IshSpiMisoPadTermination[2];

/** Offset 0x03BC - ISH SPI CLK Pad termination
  0x0: Hardware default, 0x1: None, 0x13: 1kOhm weak pull-up, 0x15: 5kOhm weak pull-up,
  0x19: 20kOhm weak pull-up - Enable/disable SerialIo SPI#N Clk pads termination
  respectively. #N-byte for each controller, byte0 for SPI0 Clk, byte1 for SPI1 Clk,
  and so on.
**/
  UINT8                       IshSpiClkPadTermination[2];

/** Offset 0x03BE - ISH SPI CS#N Pad termination
  0x0: Hardware default, 0x1: None, 0x13: 1kOhm weak pull-up, 0x15: 5kOhm weak pull-up,
  0x19: 20kOhm weak pull-up - Enable/disable SerialIo SPI#N Cs#M pads termination
  respectively. N*M-byte for each controller, byte0 for SPI0 Cs0, byte1 for SPI1
  Cs1, SPI1 Cs0, byte2, SPI1 Cs1, byte3
**/
  UINT8                       IshSpiCsPadTermination[4];

/** Offset 0x03C2 - Enable PCH ISH SPI Cs#N pins assigned
  Set if ISH SPI Cs#N pins are to be enabled by BIOS. 0: Disable; 1: Enable. N-Cs
  number: 0-1
**/
  UINT8                       PchIshSpiCsEnable[4];

/** Offset 0x03C6 - USB Per Port HS Preemphasis Bias
  USB Per Port HS Preemphasis Bias. 000b-0mV, 001b-11.25mV, 010b-16.9mV, 011b-28.15mV,
  100b-28.15mV, 101b-39.35mV, 110b-45mV, 111b-56.3mV. One byte for each port.
**/
  UINT8                       Usb2PhyPetxiset[16];

/** Offset 0x03D6 - USB Per Port HS Transmitter Bias
  USB Per Port HS Transmitter Bias. 000b-0mV, 001b-11.25mV, 010b-16.9mV, 011b-28.15mV,
  100b-28.15mV, 101b-39.35mV, 110b-45mV, 111b-56.3mV, One byte for each port.
**/
  UINT8                       Usb2PhyTxiset[16];

/** Offset 0x03E6 - USB Per Port HS Transmitter Emphasis
  USB Per Port HS Transmitter Emphasis. 00b - Emphasis OFF, 01b - De-emphasis ON,
  10b - Pre-emphasis ON, 11b - Pre-emphasis & De-emphasis ON. One byte for each port.
**/
  UINT8                       Usb2PhyPredeemp[16];

/** Offset 0x03F6 - USB Per Port Half Bit Pre-emphasis
  USB Per Port Half Bit Pre-emphasis. 1b - half-bit pre-emphasis, 0b - full-bit pre-emphasis.
  One byte for each port.
**/
  UINT8                       Usb2PhyPehalfbit[16];

/** Offset 0x0406 - Enable the write to USB 3.0 TX Output -3.5dB De-Emphasis Adjustment
  Enable the write to USB 3.0 TX Output -3.5dB De-Emphasis Adjustment. Each value
  in arrary can be between 0-1. One byte for each port.
**/
  UINT8                       Usb3HsioTxDeEmphEnable[10];

/** Offset 0x0410 - USB 3.0 TX Output -3.5dB De-Emphasis Adjustment Setting
  USB 3.0 TX Output -3.5dB De-Emphasis Adjustment Setting, HSIO_TX_DWORD5[21:16],
  <b>Default = 29h</b> (approximately -3.5dB De-Emphasis). One byte for each port.
**/
  UINT8                       Usb3HsioTxDeEmph[10];

/** Offset 0x041A - Enable the write to USB 3.0 TX Output Downscale Amplitude Adjustment
  Enable the write to USB 3.0 TX Output Downscale Amplitude Adjustment, Each value
  in arrary can be between 0-1. One byte for each port.
**/
  UINT8                       Usb3HsioTxDownscaleAmpEnable[10];

/** Offset 0x0424 - USB 3.0 TX Output Downscale Amplitude Adjustment
  USB 3.0 TX Output Downscale Amplitude Adjustment, HSIO_TX_DWORD8[21:16], <b>Default
  = 00h</b>. One byte for each port.
**/
  UINT8                       Usb3HsioTxDownscaleAmp[10];

/** Offset 0x042E
**/
  UINT8                       PchUsb3HsioCtrlAdaptOffsetCfgEnable[10];

/** Offset 0x0438
**/
  UINT8                       PchUsb3HsioFilterSelNEnable[10];

/** Offset 0x0442
**/
  UINT8                       PchUsb3HsioFilterSelPEnable[10];

/** Offset 0x044C
**/
  UINT8                       PchUsb3HsioOlfpsCfgPullUpDwnResEnable[10];

/** Offset 0x0456
**/
  UINT8                       PchUsb3HsioCtrlAdaptOffsetCfg[10];

/** Offset 0x0460
**/
  UINT8                       PchUsb3HsioOlfpsCfgPullUpDwnRes[10];

/** Offset 0x046A
**/
  UINT8                       PchUsb3HsioFilterSelN[10];

/** Offset 0x0474
**/
  UINT8                       PchUsb3HsioFilterSelP[10];

/** Offset 0x047E - Enable LAN
  Enable/disable LAN controller.
  $EN_DIS
**/
  UINT8                       PchLanEnable;

/** Offset 0x047F - Enable PCH TSN
  Enable/disable TSN on the PCH.
  $EN_DIS
**/
  UINT8                       PchTsnEnable;

/** Offset 0x0480 - TSN Link Speed
  Set TSN Link Speed.
  0: 24Mhz 2.5Gbps, 1: 24Mhz 1Gbps, 2: 38.4Mhz 2.5Gbps, 3: 38.4Mhz 1Gbps
**/
  UINT8                       PchTsnLinkSpeed;

/** Offset 0x0481 - Reserved
**/
  UINT8                       Reserved13[19];

/** Offset 0x0494 - PCIe PTM enable/disable
  Enable/disable Precision Time Measurement for PCIE Root Ports.
**/
  UINT8                       PciePtm[29];

/** Offset 0x04B1 - Reserved
**/
  UINT8                       Reserved14[29];

/** Offset 0x04CE - USB PDO Programming
  Enable/disable PDO programming for USB in PEI phase. Disabling will allow for programming
  during later phase. 1: enable, 0: disable
  $EN_DIS
**/
  UINT8                       UsbPdoProgramming;

/** Offset 0x04CF - Reserved
**/
  UINT8                       Reserved15[5];

/** Offset 0x04D4 - Power button debounce configuration
  Debounce time for PWRBTN in microseconds. For values not supported by HW, they will
  be rounded down to closest supported on. 0: disable, 250-1024000us: supported range
**/
  UINT32                      PmcPowerButtonDebounce;

/** Offset 0x04D8 - Reserved
**/
  UINT8                       Reserved16;

/** Offset 0x04D9 - PCH eSPI Link Configuration Lock (SBLCL)
  Enable/Disable lock of communication through SET_CONFIG/GET_CONFIG to eSPI target
  addresseses from range 0x0 - 0x7FF
  $EN_DIS
**/
  UINT8                       PchEspiLockLinkConfiguration;

/** Offset 0x04DA - Mask to enable the usage of external V1p05 VR rail in specific S0ix or Sx states
  Enable External V1P05 Rail in: BIT0:S0i1/S0i2, BIT1:S0i3, BIT2:S3, BIT3:S4, BIT5:S5
**/
  UINT8                       PchFivrExtV1p05RailEnabledStates;

/** Offset 0x04DB - Mask to enable the platform configuration of external V1p05 VR rail
  External V1P05 Rail Supported Configuration
**/
  UINT8                       PchFivrExtV1p05RailSupportedVoltageStates;

/** Offset 0x04DC - External V1P05 Voltage Value that will be used in S0i2/S0i3 states
  Value is given in 2.5mV increments (0=0mV, 1=2.5mV, 2=5mV...)
**/
  UINT16                      PchFivrExtV1p05RailVoltage;

/** Offset 0x04DE - External V1P05 Icc Max Value
  Granularity of this setting is 1mA and maximal possible value is 200mA
**/
  UINT8                       PchFivrExtV1p05RailIccMax;

/** Offset 0x04DF - Mask to enable the usage of external Vnn VR rail in specific S0ix or Sx states
  Enable External Vnn Rail in: BIT0:S0i1/S0i2, BIT1:S0i3, BIT2:S3, BIT3:S4, BIT5:S5
**/
  UINT8                       PchFivrExtVnnRailEnabledStates;

/** Offset 0x04E0 - Mask to enable the platform configuration of external Vnn VR rail
  External Vnn Rail Supported Configuration
**/
  UINT8                       PchFivrExtVnnRailSupportedVoltageStates;

/** Offset 0x04E1 - Reserved
**/
  UINT8                       Reserved17;

/** Offset 0x04E2 - External Vnn Voltage Value that will be used in S0ix/Sx states
  Value is given in 2.5mV increments (0=0mV, 1=2.5mV, 2=5mV...), Default is set to 420
**/
  UINT16                      PchFivrExtVnnRailVoltage;

/** Offset 0x04E4 - External Vnn Icc Max Value that will be used in S0ix/Sx states
  Granularity of this setting is 1mA and maximal possible value is 200mA
**/
  UINT8                       PchFivrExtVnnRailIccMax;

/** Offset 0x04E5 - Mask to enable the usage of external Vnn VR rail in Sx states
  Use only if Ext Vnn Rail config is different in Sx. Enable External Vnn Rail in
  Sx: BIT0-1:Reserved, BIT2:S3, BIT3:S4, BIT5:S5
**/
  UINT8                       PchFivrExtVnnRailSxEnabledStates;

/** Offset 0x04E6 - External Vnn Voltage Value that will be used in Sx states
  Use only if Ext Vnn Rail config is different in Sx. Value is given in 2.5mV increments
  (0=0mV, 1=2.5mV, 2=5mV...)
**/
  UINT16                      PchFivrExtVnnRailSxVoltage;

/** Offset 0x04E8 - External Vnn Icc Max Value that will be used in Sx states
  Use only if Ext Vnn Rail config is different in Sx. Granularity of this setting
  is 1mA and maximal possible value is 200mA
**/
  UINT8                       PchFivrExtVnnRailSxIccMax;

/** Offset 0x04E9 - Transition time in microseconds from Low Current Mode Voltage to High Current Mode Voltage
  This field has 1us resolution. When value is 0 PCH will not transition VCCIN_AUX
  to low current mode voltage.
**/
  UINT8                       PchFivrVccinAuxLowToHighCurModeVolTranTime;

/** Offset 0x04EA - Transition time in microseconds from Retention Mode Voltage to High Current Mode Voltage
  This field has 1us resolution. When value is 0 PCH will not transition VCCIN_AUX
  to retention mode voltage.
**/
  UINT8                       PchFivrVccinAuxRetToHighCurModeVolTranTime;

/** Offset 0x04EB - Transition time in microseconds from Retention Mode Voltage to Low Current Mode Voltage
  This field has 1us resolution. When value is 0 PCH will not transition VCCIN_AUX
  to retention mode voltage.
**/
  UINT8                       PchFivrVccinAuxRetToLowCurModeVolTranTime;

/** Offset 0x04EC - Transition time in microseconds from Off (0V) to High Current Mode Voltage
  This field has 1us resolution. When value is 0 Transition to 0V is disabled.
**/
  UINT16                      PchFivrVccinAuxOffToHighCurModeVolTranTime;

/** Offset 0x04EE - PMC Debug Message Enable
  When Enabled, PMC HW will send debug messages to trace hub; When Disabled, PMC HW
  will never send debug meesages to trace hub. Noted: When Enabled, may not enter S0ix
  $EN_DIS
**/
  UINT8                       PmcDbgMsgEn;

/** Offset 0x04EF - Reserved
**/
  UINT8                       Reserved18;

/** Offset 0x04F0 - Pointer to ChipsetInit Binary
  ChipsetInit Binary Pointer.
**/
  UINT32                      ChipsetInitBinPtr;

/** Offset 0x04F4 - Length of ChipsetInit Binary
  ChipsetInit Binary Length.
**/
  UINT32                      ChipsetInitBinLen;

/** Offset 0x04F8 - Reserved
**/
  UINT8                      Reserved19[16];

/** Offset 0x0508 - FIVR Dynamic Power Management
  Enable/Disable FIVR Dynamic Power Management.
  $EN_DIS
**/
  UINT8                       PchFivrDynPm;

/** Offset 0x0509 - Reserved
**/
  UINT8                       Reserved20;

/** Offset 0x050A - External V1P05 Icc Max Value
  Granularity of this setting is 1mA and maximal possible value is 500mA
**/
  UINT16                      PchFivrExtV1p05RailIccMaximum;

/** Offset 0x050C - External Vnn Icc Max Value that will be used in S0ix/Sx states
  Granularity of this setting is 1mA and maximal possible value is 500mA
**/
  UINT16                      PchFivrExtVnnRailIccMaximum;

/** Offset 0x050E - External Vnn Icc Max Value that will be used in Sx states
  Use only if Ext Vnn Rail config is different in Sx. Granularity of this setting
  is 1mA and maximal possible value is 500mA
**/
  UINT16                      PchFivrExtVnnRailSxIccMaximum;

/** Offset 0x0510 - Reserved
**/
  UINT8                       Reserved21[14];

/** Offset 0x051E - CNVi Configuration
  This option allows for automatic detection of Connectivity Solution. [Auto Detection]
  assumes that CNVi will be enabled when available, [Disable] allows for disabling CNVi.
  0:Disable, 1:Auto
**/
  UINT8                       CnviMode;

/** Offset 0x051F - CNVi Wi-Fi Core
  Enable/Disable CNVi Wi-Fi Core, Default is ENABLE. 0: DISABLE, 1: ENABLE
  $EN_DIS
**/
  UINT8                       CnviWifiCore;

/** Offset 0x0520 - CNVi BT Core
  Enable/Disable CNVi BT Core, Default is ENABLE. 0: DISABLE, 1: ENABLE
  $EN_DIS
**/
  UINT8                       CnviBtCore;

/** Offset 0x0521 - CNVi BT Audio Offload
  Enable/Disable BT Audio Offload, Default is ENABLE. 0: DISABLE, 1: ENABLE
  $EN_DIS
**/
  UINT8                       CnviBtAudioOffload;

/** Offset 0x0522 - Reserved
**/
  UINT8                       Reserved22[2];

/** Offset 0x0524 - CNVi RF_RESET pin muxing
  Select CNVi RF_RESET# pin depending on board routing. LP/P/M: GPP_A8 = 0x2942E408(default)
  or GPP_F4 = 0x194CE404. H/S: 0. Refer to GPIO_*_MUXING_CNVI_RF_RESET_* in GpioPins*.h.
**/
  UINT32                      CnviRfResetPinMux;

/** Offset 0x0528 - CNVi CLKREQ pin muxing
  Select CNVi CLKREQ pin depending on board routing. LP/P/M: GPP_A9 = 0x3942E609(default)
  or GPP_F5 = 0x394CE605. H/S: 0. Refer to GPIO_*_MUXING_CNVI_CRF_XTAL_CLKREQ_* in
  GpioPins*.h.
**/
  UINT32                      CnviClkreqPinMux;

/** Offset 0x052C - Enable Host C10 reporting through eSPI
  Enable/disable Host C10 reporting to Device via eSPI Virtual Wire.
  $EN_DIS
**/
  UINT8                       PchEspiHostC10ReportEnable;

/** Offset 0x052D - PCH USB2 PHY Power Gating enable
  1: Will enable USB2 PHY SUS Well Power Gating, 0: Will not enable PG of USB2 PHY
  Sus Well PG
  $EN_DIS
**/
  UINT8                       PmcUsb2PhySusPgEnable;

/** Offset 0x052E - PCH USB OverCurrent mapping enable
  1: Will program USB OC pin mapping in xHCI controller memory, 0: Will clear OC pin
  mapping allow for NOA usage of OC pins
  $EN_DIS
**/
  UINT8                       PchUsbOverCurrentEnable;

/** Offset 0x052F - Espi Lgmr Memory Range decode
  This option enables or disables espi lgmr
  $EN_DIS
**/
  UINT8                       PchEspiLgmrEnable;

/** Offset 0x0530 - External V1P05 Control Ramp Timer value
  Hold off time to be used when changing the v1p05_ctrl for external bypass value in us
**/
  UINT8                       PchFivrExtV1p05RailCtrlRampTmr;

/** Offset 0x0531 - External VNN Control Ramp Timer value
  Hold off time to be used when changing the vnn_ctrl for external bypass value in us
**/
  UINT8                       PchFivrExtVnnRailCtrlRampTmr;

/** Offset 0x0532 - Set SATA DEVSLP GPIO Reset Config
  Set SATA DEVSLP GPIO Reset Config per port. 0x00 - GpioResetDefault, 0x01 - GpioResumeReset,
  0x03 - GpioHostDeepReset, 0x05 - GpioPlatformReset, 0x07 - GpioDswReset. One byte
  for each port, byte0 for port0, byte1 for port1, and so on.
**/
  UINT8                       SataPortsDevSlpResetConfig[8];

/** Offset 0x053A - PCHHOT# pin
  Enable PCHHOT# pin assertion when temperature is higher than PchHotLevel. 0: disable, 1: enable
  $EN_DIS
**/
  UINT8                       PchHotEnable;

/** Offset 0x053B - SATA LED
  SATA LED indicating SATA controller activity. 0: disable, 1: enable
  $EN_DIS
**/
  UINT8                       SataLedEnable;

/** Offset 0x053C - VRAlert# Pin
  When VRAlert# feature pin is enabled and its state is '0', the PMC requests throttling
  to a T3 Tstate to the PCH throttling unit.. 0: disable, 1: enable
  $EN_DIS
**/
  UINT8                       PchPmVrAlert;

/** Offset 0x053D - AMT Switch
  Enable/Disable. 0: Disable, 1: enable, Enable or disable AMT functionality.
  $EN_DIS
**/
  UINT8                       AmtEnabled;

/** Offset 0x053E - WatchDog Timer Switch
  Enable/Disable. 0: Disable, 1: enable, Enable or disable WatchDog timer. Setting
  is invalid if AmtEnabled is 0.
  $EN_DIS
**/
  UINT8                       WatchDogEnabled;

/** Offset 0x053F - PET Progress
  Enable/Disable. 0: Disable, 1: enable, Enable/Disable PET Events Progress to receive
  PET Events. Setting is invalid if AmtEnabled is 0.
  $EN_DIS
**/
  UINT8                       FwProgress;

/** Offset 0x0540 - SOL Switch
  Enable/Disable. 0: Disable, 1: enable, Serial Over Lan enable/disable state by Mebx.
  Setting is invalid if AmtEnabled is 0.
  $EN_DIS
**/
  UINT8                       AmtSolEnabled;

/** Offset 0x0541 - Reserved
**/
  UINT8                       Reserved23;

/** Offset 0x0542 - OS Timer
  16 bits Value, Set OS watchdog timer. Setting is invalid if AmtEnabled is 0.
**/
  UINT16                      WatchDogTimerOs;

/** Offset 0x0544 - BIOS Timer
  16 bits Value, Set BIOS watchdog timer. Setting is invalid if AmtEnabled is 0.
**/
  UINT16                      WatchDogTimerBios;

/** Offset 0x0546 - PCH PCIe root port connection type
  0: built-in device, 1:slot
**/
  UINT8                       PcieRpSlotImplemented[29];

/** Offset 0x0563 - PCIE RP Access Control Services Extended Capability
  Enable/Disable PCIE RP Access Control Services Extended Capability
**/
  UINT8                       PcieRpAcsEnabled[29];

/** Offset 0x0580 - PCIE RP Clock Power Management
  Enable/Disable PCIE RP Clock Power Management, even if disabled, CLKREQ# signal
  can still be controlled by L1 PM substates mechanism
**/
  UINT8                       PcieRpEnableCpm[29];

/** Offset 0x059D - Reserved
**/
  UINT8                       Reserved24[3];

/** Offset 0x05A0 - PCIE RP Detect Timeout Ms
  The number of milliseconds within 0~65535 in reference code will wait for link to
  exit Detect state for enabled ports before assuming there is no device and potentially
  disabling the port.
**/
  UINT16                      PcieRpDetectTimeoutMs[29];

/** Offset 0x05DA - ModPHY SUS Power Domain Dynamic Gating
  Enable/Disable ModPHY SUS Power Domain Dynamic Gating. Setting not supported on
  PCH-H. 0: disable, 1: enable
  $EN_DIS
**/
  UINT8                       PmcModPhySusPgEnable;

/** Offset 0x05DB - V1p05-PHY supply external FET control
  Enable/Disable control using EXT_PWR_GATE# pin of external FET to power gate v1p05-PHY
  supply. 0: disable, 1: enable
  $EN_DIS
**/
  UINT8                       PmcV1p05PhyExtFetControlEn;

/** Offset 0x05DC - V1p05-IS supply external FET control
  Enable/Disable control using EXT_PWR_GATE2# pin of external FET to power gate v1p05-IS
  supply. 0: disable, 1: enable
  $EN_DIS
**/
  UINT8                       PmcV1p05IsExtFetControlEn;

/** Offset 0x05DD - Enable/Disable PavpEnable
  Enable(Default): Enable PavpEnable, Disable: Disable PavpEnable
  $EN_DIS
**/
  UINT8                       PavpEnable;

/** Offset 0x05DE - Enable/Disable PeiGraphicsPeimInit
  <b>Enable(Default):</b> FSP will initialize the framebuffer and provide it via EFI_PEI_GRAPHICS_INFO_HOB.
  Disable: FSP will NOT initialize the framebuffer.
  $EN_DIS
**/
  UINT8                       PeiGraphicsPeimInit;

/** Offset 0x05DF - Enable D3 Hot in TCSS
  This policy will enable/disable D3 hot support in IOM
  $EN_DIS
**/
  UINT8                       D3HotEnable;

/** Offset 0x05E0 - Enable or disable GNA device
  0=Disable, 1(Default)=Enable
  $EN_DIS
**/
  UINT8                       GnaEnable;

/** Offset 0x05E1 - Reserved
**/
  UINT8                       Reserved25[3];

/** Offset 0x05E4 - TypeC port GPIO setting
  GPIO Ping number for Type C Aux Oritation setting, use the GpioPad that is defined
  in GpioPinsXXXH.h and GpioPinsXXXLp.h as argument.(XXX is platform name, Ex: Mtl
  = MeteorLake)
**/
  UINT32                      IomTypeCPortPadCfg[12];

/** Offset 0x0614 - CPU USB3 Port Over Current Pin
  Describe the specific over current pin number of USBC Port N.
**/
  UINT8                       CpuUsb3OverCurrentPin[8];

/** Offset 0x061C - Enable D3 Cold in TCSS
  This policy will enable/disable D3 cold support in IOM
  $EN_DIS
**/
  UINT8                       D3ColdEnable;

/** Offset 0x061D - Enable/Disable PCIe tunneling for USB4
  Enable/Disable PCIe tunneling for USB4, default is enable
  $EN_DIS
**/
  UINT8                       ITbtPcieTunnelingForUsb4;

/** Offset 0x061E - Enable/Disable SkipFspGop
  Enable: Skip FSP provided GOP driver, Disable(Default): Use FSP provided GOP driver
  $EN_DIS
**/
  UINT8                       SkipFspGop;

/** Offset 0x061F - Enable/Disable VPU Device
  Enable(Default): Enable VPU Device, Disable: Disable VPU Device
  $EN_DIS
**/
  UINT8                       VpuEnable;

/** Offset 0x0620 - TC State in TCSS
  This TC C-State Limit in IOM
**/
  UINT8                       TcCstateLimit;

/** Offset 0x0621 - Reserved
**/
  UINT8                       Reserved26[3];

/** Offset 0x0624 - Intel Graphics VBT (Video BIOS Table) Size
  Size of Internal Graphics VBT Image
**/
  UINT32                      VbtSize;

/** Offset 0x0628 - Platform LID Status for LFP Displays.
  LFP Display Lid Status (LID_STATUS enum): 0 (Default): LidClosed, 1: LidOpen.
  0: LidClosed, 1: LidOpen
**/
  UINT8                       LidStatus;

/** Offset 0x0629 - Reserved
**/
  UINT8                       Reserved27[8];

/** Offset 0x0631 - Enable VMD controller
  Enable/disable to VMD controller.0: Disable; 1: Enable(Default)
  $EN_DIS
**/
  UINT8                       VmdEnable;

/** Offset 0x0632 - Enable VMD Global Mapping
  Enable/disable to VMD controller.0: Disable(Default); 1: Enable
  $EN_DIS
**/
  UINT8                       VmdGlobalMapping;

/** Offset 0x0633 - Map port under VMD
  Map/UnMap port under VMD
  $EN_DIS
**/
  UINT8                       VmdPort[31];

/** Offset 0x0652 - Reserved
**/
  UINT8                       Reserved28[31];

/** Offset 0x0671 - VMD Port Device
  VMD Root port device number.
**/
  UINT8                       VmdPortDev[31];

/** Offset 0x0690 - VMD Port Func
  VMD Root port function number.
**/
  UINT8                       VmdPortFunc[31];

/** Offset 0x06AF - Reserved
**/
  UINT8                       Reserved29;

/** Offset 0x06B0 - VMD Variable
  VMD Variable Pointer.
**/
  UINT64                      VmdVariablePtr;

/** Offset 0x06B8 - Temporary CfgBar address for VMD
  VMD Variable Pointer.
**/
  UINT32                      VmdCfgBarBase;

/** Offset 0x06BC - Temporary MemBar1 address for VMD
  VMD Variable Pointer.
**/
  UINT32                      VmdMemBar1Base;

/** Offset 0x06C0 - Temporary MemBar2 address for VMD
  VMD Variable Pointer.
**/
  UINT32                      VmdMemBar2Base;

/** Offset 0x06C4 - Reserved
**/
  UINT8                       Reserved30;

/** Offset 0x06C5 - Enable/Disable PMC-PD Solution
  This policy will enable/disable PMC-PD Solution vs EC-TCPC Solution
  $EN_DIS
**/
  UINT8                       PmcPdEnable;

/** Offset 0x06C6 - TCSS Aux Orientation Override Enable
  Bits 0, 2, ... 10 control override enables, bits 1, 3, ... 11 control overrides
**/
  UINT16                      TcssAuxOri;

/** Offset 0x06C8 - TCSS HSL Orientation Override Enable
  Bits 0, 2, ... 10 control override enables, bits 1, 3, ... 11 control overrides
**/
  UINT16                      TcssHslOri;

/** Offset 0x06CA - USB override in IOM
  This policy will enable/disable USB Connect override in IOM
  $EN_DIS
**/
  UINT8                       UsbOverride;

/** Offset 0x06CB - ITBT Root Port Enable
  ITBT Root Port Enable, 0:Disable, 1:Enable
  0:Disable, 1:Enable
**/
  UINT8                       ITbtPcieRootPortEn[4];

/** Offset 0x06CF - TCSS USB Port Enable
  Bits 0, 1, ... max Type C port control enables
**/
  UINT8                       UsbTcPortEn;

/** Offset 0x06D0 - ITBTForcePowerOn Timeout value
  ITBTForcePowerOn value. Specified increment values in miliseconds. Range is 0-1000.
  100 = 100 ms.
**/
  UINT16                      ITbtForcePowerOnTimeoutInMs;

/** Offset 0x06D2 - ITbtConnectTopology Timeout value
  ITbtConnectTopologyTimeout value. Specified increment values in miliseconds. Range
  is 0-10000. 100 = 100 ms.
**/
  UINT16                      ITbtConnectTopologyTimeoutInMs;

/** Offset 0x06D4 - VCCST request for IOM
  This policy will enable/disable VCCST and also decides if message would be replayed in S4/S5
  $EN_DIS
**/
  UINT8                       VccSt;

/** Offset 0x06D5 - Reserved
**/
  UINT8                       Reserved31;

/** Offset 0x06D6 - ITBT DMA LTR
  TCSS DMA1, DMA2 LTR value
**/
  UINT16                      ITbtDmaLtr[2];

/** Offset 0x06DA - Reserved
**/
  UINT8                       Reserved32;

/** Offset 0x06DB - Enable/Disable PTM
  This policy will enable/disable Precision Time Measurement for TCSS PCIe Root Ports
  $EN_DIS
**/
  UINT8                       PtmEnabled[4];

/** Offset 0x06DF - PCIE RP Ltr Enable
  Latency Tolerance Reporting Mechanism.
**/
  UINT8                       SaPcieItbtRpLtrEnable[4];

/** Offset 0x06E3 - PCIE RP Snoop Latency Override Mode
  Latency Tolerance Reporting, Snoop Latency Override Mode.
**/
  UINT8                       SaPcieItbtRpSnoopLatencyOverrideMode[4];

/** Offset 0x06E7 - PCIE RP Snoop Latency Override Multiplier
  Latency Tolerance Reporting, Snoop Latency Override Multiplier.
**/
  UINT8                       SaPcieItbtRpSnoopLatencyOverrideMultiplier[4];

/** Offset 0x06EB - Reserved
**/
  UINT8                       Reserved33;

/** Offset 0x06EC - PCIE RP Snoop Latency Override Value
  Latency Tolerance Reporting, Snoop Latency Override Value.
**/
  UINT16                      SaPcieItbtRpSnoopLatencyOverrideValue[4];

/** Offset 0x06F4 - PCIE RP Non Snoop Latency Override Mode
  Latency Tolerance Reporting, Non-Snoop Latency Override Mode.
**/
  UINT8                       SaPcieItbtRpNonSnoopLatencyOverrideMode[4];

/** Offset 0x06F8 - PCIE RP Non Snoop Latency Override Multiplier
  Latency Tolerance Reporting, Non-Snoop Latency Override Multiplier.
**/
  UINT8                       SaPcieItbtRpNonSnoopLatencyOverrideMultiplier[4];

/** Offset 0x06FC - PCIE RP Non Snoop Latency Override Value
  Latency Tolerance Reporting, Non-Snoop Latency Override Value.
**/
  UINT16                      SaPcieItbtRpNonSnoopLatencyOverrideValue[4];

/** Offset 0x0704 - Force LTR Override
  Force LTR Override.
**/
  UINT8                       SaPcieItbtRpForceLtrOverride[4];

/** Offset 0x0708 - PCIE RP Ltr Config Lock
  0: Disable; 1: Enable.
**/
  UINT8                       SaPcieItbtRpLtrConfigLock[4];

/** Offset 0x070C - Enable or Disable TXT
  Enables utilization of additional hardware capabilities provided by Intel (R) Trusted
  Execution Technology. Changes require a full power cycle to take effect. <b>0:
  Disable</b>, 1: Enable.
  $EN_DIS
**/
  UINT8                       TxtEnable;

/** Offset 0x070D - Reserved
**/
  UINT8                       Reserved34[3];

/** Offset 0x0710 - CpuBistData
  Pointer CPU BIST Data
**/
  UINT64                      CpuBistData;

/** Offset 0x0718 - CpuMpPpi
  <b>Optional</b> pointer to the boot loader's implementation of EFI_PEI_MP_SERVICES_PPI.
  If not NULL, FSP will use the boot loader's implementation of multiprocessing.
  See section 5.1.4 of the FSP Integration Guide for more details.
**/
  UINT64                      CpuMpPpi;

/** Offset 0x0720 - Reserved
**/
  UINT8                       Reserved35[4];

/** Offset 0x0724 - PpinSupport to view Protected Processor Inventory Number
  PPIN Feature Support to view Protected Processor Inventory Number. Disable to turn
  off this feature. When 'PPIN Enable Mode' is selected, this shows second option
  where feature can be enabled based on EOM (End of Manufacturing) flag or it is
  always enabled
  0: Disable, 1: Enable, 2: Auto
**/
  UINT8                       PpinSupport;

/** Offset 0x0725 - Reserved
**/
  UINT8                       Reserved36;

/** Offset 0x0726 - Smbios Type4 Max Speed Override
  Provide the option for platform to override the MaxSpeed field of Smbios Type 4.
  If this value is not zero, it dominates the field.
**/
  UINT16                      SmbiosType4MaxSpeedOverride;

/** Offset 0x0728 - Advanced Encryption Standard (AES) feature
  Enable or Disable Advanced Encryption Standard (AES) feature; </b>0: Disable; <b>1: Enable
  $EN_DIS
**/
  UINT8                       AesEnable;

/** Offset 0x0729 - AvxDisable
  Enable/Disable the AVX and AVX2 Instructions
  0: Enable, 1: Disable
**/
  UINT8                       AvxDisable;

/** Offset 0x072A - Reserved
**/
  UINT8                       Reserved37[58];

/** Offset 0x0764 - Enable Power Optimizer
  Enable DMI Power Optimizer on PCH side.
  $EN_DIS
**/
  UINT8                       PchPwrOptEnable;

/** Offset 0x0765 - PCH Flash Protection Ranges Write Enble
  Write or erase is blocked by hardware.
**/
  UINT8                       PchWriteProtectionEnable[5];

/** Offset 0x076A - PCH Flash Protection Ranges Read Enble
  Read is blocked by hardware.
**/
  UINT8                       PchReadProtectionEnable[5];

/** Offset 0x076F - Reserved
**/
  UINT8                       Reserved38;

/** Offset 0x0770 - PCH Protect Range Limit
  Left shifted address by 12 bits with address bits 11:0 are assumed to be FFFh for
  limit comparison.
**/
  UINT16                      PchProtectedRangeLimit[5];

/** Offset 0x077A - PCH Protect Range Base
  Left shifted address by 12 bits with address bits 11:0 are assumed to be 0.
**/
  UINT16                      PchProtectedRangeBase[5];

/** Offset 0x0784 - Enable Pme
  Enable Azalia wake-on-ring.
  $EN_DIS
**/
  UINT8                       PchHdaPme;

/** Offset 0x0785 - HD Audio Link Frequency
  HDA Link Freq (PCH_HDAUDIO_LINK_FREQUENCY enum): 0: 6MHz, 1: 12MHz, 2: 24MHz.
  0: 6MHz, 1: 12MHz, 2: 24MHz
**/
  UINT8                       PchHdaLinkFrequency;

/** Offset 0x0786 - Enable PCH ISH SPI Cs0 pins assigned
  Set if ISH SPI Cs0 pins are to be enabled by BIOS. 0: Disable; 1: Enable.
**/
  UINT8                       PchIshSpiCs0Enable[1];

/** Offset 0x0787 - Enable PCH Io Apic Entry 24-119
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIoApicEntry24_119;

/** Offset 0x0788 - PCH Io Apic ID
  This member determines IOAPIC ID. Default is 0x02.
**/
  UINT8                       PchIoApicId;

/** Offset 0x0789 - Enable PCH ISH SPI pins assigned
  Set if ISH SPI native pins are to be enabled by BIOS. 0: Disable; 1: Enable.
**/
  UINT8                       PchIshSpiEnable[1];

/** Offset 0x078A - Enable PCH ISH UART pins assigned
  Set if ISH UART native pins are to be enabled by BIOS. 0: Disable; 1: Enable.
**/
  UINT8                       PchIshUartEnable[2];

/** Offset 0x078C - Enable PCH ISH I2C pins assigned
  Set if ISH I2C native pins are to be enabled by BIOS. 0: Disable; 1: Enable.
**/
  UINT8                       PchIshI2cEnable[3];

/** Offset 0x078F - Enable PCH ISH I3C pins assigned
  Set if ISH I3C native pins are to be enabled by BIOS. 0: Disable; 1: Enable.
**/
  UINT8                       PchIshI3cEnable;

/** Offset 0x0790 - Enable PCH ISH GP pins assigned
  Set if ISH GP native pins are to be enabled by BIOS. 0: Disable; 1: Enable.
**/
  UINT8                       PchIshGpEnable[12];

/** Offset 0x079C - PCH ISH PDT Unlock Msg
  0: False; 1: True.
  $EN_DIS
**/
  UINT8                       PchIshPdtUnlock;

/** Offset 0x079D - Reserved
**/
  UINT8                       Reserved39;

/** Offset 0x079E - Enable PCH Lan LTR capabilty of PCH internal LAN
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchLanLtrEnable;

/** Offset 0x079F - Enable LOCKDOWN BIOS LOCK
  Enable the BIOS Lock feature and set EISS bit (D31:F5:RegDCh[5]) for the BIOS region
  protection.
  $EN_DIS
**/
  UINT8                       PchLockDownBiosLock;

/** Offset 0x07A0 - PCH Compatibility Revision ID
  This member describes whether or not the CRID feature of PCH should be enabled.
  $EN_DIS
**/
  UINT8                       PchCrid;

/** Offset 0x07A1 - RTC BIOS Interface Lock
  Enable RTC BIOS interface lock. When set, prevents RTC TS (BUC.TS) from being changed.
  $EN_DIS
**/
  UINT8                       RtcBiosInterfaceLock;

/** Offset 0x07A2 - RTC Cmos Memory Lock
  Enable RTC lower and upper 128 byte Lock bits to lock Bytes 38h-3Fh in the upper
  and and lower 128-byte bank of RTC RAM.
  $EN_DIS
**/
  UINT8                       RtcMemoryLock;

/** Offset 0x07A3 - Enable PCIE RP HotPlug
  Indicate whether the root port is hot plug available.
**/
  UINT8                       PcieRpHotPlug[29];

/** Offset 0x07C0 - Enable PCIE RP Pm Sci
  Indicate whether the root port power manager SCI is enabled.
  $EN_DIS
**/
  UINT8                       PcieRpPmSci[29];

/** Offset 0x07DD - Enable PCIE RP Transmitter Half Swing
  Indicate whether the Transmitter Half Swing is enabled.
**/
  UINT8                       PcieRpTransmitterHalfSwing[29];

/** Offset 0x07FA - Enable PCIE RP Clk Req Detect
  Probe CLKREQ# signal before enabling CLKREQ# based power management.
**/
  UINT8                       PcieRpClkReqDetect[29];

/** Offset 0x0817 - PCIE RP Advanced Error Report
  Indicate whether the Advanced Error Reporting is enabled.
**/
  UINT8                       PcieRpAdvancedErrorReporting[29];

/** Offset 0x0834 - PCIE RP Unsupported Request Report
  Indicate whether the Unsupported Request Report is enabled.
**/
  UINT8                       PcieRpUnsupportedRequestReport[29];

/** Offset 0x0851 - PCIE RP Fatal Error Report
  Indicate whether the Fatal Error Report is enabled.
**/
  UINT8                       PcieRpFatalErrorReport[29];

/** Offset 0x086E - PCIE RP No Fatal Error Report
  Indicate whether the No Fatal Error Report is enabled.
**/
  UINT8                       PcieRpNoFatalErrorReport[29];

/** Offset 0x088B - PCIE RP Correctable Error Report
  Indicate whether the Correctable Error Report is enabled.
**/
  UINT8                       PcieRpCorrectableErrorReport[29];

/** Offset 0x08A8 - PCIE RP System Error On Fatal Error
  Indicate whether the System Error on Fatal Error is enabled.
**/
  UINT8                       PcieRpSystemErrorOnFatalError[29];

/** Offset 0x08C5 - PCIE RP System Error On Non Fatal Error
  Indicate whether the System Error on Non Fatal Error is enabled.
**/
  UINT8                       PcieRpSystemErrorOnNonFatalError[29];

/** Offset 0x08E2 - PCIE RP System Error On Correctable Error
  Indicate whether the System Error on Correctable Error is enabled.
**/
  UINT8                       PcieRpSystemErrorOnCorrectableError[29];

/** Offset 0x08FF - PCIE RP Max Payload
  Max Payload Size supported, Default 256B, see enum PCH_PCIE_MAX_PAYLOAD.
**/
  UINT8                       PcieRpMaxPayload[29];

/** Offset 0x091C - Touch Host Controller Assignment
  Assign THC 0x0:ThcAssignmentNone, 0x1:ThcAssignmentThc0, 0x2:ThcAssignmentThc1
**/
  UINT8                       ThcAssignment[2];

/** Offset 0x091E - Reserved
**/
  UINT8                       Reserved40[122];

/** Offset 0x0998 - PCIE RP Pcie Speed
  Determines each PCIE Port speed capability. 0: Auto; 1: Gen1; 2: Gen2; 3: Gen3 (see:
  PCIE_SPEED).
**/
  UINT8                       PcieRpPcieSpeed[29];

/** Offset 0x09B5 - PCIE RP Physical Slot Number
  Indicates the slot number for the root port. Default is the value as root port index.
**/
  UINT8                       PcieRpPhysicalSlotNumber[29];

/** Offset 0x09D2 - PCIE RP Completion Timeout
  The root port completion timeout(see: PCIE_COMPLETION_TIMEOUT). Default is PchPcieCompletionTO_Default.
**/
  UINT8                       PcieRpCompletionTimeout[29];

/** Offset 0x09EF - PCIE RP Aspm
  The ASPM configuration of the root port (see: PCH_PCIE_ASPM_CONTROL). Default is
  PchPcieAspmAutoConfig.
**/
  UINT8                       PcieRpAspm[29];

/** Offset 0x0A0C - PCIE RP L1 Substates
  The L1 Substates configuration of the root port (see: PCH_PCIE_L1SUBSTATES_CONTROL).
  Default is PchPcieL1SubstatesL1_1_2.
**/
  UINT8                       PcieRpL1Substates[29];

/** Offset 0x0A29 - PCIE RP Ltr Enable
  Latency Tolerance Reporting Mechanism.
**/
  UINT8                       PcieRpLtrEnable[29];

/** Offset 0x0A46 - PCIE RP Ltr Config Lock
  0: Disable; 1: Enable.
**/
  UINT8                       PcieRpLtrConfigLock[29];

/** Offset 0x0A63 - PCIE RP override default settings for EQ
  Choose PCIe EQ method
  $EN_DIS
**/
  UINT8                       PcieEqOverrideDefault[29];

/** Offset 0x0A80 - Reserved
**/
  UINT8                       Reserved41[3767];

/** Offset 0x1937 - PCIE RP Enable Peer Memory Write
  This member describes whether Peer Memory Writes are enabled on the platform.
  $EN_DIS
**/
  UINT8                       PcieEnablePeerMemoryWrite[12];

/** Offset 0x1943 - PCIE Compliance Test Mode
  Compliance Test Mode shall be enabled when using Compliance Load Board.
  $EN_DIS
**/
  UINT8                       PcieComplianceTestMode;

/** Offset 0x1944 - PCIE Rp Function Swap
  Allows BIOS to use root port function number swapping when root port of function
  0 is disabled.
  $EN_DIS
**/
  UINT8                       PcieRpFunctionSwap;

/** Offset 0x1945 - Reserved
**/
  UINT8                       Reserved42;

/** Offset 0x1946 - PCH Pm PME_B0_S5_DIS
  When cleared (default), wake events from PME_B0_STS are allowed in S5 if PME_B0_EN = 1.
  $EN_DIS
**/
  UINT8                       PchPmPmeB0S5Dis;

/** Offset 0x1947 - PCIE IMR
  Enables Isolated Memory Region for PCIe.
  $EN_DIS
**/
  UINT8                       PcieRpImrEnabled;

/** Offset 0x1948 - PCIE IMR port number
  Selects PCIE root port number for IMR feature.
**/
  UINT8                       PcieRpImrSelection;

/** Offset 0x1949 - PCH Pm Wol Enable Override
  Corresponds to the WOL Enable Override bit in the General PM Configuration B (GEN_PMCON_B) register.
  $EN_DIS
**/
  UINT8                       PchPmWolEnableOverride;

/** Offset 0x194A - PCH Pm WoW lan Enable
  Determine if WLAN wake from Sx, corresponds to the HOST_WLAN_PP_EN bit in the PWRM_CFG3 register.
  $EN_DIS
**/
  UINT8                       PchPmWoWlanEnable;

/** Offset 0x194B - Reserved
**/
  UINT8                       Reserved43[4];

/** Offset 0x194F - PCH Pm Slp S3 Min Assert
  SLP_S3 Minimum Assertion Width Policy. Default is PchSlpS350ms.
**/
  UINT8                       PchPmSlpS3MinAssert;

/** Offset 0x1950 - PCH Pm Slp S4 Min Assert
  SLP_S4 Minimum Assertion Width Policy. Default is PchSlpS44s.
**/
  UINT8                       PchPmSlpS4MinAssert;

/** Offset 0x1951 - PCH Pm Slp Sus Min Assert
  SLP_SUS Minimum Assertion Width Policy. Default is PchSlpSus4s.
**/
  UINT8                       PchPmSlpSusMinAssert;

/** Offset 0x1952 - PCH Pm Slp A Min Assert
  SLP_A Minimum Assertion Width Policy. Default is PchSlpA2s.
**/
  UINT8                       PchPmSlpAMinAssert;

/** Offset 0x1953 - USB Overcurrent Override for VISA
  This option overrides USB Over Current enablement state that USB OC will be disabled
  after enabling this option. Enable when VISA pin is muxed with USB OC
  $EN_DIS
**/
  UINT8                       PchEnableDbcObs;

/** Offset 0x1954 - PCH Pm Slp Strch Sus Up
  Enable SLP_X Stretching After SUS Well Power Up.
  $EN_DIS
**/
  UINT8                       PchPmSlpStrchSusUp;

/** Offset 0x1955 - PCH Pm Slp Lan Low Dc
  Enable/Disable SLP_LAN# Low on DC Power.
  $EN_DIS
**/
  UINT8                       PchPmSlpLanLowDc;

/** Offset 0x1956 - PCH Pm Pwr Btn Override Period
  PCH power button override period. 000b-4s, 001b-6s, 010b-8s, 011b-10s, 100b-12s, 101b-14s.
**/
  UINT8                       PchPmPwrBtnOverridePeriod;

/** Offset 0x1957 - PCH Pm Disable Native Power Button
  Power button native mode disable.
  $EN_DIS
**/
  UINT8                       PchPmDisableNativePowerButton;

/** Offset 0x1958 - PCH Pm ME_WAKE_STS
  Clear the ME_WAKE_STS bit in the Power and Reset Status (PRSTS) register.
  $EN_DIS
**/
  UINT8                       PchPmMeWakeSts;

/** Offset 0x1959 - PCH Pm WOL_OVR_WK_STS
  Clear the WOL_OVR_WK_STS bit in the Power and Reset Status (PRSTS) register.
  $EN_DIS
**/
  UINT8                       PchPmWolOvrWkSts;

/** Offset 0x195A - PCH Pm Reset Power Cycle Duration
  Could be customized in the unit of second. Please refer to EDS for all support settings.
  0 is default, 1 is 1 second, 2 is 2 seconds, ...
**/
  UINT8                       PchPmPwrCycDur;

/** Offset 0x195B - PCH Pm Pcie Pll Ssc
  Specifies the Pcie Pll Spread Spectrum Percentage. The default is 0xFF: AUTO - No
  BIOS override.
**/
  UINT8                       PchPmPciePllSsc;

/** Offset 0x195C - PCH Legacy IO Low Latency Enable
  Set to enable low latency of legacy IO. <b>0: Disable</b>, 1: Enable
  $EN_DIS
**/
  UINT8                       PchLegacyIoLowLatency;

/** Offset 0x195D - PCH Sata Pwr Opt Enable
  SATA Power Optimizer on PCH side.
  $EN_DIS
**/
  UINT8                       SataPwrOptEnable;

/** Offset 0x195E - PCH Sata eSATA Speed Limit
  When enabled, BIOS will configure the PxSCTL.SPD to 2 to limit the eSATA port speed.
  $EN_DIS
**/
  UINT8                       EsataSpeedLimit;

/** Offset 0x195F - PCH Sata Speed Limit
  Indicates the maximum speed the SATA controller can support 0h: PchSataSpeedDefault.
**/
  UINT8                       SataSpeedLimit;

/** Offset 0x1960 - Enable SATA Port HotPlug
  Enable SATA Port HotPlug.
**/
  UINT8                       SataPortsHotPlug[8];

/** Offset 0x1968 - Enable SATA Port Interlock Sw
  Enable SATA Port Interlock Sw.
**/
  UINT8                       SataPortsInterlockSw[8];

/** Offset 0x1970 - Enable SATA Port External
  Enable SATA Port External.
**/
  UINT8                       SataPortsExternal[8];

/** Offset 0x1978 - Enable SATA Port SpinUp
  Enable the COMRESET initialization Sequence to the device.
**/
  UINT8                       SataPortsSpinUp[8];

/** Offset 0x1980 - Enable SATA Port Solid State Drive
  0: HDD; 1: SSD.
**/
  UINT8                       SataPortsSolidStateDrive[8];

/** Offset 0x1988 - Enable SATA Port Enable Dito Config
  Enable DEVSLP Idle Timeout settings (DmVal, DitoVal).
**/
  UINT8                       SataPortsEnableDitoConfig[8];

/** Offset 0x1990 - Enable SATA Port DmVal
  DITO multiplier. Default is 15.
**/
  UINT8                       SataPortsDmVal[8];

/** Offset 0x1998 - Reserved
**/
  UINT8                       Reserved44[2];

/** Offset 0x199A - Enable SATA Port DmVal
  DEVSLP Idle Timeout (DITO), Default is 625.
**/
  UINT16                      SataPortsDitoVal[8];

/** Offset 0x19AA - Enable SATA Port ZpOdd
  Support zero power ODD.
**/
  UINT8                       SataPortsZpOdd[8];

/** Offset 0x19B2 - PCH Sata Rst Raid Alternate Id
  Enable RAID Alternate ID.
  $EN_DIS
**/
  UINT8                       SataRstRaidDeviceId;

/** Offset 0x19B3 - PCH Sata Rst Pcie Storage Remap enable
  Enable Intel RST for PCIe Storage remapping.
**/
  UINT8                       SataRstPcieEnable[3];

/** Offset 0x19B6 - PCH Sata Rst Pcie Storage Port
  Intel RST for PCIe Storage remapping - PCIe Port Selection (1-based, 0 = autodetect).
**/
  UINT8                       SataRstPcieStoragePort[3];

/** Offset 0x19B9 - PCH Sata Rst Pcie Device Reset Delay
  PCIe Storage Device Reset Delay in milliseconds. Default value is 100ms
**/
  UINT8                       SataRstPcieDeviceResetDelay[3];

/** Offset 0x19BC - UFS enable/disable
  Enable/Disable UFS controller, One byte for each Controller - (1,0) to enable controller
  0 and (0,1) to enable controller 1
  $EN_DIS
**/
  UINT8                       UfsEnable[2];

/** Offset 0x19BE - Reserved
**/
  UINT8                       Reserved45[2];

/** Offset 0x19C0 - IEH Mode
  Integrated Error Handler Mode, 0: Bypass, 1: Enable
  0: Bypass, 1:Enable
**/
  UINT8                       IehMode;

/** Offset 0x19C1 - Reserved
**/
  UINT8                       Reserved46[11];

/** Offset 0x19CC - PCH Thermal Throttling Custimized T0Level Value
  Custimized T0Level value.
**/
  UINT16                      PchT0Level;

/** Offset 0x19CE - PCH Thermal Throttling Custimized T1Level Value
  Custimized T1Level value.
**/
  UINT16                      PchT1Level;

/** Offset 0x19D0 - PCH Thermal Throttling Custimized T2Level Value
  Custimized T2Level value.
**/
  UINT16                      PchT2Level;

/** Offset 0x19D2 - Enable PCH Thermal Throttle
  Enable thermal throttle function.
  $EN_DIS
**/
  UINT8                       PchTTEnable;

/** Offset 0x19D3 - PCH PMSync State 13
  When set to 1 and the programmed GPIO pin is a 1, then PMSync state 13 will force
  at least T2 state.
  $EN_DIS
**/
  UINT8                       PchTTState13Enable;

/** Offset 0x19D4 - PCH Thermal Throttle Lock
  Thermal Throttle Lock.
  $EN_DIS
**/
  UINT8                       PchTTLock;

/** Offset 0x19D5 - Reserved
**/
  UINT8                       Reserved47[9];

/** Offset 0x19DE - DMI Thermal Sensor Autonomous Width Enable
  DMI Thermal Sensor Autonomous Width Enable.
  $EN_DIS
**/
  UINT8                       PchDmiTsawEn;

/** Offset 0x19DF - DMI Thermal Sensor Suggested Setting
  DMT thermal sensor suggested representative values.
  $EN_DIS
**/
  UINT8                       DmiSuggestedSetting;

/** Offset 0x19E0 - Thermal Sensor 0 Target Width
  Thermal Sensor 0 Target Width.
  0:x1, 1:x2, 2:x4, 3:x8, 4:x16
**/
  UINT8                       DmiTS0TW;

/** Offset 0x19E1 - Thermal Sensor 1 Target Width
  Thermal Sensor 1 Target Width.
  0:x1, 1:x2, 2:x4, 3:x8, 4:x16
**/
  UINT8                       DmiTS1TW;

/** Offset 0x19E2 - Thermal Sensor 2 Target Width
  Thermal Sensor 2 Target Width.
  0:x1, 1:x2, 2:x4, 3:x8, 4:x16
**/
  UINT8                       DmiTS2TW;

/** Offset 0x19E3 - Thermal Sensor 3 Target Width
  Thermal Sensor 3 Target Width.
  0:x1, 1:x2, 2:x4, 3:x8, 4:x16
**/
  UINT8                       DmiTS3TW;

/** Offset 0x19E4 - Port 0 T1 Multipler
  Port 0 T1 Multipler.
**/
  UINT8                       SataP0T1M;

/** Offset 0x19E5 - Port 0 T2 Multipler
  Port 0 T2 Multipler.
**/
  UINT8                       SataP0T2M;

/** Offset 0x19E6 - Port 0 T3 Multipler
  Port 0 T3 Multipler.
**/
  UINT8                       SataP0T3M;

/** Offset 0x19E7 - Port 0 Tdispatch
  Port 0 Tdispatch.
**/
  UINT8                       SataP0TDisp;

/** Offset 0x19E8 - Port 1 T1 Multipler
  Port 1 T1 Multipler.
**/
  UINT8                       SataP1T1M;

/** Offset 0x19E9 - Port 1 T2 Multipler
  Port 1 T2 Multipler.
**/
  UINT8                       SataP1T2M;

/** Offset 0x19EA - Port 1 T3 Multipler
  Port 1 T3 Multipler.
**/
  UINT8                       SataP1T3M;

/** Offset 0x19EB - Port 1 Tdispatch
  Port 1 Tdispatch.
**/
  UINT8                       SataP1TDisp;

/** Offset 0x19EC - Port 0 Tinactive
  Port 0 Tinactive.
**/
  UINT8                       SataP0Tinact;

/** Offset 0x19ED - Port 0 Alternate Fast Init Tdispatch
  Port 0 Alternate Fast Init Tdispatch.
  $EN_DIS
**/
  UINT8                       SataP0TDispFinit;

/** Offset 0x19EE - Port 1 Tinactive
  Port 1 Tinactive.
**/
  UINT8                       SataP1Tinact;

/** Offset 0x19EF - Port 1 Alternate Fast Init Tdispatch
  Port 1 Alternate Fast Init Tdispatch.
  $EN_DIS
**/
  UINT8                       SataP1TDispFinit;

/** Offset 0x19F0 - Sata Thermal Throttling Suggested Setting
  Sata Thermal Throttling Suggested Setting.
  $EN_DIS
**/
  UINT8                       SataThermalSuggestedSetting;

/** Offset 0x19F1 - Reserved
**/
  UINT8                       Reserved48;

/** Offset 0x19F2 - Thermal Device Temperature
  Decides the temperature.
**/
  UINT16                      PchTemperatureHotLevel;

/** Offset 0x19F4 - USB2 Port Over Current Pin
  Describe the specific over current pin number of USB 2.0 Port N.
**/
  UINT8                       Usb2OverCurrentPin[16];

/** Offset 0x1A04 - USB3 Port Over Current Pin
  Describe the specific over current pin number of USB 3.0 Port N.
**/
  UINT8                       Usb3OverCurrentPin[10];

/** Offset 0x1A0E - Enable xHCI LTR override
  Enables override of recommended LTR values for xHCI
  $EN_DIS
**/
  UINT8                       PchUsbLtrOverrideEnable;

/** Offset 0x1A0F - Reserved
**/
  UINT8                       Reserved49;

/** Offset 0x1A10 - xHCI High Idle Time LTR override
  Value used for overriding LTR recommendation for xHCI High Idle Time LTR setting
**/
  UINT32                      PchUsbLtrHighIdleTimeOverride;

/** Offset 0x1A14 - xHCI Medium Idle Time LTR override
  Value used for overriding LTR recommendation for xHCI Medium Idle Time LTR setting
**/
  UINT32                      PchUsbLtrMediumIdleTimeOverride;

/** Offset 0x1A18 - xHCI Low Idle Time LTR override
  Value used for overriding LTR recommendation for xHCI Low Idle Time LTR setting
**/
  UINT32                      PchUsbLtrLowIdleTimeOverride;

/** Offset 0x1A1C - Enable 8254 Static Clock Gating
  Set 8254CGE=1 is required for SLP_S0 support. However, set 8254CGE=1 in POST time
  might fail to boot legacy OS using 8254 timer. Make sure it is disabled to support
  legacy OS using 8254 timer. Also enable this while S0ix is enabled.
  $EN_DIS
**/
  UINT8                       Enable8254ClockGating;

/** Offset 0x1A1D - Enable 8254 Static Clock Gating On S3
  This is only applicable when Enable8254ClockGating is disabled. FSP will do the
  8254 CGE programming on S3 resume when Enable8254ClockGatingOnS3 is enabled. This
  avoids the SMI requirement for the programming.
  $EN_DIS
**/
  UINT8                       Enable8254ClockGatingOnS3;

/** Offset 0x1A1E - Enable TCO timer.
  When FALSE, it disables PCH ACPI timer, and stops TCO timer. NOTE: This will have
  huge power impact when it's enabled. If TCO timer is disabled, uCode ACPI timer
  emulation must be enabled, and WDAT table must not be exposed to the OS.
  $EN_DIS
**/
  UINT8                       EnableTcoTimer;

/** Offset 0x1A1F - Reserved
**/
  UINT8                       Reserved50[9];

/** Offset 0x1A28 - BgpdtHash[4]
  BgpdtHash values
**/
  UINT64                      BgpdtHash[4];

/** Offset 0x1A48 - BiosGuardAttr
  BiosGuardAttr default values
**/
  UINT32                      BiosGuardAttr;

/** Offset 0x1A4C - Reserved
**/
  UINT8                       Reserved51[4];

/** Offset 0x1A50 - BiosGuardModulePtr
  BiosGuardModulePtr default values
**/
  UINT64                      BiosGuardModulePtr;

/** Offset 0x1A58 - SendEcCmd
  SendEcCmd function pointer. \n
  @code typedef EFI_STATUS (EFIAPI *PLATFORM_SEND_EC_COMMAND) (IN EC_COMMAND_TYPE
  EcCmdType, IN UINT8  EcCmd, IN UINT8  SendData, IN OUT UINT8  *ReceiveData); @endcode
**/
  UINT64                      SendEcCmd;

/** Offset 0x1A60 - EcCmdProvisionEav
  Ephemeral Authorization Value default values. Provisions an ephemeral shared secret to the EC
**/
  UINT8                       EcCmdProvisionEav;

/** Offset 0x1A61 - EcCmdLock
  EcCmdLock default values. Locks Ephemeral Authorization Value sent previously
**/
  UINT8                       EcCmdLock;

/** Offset 0x1A62 - Reserved
**/
  UINT8                       Reserved52[22];

/** Offset 0x1A78 - Skip Ssid Programming.
  When set to TRUE, silicon code will not do any SSID programming and platform code
  needs to handle that by itself properly.
  $EN_DIS
**/
  UINT8                       SiSkipSsidProgramming;

/** Offset 0x1A79 - Reserved
**/
  UINT8                       Reserved53;

/** Offset 0x1A7A - Change Default SVID
  Change the default SVID used in FSP to programming internal devices. This is only
  valid when SkipSsidProgramming is FALSE.
**/
  UINT16                      SiCustomizedSvid;

/** Offset 0x1A7C - Change Default SSID
  Change the default SSID used in FSP to programming internal devices. This is only
  valid when SkipSsidProgramming is FALSE.
**/
  UINT16                      SiCustomizedSsid;

/** Offset 0x1A7E - Reserved
**/
  UINT8                       Reserved54[2];

/** Offset 0x1A80 - SVID SDID table Poniter.
  The address of the table of SVID SDID to customize each SVID SDID entry. This is
  only valid when SkipSsidProgramming is FALSE.
**/
  UINT64                      SiSsidTablePtr;

/** Offset 0x1A88 - Number of ssid table.
  SiNumberOfSsidTableEntry should match the table entries created in SiSsidTablePtr.
  This is only valid when SkipSsidProgramming is FALSE.
**/
  UINT16                      SiNumberOfSsidTableEntry;

/** Offset 0x1A8A - USB2 Port Reset Message Enable
  0: Disable USB2 Port Reset Message; 1: Enable USB2 Port Reset Message; This must
  be enable for USB2 Port those are paired with CPU XHCI Port
**/
  UINT8                       PortResetMessageEnable[16];

/** Offset 0x1A9A - SATA RST Interrupt Mode
  Allowes to choose which interrupts will be implemented by SATA controller in RAID mode.
  0:Msix, 1:Msi, 2:Legacy
**/
  UINT8                       SataRstInterrupt;

/** Offset 0x1A9B - Enable PS_ON.
  PS_ON is a new C10 state from the CPU on desktop SKUs that enables a lower power
  target that will be required by the California Energy Commission (CEC). When FALSE,
  PS_ON is to be disabled.
  $EN_DIS
**/
  UINT8                       PsOnEnable;

/** Offset 0x1A9C - Pmc Cpu C10 Gate Pin Enable
  Enable/Disable platform support for CPU_C10_GATE# pin to control gating of CPU VccIO
  and VccSTG rails instead of SLP_S0# pin.
  $EN_DIS
**/
  UINT8                       PmcCpuC10GatePinEnable;

/** Offset 0x1A9D - Pch Dmi Aspm Ctrl
  ASPM configuration on the PCH side of the DMI/OPI Link. Default is <b>PchPcieAspmAutoConfig</b>
  0:Disabled, 1:L0s, 2:L1, 3:L0sL1, 4:Auto
**/
  UINT8                       PchDmiAspmCtrl;

/** Offset 0x1A9E - PchDmiCwbEnable
  Central Write Buffer feature configurable and enabled by default
  $EN_DIS
**/
  UINT8                       PchDmiCwbEnable;

/** Offset 0x1A9F - OS IDLE Mode Enable
  Enable/Disable OS Idle Mode
  $EN_DIS
**/
  UINT8                       PmcOsIdleEnable;

/** Offset 0x1AA0 - S0ix Auto-Demotion
  Enable/Disable the Low Power Mode Auto-Demotion Host Control feature.
  $EN_DIS
**/
  UINT8                       PchS0ixAutoDemotion;

/** Offset 0x1AA1 - Latch Events C10 Exit
  When this bit is set to 1, SLP_S0# entry events in SLP_S0_DEBUG_REGx registers are
  captured on C10 exit (instead of C10 entry which is default)
  $EN_DIS
**/
  UINT8                       PchPmLatchEventsC10Exit;

/** Offset 0x1AA2 - Reserved
**/
  UINT8                       Reserved55[127];

/** Offset 0x1B21 - Enable the write to USB 3.0 TX Output Unique Transition Bit Mode for rate 3
  Enable the write to USB 3.0 TX Output Unique Transition Bit Mode for rate 3, Each
  value in array can be between 0-1. One byte for each port.
**/
  UINT8                       Usb3HsioTxRate3UniqTranEnable[10];

/** Offset 0x1B2B - USB 3.0 TX Output Unique Transition Bit Scale for rate 3
  USB 3.0 TX Output Unique Transition Bit Scale for rate 3, HSIO_TX_DWORD9[6:0], <b>Default
  = 4Ch</b>. One byte for each port.
**/
  UINT8                       Usb3HsioTxRate3UniqTran[10];

/** Offset 0x1B35 - Enable the write to USB 3.0 TX Output Unique Transition Bit Mode for rate 2
  Enable the write to USB 3.0 TX Output Unique Transition Bit Mode for rate 2, Each
  value in array can be between 0-1. One byte for each port.
**/
  UINT8                       Usb3HsioTxRate2UniqTranEnable[10];

/** Offset 0x1B3F - USB 3.0 TX Output Unique Transition Bit Scale for rate 2
  USB 3.0 TX Output Unique Transition Bit Scale for rate 2, HSIO_TX_DWORD9[14:8],
  <b>Default = 4Ch</b>. One byte for each port.
**/
  UINT8                       Usb3HsioTxRate2UniqTran[10];

/** Offset 0x1B49 - Enable the write to USB 3.0 TX Output Unique Transition Bit Mode for rate 1
  Enable the write to USB 3.0 TX Output Unique Transition Bit Mode for rate 1, Each
  value in array can be between 0-1. One byte for each port.
**/
  UINT8                       Usb3HsioTxRate1UniqTranEnable[10];

/** Offset 0x1B53 - USB 3.0 TX Output Unique Transition Bit Scale for rate 1
  USB 3.0 TX Output Unique Transition Bit Scale for rate 1, HSIO_TX_DWORD9[22:16],
  <b>Default = 4Ch</b>. One byte for each port.
**/
  UINT8                       Usb3HsioTxRate1UniqTran[10];

/** Offset 0x1B5D - Enable the write to USB 3.0 TX Output Unique Transition Bit Mode for rate 0
  Enable the write to USB 3.0 TX Output Unique Transition Bit Mode for rate 0, Each
  value in array can be between 0-1. One byte for each port.
**/
  UINT8                       Usb3HsioTxRate0UniqTranEnable[10];

/** Offset 0x1B67 - USB 3.0 TX Output Unique Transition Bit Scale for rate 0
  USB 3.0 TX Output Unique Transition Bit Scale for rate 0, HSIO_TX_DWORD9[30:24],
  <b>Default = 4Ch</b>. One byte for each port.
**/
  UINT8                       Usb3HsioTxRate0UniqTran[10];

/** Offset 0x1B71 - Skip PAM regsiter lock
  Enable: PAM register will not be locked by RC, platform code should lock it, Disable(Default):
  PAM registers will be locked by RC
  $EN_DIS
**/
  UINT8                       SkipPamLock;

/** Offset 0x1B72 - Enable/Disable IGFX RenderStandby
  Enable(Default): Enable IGFX RenderStandby, Disable: Disable IGFX RenderStandby
  $EN_DIS
**/
  UINT8                       RenderStandby;

/** Offset 0x1B73 - Reserved
**/
  UINT8                       Reserved56;

/** Offset 0x1B74 - GT Frequency Limit
  0xFF: Auto(Default), 2: 100 Mhz, 3: 150 Mhz, 4: 200 Mhz, 5: 250 Mhz, 6: 300 Mhz,
  7: 350 Mhz, 8: 400 Mhz, 9: 450 Mhz, 0xA: 500 Mhz, 0xB: 550 Mhz, 0xC: 600 Mhz, 0xD:
  650 Mhz, 0xE: 700 Mhz, 0xF: 750 Mhz, 0x10: 800 Mhz, 0x11: 850 Mhz, 0x12:900 Mhz,
  0x13: 950 Mhz, 0x14: 1000 Mhz, 0x15: 1050 Mhz, 0x16: 1100 Mhz, 0x17: 1150 Mhz,
  0x18: 1200 Mhz
  0xFF: Auto(Default), 2: 100 Mhz, 3: 150 Mhz, 4: 200 Mhz, 5: 250 Mhz, 6: 300 Mhz,
  7: 350 Mhz, 8: 400 Mhz, 9: 450 Mhz, 0xA: 500 Mhz, 0xB: 550 Mhz, 0xC: 600 Mhz, 0xD:
  650 Mhz, 0xE: 700 Mhz, 0xF: 750 Mhz, 0x10: 800 Mhz, 0x11: 850 Mhz, 0x12:900 Mhz,
  0x13: 950 Mhz, 0x14: 1000 Mhz, 0x15: 1050 Mhz, 0x16: 1100 Mhz, 0x17: 1150 Mhz,
  0x18: 1200 Mhz
**/
  UINT8                       GtFreqMax;

/** Offset 0x1B75 - Disable Turbo GT
   0=Disable: GT frequency is not limited, 1=Enable: Disables Turbo GT frequency
  $EN_DIS
**/
  UINT8                       DisableTurboGt;

/** Offset 0x1B76 - Reserved
**/
  UINT8                       Reserved57[2];

/** Offset 0x1B78 - Enable TSN Multi-VC
  Enable/disable Multi Virtual Channels(VC) in TSN.
  $EN_DIS
**/
  UINT8                       PchTsnMultiVcEnable;

/** Offset 0x1B79 - Reserved
**/
  UINT8                       Reserved58[11];

/** Offset 0x1B84 - LogoPixelHeight Address
  Address of LogoPixelHeight
**/
  UINT32                      LogoPixelHeight;

/** Offset 0x1B88 - LogoPixelWidth Address
  Address of LogoPixelWidth
**/
  UINT32                      LogoPixelWidth;

/** Offset 0x1B8C - Reserved
**/
  UINT8                       Reserved59;

/** Offset 0x1B8D - ITbt Usb4CmMode value
  ITbt Usb4CmMode value. 0:Firmware CM, 1:Software CM
**/
  UINT8                       Usb4CmMode;

/** Offset 0x1B8E - Reserved
**/
  UINT8                       Reserved60[75];

/** Offset 0x1BD9 - RSR feature
  Enable or Disable RSR feature; 0: Disable; <b>1: Enable </b>
  $EN_DIS
**/
  UINT8                       EnableRsr;

/** Offset 0x1BDA - Reserved
**/
  UINT8                       Reserved61[4];

/** Offset 0x1BDE - Enable or Disable HWP
  Enable/Disable Intel(R) Speed Shift Technology support. Enabling will expose the
  CPPC v2 interface to allow for hardware controlled P-states. 0: Disable; <b>1:
  Enable;</b>
  $EN_DIS
**/
  UINT8                       Hwp;

/** Offset 0x1BDF - Package Long duration turbo mode time
  Power Limit 1 Time Window value in seconds. The value may vary from 0 to 128. 0
  = default value (28 sec for Mobile and 8 sec for Desktop). Defines time window
  which Processor Base Power (TDP) value should be maintained. Valid values(Unit
  in seconds) 0 to 8 , 10 , 12 ,14 , 16 , 20 , 24 , 28 , 32 , 40 , 48 , 56 , 64 ,
  80 , 96 , 112 , 128
**/
  UINT8                       PowerLimit1Time;

/** Offset 0x1BE0 - Short Duration Turbo Mode
  Enable/Disable Power Limit 2 override. If this option is disabled, BIOS will program
  the default values for Power Limit 2. 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       PowerLimit2;

/** Offset 0x1BE1 - Turbo settings Lock
  Enable/Disable locking of Package Power Limit settings. When enabled, PACKAGE_POWER_LIMIT
  MSR will be locked and a reset will be required to unlock the register. <b>0: Disable;
  </b> 1: Enable
  $EN_DIS
**/
  UINT8                       TurboPowerLimitLock;

/** Offset 0x1BE2 - Package PL3 time window
  Power Limit 3 Time Window value in Milli seconds. Indicates the time window over
  which Power Limit 3 value should be maintained. If the value is 0, BIOS leaves
  the hardware default value. Valid value: <b>0</b>, 3-8, 10, 12, 14, 16, 20, 24,
  28, 32, 40, 48, 56, 64.
**/
  UINT8                       PowerLimit3Time;

/** Offset 0x1BE3 - Package PL3 Duty Cycle
  Specify the duty cycle in percentage that the CPU is required to maintain over the
  configured time window. Range is 0-100.
**/
  UINT8                       PowerLimit3DutyCycle;

/** Offset 0x1BE4 - Package PL3 Lock
  Power Limit 3 Lock. When enabled PL3 configurations are locked during OS. When disabled
  PL3 configuration can be changed during OS. <b>0: Disable</b> ; 1:Enable
  $EN_DIS
**/
  UINT8                       PowerLimit3Lock;

/** Offset 0x1BE5 - Package PL4 Lock
  Power Limit 4 Lock. When enabled PL4 configurations are locked during OS. When disabled
  PL4 configuration can be changed during OS. <b>0: Disable</b> ; 1:Enable
  $EN_DIS
**/
  UINT8                       PowerLimit4Lock;

/** Offset 0x1BE6 - TCC Activation Offset
  TCC Activation Offset. Offset from factory set TCC activation temperature at which
  the Thermal Control Circuit must be activated. TCC will be activated at TCC Activation
  Temperature, in volts. <b>Default = 0h</b>.
**/
  UINT8                       TccActivationOffset;

/** Offset 0x1BE7 - Tcc Offset Clamp Enable/Disable
  Tcc Offset Clamp for Runtime Average Temperature Limit (RATL) allows CPU to throttle
  below P1. <b>0: Disabled</b>; 1: Enabled.
  $EN_DIS
**/
  UINT8                       TccOffsetClamp;

/** Offset 0x1BE8 - Tcc Offset Lock
  Tcc Offset Lock for Runtime Average Temperature Limit (RATL) to lock temperature
  target; <b>0: Disabled</b>; 1: Enabled.
  $EN_DIS
**/
  UINT8                       TccOffsetLock;

/** Offset 0x1BE9 - Custom Ratio State Entries
  The number of custom ratio state entries, ranges from 0 to 40 for a valid custom
  ratio table. Sets the number of custom P-states. At least 2 states must be present
**/
  UINT8                       NumberOfEntries;

/** Offset 0x1BEA - Custom Short term Power Limit time window
  Power Limit 1 Time Window value in seconds. The value may vary from 0 to 128. 0
  = default value (28 sec for Mobile and 8 sec for Desktop). Defines time window
  which Processor Base Power (TDP) value should be maintained.
**/
  UINT8                       Custom1PowerLimit1Time;

/** Offset 0x1BEB - Custom Turbo Activation Ratio
  Custom value for Turbo Activation Ratio. Needs to be configured with valid values
  from LFM to Max Turbo. 0 means don't use custom value. Valid Range 0 to 255
**/
  UINT8                       Custom1TurboActivationRatio;

/** Offset 0x1BEC - Custom Config Tdp Control
  Config Tdp(Base Power) Control (0/1/2) value for custom cTDP(Assured Power) level
  1. Valid Range is 0 to 2
**/
  UINT8                       Custom1ConfigTdpControl;

/** Offset 0x1BED - Custom Short term Power Limit time window
  Power Limit 1 Time Window value in seconds. The value may vary from 0 to 128. 0
  = default value (28 sec for Mobile and 8 sec for Desktop). Defines time window
  which Processor Base Power (TDP) value should be maintained.
**/
  UINT8                       Custom2PowerLimit1Time;

/** Offset 0x1BEE - Custom Turbo Activation Ratio
  Custom value for Turbo Activation Ratio. Needs to be configured with valid values
  from LFM to Max Turbo. 0 means don't use custom value. Valid Range 0 to 255
**/
  UINT8                       Custom2TurboActivationRatio;

/** Offset 0x1BEF - Custom Config Tdp Control
  Config Tdp(Base Power) Control (0/1/2) value for custom cTDP(Assured Power) level
  1. Valid Range is 0 to 2
**/
  UINT8                       Custom2ConfigTdpControl;

/** Offset 0x1BF0 - Custom Short term Power Limit time window
  Power Limit 1 Time Window value in seconds. The value may vary from 0 to 128. 0
  = default value (28 sec for Mobile and 8 sec for Desktop). Defines time window
  which Processor Base Power (TDP) value should be maintained.
**/
  UINT8                       Custom3PowerLimit1Time;

/** Offset 0x1BF1 - Custom Turbo Activation Ratio
  Custom value for Turbo Activation Ratio. Needs to be configured with valid values
  from LFM to Max Turbo. 0 means don't use custom value. Valid Range 0 to 255
**/
  UINT8                       Custom3TurboActivationRatio;

/** Offset 0x1BF2 - Custom Config Tdp Control
  Config Tdp(Base Power) Control (0/1/2) value for custom cTDP(Assured Power) level
  1. Valid Range is 0 to 2
**/
  UINT8                       Custom3ConfigTdpControl;

/** Offset 0x1BF3 - ConfigTdp mode settings Lock
  cTDP(Assured Power) Mode Lock sets the Lock bits on TURBO_ACTIVATION_RATIO and CONFIG_TDP_CONTROL.
  Note: When CTDP(Assured Power) Lock is enabled Custom ConfigTDP Count will be forced
  to 1 and Custom ConfigTDP Boot Index will be forced to 0. <b>0: Disable</b>; 1: Enable
  $EN_DIS
**/
  UINT8                       ConfigTdpLock;

/** Offset 0x1BF4 - Load Configurable TDP SSDT
  Enables cTDP(Assured Power) control via runtime ACPI BIOS methods. This 'BIOS only'
  feature does not require EC or driver support. <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       ConfigTdpBios;

/** Offset 0x1BF5 - PL1 Enable value
  Enable/Disable Platform Power Limit 1 programming. If this option is enabled, it
  activates the PL1 value to be used by the processor to limit the average power
  of given time window. <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       PsysPowerLimit1;

/** Offset 0x1BF6 - PL1 timewindow
  Platform Power Limit 1 Time Window value in seconds. The value may vary from 0 to
  128. 0 = default values. Indicates the time window over which Platform Processor
  Base Power (TDP) value should be maintained. Valid values(Unit in seconds) 0 to
  8 , 10 , 12 ,14 , 16 , 20 , 24 , 28 , 32 , 40 , 48 , 56 , 64 , 80 , 96 , 112 , 128
**/
  UINT8                       PsysPowerLimit1Time;

/** Offset 0x1BF7 - PL2 Enable Value
  Enable/Disable Platform Power Limit 2 programming. If this option is disabled, BIOS
  will program the default values for Platform Power Limit 2. <b>0: Disable</b>;
  1: Enable.
  $EN_DIS
**/
  UINT8                       PsysPowerLimit2;

/** Offset 0x1BF8 - Enable or Disable MLC Streamer Prefetcher
  Enable or Disable MLC Streamer Prefetcher; 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       MlcStreamerPrefetcher;

/** Offset 0x1BF9 - Enable or Disable MLC Spatial Prefetcher
  Enable or Disable MLC Spatial Prefetcher; 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       MlcSpatialPrefetcher;

/** Offset 0x1BFA - Enable or Disable Monitor /MWAIT instructions
  Enable/Disable MonitorMWait, if Disable MonitorMwait, the AP threads Idle Manner
  should not set in MWAIT Loop. 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       MonitorMwaitEnable;

/** Offset 0x1BFB - Enable or Disable initialization of machine check registers
  Enable or Disable initialization of machine check registers; 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       MachineCheckEnable;

/** Offset 0x1BFC - AP Idle Manner of waiting for SIPI
  AP threads Idle Manner for waiting signal to run. 1: HALT loop; <b>2: MWAIT loop</b>;
  3: RUN loop.
  1: HALT loop, 2: MWAIT loop, 3: RUN loop
**/
  UINT8                       ApIdleManner;

/** Offset 0x1BFD - Control on Processor Trace output scheme
  Control on Processor Trace output scheme; <b>0: Single Range Output</b>; 1: ToPA Output.
  0: Single Range Output, 1: ToPA Output
**/
  UINT8                       ProcessorTraceOutputScheme;

/** Offset 0x1BFE - Enable or Disable Processor Trace feature
  Enable or Disable Processor Trace feature; <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       ProcessorTraceEnable;

/** Offset 0x1BFF - Enable or Disable Intel SpeedStep Technology
  Allows more than two frequency ranges to be supported. 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       Eist;

/** Offset 0x1C00 - Enable or Disable Energy Efficient P-state
  Enable/Disable Energy Efficient P-state feature. When set to 0, will disable access
  to ENERGY_PERFORMANCE_BIAS MSR and CPUID Function will read 0 indicating no support
  for Energy Efficient policy setting. When set to 1 will enable access to ENERGY_PERFORMANCE_BIAS
  MSR and CPUID Function will read 1 indicating Energy Efficient policy setting is
  supported. 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       EnergyEfficientPState;

/** Offset 0x1C01 - Enable or Disable Energy Efficient Turbo
  Enable/Disable Energy Efficient Turbo Feature. This feature will opportunistically
  lower the turbo frequency to increase efficiency. Recommended only to disable in
  overclocking situations where turbo frequency must remain constant. Otherwise,
  leave enabled. <b>0: Disable</b>; 1: Enable
  $EN_DIS
**/
  UINT8                       EnergyEfficientTurbo;

/** Offset 0x1C02 - Enable or Disable T states
  Enable or Disable T states; <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       TStates;

/** Offset 0x1C03 - Enable or Disable Bi-Directional PROCHOT#
  Enable or Disable Bi-Directional PROCHOT#; 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       BiProcHot;

/** Offset 0x1C04 - Enable or Disable PROCHOT# signal being driven externally
  Enable or Disable PROCHOT# signal being driven externally; 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       DisableProcHotOut;

/** Offset 0x1C05 - Enable or Disable PROCHOT# Response
  Enable or Disable PROCHOT# Response; <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       ProcHotResponse;

/** Offset 0x1C06 - Enable or Disable VR Thermal Alert
  Enable or Disable VR Thermal Alert; <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       DisableVrThermalAlert;

/** Offset 0x1C07 - Enable or Disable Thermal Reporting
  Enable or Disable Thermal Reporting through ACPI tables; 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       EnableAllThermalFunctions;

/** Offset 0x1C08 - Enable or Disable Thermal Monitor
  Enable or Disable Thermal Monitor; 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       ThermalMonitor;

/** Offset 0x1C09 - Enable or Disable CPU power states (C-states)
  Enable/Disable CPU Power Management. Allows CPU to go to C states when it's not
  100% utilized. 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       Cx;

/** Offset 0x1C0A - Configure C-State Configuration Lock
  Configure MSR to CFG Lock bit. 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       PmgCstCfgCtrlLock;

/** Offset 0x1C0B - Enable or Disable Enhanced C-states
  Enable/Disable C1E. When enabled, CPU will switch to minimum speed when all cores
  enter C-State. 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       C1e;

/** Offset 0x1C0C - Enable or Disable Package Cstate Demotion
  Enable or Disable Package C-State Demotion. 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       PkgCStateDemotion;

/** Offset 0x1C0D - Enable or Disable Package Cstate UnDemotion
  Enable or Disable Package C-State Un-Demotion. 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       PkgCStateUnDemotion;

/** Offset 0x1C0E - Enable or Disable CState-Pre wake
  Disable - to disable the Cstate Pre-Wake. 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       CStatePreWake;

/** Offset 0x1C0F - Enable or Disable TimedMwait Support.
  Enable or Disable TimedMwait Support. <b>0: Disable</b>; 1: Enable
  $EN_DIS
**/
  UINT8                       TimedMwait;

/** Offset 0x1C10 - Enable or Disable IO to MWAIT redirection
  When set, will map IO_read instructions sent to IO registers PMG_IO_BASE_ADDRBASE+offset
  to MWAIT(offset). <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       CstCfgCtrIoMwaitRedirection;

/** Offset 0x1C11 - Set the Max Pkg Cstate
  Maximum Package C State Limit Setting. Cpu Default: Leaves to Factory default value.
  Auto: Initializes to deepest available Package C State Limit. Valid values 0 -
  C0/C1, 1 - C2, 2 - C3, 3 - C6, 4 - C7, 5 - C7S, 6 - C8, 7 - C9, 8 - C10, 254 -
  CPU Default, <b>255 - Auto</b>
**/
  UINT8                       PkgCStateLimit;

/** Offset 0x1C12 - Interrupt Redirection Mode Select
  Interrupt Redirection Mode Select for Logical Interrupts. 0: Fixed priority; 1:
  Round robin; 2: Hash vector; 7: No change.
**/
  UINT8                       PpmIrmSetting;

/** Offset 0x1C13 - Lock prochot configuration
  Lock prochot configuration Enable/Disable; 0: Disable;<b> 1: Enable</b>
  $EN_DIS
**/
  UINT8                       ProcHotLock;

/** Offset 0x1C14 - Configuration for boot TDP selection
  cTDP(Assured Power) Mode as Nominal/Level1/Level2/Deactivate TDP(Base Power) selection.
  Deactivate option will set MSR to Nominal and MMIO to Zero. <b>0: TDP(Base Power)
  Nominal</b>; 1: TDP(Base Power) Down; 2: TDP(Base Power) Up;0xFF : Deactivate
**/
  UINT8                       ConfigTdpLevel;

/** Offset 0x1C15 - Max P-State Ratio
  Maximum P-state ratio to use in the custom P-state table. Valid Range 0 to 0x7F
**/
  UINT8                       MaxRatio;

/** Offset 0x1C16 - P-state ratios for custom P-state table
  P-state ratios for custom P-state table. NumberOfEntries has valid range between
  0 to 40. For no. of P-States supported(NumberOfEntries) , StateRatio[NumberOfEntries]
  are configurable. Valid Range of each entry is 0 to 0x7F
**/
  UINT8                       StateRatio[40];

/** Offset 0x1C3E - P-state ratios for max 16 version of custom P-state table
  P-state ratios for max 16 version of custom P-state table. This table is used for
  OS versions limited to a max of 16 P-States. If the first entry of this table is
  0, or if Number of Entries is 16 or less, then this table will be ignored, and
  up to the top 16 values of the StateRatio table will be used instead. Valid Range
  of each entry is 0 to 0x7F
**/
  UINT8                       StateRatioMax16[16];

/** Offset 0x1C4E - Reserved
**/
  UINT8                       Reserved62[2];

/** Offset 0x1C50 - Package Long duration turbo mode power limit
  Power Limit 1 in Milli Watts. BIOS will round to the nearest 1/8W when programming.
  Value set 120 = 15W. 0 = no custom override. Overclocking SKU: Value must be between
  Max and Min Power Limits. Other SKUs: This value must be between Min Power Limit
  and Processor Base Power (TDP) Limit. If value is 0, BIOS will program Processor
  Base Power (TDP) value. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit. Valid
  Range 0 to 32767.
**/
  UINT32                      PowerLimit1;

/** Offset 0x1C54 - Package Short duration turbo mode power limit
  Power Limit 2 in Milli Watts. BIOS will round to the nearest 1/8W when programming.
  Value set 120 = 15W. If the value is 0, BIOS will program this value as 1.25*Processor
  Base Power (TDP). Processor applies control policies such that the package power
  does not exceed this limit. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.
  Valid Range 0 to 32767.
**/
  UINT32                      PowerLimit2Power;

/** Offset 0x1C58 - Package PL3 power limit
  Power Limit 3 in Milli Watts. BIOS will round to the nearest 1/8W when programming.
  Value set 120 = 15W. XE SKU: Any value can be programmed. Overclocking SKU: Value
  must be between Max and Min Power Limits. Other SKUs: This value must be between
  Min Power Limit and Processor Base Power (TDP) Limit. If the value is 0, BIOS leaves
  the hardware default value. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.
  Valid Range 0 to 32767.
**/
  UINT32                      PowerLimit3;

/** Offset 0x1C5C - Package PL4 power limit
  Power Limit 4 in Milli Watts. BIOS will round to the nearest 1/8W when programming.
  Value set 120 = 15W. If the value is 0, BIOS leaves default value. Units are based
  on POWER_MGMT_CONFIG.CustomPowerUnit. Valid Range 0 to 32767.
**/
  UINT32                      PowerLimit4;

/** Offset 0x1C60 - Reserved
**/
  UINT8                      Reserved63[4];

/** Offset 0x1C64 - Tcc Offset Time Window for RATL
**/
  UINT32                      TccOffsetTimeWindowForRatl;

/** Offset 0x1C68 - Short term Power Limit value for custom cTDP level 1
  Power Limit 1 in Milli Watts. BIOS will round to the nearest 1/8W when programming.
  Value set 120 = 15W. 0 = no custom override. Overclocking SKU: Value must be between
  Max and Min Power Limits. Other SKUs: This value must be between Min Power Limit
  and Processor Base Power (TDP) Limit. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.
  Valid Range 0 to 32767.
**/
  UINT32                      Custom1PowerLimit1;

/** Offset 0x1C6C - Long term Power Limit value for custom cTDP level 1
  Power Limit 2 value in Milli Watts. BIOS will round to the nearest 1/8W when programming.
  Value set 120 = 15W. 0 = no custom override. Processor applies control policies
  such that the package power does not exceed this limit. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.
  Valid Range 0 to 32767.
**/
  UINT32                      Custom1PowerLimit2;

/** Offset 0x1C70 - Short term Power Limit value for custom cTDP level 2
  Power Limit 1 in Milli Watts. BIOS will round to the nearest 1/8W when programming.
  Value set 120 = 15W. 0 = no custom override. Overclocking SKU: Value must be between
  Max and Min Power Limits. Other SKUs: This value must be between Min Power Limit
  and Processor Base Power (TDP) Limit. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.
  Valid Range 0 to 32767.
**/
  UINT32                      Custom2PowerLimit1;

/** Offset 0x1C74 - Long term Power Limit value for custom cTDP level 2
  Power Limit 2 value in Milli Watts. BIOS will round to the nearest 1/8W when programming.
  Value set 120 = 15W. 0 = no custom override. Processor applies control policies
  such that the package power does not exceed this limit. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.
  Valid Range 0 to 32767.
**/
  UINT32                      Custom2PowerLimit2;

/** Offset 0x1C78 - Short term Power Limit value for custom cTDP level 3
  Power Limit 1 in Milli Watts. BIOS will round to the nearest 1/8W when programming.
  Value set 120 = 15W. 0 = no custom override. Overclocking SKU: Value must be between
  Max and Min Power Limits. Other SKUs: This value must be between Min Power Limit
  and Processor Base Power (TDP) Limit. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.
  Valid Range 0 to 32767.
**/
  UINT32                      Custom3PowerLimit1;

/** Offset 0x1C7C - Long term Power Limit value for custom cTDP level 3
  Power Limit 2 value in Milli Watts. BIOS will round to the nearest 1/8W when programming.
  Value set 120 = 15W. 0 = no custom override. Processor applies control policies
  such that the package power does not exceed this limit. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.
  Valid Range 0 to 32767.
**/
  UINT32                      Custom3PowerLimit2;

/** Offset 0x1C80 - Platform PL1 power
  Platform Power Limit 1 Power in Milli Watts. BIOS will round to the nearest 1/8W
  when programming. Value set 120 = 15W. Any value can be programmed between Max
  and Min Power Limits. This setting will act as the new PL1 value for the Package
  RAPL algorithm. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit. Valid Range
  0 to 32767.
**/
  UINT32                      PsysPowerLimit1Power;

/** Offset 0x1C84 - Platform PL2 power
  Platform Power Limit 2 Power in Milli Watts. BIOS will round to the nearest 1/8W
  when programming. Value set 120 = 15W. Any value can be programmed between Max
  and Min Power Limits. This setting will act as the new Max Turbo Power (PL2) value
  for the Package RAPL algorithm. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.
  Valid Range 0 to 32767.
**/
  UINT32                      PsysPowerLimit2Power;

/** Offset 0x1C88 - Reserved
**/
  UINT8                       Reserved64;

/** Offset 0x1C89 - Race To Halt
  Enable/Disable Race To Halt feature. RTH will dynamically increase CPU frequency
  in order to enter pkg C-State faster to reduce overall power. 0: Disable; <b>1:
  Enable</b>
  $EN_DIS
**/
  UINT8                       RaceToHalt;

/** Offset 0x1C8A - Reserved
**/
  UINT8                       Reserved65;

/** Offset 0x1C8B - Set HW P-State Interrupts Enabled for for MISC_PWR_MGMT
  Set HW P-State Interrupts Enabled for for MISC_PWR_MGMT; <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       HwpInterruptControl;

/** Offset 0x1C8C - Reserved
**/
  UINT8                       Reserved66[4];

/** Offset 0x1C90 - Enable or Disable C1 Cstate Demotion
  Enable or Disable C1 Cstate Auto Demotion. Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       C1StateAutoDemotion;

/** Offset 0x1C91 - Enable or Disable C1 Cstate UnDemotion
  Enable or Disable C1 Cstate Un-Demotion. Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       C1StateUnDemotion;

/** Offset 0x1C92 - Minimum Ring ratio limit override
  Minimum Ring ratio limit override. <b>0: Hardware defaults.</b> Range: 0 - Max turbo
  ratio limit
**/
  UINT8                       MinRingRatioLimit;

/** Offset 0x1C93 - Maximum Ring ratio limit override
  Maximum Ring ratio limit override. <b>0: Hardware defaults.</b> Range: 0 - Max turbo
  ratio limit
**/
  UINT8                       MaxRingRatioLimit;

/** Offset 0x1C94 - Enable or Disable Per Core P State OS control
  Enable/Disable Per Core P state OS control mode. When set, the highest core request
  is used for all other core requests. 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       EnablePerCorePState;

/** Offset 0x1C95 - Enable or Disable HwP Autonomous Per Core P State OS control
  Disable Autonomous PCPS Autonomous will request the same value for all cores all
  the time. 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       EnableHwpAutoPerCorePstate;

/** Offset 0x1C96 - Enable or Disable HwP Autonomous EPP Grouping
  Enable EPP grouping Autonomous will request the same values for all cores with same
  EPP. Disable EPP grouping autonomous will not necessarily request same values for
  all cores with same EPP. <b> 0: Disable </b>; 1: Enable
  $EN_DIS
**/
  UINT8                       EnableHwpAutoEppGrouping;

/** Offset 0x1C97 - Enable Configurable TDP
  Applies cTDP(Assured Power) initialization settings based on non-cTDP(Assured Power)
  or cTDP(Assured Power). Default is 1: Applies to cTDP(Assured Power); if 0 then
  applies non-cTDP(Assured Power) and BIOS will bypass cTDP(Assured Power) initialzation flow
  $EN_DIS
**/
  UINT8                       ApplyConfigTdp;

/** Offset 0x1C98 - Reserved
**/
  UINT8                       Reserved67;

/** Offset 0x1C99 - Dual Tau Boost
  Enable Dual Tau Boost feature. This is only applicable for Desktop 35W/65W/125W
  sku. When DPTF is enabled this feature is ignored. <b>0: Disable</b>; 1: Enable
  $EN_DIS
**/
  UINT8                       DualTauBoost;

/** Offset 0x1C9A - Reserved
**/
  UINT8                       Reserved68[34];

/** Offset 0x1CBC - End of Post message
  Test, Send End of Post message. Disable(0x0): Disable EOP message, Send in PEI(0x1):
  EOP send in PEI, Send in DXE(0x2)(Default): EOP send in DXE
  0:Disable, 1:Send in PEI, 2:Send in DXE, 3:Reserved
**/
  UINT8                       EndOfPostMessage;

/** Offset 0x1CBD - D0I3 Setting for HECI Disable
  Test, 0: disable, 1: enable, Setting this option disables setting D0I3 bit for all
  HECI devices
  $EN_DIS
**/
  UINT8                       DisableD0I3SettingForHeci;

/** Offset 0x1CBE - Mctp Broadcast Cycle
  Test, Determine if MCTP Broadcast is enabled <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       MctpBroadcastCycle;

/** Offset 0x1CBF - ME Unconfig on RTC clear
  0: Disable ME Unconfig On Rtc Clear. <b>1: Enable ME Unconfig On Rtc Clear</b>.
  2: Cmos is clear, status unkonwn. 3: Reserved
  0: Disable ME Unconfig On Rtc Clear, 1: Enable ME Unconfig On Rtc Clear, 2: Cmos
  is clear, 3: Reserved
**/
  UINT8                       MeUnconfigOnRtcClear;

/** Offset 0x1CC0 - Enforce Enhanced Debug Mode
  Determine if ME should enter Enhanced Debug Mode. <b>0: disable</b>, 1: enable
  $EN_DIS
**/
  UINT8                       EnforceEDebugMode;

/** Offset 0x1CC1 - Reserved
**/
  UINT8                       Reserved69[17];

/** Offset 0x1CD2 - Enable LOCKDOWN SMI
  Enable SMI_LOCK bit to prevent writes to the Global SMI Enable bit.
  $EN_DIS
**/
  UINT8                       PchLockDownGlobalSmi;

/** Offset 0x1CD3 - Enable LOCKDOWN BIOS Interface
  Enable BIOS Interface Lock Down bit to prevent writes to the Backup Control Register.
  $EN_DIS
**/
  UINT8                       PchLockDownBiosInterface;

/** Offset 0x1CD4 - Unlock all GPIO pads
  Force all GPIO pads to be unlocked for debug purpose.
  $EN_DIS
**/
  UINT8                       PchUnlockGpioPads;

/** Offset 0x1CD5 - PCH Unlock SideBand access
  The SideBand PortID mask for certain end point (e.g. PSFx) will be locked before
  3rd party code execution. 0: Lock SideBand access; 1: Unlock SideBand access.
  $EN_DIS
**/
  UINT8                       PchSbAccessUnlock;

/** Offset 0x1CD6 - Reserved
**/
  UINT8                       Reserved70[2];

/** Offset 0x1CD8 - PCIE RP Ltr Max Snoop Latency
  Latency Tolerance Reporting, Max Snoop Latency.
**/
  UINT16                      PcieRpLtrMaxSnoopLatency[29];

/** Offset 0x1D12 - PCIE RP Ltr Max No Snoop Latency
  Latency Tolerance Reporting, Max Non-Snoop Latency.
**/
  UINT16                      PcieRpLtrMaxNoSnoopLatency[29];

/** Offset 0x1D4C - PCIE RP Snoop Latency Override Mode
  Latency Tolerance Reporting, Snoop Latency Override Mode.
**/
  UINT8                       PcieRpSnoopLatencyOverrideMode[29];

/** Offset 0x1D69 - PCIE RP Snoop Latency Override Multiplier
  Latency Tolerance Reporting, Snoop Latency Override Multiplier.
**/
  UINT8                       PcieRpSnoopLatencyOverrideMultiplier[29];

/** Offset 0x1D86 - PCIE RP Snoop Latency Override Value
  Latency Tolerance Reporting, Snoop Latency Override Value.
**/
  UINT16                      PcieRpSnoopLatencyOverrideValue[29];

/** Offset 0x1DC0 - PCIE RP Non Snoop Latency Override Mode
  Latency Tolerance Reporting, Non-Snoop Latency Override Mode.
**/
  UINT8                       PcieRpNonSnoopLatencyOverrideMode[29];

/** Offset 0x1DDD - PCIE RP Non Snoop Latency Override Multiplier
  Latency Tolerance Reporting, Non-Snoop Latency Override Multiplier.
**/
  UINT8                       PcieRpNonSnoopLatencyOverrideMultiplier[29];

/** Offset 0x1DFA - PCIE RP Non Snoop Latency Override Value
  Latency Tolerance Reporting, Non-Snoop Latency Override Value.
**/
  UINT16                      PcieRpNonSnoopLatencyOverrideValue[29];

/** Offset 0x1E34 - PCIE RP Slot Power Limit Scale
  Specifies scale used for slot power limit value. Leave as 0 to set to default.
**/
  UINT8                       PcieRpSlotPowerLimitScale[29];

/** Offset 0x1E51 - Reserved
**/
  UINT8                       Reserved71;

/** Offset 0x1E52 - PCIE RP Slot Power Limit Value
  Specifies upper limit on power supplie by slot. Leave as 0 to set to default.
**/
  UINT16                      PcieRpSlotPowerLimitValue[29];

/** Offset 0x1E8C - PCIE RP Enable Port8xh Decode
  This member describes whether PCIE root port Port 8xh Decode is enabled. 0: Disable;
  1: Enable.
  $EN_DIS
**/
  UINT8                       PcieEnablePort8xhDecode;

/** Offset 0x1E8D - PCIE Port8xh Decode Port Index
  The Index of PCIe Port that is selected for Port8xh Decode (0 Based).
**/
  UINT8                       PchPciePort8xhDecodePortIndex;

/** Offset 0x1E8E - PCH Energy Reporting
  Disable/Enable PCH to CPU energy report feature.
  $EN_DIS
**/
  UINT8                       PchPmDisableEnergyReport;

/** Offset 0x1E8F - PCH Sata Test Mode
  Allow entrance to the PCH SATA test modes.
  $EN_DIS
**/
  UINT8                       SataTestMode;

/** Offset 0x1E90 - PCH USB OverCurrent mapping lock enable
  If this policy option is enabled then BIOS will program OCCFDONE bit in xHCI meaning
  that OC mapping data will be consumed by xHCI and OC mapping registers will be locked.
  $EN_DIS
**/
  UINT8                       PchXhciOcLock;

/** Offset 0x1E91 - Low Power Mode Enable/Disable config mask
  Configure if respective S0i2/3 sub-states are to be supported. Each bit corresponds
  to one sub-state (LPMx - BITx): LPM0-s0i2.0, LPM1-s0i2.1, LPM2-s0i2.2, LPM3-s0i3.0,
  LPM4-s0i3.1, LPM5-s0i3.2, LPM6-s0i3.3, LPM7-s0i3.4.
**/
  UINT8                       PmcLpmS0ixSubStateEnableMask;

/** Offset 0x1E92 - Reserved
**/
  UINT8                       Reserved72[105];

/** Offset 0x1EFB - PMC C10 dynamic threshold dajustment enable
  Set if you want to enable PMC C10 dynamic threshold adjustment. Only works on supported SKUs
  $EN_DIS
**/
  UINT8                       PmcC10DynamicThresholdAdjustment;

/** Offset 0x1EFC - Reserved
**/
  UINT8                       Reserved73[68];
} FSP_S_CONFIG;

/** Fsp S UPD Configuration
**/
typedef struct {

/** Offset 0x0000
**/
  FSP_UPD_HEADER              FspUpdHeader;

/** Offset 0x0020
**/
  FSPS_ARCH2_UPD              FspsArchUpd;

/** Offset 0x0040
**/
  FSP_S_CONFIG                FspsConfig;

/** Offset 0x1F40
**/
  UINT8                       Rsvd600[6];

/** Offset 0x1F46
**/
  UINT16                      UpdTerminator;
} FSPS_UPD;

#pragma pack()

#endif
