/* $Id$ 
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __TYPE_HPP_INCLUDED
#define __TYPE_HPP_INCLUDED

#include <string>
#include <list>
#include "intermediate/container/TypeElement.hpp"

namespace intermediate {

//! declaration of a type
/** 
 * TYPE foo : bar[20];
 * TYPE bar : universal_integer := -1, universal_integer := -5, 
 * 	      universal_real := 3.14, foobar;
 */
class Type : public Node {
private:
	friend class TypeFactory;
	
	//! c'tor
	/** @param typeName declared name of the type.
	 *  @param relements list of elements of a composite type.
	 */
	Type(
		std::string typeName, 
		std::list<TypeElement*> relements
		) :	name(typeName),
			elements(relements) {}
public:
	//! Accept a Visitor.
 	/** All intermediate code nodes need to implement this method.
         *
         *  @param v the Visitor that can visit this node.
         */
	virtual void accept(Visitor& v) {
		v.visit(*this);
	}

	/** name of the declared type */
	std::string name;

	/** list of elements for composite types, or one element for
	 *  non-composite types. */
	std::list<TypeElement*> elements;
};

}; /* namespace intermediate */

#endif /* __TYPE_HPP_INCLUDED */
