/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * gnome-scan
 * Copyright (C) Étienne Bersac 2007 <bersace03@laposte.net>
 * 
 * gnome-scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * gnome-scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with gnome-scan.  If not, write to:
 * 	The Free Software Foundation, Inc.,
 * 	51 Franklin Street, Fifth Floor
 * 	Boston, MA  02110-1301, USA.
 */

#ifndef _GNOME_SCAN_PREVIEW_PLUGIN_H_
#define _GNOME_SCAN_PREVIEW_PLUGIN_H_

#include <gtk/gtk.h>
#include <cairo.h>
#include "gnome-scan-plugin.h"
#include "gnome-scan-job.h"

G_BEGIN_DECLS

#define GNOME_TYPE_SCAN_PREVIEW_PLUGIN             (gnome_scan_preview_plugin_get_type ())
#define GNOME_SCAN_PREVIEW_PLUGIN(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_TYPE_SCAN_PREVIEW_PLUGIN, GnomeScanPreviewPlugin))
#define GNOME_SCAN_PREVIEW_PLUGIN_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_TYPE_SCAN_PREVIEW_PLUGIN, GnomeScanPreviewPluginClass))
#define GNOME_IS_SCAN_PREVIEW_PLUGIN(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_TYPE_SCAN_PREVIEW_PLUGIN))
#define GNOME_IS_SCAN_PREVIEW_PLUGIN_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_TYPE_SCAN_PREVIEW_PLUGIN))
#define GNOME_SCAN_PREVIEW_PLUGIN_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_TYPE_SCAN_PREVIEW_PLUGIN, GnomeScanPreviewPluginClass))

/* max param to watch per plugin */
#define	GSPP_MAX_WATCH	4

/**
 * GS_DEFINE_PREVIEW_PLUGIN:
 * @Name:		Class name
 * @name:		function prefix
 * @options:	options to watch.
 *
 * Generate glib boiler plate code for creatin a new preview plugin.
 **/
#define	GS_DEFINE_PREVIEW_PLUGIN(Name, name, options)							\
	static void	name##_class_init (GnomeScanPreviewPluginClass *klass);	\
	static void	name##_init (GnomeScanPreviewPlugin *gspp);				\
	static void	name##_finalize	(GnomeScanPreviewPlugin *gspp);			\
	static void	name##_build_ui (GnomeScanPreviewPlugin *gspp, GtkBox *box); \
	static void	name##_draw_buffer (GnomeScanPreviewPlugin *gspp, GtkWidget *gspa, cairo_t *cr); \
	static void	name##_changed (GnomeScanPreviewPlugin *gspp);			\
	GType name##_get_type () {											\
		static GType 				type;								\
		if (type == 0) {												\
			static GnomeScanPreviewPluginTypeInfo info = {				\
				sizeof (Name),											\
				.class_init	= (GClassInitFunc) name##_class_init,		\
				.init		= (GInstanceInitFunc) name##_init,			\
			};															\
			type = gnome_scan_preview_plugin_type_register_static (#Name, &info); \
		}																\
		return type;													\
	}																	\
	static void name##_class_init (GnomeScanPreviewPluginClass *klass) { \
		GnomeScanPreviewPluginClass *parent_class = GNOME_SCAN_PREVIEW_PLUGIN_CLASS (klass); \
		parent_class->init			= name##_init;							\
		parent_class->build_ui		= name##_build_ui;						\
		parent_class->draw_buffer	= name##_draw_buffer;					\
		parent_class->changed	   	= name##_changed;						\
		parent_class->finalize		= name##_finalize;						\
		parent_class->watch			= g_strsplit(options, ",", GSPP_MAX_WATCH);			\
	}



typedef struct _GnomeScanPreviewPluginTypeInfo GnomeScanPreviewPluginTypeInfo;
struct _GnomeScanPreviewPluginTypeInfo
{
	guint					instance_size;
	GClassInitFunc			class_init;
	GInstanceInitFunc		init;
};


typedef struct _GnomeScanPreviewPluginClass GnomeScanPreviewPluginClass;
typedef struct _GnomeScanPreviewPlugin GnomeScanPreviewPlugin;

struct _GnomeScanPreviewPluginClass
{
	GTypeClass		parent_class;
	
	void	(*init)			(GnomeScanPreviewPlugin *gspp);
	void	(*build_ui)		(GnomeScanPreviewPlugin *gspp,
							 GtkBox *box);
	void	(*draw_buffer)	(GnomeScanPreviewPlugin *gspp,
							 GtkWidget *gspa,
							 cairo_t *cr);
	void	(*changed)		(GnomeScanPreviewPlugin *gspp);
	void	(*finalize)		(GnomeScanPreviewPlugin *gspp);
	
	gchar**	watch;
};

/**
 * GnomeScanPreviewPlugin:
 *
 * 
 **/
struct _GnomeScanPreviewPlugin
{
	/*< private >*/
	GTypeInstance		instance;
	
	/*< public >*/
	GnomeScanPlugin*	plugin;
	GtkWidget*			preview_area;
	GnomeScanSettings*	settings;
	GParamSpec*			pspec;
	gulong				settings_changed;
	gulong				preview_changed;
	gboolean			frozen;
};

GType gnome_scan_preview_plugin_get_type (void) G_GNUC_CONST;

GnomeScanPreviewPlugin*
gnome_scan_preview_plugin								(GType type,
														 GnomeScanPlugin *plugin,
														 GParamSpec *pspec,
														 GtkWidget *gspa,
														 GnomeScanSettings *settings,
														 GtkBox *bbox);
void	gnome_scan_preview_plugin_freeze				(GnomeScanPreviewPlugin *gspp);
void	gnome_scan_preview_plugin_thaw					(GnomeScanPreviewPlugin *gspp);
void	gnome_scan_preview_plugin_changed				(GnomeScanPreviewPlugin *gspp);
void	gnome_scan_preview_plugin_draw_buffer			(GnomeScanPreviewPlugin *gspp,
														 GtkWidget *gspa,
														 cairo_t *cr);
void	gnome_scan_preview_plugin_destroy				(GnomeScanPreviewPlugin *gspp);
GType	gnome_scan_preview_plugin_type_register_static	(const gchar *name,
														 const GnomeScanPreviewPluginTypeInfo *pinfo);


	G_END_DECLS

#endif /* _GNOME_SCAN_PREVIEW_PLUGIN_H_ */
