/* Gnome Scan - Scan as easy as you print
 * Copyright © 2007  Étienne Bersac <bersace03@laposte.net>
 *
 * Gnome Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * gnome-scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with gnome-scan.  If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

/**
 * SECTION: gnome-scan-sink
 * @short_description: Plug scan output to application
 * @include: gnome-scan.h
 *
 * Sink is the last stage of the acquisition process. It handle the
 * scan output and plug it into the application. e.g. do OCR and put
 * into document, add image as layer, etc.
 *
 * In the future, #GnomeScanSink should be replace or just herit from
 * #GeglOperation.
 **/

#include "gnome-scan-sink.h"


static GObjectClass* parent_class = NULL;

G_DEFINE_TYPE (GnomeScanSink, gnome_scan_sink, GNOME_TYPE_SCAN_PLUGIN);

static void
gnome_scan_sink_init (GnomeScanSink *object)
{
	/* TODO: Add initialization code here */
}

static void
gnome_scan_sink_finalize (GObject *object)
{
	/* TODO: Add deinitalization code here */

	G_OBJECT_CLASS (parent_class)->finalize (object);
}

static void
gnome_scan_sink_class_init (GnomeScanSinkClass *klass)
{
	GObjectClass* object_class = G_OBJECT_CLASS (klass);
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));

	object_class->finalize = gnome_scan_sink_finalize;
}

