/* Copyright (C) LinBox
 *
 * using generic testBlackbox  -bds
 *
 *
 * ========LICENCE========
 * This file is part of the library LinBox.
 *
  * LinBox is free software: you can redistribute it and/or modify
 * it under the terms of the  GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 * ========LICENCE========
 */


/*! @file  tests/test-companion.C
 * @ingroup tests
 * @brief  no doc
 * @test NO DOC
 */




#include "linbox/linbox-config.h"

#include <iostream>
#include <fstream>


#include "linbox/ring/modular.h"
#include "linbox/blackbox/companion.h"
#include "linbox/matrix/matrix-domain.h"

#include "test-blackbox.h"

using namespace LinBox;

int main (int argc, char **argv)
{
	bool pass = true;

	static size_t n = 10;
	static size_t q = 101;
	static int iterations = 1; // was 10

	static Argument args[] = {
		{ 'n', "-n N", "Set dimension of test matrices to NxN.",        TYPE_INT,     &n },
		{ 'q', "-q Q", "Operate over the \"field\" GF(Q) [1].", TYPE_INT, &q },
		{ 'i', "-i I", "Perform each test for I iterations.",          TYPE_INT,     &iterations },
		END_OF_ARGUMENTS
	};

	parseArguments (argc, argv, args);

	srand ((unsigned int) time (NULL));

	commentator().start("Companion matrix black box test suite", "companion");

	typedef Givaro::Modular<int32_t> Field;
	// typedef vector <Field::Element> Vector;
	typedef vector <Field::Element> Polynomial;
	typedef Companion<Field> Blackbox;

	Field F (q);
	//Field F ((int32_t)q);
	// no fail at q = 50000, intermitent at q = 55000
	if (q > Field::maxCardinality()) {std::cout<<"NO NO"<<std::endl; exit(-1);}
	Field::Element d;
	F.assign(d, F.mOne);
	Polynomial p(n+1, d);
	F.assign (d, F.one); F.assign(p[n], d);

	// cstor from poly
	Blackbox A (F, p);
	pass = pass && testBlackboxNoRW(A); // no RW yet

	// cstor using own randiter
	Blackbox B (F, n);
	pass = pass && testBlackboxNoRW(B); // no RW yet

	Field::RandIter r(F);

	// cstor from randiter
	Blackbox C (F, n, r);
	pass = pass && testBlackboxNoRW(C); // no RW yet

	commentator().stop("companion matrix black box test suite");

	return pass ? 0 : -1;
}

// Local Variables:
// mode: C++
// tab-width: 4
// indent-tabs-mode: nil
// c-basic-offset: 4
// End:
// vim:sts=4:sw=4:ts=4:et:sr:cino=>s,f0,{0,g0,(0,\:0,t0,+0,=s
