import QtQuick
import QtQuick.Controls
import PappsoMS 1.0

ApplicationWindow {
    width: 400
    height: 400
    visible: true
    title: "MzIntegrationParams QML Test"


    MzIntegrationParams {
        id: params
        smallestMz : 40
        greatestMz : 1200

        onSmallestMzChanged: console.log("QML onSmallestMzChanged signal!")

        Component.onCompleted: {
            console.log("Property test for MzIntegrationParams:",
                typeof params.smallestMz,
                params.smallestMz);

            Qt.callLater(() => {
                params.smallestMz = 123.456; // Test async setter
            });
        }
    }

    MzIntegrationParams {
        id: params_new
        smallestMz : params.smallestMz +10
        greatestMz : params.greatestMz +20

        onSmallestMzChanged: console.log("new QML onSmallestMzChanged signal!")

        Component.onCompleted: {
            console.log("Property test for MzIntegrationParams:",
                typeof params_new.smallestMz,
                params_new.smallestMz);
            }
        }

    // --- Test 2: Bind properties to UI elements ---
    Column {
        anchors.centerIn: parent
        spacing: 10

        Text {
            text: `Initial smallestMz/greatestMz Value: (${params.smallestMz}, ${params.greatestMz})`
            color: "green"
        }

        // --- Test 3: Modify properties dynamically ---
        Button {
            text: "Randomize MzIntegrationParams"
            onClicked: {
                params.smallestMz = Math.random() * 100;
                params.greatestMz = Math.random() * 100;
            }
        }

        // --- Test 4: Verify property bindings ---
        Text {
            text: `Current params Values: (${params.smallestMz}, ${params.greatestMz})`
            color: params.smallestMz > 50 ? "red" : "blue"  // Binding test
        }
        Text {
            text: `Current params new Values: (${params_new.smallestMz}, ${params_new.greatestMz})`
            color: params_new.smallestMz > 50 ? "red" : "blue"  // Binding test
        }

        // --- Test 5: Log changes (verify signals) ---
        Connections {
            target: params
            function onXChanged() {
                console.log("X changed to:", params.smallestMz);
            }
            function onYChanged() {
                console.log("Y changed to:", params.greatestMz);
            }
        }

        // --- Test 5: Log changes (verify signals) ---
        Connections {
            target: params_new
            function onXChanged() {
                console.log("new X changed to:", params_new.smallestMz);
            }
            function onYChanged() {
                console.log("new Y changed to:", params_new.greatestMz);
            }
        }
    }
}
