; APX shift testcases

%macro testcase 2
 %ifdef BIN
  db %1
 %endif
 %ifdef SRC
  %2
 %endif
%endmacro

bits 64

; --- Rotate instructions : RCL/RCR/ROL/ROR ---
; legacy - rcl
testcase	{0xD0, 0x12},			{rcl byte [rdx], 1}
testcase	{0xD2, 0x12},			{rcl byte [rdx], cl}
testcase	{0xC0, 0x12, 0x03},		{rcl byte [rdx], 0x03}
testcase	{0x66, 0xD1, 0x12},		{rcl word [rdx], 1}
testcase	{0x66, 0xD3, 0x12},		{rcl word [rdx], cl}
testcase	{0x66, 0xC1, 0x12, 0x03},	{rcl word [rdx], 0x03}
testcase	{0xD1, 0x12},			{rcl dword [rdx], 1}
testcase	{0xD3, 0x12},			{rcl dword [rdx], cl}
testcase	{0xC1, 0x12, 0x03},		{rcl dword [rdx], 0x03}
testcase	{0x48, 0xD1, 0x12},		{rcl qword [rdx], 1}
testcase	{0x48, 0xD3, 0x12},		{rcl qword [rdx], cl}
testcase	{0x48, 0xC1, 0x12, 0x03},	{rcl qword [rdx], 0x03}
; legacy - rcr
testcase	{0xD0, 0x1A},			{rcr byte [rdx], 1}
testcase	{0xD2, 0x1A},			{rcr byte [rdx], cl}
testcase	{0xC0, 0x1A, 0x03},		{rcr byte [rdx], 0x03}
testcase	{0x66, 0xD1, 0x1A},		{rcr word [rdx], 1}
testcase	{0x66, 0xD3, 0x1A},		{rcr word [rdx], cl}
testcase	{0x66, 0xC1, 0x1A, 0x03},	{rcr word [rdx], 0x03}
testcase	{0xD1, 0x1A},			{rcr dword [rdx], 1}
testcase	{0xD3, 0x1A},			{rcr dword [rdx], cl}
testcase	{0xC1, 0x1A, 0x03},		{rcr dword [rdx], 0x03}
testcase	{0x48, 0xD1, 0x1A},		{rcr qword [rdx], 1}
testcase	{0x48, 0xD3, 0x1A},		{rcr qword [rdx], cl}
testcase	{0x48, 0xC1, 0x1A, 0x03},	{rcr qword [rdx], 0x03}
; legacy - rol
testcase	{0xD0, 0x02},			{rol byte [rdx], 1}
testcase	{0xD2, 0x02},			{rol byte [rdx], cl}
testcase	{0xC0, 0x02, 0x03},		{rol byte [rdx], 0x03}
testcase	{0x66, 0xD1, 0x02},		{rol word [rdx], 1}
testcase	{0x66, 0xD3, 0x02},		{rol word [rdx], cl}
testcase	{0x66, 0xC1, 0x02, 0x03},	{rol word [rdx], 0x03}
testcase	{0xD1, 0x02},			{rol dword [rdx], 1}
testcase	{0xD3, 0x02},			{rol dword [rdx], cl}
testcase	{0xC1, 0x02, 0x03},		{rol dword [rdx], 0x03}
testcase	{0x48, 0xD1, 0x02},		{rol qword [rdx], 1}
testcase	{0x48, 0xD3, 0x02},		{rol qword [rdx], cl}
testcase	{0x48, 0xC1, 0x02, 0x03},	{rol qword [rdx], 0x03}
; legacy - ror
testcase	{0xD0, 0x0A},			{ror byte [rdx], 1}
testcase	{0xD2, 0x0A},			{ror byte [rdx], cl}
testcase	{0xC0, 0x0A, 0x03},		{ror byte [rdx], 0x03}
testcase	{0x66, 0xD1, 0x0A},		{ror word [rdx], 1}
testcase	{0x66, 0xD3, 0x0A},		{ror word [rdx], cl}
testcase	{0x66, 0xC1, 0x0A, 0x03},	{ror word [rdx], 0x03}
testcase	{0xD1, 0x0A},			{ror dword [rdx], 1}
testcase	{0xD3, 0x0A},			{ror dword [rdx], cl}
testcase	{0xC1, 0x0A, 0x03},		{ror dword [rdx], 0x03}
testcase	{0x48, 0xD1, 0x0A},		{ror qword [rdx], 1}
testcase	{0x48, 0xD3, 0x0A},		{ror qword [rdx], cl}
testcase	{0x48, 0xC1, 0x0A, 0x03},	{ror qword [rdx], 0x03}

; implicit evex through EGPRs - rcl
testcase	{0xD5, 0x11, 0xD0, 0x12},		{rcl byte [r26], 1}
testcase	{0xD5, 0x11, 0xD2, 0x12},		{rcl byte [r26], cl}
testcase	{0xD5, 0x11, 0xC0, 0x12, 0x03},		{rcl byte [r26], 0x03}
testcase	{0x66, 0xD5, 0x11, 0xD1, 0x12},		{rcl word [r26], 1}
testcase	{0x66, 0xD5, 0x11, 0xD3, 0x12},		{rcl word [r26], cl}
testcase	{0x66, 0xD5, 0x11, 0xC1, 0x12, 0x03},	{rcl word [r26], 0x03}
testcase	{0xD5, 0x11, 0xD1, 0x12},		{rcl dword [r26], 1}
testcase	{0xD5, 0x11, 0xD3, 0x12},		{rcl dword [r26], cl}
testcase	{0xD5, 0x11, 0xC1, 0x12, 0x03},		{rcl dword [r26], 0x03}
testcase	{0xD5, 0x19, 0xD1, 0x12},		{rcl qword [r26], 1}
testcase	{0xD5, 0x19, 0xD3, 0x12},		{rcl qword [r26], cl}
testcase	{0xD5, 0x19, 0xC1, 0x12, 0x03},		{rcl qword [r26], 0x03}
; implicit evex through ND - rcl
testcase	{0x62, 0xDC, 0x34, 0x10, 0xD0, 0x12},		{rcl r25b, byte [r26], 1}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xD2, 0x12},		{rcl r25b, byte [r26], cl}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xC0, 0x12, 0x03},	{rcl r25b, byte [r26], 0x03}
testcase	{0x62, 0xDC, 0x35, 0x10, 0xD1, 0x12},		{rcl r25w, word [r26], 1}
testcase	{0x62, 0xDC, 0x35, 0x10, 0xD3, 0x12},		{rcl r25w, word [r26], cl}
testcase	{0x62, 0xDC, 0x35, 0x10, 0xC1, 0x12, 0x03},	{rcl r25w, word [r26], 0x03}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xD1, 0x12},		{rcl r25d, dword [r26], 1}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xD3, 0x12},		{rcl r25d, dword [r26], cl}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xC1, 0x12, 0x03},	{rcl r25d, dword [r26], 0x03}
testcase	{0x62, 0xDC, 0xB4, 0x10, 0xD1, 0x12},		{rcl r25, qword [r26], 1}
testcase	{0x62, 0xDC, 0xB4, 0x10, 0xD3, 0x12},		{rcl r25, qword [r26], cl}
testcase	{0x62, 0xDC, 0xB4, 0x10, 0xC1, 0x12, 0x03},	{rcl r25, qword [r26], 0x03}
; implicit evex through EGPRs - rcr
testcase	{0xD5, 0x11, 0xD0, 0x1A},		{rcr byte [r26], 1}
testcase	{0xD5, 0x11, 0xD2, 0x1A},		{rcr byte [r26], cl}
testcase	{0xD5, 0x11, 0xC0, 0x1A, 0x03},		{rcr byte [r26], 0x03}
testcase	{0x66, 0xD5, 0x11, 0xD1, 0x1A},		{rcr word [r26], 1}
testcase	{0x66, 0xD5, 0x11, 0xD3, 0x1A},		{rcr word [r26], cl}
testcase	{0x66, 0xD5, 0x11, 0xC1, 0x1A, 0x03},	{rcr word [r26], 0x03}
testcase	{0xD5, 0x11, 0xD1, 0x1A},		{rcr dword [r26], 1}
testcase	{0xD5, 0x11, 0xD3, 0x1A},		{rcr dword [r26], cl}
testcase	{0xD5, 0x11, 0xC1, 0x1A, 0x03},		{rcr dword [r26], 0x03}
testcase	{0xD5, 0x19, 0xD1, 0x1A},		{rcr qword [r26], 1}
testcase	{0xD5, 0x19, 0xD3, 0x1A},		{rcr qword [r26], cl}
testcase	{0xD5, 0x19, 0xC1, 0x1A, 0x03},		{rcr qword [r26], 0x03}
; implicit evex through ND - rcr
testcase	{0x62, 0xDC, 0x34, 0x10, 0xD0, 0x1A},		{rcr r25b, byte [r26], 1}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xD2, 0x1A},		{rcr r25b, byte [r26], cl}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xC0, 0x1A, 0x03},	{rcr r25b, byte [r26], 0x03}
testcase	{0x62, 0xDC, 0x35, 0x10, 0xD1, 0x1A},		{rcr r25w, word [r26], 1}
testcase	{0x62, 0xDC, 0x35, 0x10, 0xD3, 0x1A},		{rcr r25w, word [r26], cl}
testcase	{0x62, 0xDC, 0x35, 0x10, 0xC1, 0x1A, 0x03},	{rcr r25w, word [r26], 0x03}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xD1, 0x1A},		{rcr r25d, dword [r26], 1}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xD3, 0x1A},		{rcr r25d, dword [r26], cl}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xC1, 0x1A, 0x03},	{rcr r25d, dword [r26], 0x03}
testcase	{0x62, 0xDC, 0xB4, 0x10, 0xD1, 0x1A},		{rcr r25, qword [r26], 1}
testcase	{0x62, 0xDC, 0xB4, 0x10, 0xD3, 0x1A},		{rcr r25, qword [r26], cl}
testcase	{0x62, 0xDC, 0xB4, 0x10, 0xC1, 0x1A, 0x03},	{rcr r25, qword [r26], 0x03}
; implicit evex through EGPRs - rol
testcase	{0xD5, 0x11, 0xD0, 0x02},		{rol byte [r26], 1}
testcase	{0xD5, 0x11, 0xD2, 0x02},		{rol byte [r26], cl}
testcase	{0xD5, 0x11, 0xC0, 0x02, 0x03},		{rol byte [r26], 0x03}
testcase	{0x66, 0xD5, 0x11, 0xD1, 0x02},		{rol word [r26], 1}
testcase	{0x66, 0xD5, 0x11, 0xD3, 0x02},		{rol word [r26], cl}
testcase	{0x66, 0xD5, 0x11, 0xC1, 0x02, 0x03},	{rol word [r26], 0x03}
testcase	{0xD5, 0x11, 0xD1, 0x02},		{rol dword [r26], 1}
testcase	{0xD5, 0x11, 0xD3, 0x02},		{rol dword [r26], cl}
testcase	{0xD5, 0x11, 0xC1, 0x02, 0x03},		{rol dword [r26], 0x03}
testcase	{0xD5, 0x19, 0xD1, 0x02},		{rol qword [r26], 1}
testcase	{0xD5, 0x19, 0xD3, 0x02},		{rol qword [r26], cl}
testcase	{0xD5, 0x19, 0xC1, 0x02, 0x03},		{rol qword [r26], 0x03}
; implicit evex through ND - rol
testcase	{0x62, 0xDC, 0x34, 0x10, 0xD0, 0x02},		{rol r25b, byte [r26], 1}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xD2, 0x02},		{rol r25b, byte [r26], cl}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xC0, 0x02, 0x03},	{rol r25b, byte [r26], 0x03}
testcase	{0x62, 0xDC, 0x35, 0x10, 0xD1, 0x02},		{rol r25w, word [r26], 1}
testcase	{0x62, 0xDC, 0x35, 0x10, 0xD3, 0x02},		{rol r25w, word [r26], cl}
testcase	{0x62, 0xDC, 0x35, 0x10, 0xC1, 0x02, 0x03},	{rol r25w, word [r26], 0x03}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xD1, 0x02},		{rol r25d, dword [r26], 1}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xD3, 0x02},		{rol r25d, dword [r26], cl}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xC1, 0x02, 0x03},	{rol r25d, dword [r26], 0x03}
testcase	{0x62, 0xDC, 0xB4, 0x10, 0xD1, 0x02},		{rol r25, qword [r26], 1}
testcase	{0x62, 0xDC, 0xB4, 0x10, 0xD3, 0x02},		{rol r25, qword [r26], cl}
testcase	{0x62, 0xDC, 0xB4, 0x10, 0xC1, 0x02, 0x03},	{rol r25, qword [r26], 0x03}
; implicit evex through EGPRs - ror
testcase	{0xD5, 0x11, 0xD0, 0x0A},		{ror byte [r26], 1}
testcase	{0xD5, 0x11, 0xD2, 0x0A},		{ror byte [r26], cl}
testcase	{0xD5, 0x11, 0xC0, 0x0A, 0x03},		{ror byte [r26], 0x03}
testcase	{0x66, 0xD5, 0x11, 0xD1, 0x0A},		{ror word [r26], 1}
testcase	{0x66, 0xD5, 0x11, 0xD3, 0x0A},		{ror word [r26], cl}
testcase	{0x66, 0xD5, 0x11, 0xC1, 0x0A, 0x03},	{ror word [r26], 0x03}
testcase	{0xD5, 0x11, 0xD1, 0x0A},		{ror dword [r26], 1}
testcase	{0xD5, 0x11, 0xD3, 0x0A},		{ror dword [r26], cl}
testcase	{0xD5, 0x11, 0xC1, 0x0A, 0x03},		{ror dword [r26], 0x03}
testcase	{0xD5, 0x19, 0xD1, 0x0A},		{ror qword [r26], 1}
testcase	{0xD5, 0x19, 0xD3, 0x0A},		{ror qword [r26], cl}
testcase	{0xD5, 0x19, 0xC1, 0x0A, 0x03},		{ror qword [r26], 0x03}
; implicit evex through ND - ror
testcase	{0x62, 0xDC, 0x34, 0x10, 0xD0, 0x0A},		{ror r25b, byte [r26], 1}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xD2, 0x0A},		{ror r25b, byte [r26], cl}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xC0, 0x0A, 0x03},	{ror r25b, byte [r26], 0x03}
testcase	{0x62, 0xDC, 0x35, 0x10, 0xD1, 0x0A},		{ror r25w, word [r26], 1}
testcase	{0x62, 0xDC, 0x35, 0x10, 0xD3, 0x0A},		{ror r25w, word [r26], cl}
testcase	{0x62, 0xDC, 0x35, 0x10, 0xC1, 0x0A, 0x03},	{ror r25w, word [r26], 0x03}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xD1, 0x0A},		{ror r25d, dword [r26], 1}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xD3, 0x0A},		{ror r25d, dword [r26], cl}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xC1, 0x0A, 0x03},	{ror r25d, dword [r26], 0x03}
testcase	{0x62, 0xDC, 0xB4, 0x10, 0xD1, 0x0A},		{ror r25, qword [r26], 1}
testcase	{0x62, 0xDC, 0xB4, 0x10, 0xD3, 0x0A},		{ror r25, qword [r26], cl}
testcase	{0x62, 0xDC, 0xB4, 0x10, 0xC1, 0x0A, 0x03},	{ror r25, qword [r26], 0x03}

; --- rorx instruction ---
; legacy
testcase	{0xC4, 0xE3, 0x7B, 0xF0, 0x0A, 0x03},	{rorx ecx, [rdx], 0x03}
testcase	{0xC4, 0xE3, 0xFB, 0xF0, 0x0A, 0x03},	{rorx rcx, [rdx], 0x03}
; implicit evex through EGPRs
testcase	{0x62, 0x63, 0x7F, 0x08, 0xF0, 0x0A, 0x03},	{rorx r25d, [rdx], 0x03}
testcase	{0x62, 0x63, 0xFF, 0x08, 0xF0, 0x0A, 0x03},	{rorx r25, [rdx], 0x03}

; --- sar instruction ---
; legacy - sar
testcase	{0xD0, 0x3A},			{sar byte [rdx], 1}
testcase	{0xD2, 0x3A},			{sar byte [rdx], cl}
testcase	{0xC0, 0x3A, 0x03},		{sar byte [rdx], 0x03}
testcase	{0x66, 0xD1, 0x3A},		{sar word [rdx], 1}
testcase	{0x66, 0xD3, 0x3A},		{sar word [rdx], cl}
testcase	{0x66, 0xC1, 0x3A, 0x03},	{sar word [rdx], 0x03}
testcase	{0xD1, 0x3A},			{sar dword [rdx], 1}
testcase	{0xD3, 0x3A},			{sar dword [rdx], cl}
testcase	{0xC1, 0x3A, 0x03},		{sar dword [rdx], 0x03}
testcase	{0x48, 0xD1, 0x3A},		{sar qword [rdx], 1}
testcase	{0x48, 0xD3, 0x3A},		{sar qword [rdx], cl}
testcase	{0x48, 0xC1, 0x3A, 0x03},	{sar qword [rdx], 0x03}
; legacy - shl
testcase	{0xD0, 0x22},			{shl byte [rdx], 1}
testcase	{0xD2, 0x22},			{shl byte [rdx], cl}
testcase	{0xC0, 0x22, 0x03},		{shl byte [rdx], 0x03}
testcase	{0x66, 0xD1, 0x22},		{shl word [rdx], 1}
testcase	{0x66, 0xD3, 0x22},		{shl word [rdx], cl}
testcase	{0x66, 0xC1, 0x22, 0x03},	{shl word [rdx], 0x03}
testcase	{0xD1, 0x22},			{shl dword [rdx], 1}
testcase	{0xD3, 0x22},			{shl dword [rdx], cl}
testcase	{0xC1, 0x22, 0x03},		{shl dword [rdx], 0x03}
testcase	{0x48, 0xD1, 0x22},		{shl qword [rdx], 1}
testcase	{0x48, 0xD3, 0x22},		{shl qword [rdx], cl}
testcase	{0x48, 0xC1, 0x22, 0x03},	{shl qword [rdx], 0x03}
; legacy - shr
testcase	{0xD0, 0x2A},			{shr byte [rdx], 1}
testcase	{0xD2, 0x2A},			{shr byte [rdx], cl}
testcase	{0xC0, 0x2A, 0x03},		{shr byte [rdx], 0x03}
testcase	{0x66, 0xD1, 0x2A},		{shr word [rdx], 1}
testcase	{0x66, 0xD3, 0x2A},		{shr word [rdx], cl}
testcase	{0x66, 0xC1, 0x2A, 0x03},	{shr word [rdx], 0x03}
testcase	{0xD1, 0x2A},			{shr dword [rdx], 1}
testcase	{0xD3, 0x2A},			{shr dword [rdx], cl}
testcase	{0xC1, 0x2A, 0x03},		{shr dword [rdx], 0x03}
testcase	{0x48, 0xD1, 0x2A},		{shr qword [rdx], 1}
testcase	{0x48, 0xD3, 0x2A},		{shr qword [rdx], cl}
testcase	{0x48, 0xC1, 0x2A, 0x03},	{shr qword [rdx], 0x03}

; implicit evex through EGPRs - sar
testcase	{0xD5, 0x11, 0xD0, 0x3A},		{sar byte [r26], 1}
testcase	{0xD5, 0x11, 0xD2, 0x3A},		{sar byte [r26], cl}
testcase	{0xD5, 0x11, 0xC0, 0x3A, 0x03},		{sar byte [r26], 0x03}
testcase	{0x66, 0xD5, 0x11, 0xD1, 0x3A},		{sar word [r26], 1}
testcase	{0x66, 0xD5, 0x11, 0xD3, 0x3A},		{sar word [r26], cl}
testcase	{0x66, 0xD5, 0x11, 0xC1, 0x3A, 0x03},	{sar word [r26], 0x03}
testcase	{0xD5, 0x11, 0xD1, 0x3A},		{sar dword [r26], 1}
testcase	{0xD5, 0x11, 0xD3, 0x3A},		{sar dword [r26], cl}
testcase	{0xD5, 0x11, 0xC1, 0x3A, 0x03},		{sar dword [r26], 0x03}
testcase	{0xD5, 0x19, 0xD1, 0x3A},		{sar qword [r26], 1}
testcase	{0xD5, 0x19, 0xD3, 0x3A},		{sar qword [r26], cl}
testcase	{0xD5, 0x19, 0xC1, 0x3A, 0x03},		{sar qword [r26], 0x03}
; implicit evex through ND - sar
testcase	{0x62, 0xDC, 0x34, 0x10, 0xD0, 0x3A},		{sar r25b, byte [r26], 1}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xD2, 0x3A},		{sar r25b, byte [r26], cl}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xC0, 0x3A, 0x03},	{sar r25b, byte [r26], 0x03}
testcase	{0x62, 0xDC, 0x35, 0x10, 0xD1, 0x3A},		{sar r25w, word [r26], 1}
testcase	{0x62, 0xDC, 0x35, 0x10, 0xD3, 0x3A},		{sar r25w, word [r26], cl}
testcase	{0x62, 0xDC, 0x35, 0x10, 0xC1, 0x3A, 0x03},	{sar r25w, word [r26], 0x03}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xD1, 0x3A},		{sar r25d, dword [r26], 1}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xD3, 0x3A},		{sar r25d, dword [r26], cl}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xC1, 0x3A, 0x03},	{sar r25d, dword [r26], 0x03}
testcase	{0x62, 0xDC, 0xB4, 0x10, 0xD1, 0x3A},		{sar r25, qword [r26], 1}
testcase	{0x62, 0xDC, 0xB4, 0x10, 0xD3, 0x3A},		{sar r25, qword [r26], cl}
testcase	{0x62, 0xDC, 0xB4, 0x10, 0xC1, 0x3A, 0x03},	{sar r25, qword [r26], 0x03}
; implicit evex through EGPRs - shl
testcase	{0xD5, 0x11, 0xD0, 0x22},		{shl byte [r26], 1}
testcase	{0xD5, 0x11, 0xD2, 0x22},		{shl byte [r26], cl}
testcase	{0xD5, 0x11, 0xC0, 0x22, 0x03},		{shl byte [r26], 0x03}
testcase	{0x66, 0xD5, 0x11, 0xD1, 0x22},		{shl word [r26], 1}
testcase	{0x66, 0xD5, 0x11, 0xD3, 0x22},		{shl word [r26], cl}
testcase	{0x66, 0xD5, 0x11, 0xC1, 0x22, 0x03},	{shl word [r26], 0x03}
testcase	{0xD5, 0x11, 0xD1, 0x22},		{shl dword [r26], 1}
testcase	{0xD5, 0x11, 0xD3, 0x22},		{shl dword [r26], cl}
testcase	{0xD5, 0x11, 0xC1, 0x22, 0x03},		{shl dword [r26], 0x03}
testcase	{0xD5, 0x19, 0xD1, 0x22},		{shl qword [r26], 1}
testcase	{0xD5, 0x19, 0xD3, 0x22},		{shl qword [r26], cl}
testcase	{0xD5, 0x19, 0xC1, 0x22, 0x03},		{shl qword [r26], 0x03}
; implicit evex through ND - shl
testcase	{0x62, 0xDC, 0x34, 0x10, 0xD0, 0x22},		{shl r25b, byte [r26], 1}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xD2, 0x22},		{shl r25b, byte [r26], cl}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xC0, 0x22, 0x03},	{shl r25b, byte [r26], 0x03}
testcase	{0x62, 0xDC, 0x35, 0x10, 0xD1, 0x22},		{shl r25w, word [r26], 1}
testcase	{0x62, 0xDC, 0x35, 0x10, 0xD3, 0x22},		{shl r25w, word [r26], cl}
testcase	{0x62, 0xDC, 0x35, 0x10, 0xC1, 0x22, 0x03},	{shl r25w, word [r26], 0x03}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xD1, 0x22},		{shl r25d, dword [r26], 1}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xD3, 0x22},		{shl r25d, dword [r26], cl}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xC1, 0x22, 0x03},	{shl r25d, dword [r26], 0x03}
testcase	{0x62, 0xDC, 0xB4, 0x10, 0xD1, 0x22},		{shl r25, qword [r26], 1}
testcase	{0x62, 0xDC, 0xB4, 0x10, 0xD3, 0x22},		{shl r25, qword [r26], cl}
testcase	{0x62, 0xDC, 0xB4, 0x10, 0xC1, 0x22, 0x03},	{shl r25, qword [r26], 0x03}
; implicit evex through EGPRs - shr
testcase	{0xD5, 0x11, 0xD0, 0x2A},		{shr byte [r26], 1}
testcase	{0xD5, 0x11, 0xD2, 0x2A},		{shr byte [r26], cl}
testcase	{0xD5, 0x11, 0xC0, 0x2A, 0x03},		{shr byte [r26], 0x03}
testcase	{0x66, 0xD5, 0x11, 0xD1, 0x2A},		{shr word [r26], 1}
testcase	{0x66, 0xD5, 0x11, 0xD3, 0x2A},		{shr word [r26], cl}
testcase	{0x66, 0xD5, 0x11, 0xC1, 0x2A, 0x03},	{shr word [r26], 0x03}
testcase	{0xD5, 0x11, 0xD1, 0x2A},		{shr dword [r26], 1}
testcase	{0xD5, 0x11, 0xD3, 0x2A},		{shr dword [r26], cl}
testcase	{0xD5, 0x11, 0xC1, 0x2A, 0x03},		{shr dword [r26], 0x03}
testcase	{0xD5, 0x19, 0xD1, 0x2A},		{shr qword [r26], 1}
testcase	{0xD5, 0x19, 0xD3, 0x2A},		{shr qword [r26], cl}
testcase	{0xD5, 0x19, 0xC1, 0x2A, 0x03},		{shr qword [r26], 0x03}
; implicit evex through ND - shr
testcase	{0x62, 0xDC, 0x34, 0x10, 0xD0, 0x2A},		{shr r25b, byte [r26], 1}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xD2, 0x2A},		{shr r25b, byte [r26], cl}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xC0, 0x2A, 0x03},	{shr r25b, byte [r26], 0x03}
testcase	{0x62, 0xDC, 0x35, 0x10, 0xD1, 0x2A},		{shr r25w, word [r26], 1}
testcase	{0x62, 0xDC, 0x35, 0x10, 0xD3, 0x2A},		{shr r25w, word [r26], cl}
testcase	{0x62, 0xDC, 0x35, 0x10, 0xC1, 0x2A, 0x03},	{shr r25w, word [r26], 0x03}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xD1, 0x2A},		{shr r25d, dword [r26], 1}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xD3, 0x2A},		{shr r25d, dword [r26], cl}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xC1, 0x2A, 0x03},	{shr r25d, dword [r26], 0x03}
testcase	{0x62, 0xDC, 0xB4, 0x10, 0xD1, 0x2A},		{shr r25, qword [r26], 1}
testcase	{0x62, 0xDC, 0xB4, 0x10, 0xD3, 0x2A},		{shr r25, qword [r26], cl}
testcase	{0x62, 0xDC, 0xB4, 0x10, 0xC1, 0x2A, 0x03},	{shr r25, qword [r26], 0x03}

; --- sarx instruction ---
; legacy
testcase	{0xC4, 0xE2, 0x2A, 0xF7, 0x0A},	{sarx ecx, [rdx], r10d}
testcase	{0xC4, 0xE2, 0xAA, 0xF7, 0x0A},	{sarx rcx, [rdx], r10}
; implicit evex through EGPRs
testcase	{0x62, 0x62, 0x2E, 0x08, 0xF7, 0x0A},	{sarx r25d, [rdx], r10d}
testcase	{0x62, 0x62, 0xAE, 0x08, 0xF7, 0x0A},	{sarx r25, [rdx], r10}
; --- shlx instruction ---
; legacy
testcase	{0xC4, 0xE2, 0x29, 0xF7, 0x0A},	{shlx ecx, [rdx], r10d}
testcase	{0xC4, 0xE2, 0xA9, 0xF7, 0x0A},	{shlx rcx, [rdx], r10}
; implicit evex through EGPRs
testcase	{0x62, 0x62, 0x2D, 0x08, 0xF7, 0x0A},	{shlx r25d, [rdx], r10d}
testcase	{0x62, 0x62, 0xAD, 0x08, 0xF7, 0x0A},	{shlx r25, [rdx], r10}
; --- shrx instruction ---
; legacy
testcase	{0xC4, 0xE2, 0x2B, 0xF7, 0x0A},	{shrx ecx, [rdx], r10d}
testcase	{0xC4, 0xE2, 0xAB, 0xF7, 0x0A},	{shrx rcx, [rdx], r10}
; implicit evex through EGPRs
testcase	{0x62, 0x62, 0x2F, 0x08, 0xF7, 0x0A},	{shrx r25d, [rdx], r10d}
testcase	{0x62, 0x62, 0xAF, 0x08, 0xF7, 0x0A},	{shrx r25, [rdx], r10}

; --- shld instruction ---
; legacy
testcase	{0x66, 0x0F, 0xA4, 0x02, 0x03},		{shld [rdx], ax, 0x03}
testcase	{0x0F, 0xA4, 0x02, 0x03},		{shld [rdx], eax, 0x03}
testcase	{0x48, 0x0F, 0xA4, 0x02, 0x03},		{shld [rdx], rax, 0x03}
testcase	{0x66, 0x0F, 0xA5, 0x02},		{shld [rdx], ax, cl}
testcase	{0x0F, 0xA5, 0x02},			{shld [rdx], eax, cl}
testcase	{0x48, 0x0F, 0xA5, 0x02},		{shld [rdx], rax, cl}

; implicit rex2 through EGPRs
testcase	{0x66, 0xD5, 0x91, 0xA4, 0x02, 0x03},	{shld [r26], ax, 0x03}
testcase	{0xD5, 0x91, 0xA4, 0x02, 0x03},		{shld [r26], eax, 0x03}
testcase	{0xD5, 0x99, 0xA4, 0x02, 0x03},		{shld [r26], rax, 0x03}
testcase	{0x66, 0xD5, 0x91, 0xA5, 0x02},		{shld [r26], ax, cl}
testcase	{0xD5, 0x91, 0xA5, 0x02},		{shld [r26], eax, cl}
testcase	{0xD5, 0x99, 0xA5, 0x02},		{shld [r26], rax, cl}

; implicit evex through ND
testcase	{0x62, 0xDC, 0x35, 0x10, 0x24, 0x02, 0x03},	{shld r25w, [r26], ax, 0x03}
testcase	{0x62, 0xDC, 0x34, 0x10, 0x24, 0x02, 0x03},	{shld r25d, [r26], eax, 0x03}
testcase	{0x62, 0xDC, 0xB4, 0x10, 0x24, 0x02, 0x03},	{shld r25, [r26], rax, 0x03}
testcase	{0x62, 0xDC, 0x35, 0x10, 0xA5, 0x02},		{shld r25w, [r26], ax, cl}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xA5, 0x02},		{shld r25d, [r26], eax, cl}
testcase	{0x62, 0xDC, 0xB4, 0x10, 0xA5, 0x02},		{shld r25, [r26], rax, cl}

; implicit evex through ND
testcase	{0x62, 0xDC, 0x7D, 0x0C, 0x24, 0x02, 0x03},	{shld{nf} [r26], ax, 0x03}
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0x24, 0x02, 0x03},	{shld{nf} [r26], eax, 0x03}
testcase	{0x62, 0xDC, 0xFC, 0x0C, 0x24, 0x02, 0x03},	{shld{nf} [r26], rax, 0x03}
testcase	{0x62, 0xDC, 0x7D, 0x0C, 0xA5, 0x02},		{shld{nf} [r26], ax, cl}
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0xA5, 0x02},		{shld{nf} [r26], eax, cl}
testcase	{0x62, 0xDC, 0xFC, 0x0C, 0xA5, 0x02},		{shld{nf} [r26], rax, cl}

; --- shrd instruction ---
; legacy
testcase	{0x66, 0x0F, 0xAC, 0x02, 0x03},		{shrd [rdx], ax, 0x03}
testcase	{0x0F, 0xAC, 0x02, 0x03},		{shrd [rdx], eax, 0x03}
testcase	{0x48, 0x0F, 0xAC, 0x02, 0x03},		{shrd [rdx], rax, 0x03}
testcase	{0x66, 0x0F, 0xAD, 0x02},		{shrd [rdx], ax, cl}
testcase	{0x0F, 0xAD, 0x02},			{shrd [rdx], eax, cl}
testcase	{0x48, 0x0F, 0xAD, 0x02},		{shrd [rdx], rax, cl}

; implicit rex2 through EGPRs
testcase	{0x66, 0xD5, 0x91, 0xAC, 0x02, 0x03},	{shrd [r26], ax, 0x03}
testcase	{0xD5, 0x91, 0xAC, 0x02, 0x03},		{shrd [r26], eax, 0x03}
testcase	{0xD5, 0x99, 0xAC, 0x02, 0x03},		{shrd [r26], rax, 0x03}
testcase	{0x66, 0xD5, 0x91, 0xAD, 0x02},		{shrd [r26], ax, cl}
testcase	{0xD5, 0x91, 0xAD, 0x02},		{shrd [r26], eax, cl}
testcase	{0xD5, 0x99, 0xAD, 0x02},		{shrd [r26], rax, cl}

; implicit evex through ND
testcase	{0x62, 0xDC, 0x35, 0x10, 0x2C, 0x02, 0x03},	{shrd r25w, [r26], ax, 0x03}
testcase	{0x62, 0xDC, 0x34, 0x10, 0x2C, 0x02, 0x03},	{shrd r25d, [r26], eax, 0x03}
testcase	{0x62, 0xDC, 0xB4, 0x10, 0x2C, 0x02, 0x03},	{shrd r25, [r26], rax, 0x03}
testcase	{0x62, 0xDC, 0x35, 0x10, 0xAD, 0x02},		{shrd r25w, [r26], ax, cl}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xAD, 0x02},		{shrd r25d, [r26], eax, cl}
testcase	{0x62, 0xDC, 0xB4, 0x10, 0xAD, 0x02},		{shrd r25, [r26], rax, cl}

; implicit evex through ND
testcase	{0x62, 0xDC, 0x7D, 0x0C, 0x2C, 0x02, 0x03},	{shrd{nf} [r26], ax, 0x03}
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0x2C, 0x02, 0x03},	{shrd{nf} [r26], eax, 0x03}
testcase	{0x62, 0xDC, 0xFC, 0x0C, 0x2C, 0x02, 0x03},	{shrd{nf} [r26], rax, 0x03}
testcase	{0x62, 0xDC, 0x7D, 0x0C, 0xAD, 0x02},		{shrd{nf} [r26], ax, cl}
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0xAD, 0x02},		{shrd{nf} [r26], eax, cl}
testcase	{0x62, 0xDC, 0xFC, 0x0C, 0xAD, 0x02},		{shrd{nf} [r26], rax, cl}

