/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#ifndef MESSAGEFILTEREDITOR_H
#define MESSAGEFILTEREDITOR_H

#include <QWidget>
#include <QListWidget>
#include <QPushButton>

class MessageFilter;
class FiltrationRule;

/**
	@author Anistratov Oleg <ower86@gmail.com>
*/
class MessageFilterEditor : public QWidget
{
  Q_OBJECT
  private:
    MessageFilter* m_filter;
    QListWidget*   m_rulesListWgt;
    QPushButton*   m_addRuleBtn;
    QPushButton*   m_delRuleBtn;
    QPushButton*   m_enableDisableRuleBtn;

  private:
    void retranslate();

  public:
    MessageFilterEditor(QWidget *parent = 0);
    ~MessageFilterEditor();

    void setFilter(MessageFilter* filter){m_filter = filter;}

    void refresh();

    bool editRule(FiltrationRule*);

  public slots:
    void addRule();
    void editRule(QListWidgetItem*);
    void removeRule();
    void enableDisableRule();
    void itemActivated(int);
};

#endif
